*    Program: DefOnKey.prg
*
*     Author: Jim Booth
*
*       Date: May 19, 1994
*
*  Copyright: James Booth 1994
*
*    Purpose: Simulates ON KEY LABEL command with the use of a POPUP menu
*             where the SHORT CUT keys are the OKL keys.  Uses a POPUP
*             named tcKeyPop
*
* Parameters: tcAction: "D" for Define the key
*                       "R" for Release the key. If no tcKey is passed
*                           all keys will be released.
*
*             tcKey:    Key label for the definition or release
*
*             tcKeyAct: The action to be assigned to the key
*
*    Returns: .T. if succeeded and .F. if failed
*
*     Syntax: =DefOnKey("D","F2","WAIT WINDOW 'Hello!'")
*

PARAMETERS tcAction, tcKey, tcKeyAct

* Declare local variables as private
PRIVATE tcOldErr, tnBars, tnCnt, tlGotIt
IF PARAMETERS() > 0 AND TYPE("tcAction") = "C"
	tcAction = UPPER(tcAction)
ELSE
	RETURN .F.
ENDIF

DO CASE
	CASE PARAMETERS() = 0
		RETURN .F.  && Fail
	CASE PARAMETERS() = 1 AND tcAction <> "R"
		RETURN .F.  && Fail
ENDCASE
tcOldErr = ON("ERROR")
ON ERROR DO DefPop     && Trap undefined popup and define it

IF tcAction = "R" AND PARAMETERS() = 1  && Global key release
	RELEASE POPUP tcKeyPop
	ON ERROR &tcOldErr     && Reset error trap
	RETURN .T.
ENDIF

HIDE POPUP tcKeyPop    && Find out if popup is defined
ON ERROR &tcOldErr     && Reset error trap

IF tcAction = "R"
	FOR tnCnt = 1 TO CNTBAR("tcKeyPop")
		IF PRMBAR("tcKeyPop",tnCnt) = tcKey
			ON SELECTION BAR tnCnt OF tcKeyPop
			EXIT
		ENDIF
	ENDFOR
ELSE
	IF TYPE("tcKey") <> "C" OR TYPE("tcKeyAct") <> "C"
		RETURN .F.
	ENDIF
	tlGotIt = .F.
	FOR tnCnt = 1 TO CNTBAR("tcKeyPop")
		IF PRMBAR("tcKeyPop",tnCnt) = tcKey
			tlGotIt = .T.
			DEFINE BAR tnCnt OF tcKeyPop PROMPT tcKey KEY &tcKey 
			ON SELECTION BAR tnCnt OF tcKeyPop &tcKeyAct
			EXIT
		ENDIF
	ENDFOR
	IF !tlGotIt
		tnCnt = CNTBAR("tcKeyPop") + 1
		DEFINE BAR tnCnt OF tcKeyPop PROMPT tcKey KEY &tcKey 
		ON SELECTION BAR tnCnt OF tcKeyPop &tcKeyAct
	ENDIF
ENDIF
RETURN .T.

PROCEDURE DefPop
* Define the popup when it doesn't exist
DEFINE POPUP tcKeyPop FROM 0,0
RETURN
