****************************************************************
* PROGRAM FILE  : okdosnam
* PROC/FUNC NAME: ok_dosnam
* DESCRIPTION   : checks a file name for validity according to DOS
*               : rules
* AUTHOR        : Olin Robie
* DATE          : 6:03pm May 04,1990
* COPYRIGHT     : (C) 1989 Olin Robie, The Olin Group
*               : and put in the public domain
* PARAMETERS    : expC - file name to check
* DEFAULTS      :
* RETURNS       : .t. or .f.
* EXAMPLE(S)    : @ ...say...get mFile pict "@!" valid ok_dosname(mFile)
* NOTES/CAUTIONS: this function does NOT expect to receive a drive designation
*               : or path or file extension. It checks for illegal characters 
*               : and DOS device names PLUS dissallows quotes in filename to 
*               : protect from Clipper macro expansion problems
*               :
* MODIFICATIONS : for Foxpro ... change pcount() to parameters()
*               : for your app ... substitute your message style/function
*               : for Lmsg()
***************************************************************

FUNCTION OK_DOSNAM

parameter name2ck

if pcount() <> 1 .or. type("name2ck") <> "C"
   Lmsg("Parameter Error. Filename Allowed but NOT Validated.",1)
   *** don't penalize the user for a programmer mistake
   return .t.
endif

*** get rid of leading/trailing spaces
name2ck = ltrim(rtrim(name2ck))

*** no empty file names, please
if len(name2ck) = 0
   Lmsg("No Empty File Names, Please",1)
   return .f.
endif

*** check for reserved characters \ < > | * ? / : , + " ' spac()

if "."$name2ck .or. "."$name2ck .or. "\"$name2ck .or. "<"$name2ck .or. ;
   ">"$name2ck .or. "|"$name2ck .or. "*"$name2ck .or. "?"$name2ck .or. ;
   "/"$name2ck .or. ":"$name2ck .or. ","$name2ck .or. "+"$name2ck .or. ;
   " "$name2ck .or. "'"$name2ck .or. '"'$name2ck
   
   Lmsg("Replace Illegal Character in Filename: \<>|*?/:,+ or space or quote.",1)  
   return .f.

endif

*** check for reserved DOS devices   AUX CON LPT1,2 NUL PRN PRT COM1,2
*** if you are real particular, put in LPT3,4 and COM3,4

if name2ck == "AUX" .or. name2ck == "CON" .or. name2ck == "LPT1" .or. ;
   name2ck == "LPT2".or. name2ck == "NUL" .or. name2ck == "PRN" .or. ;
   name2ck == "PRT" .or. name2ck == "COM1" .or. name2ck == "COM2"

   Lmsg("This Filename is Reserved for DOS Use.",1)
   return .f.

endif


return .t.
********************************************* end
