PARAMETER inst_remo

	*- this code and proc installs/removes tile
	*- into your menu system...
	*- Just tell it:
	*-   DO TILE WITH "INSTALL"
	*- or
	*-   DO TILE WITH "REMOVE"
	*-
	IF !EMPTY(inst_remo)

		DO inst_remo WITH inst_remo
		RETURN

	ENDIF

			
	*- TILE.PRG
	*-
	*-    This snippet, which should be part of an _mwindow
	*- option, will "tile" your windows
	*-
	*-    The windows look a little nicer with SHADOWS OFF
	*-    You probably want to assign this to rightmouse or
	*- put it in the _mwindow menu

	*-   Get count of windows by peeking in the _MWINDOW
	*- menu and subtracting the offset of none-window menu
	*- bar choices.
	*-
	window_count = CNTBAR("_mwindow") - _mboffset

	*- If we don't have any windows, RETURN
	*-
	IF window_count < 1
		RETURN
	ENDIF

	*- Cheezy grid size calculation:
	*- just figure we'll be creating a square
	*-
	grid_size = CEILING(SQRT(window_count))

	*- Set up starting row and some height variables
	*-
	currRow = 1
	currCol = 0
	colStep = INT((SCOLS() - 2)/grid_size)
	rowStep = INT((SROWS() - 2)/grid_size)

	*- in case we try to make the window too small,
	*- we'll borrow some lines from the columns
	*-
	rowDeviation = 5 - rowStep
	IF rowDeviation > 1
		rowStep = 5
		colStep = MAX(7, colStep - rowDeviation)
	ENDIF
	
	*- Here, we determine and go through the window list by 
	*- peeking into the _MWINDOW menu
	*-
	FOR i = 1 TO window_count

		bar_title = PRMBAR("_MWINDOW", ;
			GETBAR("_MWINDOW", i + _mboffset))

		f_title = first(bar_title)

		*- We are testing to see if the PRMBAR() call
		*- returned the window's number on the menu bar.
		*- Windows are numbered on the menu bar from 0 to 9.
		*- After that, they get no numbers.
		*-
		IF (f_title >= "0" AND f_title <= "9") AND ;
				LEN(first(bar_title)) = 1
	
			wtitle = butfirst(bar_title)
		
		ELSE
	
			wtitle = bar_title
		
		ENDIF

		first_char = LEFT(wtitle, 1)

		*- Here we must filter out any window names which
		*- will choke Foxpro. Why Foxpro will let you name
		*- files strange things but not let you reference
		*- their window names is beyond me! Chars and
		*- underscores are okay as first character. We skip
		*- EMPTY window names (command, screen, etc.)
		*-
		IF !EMPTY(wtitle) AND ;
		(first_char >= "A" AND first_char <= "Z") OR ;
		(first_char >= "a" AND first_char <= "z") OR ;
		first_char = "_"

			ACTIVATE WINDOW (wtitle) TOP
			ZOOM WINDOW (wtitle) NORM ;
				FROM currRow, currCol ;
				TO MIN(SROWS() - 1, currRow + rowStep), ;
					  MIN(SCOLS() - 1, currCol + colStep)

			IF currCol + colStep > ;
				SCOLS() - colStep - 1

				currCol = 0
				IF currRow + rowStep > ;
						SROWS() - rowStep - 1
					currRow = 1
				ELSE
					currRow = currRow + rowStep
				ENDIF

			ELSE

				currCol = currCol + colStep  

			ENDIF

		ENDIF
	
	NEXT

RETURN

*-
*- butfirst
*- returns all but the first atom
*- of a list string expression
*-
FUNCTION butfirst
PARAMETER list

	list = ALLTRIM(list)

	send = IIF( " " $ list, RIGHT(list, LEN(list) -;
			AT(" ", list)), "")

RETURN ALLTRIM(send)

*-
*- first
*- returns the first atom of a 
*- list expression
*-
FUNCTION first
PARAMETER list

	list = ALLTRIM(list)

	send = IIF( " " $ list, SUBSTR(list, 1, ;
			AT(" ",list)-1), list)

RETURN send

*-
*- inst_remo
*- Installs or removes the tile menu
*-
PROCEDURE inst_remo
PARAMETER inst_remo
PRIVATE i

	inst_remo = UPPER(inst_remo)

	DO CASE
	CASE inst_remo = "INSTALL"
	
		FOR i = 1 TO CNTPAD("_MSYSMENU")
			IF PRMPAD("_MSYSMENU", GETPAD("_MSYSMENU", i)) = "Window"
				EXIT
			ENDIF
		NEXT
		IF i = CNTPAD("_MSYSMENU") + 1
			WAIT WINDOW "Window menu pad not found: Press any key..."
			RETURN
		ENDIF

		? "Window Tiler. Version 1."
		? "(c) 1992, Oat Bran Software."
		? "Written by Brian Jepson."
		PUBLIC _tile, _mboffset
		
		_tile = "TILE"
		
		mbarCnt = CNTBAR("_mwindow")
		FOR barNo = 1 TO mbarCnt

			bar_title = PRMBAR("_MWINDOW", ;
					GETBAR("_MWINDOW", barNo))

			f_title = first(bar_title)

			*- look to see if there's any windows
			*-
			IF (f_title >= "0" AND f_title <= "9") AND ;
			  LEN(first(bar_title)) = 1

			   EXIT
			   
			ENDIF

		NEXT

		_mboffset = barNo
		barNo = barNo - 1
		tileLoc = SYS(16,0)
		DEFINE BAR barNo ;
			OF _mwindow ;
			PROMPT "T\<ile Windows"
		ON SELECTION BAR barNo ;
			OF _mwindow ;
			DO &tileLoc
				
	CASE inst_remo = "REMOVE"

		RELEASE BAR _mboffset - 1 OF _mwindow
		RELEASE _tile, _mboffset

	ENDCASE
	
RETURN