*	CAPTITLE AND NUMTOWORD		&& By Steven E. Neiner cseve ID 73072,2057
*----------------------------------------------------------------------	
*	CAPTITLE(<expC1> [, <expC2] [,<expC3>,...<expC6])
*	Returns a character expression that is in proper capitilization
*	form for title, where pronouns are left in lower case. Words
*	such as acronymns that ignore captilization rules can be passed in
*	addition, so their capitilization is ignored.
*	
*	<expC1> is the character string to capitialize
*	<expC2..6> are words/acronymns that are exceptions to capitalization
*		rules.
*
*	Example:	
*	FUNCTION myvalid
*		parameter m.title
*		if m.title = lower(m.title) or m.title = upper(m.title)
*			m.title = CAPTITLE(m.title)
*			SHOW GETS
*		endif
*		RETURN .T.
*
*-----------------------------------------------------------------------	
*	NUMTOWORD(<expN>)
*	Returns a character expression of a value. Given an amount, returns
*	the numeric wording of a number. Useful for printing checks.
*
*	<expN> is a numeric value to pass
*	
*	Example:
*	Prints numeric word string, with trailing *'s for safety
*	? PADR(NUMTOWORD(check.amount), 60, "*")
*	
*
* THIS PORTION IS FOR DEMO PURPOSES. CUT AND PASTE UDF'S INTO YOUR APPS.
*:*****************************************************************************
*:
*: Procedure file: NUMWORD.PRG
*:
*:         System: numword
*:         Author: Steven E. Neiner 73072,2057
*:      Copyright (c) 1993, Steve Neiner Consulting
*:  Last modified: 02/17/94     11:34
*:
*:  Procs & Fncts: numtoword()
*:               : CAPTITLE()
*:               : NUMWORD()
*:
*:          Calls: numtoword()          (function  in NUMWORD.PRG)
*:               : CAPTITLE()         (function  in NUMWORD.PRG)
*:
*:      Documented 02/17/94 at 11:36               FoxDoc  version 2.10f
*:*****************************************************************************
*
SET TALK OFF
CLEAR
? "For Demo purposes"
?
? numtoword(99.99)
?
m.str = "foxpro  FOR dos and windows"
? "Before CAPTITLE(): "
?? m.str
?
? "After CAPTITLE():  "
?? captitle(m.str, "DOS", "FoxPro")


*!*****************************************************************************
*!
*!       Function: numtoword()
*!
*!          Calls: NUMWORD()          (function  in NUMWORD.PRG)
*!
*!
*!*****************************************************************************
FUNCTION numtoword
PARAMETER amt
amt = ABS(amt)
m.numphrase = " "
IF INT(amt / 1000000) > 0		&& Amount in millions?
   m.numphrase = m.numphrase + numword(INT(amt / 1000000)) + ;
      " Million "
ENDIF
IF INT(amt / 1000) > 0			&& Amount in thousands?
   m.numphrase = m.numphrase + numword(MOD(INT(amt / 1000),1000)) + ;
      " Thousand "
ENDIF
m.numphrase = ALLTRIM(m.numphrase + numword(MOD(INT(amt),1000))) + ;
   " Dollars and "
m.cent = MOD(amt * 100, 100)	&& Get decimal
IF m.cent = 1
   m.numphrase = m.numphrase + "1 Cent"
ELSE
   m.numphrase = m.numphrase + LTRIM(STR(m.cent)) + " Cents"
ENDIF
RETURN m.numphrase

*!*****************************************************************************
*!
*!       Function: NUMWORD()
*!
*!      Called by: numtoword()          (function  in NUMWORD.PRG)
*!
*!*****************************************************************************
FUNCTION numword
PARAMETER amt
DECLARE one[10]
DECLARE ten[10]
DECLARE teen[10]

one[1] = "One"
one[2] = "Two"
one[3] = "Three"
one[4] = "Four"
one[5] = "Five"
one[6] = "Six"
one[7] = "Seven"
one[8] = "Eight"
one[9] = "Nine"
ten[1] = "Ten"
ten[2] = "Twenty"
ten[3] = "Thirty"
ten[4] = "Fourty"
ten[5] = "Fifty"
ten[6] = "Sixty"
ten[7] = "Seventy"
ten[8] = "Eighty"
ten[9] = "Ninety"
teen[1] = "Eleven"
teen[2] = "Twelve"
teen[3] = "Thirteen"
teen[4] = "Fourteen"
teen[5] = "Fifteen"
teen[6] = "Sixteen"
teen[7] = "Seventeen"
teen[8] = "Eighteen"
teen[9] = "Ninteen"
m.hundred = INT(amt / 100)		&& Get decimal position 1 number
IF m.hundred > 0
   m.numphrase = one[m.hundred] + " Hundred "
ELSE
   m.numphrase = " "
ENDIF
m.decpos2 = MOD(amt, 100)		&& Get decimal position 2 number
m.decpos3 = INT(m.decpos2 / 10)	&& Get decimal position 3 number
IF m.decpos2 >= 11 AND m.decpos2 <= 19	&& Number in teens?
   m.numphrase = m.numphrase + teen[INT(MOD(m.decpos2, 10))]
ELSE							&& Not in teens
   IF m.decpos3 > 0
      m.numphrase = m.numphrase + ten[INT(m.decpos2 / 10)]
   ENDIF
   IF MOD(m.decpos2, 10) > 0
      m.numphrase = ALLTRIM(m.numphrase) + " " + one[MOD(m.decpos2, 10)]
   ENDIF
ENDIF
RETURN ALLTRIM(m.numphrase)


*!*****************************************************************************
*!
*!       Function: CAPTITLE()
*!
*!      Called by: NUMWORD.PRG                       
*!
*!*****************************************************************************
FUNCTION captitle
PARAMETER m.title, m.mustcap1, m.mustcap2, m.mustcap3, mustcap4, ;
   mustcap5, mustcap6

PRIVATE ALL
DIMENSION capex[6, 1]
m.mustcap1 = IIF(EMPTY(mustcap1), CHR(255), mustcap1)
m.mustcap2 = IIF(EMPTY(mustcap2), CHR(255), mustcap2)
m.mustcap3 = IIF(EMPTY(mustcap3), CHR(255), mustcap3)
m.mustcap4 = IIF(EMPTY(mustcap4), CHR(255), mustcap4)
m.mustcap5 = IIF(EMPTY(mustcap5), CHR(255), mustcap5)
m.mustcap6 = IIF(EMPTY(mustcap6), CHR(255), mustcap6)
capex(1) = UPPER(m.mustcap1)
capex(2) = UPPER(m.mustcap2)
capex(3) = UPPER(m.mustcap3)
capex(4) = UPPER(m.mustcap4)
capex(5) = UPPER(m.mustcap5)
capex(6) = UPPER(m.mustcap6)

m.title = ALLTRIM(m.title) + " "
m.new = ""						&& The new string to return
m.word = ""						&& Word in title
m.lastch = "."					&& Save last char
m.pastspace = .T.				&& Flag for past a space
m.exactstat = SET("EXACT")		&& Save exact status
SET EXACT ON
m.hitstart = .T.				&& Hit beginning of a word
m.wasstart = .F.				&& Save beginning
m.firstword = .T.
FOR X = 1 TO LEN(m.title)
   m.ch = SUBSTR(m.title, X, 1)
   IF INLIST(m.ch, ":", ",", CHR(34), ".", "-")
      * We hit the beginning of a word
      m.pastspace = .F.
      m.hitstart = .T.
   ELSE
      IF UPPER(m.ch) >= "A" AND UPPER(m.ch) <= "Z") AND m.pastspace
         * we are in a word
         m.hitstart = .F.
      ENDIF
   ENDIF
   * punctuation character?
   IF INLIST(m.ch, " ", ":", ",", CHR(34), ".", "-")
      * Are we in the beginning of a word?
      IF m.wasstart = .F. AND m.pastspace = .T.
         IF NOT m.firstword AND INLIST(UPPER(m.word), ;
               "AS", "OF", "AT", "AND", "THE", "IN", "TO", "FOR", "A")
            m.word = LOWER(m.word)
         ELSE
            N = ASCAN(capex, UPPER(m.word))
            IF N > 0	&& in exception list
               expr = "mustcap" + ALLTRIM(STR(N))
               m.word = &expr
            ELSE
               m.word = PROPER(m.word)
               m.firstword = .F.
            ENDIF
         ENDIF
      ENDIF
      m.new = m.new + m.word + m.ch
      m.word = ""
      * scan through spaces
      IF m.ch = " " AND X < LEN(m.title)
         DO WHILE SUBSTR(m.title, X + 1, 1) = " " AND ;
               X <= LEN(m.title)
            X = X + 1
         ENDDO
         m.pastspace = .T.
      ENDIF
      m.lastch = m.ch				&& save last character
      m.wasstart = m.hitstart		&& Save "hit start of a word" flag
   ELSE							&& in middle of word
      m.word = m.word + m.ch		&& add char
   ENDIF
NEXT X
IF m.exactstat = "OFF"
   SET EXACT OFF
ENDIF
RETURN ALLTRIM(m.new)
*: EOF: NUMWORD.PRG
