/****************************************************************
*  N2STEST.C                                                    *
*                                                               *
*  By        : Leonard Zerman                                   *
*  Notice    : Placed into the public domain by Leonard Zerman. *
*  Date      : 09/01/93                                         *
*  Version   : 1.00                                             *
*  Revision  : 0                                                *
*  Usage     :                                                  *
*  Operation : Tests the NumericToString function.              *
*  Compile   : CL /c /ALw /FPc /GD /Gs /I\FOXLCK N2STEST.C      *
*  Link      : LINK /CO /NOD /NOE N2STEST NUMTOSTR,             *
*              NUMTOSTR.FLL, , \FOXLCK\PROAPIML.LIB LIBW.LIB    *
*              /NOD:LLIBCE LDLLCEW, N2STEST.DEF                 *
*  Notes     : Only been tested with MS Visual C/C++.           *
*              Only been tested under MS Windows.               *
****************************************************************/

/****************************************************************

DESCRIPTION:
  N2STEST is a FoxPro for Windows .FLL library file that test the
  NumericToString function.

*****************************************************************

INSTALL:
  Copy the file, N2STEST.FLL anywhere into the FoxPro PATH.

USAGE:
  SET LIBRARY TO D2STEST

*****************************************************************

CONTENTS:

  NBRTOSTR              Converts a FoxPro for Windows numeric 
                        into a character string.

****************************************************************/

#pragma warning (disable : 4001 4100)

/*----------------------* C INCLUDES *-------------------------*/

#include <windows.h>

/*----------------------* FOX INCLUDES *-----------------------*/

#include "pro_ext.h"

/*----------------------* LOCAL INCLUDES *---------------------*/

#include "numtostr.h"

/****************************************************************

FUNCTION NAME: NBRTOSTR

PROTOTYPE:
  NBRTOSTR(<nNumeric>) -> cNbrString

PARAMETERS:
  <nNumeric>
  FoxPro numeric floating point number. Format (nn.nn) where n 
  is a number.

RETURNS:
  The NBRTOSTR function returns a character string that contains 
  the conversion of the number.

ERROR:
  None.

DESCRIPTION:
  The NBRTOSTR function converts a FoxPro for Windows numeric 
  into a character string.

EXAMPLE:
  ? NBRTOSTR(1.1)
  * The result is "1.1"

MODIFICATION HISTORY:
  L. A. Zerman  09/01/93  Original version.

****************************************************************/

void FAR NBRTOSTR_(ParamBlk FAR * parm)
{
   double dblNumber;
   LPSTR lpszNbrString;

   dblNumber = parm->p[0].val.ev_real;

   lpszNbrString = NumericToString(dblNumber);

   _RetChar(lpszNbrString);
}

/*----------------------* FLL DATA *---------------------------*/

FoxInfo myFoxInfo[] =
{
   {"NBRTOSTR", (FPFI)NBRTOSTR_, 1, "N" }
};


FoxTable _FoxTable =
{
   (FoxTable FAR *)0,
   (sizeof(myFoxInfo) / sizeof(FoxInfo)),
   myFoxInfo
};

/*----------------------* EOF N2STEST.C *----------------------*/






