
* ------------------------------------------------------------------------------
*		Filename: NEW.prg
*		Purpose : Create empty databases.
*		
*		Created on Friday, August 13, 1993
*		Copyright(C) 1993, Ng Khai Development Corp.
*
*  Parameters:  1 parameter, what STR (with the database specs)file to open
*
*  For any comments or suggestions, pls e-mail to 73751.1012 @ Compuserve.com
* ------------------------------------------------------------------------------
parameters STRF

m.params = parameters()
if m.params != 1
	wait window 'Missing or invalid number of parameters.'
	return
endif

set talk off
close all

**	Supply file name with default extension if it has none:	
	
if at('.', STRF) = 0								
	STRF = STRF + '.str'
endif

** Check if file exists:

if !file(STRF)
	wait window 'File does not exist.'
	return
endif
	
** Copy the text file to a dbf:	

STRDBF = '_' + substr(sys(3), 2) + '.dbf'
create table ( STRDBF ) (line C(82))
append from ( STRF ) sdf
use ( STRDBF ) again alias STRDBF


*!! Create the arrays:
*!! The STR may contain specs for many files.  It will now
*	be recorded by the program into the appropriate array.



dimension dbffiles(1)
dimension related(1, 2)
dimension relatives(1)
m.files = 0			&& Counter for number of dbf files
m.rela  = 0			&& Counter for number of relations
		
scan 
	if at('FILE@', line) != 0
		m.files = m.files + 1
		dimension dbffiles(m.files)
		dbffiles(m.files) = upper(alltrim(substr(line, 10, 8)))

*!! Process next line:
		if !eof()
			skip
			if eof()
				skip -1
				exit
			endif
		endif

		&&Get names of related files:
		scan rest 
			if at('RELA@', line) != 0
				pcRLine = upper(substr(line, 10, 65))

				&& Parse comma-delimited string to array:
				&& Note that there could be several related files 
				&& separated by commas
				&& Get the Whole line and parse the files into an array

				pnCommacnt = occurs(',', pcRLine)
				pnCommacnt = iif(pnCommacnt = 0, 1, pnCommacnt + 1)
				for i = 1 to pnCommacnt
					pnComma0 = iif(i = 1, 0, at(',', pcRLine, i - 1))
					pnComma1 = at(',', pcRLine, i)
					pnComma1 =iif(pnComma1=0,len(pcRLine)+1, pnComma1)
		
					m.rela = m.rela + 1    && Number of relations
					dimension related(m.rela, 2)
					related(m.rela,1)=alltrim(substr(pcRLine,pnComma0+1,;
						pnComma1 - pnComma0 - 1))
					related(m.rela, 2) = m.files
				next
			endif
			if at('FILE@', line) != 0 or eof()
				skip -1
				exit
			endif
	    endscan   && of Scan rest
	endif
endscan   && of scan

*!! Assign a dummy value if array related is empty:
*   That means this file has no related file at all:
if empty(related(1, 1))
	related(1, 1) = space(8)
	related(1, 2) = 0
	relatives(1) = space(8)
endif
	
*! Copy to another array and make room for mark character:

=acopy(dbffiles, dbf_tbl)
for i = 1 to alen(dbf_tbl)
	dbf_tbl(i) = '  '+dbf_tbl(i)
next

*!! Define the windows:
*   This menu will now show the various database file you can create.
*	When a database file is shown, its related file will also show.
*	You cannot create a database file without creating all related
*		files.  This is to prevent referential integrity problems.

define window create_w from 3, 23 to 22, 55 system ;
	footer 'Ctrl+Letter for options' shadow
activate window create_w noshow
	
pcMarker	= ''								&& Marker.
on key label Ctrl+A do btn0_valid with 1
on key label Ctrl+N do btn0_valid with 2
on key label Ctrl+C do btn1_valid with 1
on key label Ctrl+E do btn1_valid with 2
	
pcPair1 = scheme(1, 1)	
pcPair1 = 'W+/'+substr(pcPair1, rat('/', pcPair1)+1)
@ 1, 7 say 'CREATE DATABASES' color (pcPair1)
@ 3, 0 say '   Databases    Related Files'
@ 4, 1 get pnBar0 ;
	from dbf_tbl ;
	default 1 ;
	size 10, 14 ;
	when bar0_when() ;
	valid bar0_valid()
	
@ 4, 16 get pnBar1 ;
	from relatives ;
	default 1 ;
	size 10, 14

** You have four choices.  TAG all means you select all database
** file to be created.  TAG none means you deselect all.
** You may use a space bar to select individually.
** Then.
** Create to create the database files selected.
** Cancel to QUIT
	
@ 15, 4 get pnButton0 ;
	picture '@*N Tag \<All;Tag \<None' ;
	valid btn0_valid(pnButton0) ;
	default 1 ;
	size 1, 10
		
@ 15, 16 get pnButton1 ;
	picture '@*N \<Create;\?Canc\<el' ;
	valid btn1_valid(pnButton1) ;
	default 1 ;
	size 1, 10

show window create_w
read cycle
release windows create_w
pop key

use in STRDBF
delete file ( STRDBF )
*****NEW ENDP	
	
* ------------------------------------------------------------------------------
function BAR0_WHEN
* This function gives an array listing of all related files of
* a group of the selected database file.
* ------------------------------------------------------------------------------
external array related, relatives
	
dimension relatives(100)
pnAryLen = alen(related, 1)
j = 0
for i = 1 to pnAryLen
	if related(i, 2) = pnBar0
		j = j + 1
		relatives(j) = related(i, 1)
	endif
next

*!! Assign a dummy value if none is found:
if j = 0
	dimension relatives(1)
	relatives(1) = space(8)
else
	dimension relatives(j)
endif
show get pnBar1
***** BAR0_WHEN ENDP

* ------------------------------------------------------------------------------
function BAR0_VALID
* Toggle between a selected and an unselected file
*------------------------------------------------------------------------------
external array dbf_tbl
	
*!! Mark row if not marked and unmark if marked:
	
dbf_tbl(pnBar0)=iif(left(dbf_tbl(pnBar0),2)=pcMarker+' ','  ',pcMarker+' ')+;
	substr(dbf_tbl(pnBar0), 3)
		
show get pnBar0
return .F.
***** BAR0_VALID ENDP

* ------------------------------------------------------------------------------
function BTN0_VALID
* This function when TAG ALL or TAG NONE is selected.
* Either marks all database files, or unmarks them.
* ------------------------------------------------------------------------------
parameters pnButton0

do case
case pnButton0 = 1						&& Tag All.
	for i = 1 to alen(dbf_tbl)
		dbf_tbl(i) = pcMarker+' '+substr(dbf_tbl(i), 3)
	next
	show get pnBar0
case pnButton0 = 2						&& Tag None.
	for i = 1 to alen(dbf_tbl)
		dbf_tbl(i) = '  '+substr(dbf_tbl(i), 3)
	next
	show get pnBar0
endcase
***** BTN0_VALID ENDP

* ------------------------------------------------------------------------------
function BTN1_VALID
* This function when either CREATE or CANCEL is selected.
* ------------------------------------------------------------------------------
parameters pnButton1

do case
case pnButton1 = 1						&& Create.
	=create_it()
case pnButton1 = 2						&& Cancel.
	clear read
endcase
***** BTN1_VALID ENDP

* ------------------------------------------------------------------------------
procedure CREATE_IT
* You now have to create all the database files that has been 
*    selected, plus all its related files.
* Note that:
*    the list of database file names are now in the array dbf_tbl.
*	 The actual file names are substr(dbf_tbl(number),3)
*		because the first char was used for marking, and the
*		second char was always a space ' '.
*	 The list of their related files are in related(number,1).
* ------------------------------------------------------------------------------
external array dbf_tbl
	
if existing()   	&& Make sure not even one dbf file is existing.
	return
endif
pnCreated = 0		&& Counts number of created files.
for pnDBFctr = 1 to alen(dbf_tbl)
	if left(dbf_tbl(pnDBFctr), 1) = pcMarker
		pnCreated = pnCreated + 1
			
		do makedbf with STRF, substr(dbf_tbl(pnDBFctr), 3)
		=create_rela()
	endif
next
if pnCreated = 0
	wait window 'No files are tagged.' nowait
endif
***** CREATE_IT ENDP

* ------------------------------------------------------------------------------
procedure CREATE_RELA
* We now create all the related files.
* ------------------------------------------------------------------------------
external array related
	
for pnRctr = 1 to alen(related, 1)
	if related(pnRctr, 2) = pnDBFctr
		do makedbf with STRF, related(pnRctr, 1)
	endif
next
***** CREATE_RELA ENDP

* ------------------------------------------------------------------------------
function EXISTING
* ------------------------------------------------------------------------------
external array dbf_tbl, related
	
pnExisting = 0
dimension existing(1)
for pnDBFctr = 1 to alen(dbf_tbl)
	if left(dbf_tbl(pnDBFctr), 1) = pcMarker
		if file(substr(dbf_tbl(pnDBFctr), 3)+'.dbf')
			=rcrd_existing(substr(dbf_tbl(pnDBFctr), 3)) && Record it.
		endif
		for pnRctr = 1 to alen(related, 1)
			if related(pnRctr, 2) = pnDBFctr
				if file(related(pnRctr, 1)+'.dbf')
					=rcrd_existing(related(pnRctr, 1))	&& Record it.
				endif
			endif
		next
	endif  && if left(dbf_tbl(...
next

*!! If any of the files exist, disallow creation:
if pnExisting != 0
	do exist
	return .T.
else
	return .F.
endif
***** EXISTING ENDP

* ------------------------------------------------------------------------------
procedure RCRD_EXISTING
* Purpose : Record the .dbf file which exists to array 'existing'.
* ------------------------------------------------------------------------------
parameters pcDBFname
external array existing
	
if ascan(existing, pcDBFname) = 0
	pnExisting = pnExisting + 1
	dimension existing(pnExisting)
	existing(pnExisting) = pcDBFname
endif
***** RCRD_EXISTING ENDP

*------------------------------------------------------------------
procedure EXIST
*  This program was automatically generated by GENSCRN.  
*  It makes a window and enumerates an array of filenames 
*     that are already existing and why we cannot create the DBFs
*------------------------------------------------------------------
#REGION 0
REGIONAL m.currarea, m.talkstat, m.compstat
external array existing
* Window definitions 

IF NOT WEXIST("_qiw0n7k03")
	DEFINE WINDOW _qiw0n7k03 ;
		FROM INT((SROW()-16)/2),INT((SCOL()-24)/2) ;
		TO INT((SROW()-16)/2)+15,INT((SCOL()-24)/2)+23 ;
		NOFLOAT ;
		NOCLOSE ;
		SHADOW ;
		SYSTEM ;
		COLOR SCHEME 1
ENDIF

* EXISTING Screen Layout 

#REGION 1
IF WVISIBLE("_qiw0n7k03")
	ACTIVATE WINDOW _qiw0n7k03 SAME
ELSE
	ACTIVATE WINDOW _qiw0n7k03 NOSHOW
ENDIF
@ 5,3 GET m.dummy ;
	PICTURE "@&N" ;
	FROM existing ;
	SIZE 8,16 ;
	DEFAULT 1 ;
	COLOR SCHEME 2
@ 1,1 SAY "Cannot create files."
@ 2,1 SAY "The following files"
@ 3,1 SAY " exist:"

IF NOT WVISIBLE("_qiw0n7k03")
	ACTIVATE WINDOW _qiw0n7k03
ENDIF

READ CYCLE
RELEASE WINDOW _qiw0n7k03
#REGION 0

*****EXIST ENDP
