* ------------------------------------------------------------------------------
*Filename: 2TECHDOC.prg
*Purpose : Creates an .STR file for the creation of a 
*		  framework for additional inputs from the analyst 
*		  as a guide for programmer work.
*		 The structures of all database files in the current
*		 directory will be created and placed in a text file
*		 whose name is passed as parameter.  The default ext.
*		 '.str' is assumed if none is given.
*
*Author : Froilan C. Yu Yap / Wilson Ng
*		
*Created on August 14, 1993
*
*Copyright(C) 1993, Ng Khai Development Corp.  
* For comments, pls. e-mail to 73751,1012 @ Compuserve.com
* ------------------------------------------------------------------------------
parameters STR_FILE	

* If no extension specified, give it a .str extension
if at('.', STR_FILE) = 0
	STR_FILE = STR_FILE + '.str'
endif

* Store all *.dbf files in to an array
if adir(paDBFinDir, '*.dbf') = 0
	wait window 'Directory has no .dbf files.'
endif			&& Cannot process without any .dbf files.

*!! Save and alter some settings:
pcEscape = set('ESCAPE')
pcSafety = set('SAFETY')
set escape off
set safety off
set talk off
wait window 'Working ...  ' nowait				
				
*!! Create temporary files:

ALLFLDS = uniqdbf()		
	&& Will contain field names of all files.
FLDTABLE = uniqdbf()	
	&& Distinct fields and list of files they belong. 
DBFTABLE = uniqdbf()	
	&& Table of .dbf files in current directory.
TMPSTRUC = uniqdbf()	
	&& COPY STRUCTURE EXTENDED temp file.
STRF = uniqdbf()		
	&& Database for str text file.
		
create table (ALLFLDS)(field_name C(10), dbf N(3), link N(3))
* field_name is the name of the field 
* dbf is the index number of the database 
* to which the field belong
* link is the index number of the field if 
* it is found in other files

use (ALLFLDS) again alias ALLFLDS
create table (DBFTABLE) (dbfname C(8), dbflist C(100))
* dbfname is the name of the database file
* dbflist is a listing of the database files by number 
*      to whom the database is related to.

use (DBFTABLE) again alias DBFTABLE
create table (STRF) (line C(160))
use (STRF) again alias STRF
	

*!! Strip the filenames of extensions and store to DBFTABLE:


for m.i = 1 to alen(paDBFinDir, 1)
	paDBFinDir(m.i, 1) =; 
	left(paDBFinDir(m.i, 1), rat('.', paDBFinDir(m.i, 1)) - 1)
next
select DBFTABLE
append from array paDBFinDir
replace all dbflist with space(100)

		
*!! Store the field names of all files to ALLFLDS:

select 0
pcArea = select()		
select DBFTABLE
scan
	select (pcArea)
	use (DBFTABLE.dbfname)
	copy structure extended to (TMPSTRUC)  
				&& Get the field names ...
	select ALLFLDS
	pnLastRec = reccount() + 1
	append from (TMPSTRUC)			
				&& ... and store to ALLFLDS.
	go pnLastRec
	&& The databases are numbered 1 to no. of databases.
	&& rest field contains the number of the database 
	&& to which the field belong
	replace rest dbf with recno('DBFTABLE')
endscan
use in (pcArea)



*!! Cross-link the fields.
*!! Fields of all files are gathered into a file and grouped
*!!	according to their names.
*!! For each distinct field, the number of times the field 
*!!	occurs is stored in the 'occurrence' field.

create table (FLDTABLE) ( field_name C(10), occurrence N(3) ) 
use (FLDTABLE) again alias FLDTABLE
index on field_name tag 'field_name'


select ALLFLDS
plAborted = .F.
scan all while !plAborted     && User may press ESC to stop
	if chrsaw()
		=inkey()
		if lastkey() = 27 
			plAborted = .T.
			exit
		endif
	endif
	&& As you transfer the records to this file, seek out
	&& fields that occur more than once.
	&& Thus, for example, if custcode occurs three times,
	&& the field_name will be custcode, and occurence will be 3.
	
	select FLDTABLE
	if !seek(ALLFLDS.field_name)
		insert into (FLDTABLE) (field_name, occurrence) values ;
			(ALLFLDS.field_name, 1)
	else
		replace occurrence with occurrence + 1
	endif
endscan
	

*!! Put a number on the fields that occur more than one time.
*!! Like, if custcode field occurs > 1, then it becomes no.1.
*!! if next you find items field occur > 1, then it becomes no.2.
*!! if again, the next field is descript, then it becomes no. 3.
*!! All fields without duplicates will have no number.

select FLDTABLE
pnOver1x = 0
scan all for occurrence > 1
	pnOver1x = pnOver1x + 1
	select ALLFLDS
	replace all link with pnOver1x ;
		for field_name = FLDTABLE.field_name
endscan

if !plAborted
	for z = 1 to pnOver1x
		if chrsaw() 
			=inkey()
			if lastkey() = 27 
				plAborted = .T.
				exit
			endif
		endif
		select ALLFLDS
		scan all for ALLFLDS.link = z
		&& All records occuring more than once.
			go ALLFLDS.dbf in DBFTABLE
			select ALLFLDS
			pnRecord = recno()
			scan all for ALLFLDS.link = ;
				z and recno('DBFTABLE') != ALLFLDS.dbf
				select DBFTABLE
				&& Document the relation of the field by
				&& relating the database.
				replace dbflist with postnum(dbflist,;
					 ALLFLDS.dbf)
			endscan
			go pnRecord
		endscan
	next
endif


* Now we have finished the work.
* We know which fields are duplicated.
* We have numbered the fields that are duplicated.
* We have also numbered which databases are related.
* We create the structure file.
if !plAborted
	=MK_STR()				&& Create the structure file.
endif

set escape &pcEscape
set safety &pcSafety

*!! Close and delete temporary files:
use in ALLFLDS
erase (ALLFLDS)
use in DBFTABLE
erase (DBFTABLE)
use in STRF
erase (STRF)
use in FLDTABLE
erase (FLDTABLE)
erase ( left(FLDTABLE, 8) + '.cdx' )
erase (TMPSTRUC)
		
*****2TECHDOC ENDP
	
* ------------------------------------------------------------------------------
procedure MK_STR
* ------------------------------------------------------------------------------

*!! Declare and define .str's structure array:
	
dimension paSTRstruc(13)
=strstruc(@paSTRstruc)

select DBFTABLE
scan
	@ 0, 0 say padr('  Creating ' + DBFTABLE.dbfname, 20)
	=one_struc(DBFTABLE.dbfname, recno('DBFTABLE'),;
	 DBFTABLE.dbflist)
	&& Create the header of the database by passing
	&& the name of the database,
	&& its number
	&& its list of related files.
endscan	

select STRF
if reccount() != 0
	copy to ( STR_FILE ) sdf
endif

***** MK_STR ENDP

* ------------------------------------------------------------------------------
procedure ONE_STRUC
* Purpose : Create a structure for one database.
* ------------------------------------------------------------------------------
parameters DBF_FILE, pnDBFindex, pcDBFlist
private all like p?
external array paSTRstruc

select 0	
use ( DBF_FILE ) alias DBF_FILE

m.fields = afields(fld_array)

	
*!! Structure file's header:
	

select STRF
insert into (STRF) (line) values (paSTRstruc(1))
insert into (STRF) (line) values ('FILE# '+;
	str(pnDBFindex, 3)+'')
insert into (STRF) (line) values (paSTRstruc(3))
insert into (STRF) (line) values ;
	(' FILE@ '+padr(upper(DBF_FILE), 8)+''+space(101) + '')
insert into (STRF) (line) values (paSTRstruc(5))


*!! Indices:


m.tag_ctr = 1
m.tagname = tag(m.tag_ctr, 'DBF_FILE')
do while !empty(m.tagname)
	insert into (STRF) (line) values ('INDEX@ ' +;
	   padr(m.tagname, 10) + '' + padr(sys(14, m.tag_ctr,;
	    'DBF_FILE'), 99) + '')
	m.tag_ctr = m.tag_ctr + 1
	m.tagname = tag(m.tag_ctr, 'DBF_FILE')
enddo
insert into (STRF) (line) values (paSTRstruc(7))

	
*!! Related files list:


pcRelList = reldbf(pcDBFlist)
do while !empty(pcRelList)
	if len(pcRelList) > 110   && if list of related files will
					  && exceed 110 chars, continue next line
		pcRelLine = ;
			left(pcRelList, rat(',', left(pcRelList, 110)))
		pcRelList = substr(pcRelList, rat(',',;
			 left(pcRelList, 110))+1)
		insert into (STRF) (line) values ('RELA@  ' +;
			 padr(pcRelLine, 110) + '')
	else 
		insert into (STRF) (line) values ('RELA@  ' +;
			 padr(pcRelList, 110) + '')
		exit
	endif
enddo

insert into (STRF) (line) values (paSTRstruc(9))
insert into (STRF) (line) values (paSTRstruc(10))
insert into (STRF) (line) values (paSTRstruc(11))


*!! List out the Fields:

for m.fld_ctr = 1 to m.fields
	=seek(fld_array(m.fld_ctr, 1), 'FLDTABLE')
	insert into (STRF) (line) values ('~ ' + ;
		padr(fld_array(m.fld_ctr, 1), 10) + '' + ;
		transform(fld_array(m.fld_ctr, 2), '@I xxxxx') + '' + ;
		transform(fld_array(m.fld_ctr, 3), '@I 99999') + '' + ;
		transform(fld_array(m.fld_ctr, 4), '@I 99999') + ;
		substr(paSTRstruc(12), 32, 54) + ;
		iif(FLDTABLE.occurrence > 1, ;
			padr(alltrim(str(recno('FLDTABLE'))) +'-'+ ;
			alltrim(str(FLDTABLE.occurrence)), 7), ;
			space(7)) + ;
			'     '+padr(fld_array(m.fld_ctr, 1), 20)+'' )
next
insert into (STRF) (line) values (paSTRstruc(13))
use in DBF_FILE
	
***** ONE_STRUC ENDP

* ------------------------------------------------------------------------------
function UNIQDBF	
* Returns an alias-compatible temp file name.
* ------------------------------------------------------------------------------
return '_' + substr(sys(3), 2) + '.dbf'
***** UNIQDBF ENDP


* ------------------------------------------------------------------------------
function POSTNUM
* Purpose : Includes a given number in a comma-delimited 
*			list of numbers if
*			it still is not included.
* ------------------------------------------------------------------------------
parameters pcCommaLst, pnNumber
private all like p?

if !isinlist(pcCommaLst, pnNumber)
&& The number is not yet in the list
	for i = 1 to len(pcCommaLst)
		if empty(substr(pcCommaLst, i))
			exit
		endif
	next
	&& Add the number to the list
	return alltrim( alltrim(left(pcCommaLst, i)) + ;
		iif(!empty(pcCommaLst), ',', '') + ;
		alltrim(str(pnNumber)) )
else 
	return pcCommaLst
endif

***** POSTNUM ENDP

* ------------------------------------------------------------------------------
function ISINLIST
* Purpose : Searches a comma-delimited list of 
*			numbers for a given number.
* 			Returns T if found, F if not.
* ------------------------------------------------------------------------------
parameters pcSrchText, pnNumber
private all like p?

pnCommas = occurs(',', pcSrchText)  && How many times comma occur
for i = 1 to pnCommas + 1
	if val(strlist(pcSrchText, i, ',')) = pnNumber
		return .T.   					&& Found.
	endif
next
return .F.								&& Not found.
	
***** ISINLIST ENDP

* ------------------------------------------------------------------------------
function STRLIST
* Purpose : Returns the nth word of a list of words 
*			separated by a given delimiter.
* ------------------------------------------------------------------------------
parameters pcString, pnPosition, pcDelimiter
private all like p?

* get the start position
pnDel0 = iif(pnPosition = 1,0,at(pcDelimiter,;
	 pcString, pnPosition - 1))

pnDel1 = at(pcDelimiter, pcString, pnPosition)
* means it is the first string.
pnDel1 = iif(pnDel1 = 0, len(pcString) + 1, pnDel1)

*Get the string by starting at the start position,
* and the length is (endposition-start position-1).			
return substr(pcString, pnDel0 + 1, pnDel1 - pnDel0 - 1)
***** STRLIST ENDP

* ------------------------------------------------------------------------------
function RELDBF
* Purpose : Returns a list of dbf names from a list 
* 			of indices to dbf names.
* 	Upon return, the string will contain something like this.
*     1,2,5,6 - that means these databases are related
*			    to these files.
* ------------------------------------------------------------------------------
parameters pcDbfList
private all like p?

if empty(pcDbfList)
	return ''
endif
pnRecord = recno('DBFTABLE')
* How many times the comma occurs
pnCommas = occurs(',', pcDbfList)

pcRelFiles = ''

*Number of files is number of commas + 1
for pnDbfIndex = 1 to pnCommas + 1
	 go val(strlist(pcDbfList, pnDbfIndex, ',')) in DBFTABLE
	 pcRelFiles = postname(pcRelFiles, DBFTABLE.dbfname)
	 	&& put that database file to your list.
next
go pnRecord in DBFTABLE
return pcRelFiles
***** RELDBF ENDP

* ------------------------------------------------------------------------------
function POSTNAME
* Purpose : Includes a given string in a 
*			comma-delimited list of strings.
* ------------------------------------------------------------------------------
parameters pcCommaLst, pcName
private all like p?

for i = 1 to len(pcCommaLst)
	if empty(substr(pcCommaLst, i))
		exit
	endif
next
return alltrim( alltrim(left(pcCommaLst, i)) + ;
	iif(!empty(pcCommaLst), ',', '') + ;
	alltrim(pcName) )

***** POSTNAME ENDP

* ------------------------------------------------------------------------------
procedure STRSTRUC
* Purpose : Initialize str's structure to array.
* ------------------------------------------------------------------------------
parameters paSTRstruc
external array paSTRstruc

paSTRstruc(1) = 'Ŀ'
paSTRstruc(2) = 'FILE#    '
paSTRstruc(3) = '' + ;
				'' + ;
				'Ŀ' 
paSTRstruc(4) = ' FILE@                                    ' + ;
		    	'                                             ' + ;
 				'                             '
paSTRstruc(5) = '' + ;
				'' + ;
				'Ĵ'
paSTRstruc(6) = 'INDEX@                                    ' + ;
				'                                             ' + ;
				'                             '
paSTRstruc(7) = '' + ;
				'' + ;
				'Ĵ'
paSTRstruc(8) = 'RELA@                                      ' + ;
				'                                             ' + ;
				'                             '
paSTRstruc(9) = '' + ;
				'' + ;
				'Ĵ'
paSTRstruc(10)= ' FIELD NAME TYPE WIDTH DEC       PICTURE' + ;
				'       EUM     VALID      DEFAULT  RELA' + ;
				'  RMRKS       PROMPT       '
paSTRstruc(11)= '' + ;
				'' + ;
				'Ĵ'
paSTRstruc(12)= '~                                       ' + ;
				'                                       ' + ;
				'                           '  
paSTRstruc(13)= '' + ;
				'' + ;
				''

***** STRSTRUC ENDP
