* ------------------------------------------------------------------------------
*		Filename: MakeDbf.Prg
*		Purpose : Create databases using str file.  Str file must conform
*				  to the structure below.
*				  
*		
*		Created on Friday, August 13, 1993  
*		Copyright(C) 1993, Ng Khai Development Corp.
*
* 				      !! STR file structure !!
*Ŀ
* FILE@ filename description of the file                                
*Ĵ 
*INDEX@ index_tag index_expression                                      
*Ĵ
*RELA@  file1, file2, ...                                                
*Ĵ 
* FIELD NAME TYPE WIDTH DEC  REMARKS                                   
*Ĵ 
*~ field_name c    10        description of the field                 
* ...         ...  ... ...   ....                                     
* 
*  Max number of chars in STR must not exceed 136 chars per line
*  Preferably should use STR files generated by 2TECHDOC.PRG
*  	    or 2USERMAN that is also written by Ng Khai and included in this
* 		set of utilities.
*  The above configuration should be strictly followed.
*
*  Variables above in all capital letters are prompts and is disregarded
*  by the program.  Variables in small letters are the variables that
*  become inputs in the program.
*
*  Parameters:  STRF  - The name of the STR File as input
*  				WHICHDBF-An STR file may contain more than
*						one database specification.  This parameter
*						will indicate which of the database will be 
*						created.  The user may also pass the parameter
*						'Allfiles', in which therefore all of the database
*						in that STR file will be created.
*
* We appreciate comments ,feedbacks and especially suggestions for 
* improvements.  Pls send to 73751.1012@ Compuserve.com
* ------------------------------------------------------------------------------
parameters STRF, WHICHDBF		
private all

m.params = parameters()			&& Get number of parameters
if m.params !=2            		&& Should have at least 2 params
	wait window 'Missing or invalid number of parameters.'
	return
endif


** Arrays for creating the database and associated compound index:
dimension structure(100, 4)					&& Max of 100 fields.
dimension indextags(20, 2)					&& Max of 20 tags.
m.fld_ctr = 1		&& Counter for field names specified
m.ndx_ctr = 1		&& Counter for number of indexes specified

**	Supply file name with default extension if it has none:	
if at('.', STRF) = 0								
	STRF = STRF + '.str'
endif
	
** Check if file exists:
if !file(STRF)
	wait window 'File does not exist.'
	return
endif
	
wait window 'Working ...  ' nowait
set safety off

** Copy the STR file to a dbf:	
STR = '_' + substr(sys(3), 2) + '.dbf' &&Create a unique Data filename
create table ( STR ) (line C(136))      && File with single field 136c
append from ( STRF ) sdf			   && read from STR file 
use ( STR ) again alias STR	
			   
** All the text in the STR file are now in a .DBF file.  Each line
** is equivalent to one record.
	
scan 
    m.fname_pos = at('FILE@', line)			&& DBF file name.
	if m.fname_pos != 0
		m.fld_ctr = 1
		m.ndx_ctr = 1
	&& The name of the file is on the 10th char to the 18th char	
		m.dbf_file = alltrim(substr(line, 10, 8))
		
		do while .T.
			&& Keep looping until you get all the indexes and 
			&& All the fields of the certain database file
			
			&& For each loop, it will either create a new index
			&& or a new field for a database
										
			&& Create the index
					
			m.tag_pos = at('INDEX@', line)	&& Index tag.
								
			if m.tag_pos != 0    		    && an index is specified
			  && Tag is presumed to be from the 10th to 20th char
		      indextags(m.ndx_ctr, 1) = upper(alltrim(substr(line,10,10)))
		      && Index Expression presumed to be 21th to 75th char
		      indextags(m.ndx_ctr, 2) = upper(alltrim(substr(line,21,54)))	
		      	=error_chk('INDEX')
		      && index counter increments by 1		
				m.ndx_ctr = m.ndx_ctr + 1
			endif
				
			m.fld_pos = at('~', line)		   && Field definition.
			if m.fld_pos != 0
	 			structure(m.fld_ctr, 1) =upper(left(alltrim(substr(line,;
	 				 3, 11)),10))			 && The field name
	 			structure(m.fld_ctr, 2) =upper(alltrim(substr(line,;
	 				 15, 5)))				 && The Field type
				structure(m.fld_ctr, 3) =val(substr(line, 21, 5)) 
											 && The Field Width
	 			structure(m.fld_ctr, 4)	=val(substr(line, 27, 5))
	 										 && The decimal
				=error_chk('FIELD')
				
				&& The remarks field is disregarded
					
				m.fld_ctr = m.fld_ctr + 1
			endif 
				
			if !eof()   && Not yet EOF, go to next record
				skip    && and process some more
			endif
				
			&& Maybe you have finished with the field, and
			&& encounter the next database file, or EOF()
				
			if at('FILE@', line) != 0 or eof()
				&& If the database file you do not want to create
				if !inlist(upper(WHICHDBF), 'ALLFILES', upper(m.dbf_file))
					skip -1
					exit         && Whew! Finally.
				endif
				m.fields = m.fld_ctr - 1
				m.indexes = m.ndx_ctr - 1
				
			    && Create now the Database file!
			    
				dimension structure(m.fields, 4)
				create table (m.dbf_file) from array structure
				for m.ndx_ctr = 1 to m.indexes
					m.index_tag = indextags(m.ndx_ctr, 1)
					m.index_expr = indextags(m.ndx_ctr, 2)
					index on &index_expr tag (m.index_tag) additive
				next
				use in (m.dbf_file)
				select STR
				
				dimension structure(100, 4)
				skip -1
				exit
			endif	&& if at ('File@',line)....
		enddo		&& While .T.
	endif			&& if m.fname_pos !=0
endscan				&& Scan
	

** Clean up and exit:
wait clear
set safety on
use in STR
delete file ( STR )
	
***** MAKEDBF ENDP	

* ------------------------------------------------------------------------------
procedure ERROR_CHK
* Purpose : Error checking if index expressions and field names are valid
* ------------------------------------------------------------------------------
parameters m.check_for
private m.name, m.type, m.width, m.dec, m.err_mess, m.char

do case
* Check the index.  Make sure that if an index Tag is specified,
* There is also a corresponding index expression.
	
case m.check_for = 'INDEX'				
if !empty(indextags(m.ndx_ctr, 1)) ;
	and empty(indextags(m.ndx_ctr, 2))
		=halt()
endif
   	
&& Check the field
case m.check_for = 'FIELD'				&& Error-check for fields.
	m.name = structure(m.fld_ctr, 1)
	m.type = structure(m.fld_ctr, 2)
	m.width = structure(m.fld_ctr, 3)
	m.dec = structure(m.fld_ctr, 4)

	&& Validate field name:
		
	if !isalpha(left(m.name, 1)) and left(m.name, 1) != '_'
		=halt('Invalid field name.')
	endif
	for i = 1 to len(m.name)
		m.char = substr(m.name, i, 1) 
		if !isalpha(m.char) and !isdigit(m.char) and m.char != '_'
			=halt('Invalid field name.')
		endif
	next
		
	&& Other validations:  	no decimals for chars
	&&						date must be 8 chars
	&&						Logical must be 1 char

	if 	(m.type = 'C' and m.dec != 0) ;  
		or (m.type = 'D' and m.width != 8) ; 
		or (m.type = 'L' and m.width != 1)   
		=halt()
	endif
endcase

***** ERROR_CHK ENDP

* ------------------------------------------------------------------------------
procedure HALT
*  This procedure will stop the program, and will indicate on what
*  Line the error occured.  To rectify the error, go to the STR
*  file and go to that line number specified by this procedure.
* ------------------------------------------------------------------------------
parameters m.mess

m.mess = iif(parameters() = 0, '', m.mess)
wait window 'Error in line '+alltrim(str(recno(), 4))+'. ' + m.mess
cancel
	
***** HALT ENDP