* ------------------------------------------------------------------------------
*	  Filename :2USERMAN.prg
*	   Purpose :Creates an .STR file from a database file so as to ease 
*				the user's documentation.
*
*				 Created on August 14, 1993
*			 By: Froilan Yu Yap / Wilson Ng, Ng Khai Dev. Corp.
*
*	Parameters : STR_FILE - name of the STR file you want to create
*				 DBF_FILE - name of the DBF you want to include.
*   			     If the dbf filename parameter is specified, only one
*	    			 structure is created, otherwise the structures of all
*		    		 databases in the current directory are created.
*
*	             Copyright(C) 1993, Ng Khai Development Corp.
*  For comments please e-mail to  73751,1012 @ Compuserve
* ------------------------------------------------------------------------------
parameters STR_FILE, DBF_FILE		&& Second param is optional.
close all
set talk off
set echo off
m.parms = parameters()

if at('.', STR_FILE) = 0        && Give extension if none
	STR_FILE = STR_FILE + '.str'
endif

wait window 'Working ...  ' nowait

* create a temporary file

STRF = '_' + substr(sys(3), 2) + '.sdb'
create table ( STRF ) (line C(80))
if m.parms = 1						&& Only the STR file is specified
	&& Put all existing .DBF into that STR file
						
	if adir(dbf_indir, '*.dbf') = 0
		wait window 'Directory has no .dbf files.'
	else
		for m.i = 1 to alen(dbf_indir, 1)
			m.dbf = left(dbf_indir(m.i, 1), at('.', dbf_indir(m.i, 1)) - 1)
			do mk_str with m.dbf
		next
	endif
else			&& Only 1 database file is to be included.
	do mk_str with DBF_FILE
endif


* Now copy to the desired STR file	
select ( STRF )
if reccount() != 0
	copy to ( STR_FILE ) sdf
endif
use in ( STRF )
delete file ( STRF )
	
wait clear
***** 2USERMAN ENDP	

	
* ------------------------------------------------------------------------------
procedure MK_STR
* ------------------------------------------------------------------------------
parameters DBF_FILE

select 0	
use ( DBF_FILE ) alias DBF_FILE
	
m.fields = afields(fld_array)
	
select ( STRF )
append blank
replace line with;
 ''+replicate('',42)+''
append blank
replace line with ' FILE@ ' + padr(upper(DBF_FILE), 8) +;
	 '                                                        '
append blank
replace line with;
 ''+replicate('',42)+''

m.tag_ctr = 1

* Now the indexes
m.tagname = tag(m.tag_ctr, 'DBF_FILE')
do while !empty(m.tagname)
	append blank
	replace line with 'INDEX@ ' + padr(m.tagname, 10) + '' +;
		 padr(sys(14, m.tag_ctr, 'DBF_FILE'), 54) + ''
	m.tag_ctr = m.tag_ctr + 1
	m.tagname = tag(m.tag_ctr, 'DBF_FILE')
enddo
append blank
replace line with;
 ''+replicate('',42)+'' 
append blank
replace line with;
 ' FIELD NAME TYPE WIDTH DEC  REMARKS                                  ' 
append blank 
replace line with;
 ''+replicate('',42)+''  

for m.fld_ctr = 1 to m.fields
	append blank
	replace line with '~ ' + ;
		padr(fld_array(m.fld_ctr, 1), 10) + '' + ;
		transform(fld_array(m.fld_ctr, 2), '@I xxxxx') + '' + ;
		transform(fld_array(m.fld_ctr, 3), '@I 99999') + '' + ;
		transform(fld_array(m.fld_ctr, 4), '@I 99999') + '                                          '
next
append blank
replace line with;
 ''+replicate('',42)+'' 
use in DBF_FILE
***** MK_STR ENDP