* mouse.prg
* derived from Turbo Prolog program mouse.pro
* requires inter.bin
* Andrew Schulman, 12 Humboldt Street, Cambridge MA 02140, 617-876-2102
* 8/11/87, revised 8/18/87, revised 8/20/87
* tested in dBase III Plus and FoxBase+ 2.0

* THIS SHOULD CHECK IF MOUSE IS INSTALLED -- SEE CHKDRV.PRG

if .not. file("inter.bin")
    ? "This program requires INTER.BIN and a Microsoft-" + ;
        "compatible mouse"
    return
endif

set talk off
set echo off
set scoreboard off

if type('didinter') = 'U'
    public didinter
    load inter
    didinter = .t.
endif

set proc to mouse
do main
set proc to

proc main
    okay = .f.
    do ms_init
    if .not. okay
        ? "Can't find MOUSE"
        return
    endif
    clear
    do ms_show
    do menudemo
    do constrain
    do putmouse
    @ 20,0 say "Done!  Remember, you can do all sorts of neat things with" + ;
        " INTER.BIN"
    do ms_hide
return

proc menudemo
    @ 1,0 say "INTER.BIN LETS YOU DO MICROSOFT MOUSE (INT 51) PROGRAMMING" + ;
        " IN dBASE"
    @ 2,0 say "Click the RIGHT mouse button (or select Quit) when done"
    @ 3,0 to 3,78 double
    msg=""
    do menu with 0
    @ 5,0 to 5,78 double
    do ms_vert with 4,21            && constrain
    store 0 to row,col,button
    do while (button <> 2)          && right button to quit
        do ms_stat
        if (row > 5 .and. col < 75 .and. button = 1)      && left button
            @ row,col say " "+ltrim(str(row))+","+ltrim(str(col))+" "
        endif
        if (button = 1 .and. row = 4)       && in the menu bar
            do menu with iif(col>=00 .and. col<11, 1, ;
                         iif(col>=11 .and. col<22, 2, ;
                         iif(col>=22 .and. col<35, 3, 4)))
        endif
    enddo
return

proc constrain
    do ms_vert with 6,14
    do ms_horz with 6,39
    @ 2,0 to 2,78 double
    @ 3,0 clear to 21,79
    @ 5,5 to 15,40 double
    @ 10,42 say "You can confine the mouse to a window"
    @ 11,42 say "Press any mouse button to continue"
    button = 0
    do while (button = 0)
        do ms_stat
    enddo
return

proc putmouse
    @ 3,0 clear to 21,79
    @ 5,5 to 15,40 double
    @ 10,42 say "You can even do a PutMouse"
    @ 11,42 say "Press any mouse button to continue"
    store 0 to button, y, x
    do while (button = 0)
        cmd="26 0 0 0 0"+space(20)      && get system time in raw ticks
        call inter with cmd
        y=max(6,mod(val(substr(cmd,19,5)),14))
        cmd="26 0 0 0 0"+space(20)
        call inter with cmd
        x=max(6,mod(val(substr(cmd,19,5)),39))
        do ms_put with y,x
        do ms_stat
    enddo
return

proc ms_init
    * also use CHKDRV.PRG to see if installed!
    ax = 0
    do inter with 51,ax,0,0,0
    if (ax <> 0)
        okay = .t.
    endif
return

proc ms_show
    call inter with "51 1 0 0 0"
return

proc ms_hide
    call inter with "51 2 0 0 0"
return

* left button = 1, right button = 2, no button down = 0
* both buttons down = 3
* since this is called constantly, make CALL directly, not through PROC,
* otherwise we lose mouse messages
proc ms_stat
    cmd = "51 3 0 0 0"+space(20)
    call inter with cmd
    button=val(substr(cmd,7,5))     && BX
    col=val(substr(cmd,13,5))/8     && CX
    row=val(substr(cmd,19,5))/8     && DX
return

proc ms_put
    param row,col
    cmd = "51 4 0 "+str(col*8)+str(row*8)
    call inter with cmd
return

proc ms_horz
    param min,max
    cmd="51 7 0"+str(min*8)+str(max*8)
    call inter with cmd
return

proc ms_vert
    param min,max
    cmd="51 8 0"+str(min*8)+str(max*8)
    call inter with cmd
return

* splice registers into command string (dBase BIN's only take one param!)
* parse return string into registers
proc inter
    param intno,ax,bx,cx,dx
    cmd = ltrim(str(intno)+str(ax)+str(bx)+str(cx)+str(dx))+space(10)
    call inter with cmd
    ax=val(substr(cmd,1,5))
    bx=val(substr(cmd,7,5))
    cx=val(substr(cmd,13,5))
    dx=val(substr(cmd,19,5))
return

proc menu
    param which
    do ms_hide
    @ 4,0 say "Menu 1  "
    @ 4,11 say "Menu 2  "
    @ 4,22 say "Menu 3    "
    @ 4,35 say "Quit"
    @ 20,0 say space(40)
    do case
        case (which = 1)
            @ 4,0 say "MENU ONE"
            msg="You clicked on menu number one"
        case (which = 2)
            @ 4,11 say "MENU TWO"
            msg="You selected the second menu item"
        case (which = 3)
            @ 4,22 say "MENU THREE"
            msg="You picked the third menu"
        case (which = 4)
            @ 4,35 say "QUIT!"
            button = 2
    endcase
    do ms_show
    @ 20,0 say msg
return
