* chkdrv.prg
* Andrew Schulman
* 12 Humboldt Street,Cambridge MA 02140
* check for presence of drivers like mouse or expanded memory
* cf. Microsoft Mouse programmer's guide,p.7-9
* According to Microsoft manual, if the first byte of supposed code is
* 0 or IRET (CFh==207), it's not installed
* AS 8/22/87, revised 8/27/87, revised 9/8/87 (doesn't need INTER.BIN)

parameters intno,msg

if .not. file("peek.bin")
    ? "This program requires PEEK.BIN"
    return
endif
if type('didpeek') = 'U'
    public didpeek
    load peek
    didpeek = .t.
endif

if (type('intno') = 'C')
	if (left(intno,1)='x' .or. left(intno,1)='X')
		*---- convert from hex string to decimal number, using PEEK operation
		cmd=intno+" 0 cd"+space(5)
		call peek with cmd
		intno=val(cmd)
		msg=msg+" (INT "+ltrim(str(intno))+")"
	endif
endif

pubvar="inst"+ltrim(str(intno))
public &pubvar
store .f. to &pubvar

*---- Get Interrupt Vector, stored at 0000:(intno*4)
*---- using PEEK instead of interrupt 21h, func 35h
cmd="0 "+str(intno*4)+" xw"
call peek with cmd
off=right(trim(cmd),4)
cmd="0 "+str((intno*4)+2)+" xw"
call peek with cmd
seg=right(trim(cmd),4)

if (seg="0000" .and. off="0000")
    ? msg + " not installed"
else
    cmd=seg+" "+off
    call peek with cmd
    p=asc(left(cmd,1))
    if (p=0 .or. p=207)
        ? msg + " not installed"
    else
        ? msg + " located at "+seg+":"+off
        store .t. to &pubvar
    endif
endif


