* PSP.PRG
* dBase III Plus program to examine & change Program Segment Prefix
* uses PEEK.BIN and INTER.BIN
* Andrew Schulman 9/1/87, revised 9/8/87: use undocumented DOS2 call if needed
* 12 Humboldt Street, Cambridge MA 02140

*----necessary formalities
if .not. file("inter.bin") .or. .not. file("peek.bin")
    ? "This program requires INTER.BIN and PEEK.BIN"
    return
endif
if type('didinter') = 'U'
    public didinter
    load inter
    didinter = .t.
endif
if type('didpeek') = 'U'
    public didpeek
    load peek
    didpeek = .t.
endif

set proc to psp
do main
set proc to

proc main
    clear
    *----get PSP address
    *----if DOS3, get from int 21h, func 62h (Ray Duncan, p.384)
    *----otherwise, use undocumented func 51h (Michael Hyman, p.189)
    cmd="x21 "+iif("3." $ os(), "x6200", "x5100")+" 0 0 0"+space(20)
    call inter with cmd
    bx=int(val(substr(cmd,7,5)))

    *----convert to hex (only necessary to display address on screen, since
    *----peek understands both decimal and hex)
    psp=""
    do hex with bx,psp
    ? "PSP at " + psp + ":0000"

    *----check that it's really okay: first 2 bytes must be INT 20 instruction
    cmd="x"+psp+" 0000 wx"
    call peek with cmd
    if .not. ("20CD" $ cmd)
        ? "Invalid PSP--something wrong"
        return
    endif

    *----get segment address of environment block, in hex
    env=""
    do getaddr with bx,44,env      && offset 2Ch
    ?? "     Environment block at " + env + ":0000"

    *----print out the environment, which consists of chr(0)-delimited strings
    *----use PEEK operation to retrieve next zero-delimited string
    len=0
    offset="0"
    str=" "
    ?
    ? "Edit the environment variables (but don't leave trailing blanks):"
    ?

    on error loop    
    vars=0
    do while .t.
        cmd="x"+env+str(len)+ " s"+space(50)
        call peek with cmd
        str=trim(cmd)       && problem if supposed to have trailing blanks!
        if (len(str) > 0)
            key=substr(str,1,at("=",str)-1)
            val=substr(str,at("=",str)+1)
            vars=vars+1
            v="var"+ltrim(str(vars))
            store "x"+env+" "+ltrim(str(len))+ " !!"+key to &v
            store getenv(key) to &key
            @ row()+1,0 say key get &key
            len=len+len(str)+1
        else
            exit
        endif
    enddo
    on error

    row=row()
    read
    @ row+2,0

    *---- now POKE any changes they made back into the environment
    i=0
    do while (i<vars)
        i=i+1
        var="var"+ltrim(str(i))
        name=substr(&var,at("!!",&var)+2)
        *---- only change it if there are no trailing blanks!
        if (len(trim(&name)) = len(&name))
            do putenv with name,&name,substr(&var,1,at("!!",&var)-1)
            @ row(),0 say "Changing " + name + space(20)
        else
            @ row(),0 say "NOT CHANGING " + name + space(10)
        endif
    enddo
    @ row(),0 say "Done! Check changed environment with GETENV() or RUN SET"
return

proc hex
    param dec,hexstr
    private hex, d
    hex="0123456789ABCDEF"
    hexstr=""
    d=dec
    do while (d>0)
        hexstr=substr(hex,mod(d,16)+1,1)+hexstr
        d=int(d/16)
    enddo
return

*----use peek operation to get word (two bytes) as hex string
proc getaddr
    param seg,ofs,addr
    cmd=ltrim(str(seg))+str(ofs)+" xw"
    call peek with cmd
    addr=trim(cmd)
return

*----POKE new values into environment, but first check that address is okay
proc putenv
    param envvar, newval, peekcmd
    cmd=peekcmd+" s"+space(50)
    call peek with cmd
    if (left(cmd,at("=",cmd)-1) <> envvar)
        ? "Trouble in River City"
    else
        seg=left(peekcmd,at(" ",peekcmd)-1)
        ofs=val(substr(peekcmd,at(" ",peekcmd)+1))
        *---- have to start poke AFTER len(name) and AFTER "="
        cmd=seg+str(ofs+len(envvar)+1)+" ps "+newval
        call peek with cmd
    endif
return

* dBase looks at PSP table for getenv(), so that you can see changes
* we made; but FoxBase must make its own copy of the table.  If you RUN SET,
* you can see the changes, but not if you getenv().  In dBase, if you
* change COMSPEC to something absurd like C:\CMD.EXE, pretending you're
* running OS/2, next you do a MODI COMM, dBase will say ......


