* FOX2INT.PRG
* INTERRUPTS FOR FOXBASE+ 2.0
* Andrew Schulman 7/24/87
* 12 Humboldt Street, Cambridge MA 02140
* NOTE:  many of the Fox sys() functions do the same work as more complicated
* udf's shown here

if .not. "FOXBASE+ REV 2" $ upper(version())
    ? "This program requires FoxBase+ vers. 2"
    return
endif
if .not. file("inter.bin")
    ? "This program requires INTER.BIN"
    return
endif

set proc to fox2int                 && this file
do main
set proc to

proc main
    tlk = sys(103)
    set talk off
    set status off
    set scoreboard off
    clear

    if type('didinter') = 'U'
        public didinter
        load inter
        didinter = .t.
    endif
    do convmem
    do expmem
    do clock
    do scroll
    do graphics
    ? "That's the end of the test -- I'm sure you could do better!"
    set talk &tlk       && Fox saves away previous state
return

* flexible function:  returns whatever caller wants
proc interrupt
    param intno, ax, bx, cx, dx, dsdx, retexp
    private cmd
    t = .t.     && t for dummy returns
    if (type('dsdx') = 'C' .and. len(dsdx) > 0)
        cmd = ltrim(str(intno))+str(ax)+str(bx)+str(cx)+str(dx) + " " + ;
            dsdx + space(5)
    else
        cmd = ltrim(str(intno))+str(ax)+str(bx)+str(cx)+str(dx) + space(10)
    endif
    call inter with cmd
    retexp = lower(retexp)
    * parse return string into registers
    ax=iif("ax" $ retexp,val(substr(cmd,1,5)),0)
    bx=iif("bx" $ retexp,val(substr(cmd,7,5)),0)
    cx=iif("cx" $ retexp,val(substr(cmd,13,5)),0)
    dx=iif("dx" $ retexp,val(substr(cmd,19,5)),0)
    * get hiword and loword of registers
    if ("h" $ retexp .or. "l" $ retexp)
        ah=iif("ah" $ retexp,int(ax/256),0)
        al=iif("al" $ retexp,int(mod(ax,256)),0)
        bh=iif("bh" $ retexp,int(bx/256),0)
        bl=iif("bl" $ retexp,int(mod(bx,256)),0)
        ch=iif("ch" $ retexp,int(cx/256),0)
        cl=iif("cl" $ retexp,int(mod(cx,256)),0)
        dh=iif("dh" $ retexp,int(dx/256),0)
        dl=iif("dl" $ retexp,int(mod(dx,256)),0)
        fl=iif("fl" $ retexp,val(substr(cmd,25,5)),0)       && flags
    endif
return &retexp

proc convmem
    * FoxBase+ 2.0 has sys(12) which tells amount of available memory
    ? "CONVENTIONAL MEMORY"
    ? interrupt(18,0,0,0,0,0,"ax"), "Kbytes conventional memory"
return

proc expmem
    priv emm
	if file("chkdrv.prg")
		?
		do chkdrv with 103,"LIM EMS"
		if inst103
			? "EXPANDED MEMORY MANAGER"
			free = interrupt(103,66*256,0,0,0,0,"bx")
			tot = interrupt(103,66*256,0,0,0,0,"dx")
			? free, "EMM pages free"
			? tot, "EMM total pages"
			? free*16, "EMM Kbytes free"
			? tot*16, "total EMM Kbytes"
		endif
    endif
return

proc clock
    ?
    ? "CLOCK:  RAW TICKS"
    * note complex expression for retval: also need check for al rollover
    i = 0
    r = row()+1
    do while (i < 120)
        x = interrupt(26,0,0,0,0,0,"dx+(cx*32768)")
        @ r,0 say str(x)
        i = i + 1
    enddo
return

proc scroll
    ?
    ? "SCROLLING TEST"
    ? "This should blank out screen from (5,5) to (15,15)"
    wait
    dummy = interrupt(16,6*256+15,5*256,5*256+5,15*256+15,0,"t")
return

proc graphics
    ?
    ? "GRAPHICS TEST"
    ? "This is a paltry graphics test"
    ? "It probably won't work on a Hercules card..."
    wait "Want to do the graphics test? (Y/N) " to graph
    if (graph $ "yYtT")
        set status off
        * set mode to graphics
        dummy = interrupt(16,6,0,0,0,0,"t")
        * draw some dots
        store 0 to row, column
        do while (row < 200)
            cmd="16 3073 0"+str(column)+str(row)
            call inter with cmd		&& do in-line inside loop
            column = column + 15
            row = row + 5
        enddo
        * wait for key
        dummy = interrupt(33,8*256,0,0,0,0,"t")
        * restore text mode
        dummy = interrupt(16,2,0,0,0,0,"t")
    endif
return

