***************************************************************************
*		Program:  
*	Programmer:  
*			Date:  
*		Purpose:  
*
*     DATE----  REVISION DESCRIPTION---------------------------------------
*
***************************************************************************

*---------------------------------
* Let's get our environment set up
*---------------------------------
*set escape off                       && Don't let the user suspend program
set safety off                       && Blow things away w/ reckless abandon
set talk off                         && Don't want system msgs displayed
set exact off                        && Better for comparing strings
set notify off                       && Suppress system messages
set near on                          && Stop at nearest match during seeks
set deleted on                       && Normally we don't want to see them

*---------------------------------
* Define our public variables
*---------------------------------
public MaxFiles

MaxFiles = 1                          && No. of files to back up/restore
public array FileNames(MaxFiles, 3)   && Array to hold file names
CtrlEnd = chr(23)                     && Assign the CTRL-END char 
AllDone = .f.

FileNames(1,1) = ""                   && Format is EXAMPLE.DBF
FileNames(1,2) = ""                   && Format is EXAMPLE.CDX
FileNames(1,3) = ""                   && Format is EXAMPLE.FPT

clear windows                         && Get rid of leftover windows
clear                                 && Clear any DOS stuff
*do OpenDBases with ""                 && Open databases and set relations

*on key label F1 do EasyHelp.Spr with program()   && F1 will call the help system

do template.mpr                       && Init the menu

read valid AllDone                    && Halt program execution

*---------------------------------
* Reset the environment variables
*---------------------------------
on key
set notify on
set safety on
set deleted off
set escape on
*close databases
clear windows
clear
set talk on

return


*-------------------------------------------------------------------------
*                     END OF MAIN PROGRAM
*-------------------------------------------------------------------------


*-------------------------------------------------------------------------
*	Procedure OpenDBases
*  This procedure opens the main databases and indexes that are used by
*  the program.
*
*  Parameter:  Mode - If mode = "R", then the databases will be reindexed.
*              Any code that opens special databases on the fly will need
*              to include it own checks for indexes and rebuild any that
*              are not found.
*
*-------------------------------------------------------------------------
Procedure OpenDBases
parameters Mode

	close databases              && Always close databases first
	
	if Mode = "R"                && If we want to open and reindex, then
		run erase *.cdx           && kill all the CDX files and set talk
		set talk window           && so we can see the reindexing occur.
		set notify on
	endif
	
*	select 0                                  && CHANGE THIS CODE TO OPEN
*	use nbranch alias nbranch                 && YOUR DATABASES
*	if .not. file("nbranch.cdx")
*		set talk on
*		index on branch tag branch additive
*		set talk off
*	endif
*	set order to branch

	set notify off
	
return


*-------------------------------------------------------------------------
*	Procedure BackIt
*  This procedure handles backing up the databases to a floppy disk.
*
*  ASSUMPTIONS:
*  A public array called FileNames should have been initialized to (R,3)
*  where R is the number of file sets (a file set being a DBF, CDX, and
*  FPT file).
*  The procedure to reopen the databases must be OpenDBases as defined
*  above.
*  The screen set ALERT.SCX must be included in the project.
*-------------------------------------------------------------------------
procedure BackIt

	*-------------------------------
	* Don't let other things happen
	* while we're doing a back-up.
	*-------------------------------

	push key clear
*	on key label F1 do easyhelp.spr with program()
	
	*-------------------------------
	* Be nice and confirm the choice
	*-------------------------------

	Phrase = "Back-up the data to floppy disk?"
	Answer = 1
	do alert.spr with Phrase, "Yes", "No", "", Answer
	
	if Answer = 1                                         && If user said Yes
		Phrase = "Select drive to back-up TO:"             && Let user choose
		Answer = 1                                         && the drive
		do alert.spr with Phrase, "A", "B", "", Answer
		if (Answer = 1 or Answer = 2) and lastkey() <> 27
			Drv = substr("AB", Answer, 1)       && Determine drive letter
			close databases                     && So copy command will work
			OrigPath = set("path")              && Remember old path
			set path to                         && Cancel path
			
			*---------------------------------------------
			* Now we'll do the actual back-up.  First we
			* back-up the database, then the index, then
			* the memo file.
			*---------------------------------------------
			
			for i = 1 to MaxFiles
				
				*---------------------------------------
				* Back up the DBF
				*---------------------------------------
				
				BackUpPath = Drv + ":\" + FileNames(i,1)
				MainPath   = FileNames(i,1)
				wait window "Backing up " + MainPath + " to " + BackUpPath nowait
				if file(MainPath)
					copy file &MainPath to &BackUpPath
				else
					wait MainPath + " is missing" nowait window
				endif

				*---------------------------------------
				* Back up the CDX
				*---------------------------------------
				
				BackUpPath = Drv + ":\" + FileNames(i,2)
				MainPath   = FileNames(i,2)
				if not empty(MainPath)
					wait window "Backing up " + MainPath + " to " + BackUpPath nowait
					if file(MainPath)
						copy file &MainPath to &BackUpPath
					else
						wait MainPath + " is missing" nowait window
					endif
				endif

				*---------------------------------------
				* Back up the FPT
				*---------------------------------------
				
				BackUpPath = Drv + ":\" + FileNames(i,3)
				MainPath   = FileNames(i,3)
				if not empty(MainPath)
					wait window "Backing up " + MainPath + " to " + BackUpPath nowait
					if file(MainPath)
						copy file &MainPath to &BackUpPath
					else
						wait MainPath + " is missing" nowait window
					endif
				endif

			endfor
			
			set path to &OrigPath            && Restore original path
			do OpenDBases with ""            && Re-open the databases
		endif
	endif
	
	wait clear
	pop key

return


*-------------------------------------------------------------------------
*	Procedure RestoreIt
*  This procedure handles restoring the databases from a floppy disk.  It
*  only restores the DBF and FPT files.  The CDX files are recreated.
*
*  ASSUMPTIONS:
*  A public array called FileNames should have been initialized to (R,3)
*  where R is the number of file sets (a file set being a DBF, CDX, and
*  FPT file).
*  The procedure to reopen the databases must be OpenDBases as defined
*  above.
*  The screen set ALERT.SCX must be included in the project.
*-------------------------------------------------------------------------
procedure RestoreIt

	*-------------------------------
	* Don't let other things happen
	* while we're doing a back-up.
	*-------------------------------

	push key clear
*	on key label F1 do easyhelp.spr with program()
	
	*-------------------------------
	* Be nice and confirm the choice
	*-------------------------------

	Phrase = "Restore from floppy disk?"
	Answer = 1
	do alert.spr with Phrase, "Yes", "No", "", Answer
	
	if Answer <> 1                     && If user didn't say Yes
		pop key
		return
	endif
	
	Phrase = "Select drive to restore FROM:"             && Let user choose
	Answer = 1                                           && the drive
	do alert.spr with Phrase, "A", "B", "", Answer
	if (Answer = 1 or Answer = 2) and lastkey() <> 27
		close databases
		Drv = substr("AB", Answer, 1)
		if ChkFiles(Drv)
			for i = 1 to MaxFiles

				*---------------------------------------
				* Restore the DBF
				*---------------------------------------

				RestorePath = Drv + ":\" + FileNames(i,1)
				MainPath    = FileNames(i,1)
				wait window "Restoring " + MainPath + " from " + RestorePath nowait
				copy file &RestorePath to &MainPath

				*---------------------------------------
				* Restore the FPT
				*---------------------------------------

				RestorePath = Drv + ":\" + FileNames(i,3)
				MainPath    = FileNames(i,1)
				wait window "Restoring " + MainPath + " from " + RestorePath nowait
				copy file &RestorePath to &MainPath

			endfor
		else
			Phrase = "One of the required files is missing. Unable to restore."
			Answer = 1
			do alert.spr with Phrase, "OK", "", "", Answer
		endif
		do OpenDBases with "R"
		show gets
	endif
	
	pop key
	
return


*-------------------------------------------------------------------------
*	Function ChkFiles
*  This procedure checks to make sure all the required databases are on
*  the floppy before a restore is performed.  It only checks for the
*  database and any memo files (.FPT files).  It does not check for CDX
*  files, since these are recreated after the restore.
*-------------------------------------------------------------------------
function ChkFiles
parameter TheDrv

	ItsOK = .t.
	for i = 1 to MaxFiles

		*---------------------------------------
		* Check for the DBF
		*---------------------------------------

		TheFile = TheDrv + ":\" + FileNames(i,1)
		if not empty(FileNames(i,1)) and not file(TheFile)
			ItsOK = .f.
			exit
		endif

		*---------------------------------------
		* Check for the FPT
		*---------------------------------------

		TheFile = TheDrv + ":\" + FileNames(i,3)
		if not empty(FileNames(i,3)) and not file(TheFile)
			ItsOK = .f.
			exit
		endif

	endfor
	
return ItsOK


*-------------------------------------------------------------------------
*	Procedure BldIndexes
*  This procedure rebuild the database indexes by simply calling
*  OpenDBases with the reindex flag.
*-------------------------------------------------------------------------
procedure BldIndexes

	Phrase = "Rebuild database indexes?"
	Ch1 = "Yes"
	Ch2 = "No"
	Ch3 = ""
	Choice = 1
	do alert.spr with Phrase, Ch1, Ch2, Ch3, Choice
	
	If Choice = 1
		do OpenDBases with "R"
	endif
	
return


*-------------------------------------------------------------------------
*	Procedure ErrTrap
*  This procedure will allow the user five choices about how to recover 
*  from an error.  Normally the user should only pick RETRY, RESUME, or
*  QUIT.  If they are talking to us on the phone we might have them
*  choose SUSPEND or CANCEL and attempt to determine the cause of the error.
*-------------------------------------------------------------------------
procedure ErrTrap

	*---------------------------------------
	* Define a window for the error messages
	*---------------------------------------
	
	define window ErrWind from 5,10 to 15,70;
		title "Program Error" double noclose nofloat;
		nogrow nozoom shadow	COLOR W+/R,N/R,W+/R,W+/R,N/R
	activate window ErrWind
	
	@01,01 say "Err Msg  :  " + message()      && Show error message
	@02,01 say "Proc Name:  " + program(2)     && Show procedure name
	@03,01 say "Prog Name:  " + program(1)     && Show program name
	
	GoodChoice = .f.                           && Initialize
	do while .not. GoodChoice

		@07,15      prompt " Resume "           && Give user his choices
		@07,col()+1 prompt " Retry "
		@07,col()+1 prompt " Quit "
		menu to Choice
		
		GoodChoice = Choice <> 0          && Escape is not a valid choice

	enddo

	release window ErrWind
	
	do case
		case Choice = 0
		case Choice = 1
			Return              && Pick up where we left off
		case Choice = 2
			Retry               && Try the operation again
		case Choice = 3
			Quit                && Cancel program, quit FoxPro
	endcase
		
return