* Function MONEY
* Enter with Numeric parameter containing value to be converted
* Handles conversions to $999,999,999.99
* Author:  Alan P. Goodrich
* Date: February 9, 1993

function money  
  parameter amt  
  d=set("decimals")
  set decimals to 6
  if !type("amt")="N"
    set decimals to d
    return "ERROR - Must Pass Numeric Value"
  endif  
  private h, t, o, mil, tho, one, cents, amt, hx, tx, ox, tox, onex
  private a10x, a100x, centsx, ans, thox, milx, a100, a10, a1, ans
  store " " to hx, tx, ox, tox, onex, a10x, a100x, centsx, ans, thox, milx
  store 0 to h, t, o, a100, a10, a1
  mil=int(m.amt/1000000)                          &&  get 3 digit millions         
  tho=int((m.amt-(mil*1000000))/1000)             && get 3 digit thousands
  one=int(m.amt-(mil*1000000)-(tho*1000))         && get 3 digit dollars
  cents=int(100*(m.amt-(mil*1000000)-(tho*1000)-one))  && Get cents

  if mil>0                && Convert Millions to alpha
    a100=mil
    do makex
    milx=a100x+" Million"
  endif  
  
  if tho>0                && Convert Thousands to alpha
    a100=tho
    do makex
    thox=a100x+" Thousand"
  endif  

  if one > 0              && Convert Dollars to alpha
    a100=one           
    do makex 
    onex=a100x
  endif
  
  if cents>0              && Convert Pennys to alpha
    a100=cents
    do makex
    centsx=a100x
  endif  
  
  do case               && Put dollars & thousands together 
    case empty(thox)    
      ans=onex
    case empty(onex)
      ans=thox
    otherwise
      ans=thox+", "+onex
  endcase       
  
  do case               && Add in the millions
    case empty(ans)
      ans=milx
    case empty(milx)
      ans=ans
    otherwise
      ans=milx+", "+ans
  endcase       
  

  
  do case                               && Now merge in the cents
    case !empty(ans)
      do case 
        case empty(centsx)
          ans=ans+" & No/100"           && Here if No Cents     
        otherwise
          ans=ans+" & "+str(cents,2)+"/100"  
      endcase
    otherwise
      do case
        case empty(centsx)
          ans="No Dollars & No Cents"   && Here if amt is zero
        otherwise
          ans=centsx+" Cents"
      endcase
  endcase         
  
  set decimals to d      
  return ans                        && Return
 

procedure makex                     && Convert 3 digit numeric to alpha 
  h=int(a100/100)                   && How many Hundreds
  t=int((a100-(h*100))/10)          && Calc the tens
  o=a100-(h*100)-(t*10)             && Now the ones
  if h>0                            && Convert Hundreds to alpha                           
    a1=h
    do 1_9
    hx=ox+" Hundred"
  else
    hx=""
  endif  
  tox="" 
  a10=t
  A1=o
  do 10_99                          && Go convert the tens
  
  if t<>1                           && Go convert the ones if not in teens
    a1=o
    do 1_9
  endif
 
  do case                           && Merge ones & tens together
    case empty(ox)          
      tox=tx
    case empty(tx)
      tox=ox
    otherwise
      tox=tx+"-"+ox
  endcase      

  do case                           && Merge in the hundreds
    case empty(hx)
      a100x=tox
    case empty(tox)
      a100x=hx
    otherwise
      a100x=hx+", "+tox
  endcase        
  
   

procedure 10_99                     && Convert Tens to alpha
  tx=""
  ox=""
  do case
    case a10<1
      tx=""
    case a10<2                      && Special Route if ten to 19
      do case
        case a1=9
          tx="Nineteen"
        case a1=8
          tx="Eighteen"  
        case a1=7
          tx="Seventeen"
        case a1=6
          tx="Sixteen"
        case a1=5
          tx="Fifteen"
        case a1=4
          tx="Fourteen"
        case a1=3
          tx="Thirteen"
        case a1=2
          tx="Twelve"
        case a1=1
          tx="Eleven" 
        otherwise
          tx="Ten"  
      endcase 
    case t<3
      tx="Twenty"    
    case t<4
      tx="Thirty"
    case t<5
      tx="Forty"      
    case t<6
      tx="Fifty" 
    case t<7
      tx="Sixty"
    case t<8
      tx="Seventy"
    case t<9
      tx="Eighty"
    otherwise
      tx="Ninety"  
  endcase  
 

procedure 1_9                          &&  Convert ones to alpha
  do case
    case a1=1
      ox="One"
    case a1=2
      ox="Two"
    case a1=3
      ox="Three"
    case a1=4
      ox="Four"
    case a1=5
      ox="Five"
    case a1=6
      ox="Six"
    case a1=7
      ox="Seven"
    case a1=8
      ox="Eight"
    case a1=9
      ox="Nine"  
  endcase    
