* MainMenu.prg
* Copyright 1994, QT Enterprises
* Author:  David L. Woodworth
* Created: 04/18/94 Version 1.0
* Updated: 04/18/94
* Displays the main menu and directs selections from it
*******************************************************
SET TALK OFF
ON ESCAPE DO EXITPROC						&& Line 279

*-----	System Variables
M_App1 = " New Application "
M_App2 = " N E W   A P P L I C A T I O N "
Your_Co = " Your Application's Name - Copyright 1994, Your Company "
Emp = SPACE(3)
WhoDidIt = SPACE(9)

*-----	Security Log-in
DO Login											&& Line 391

*-----	Open All Databases and Set System Variables
DO OpenFiles									&& Line 321
CLEAR

*-----	Add Wallpaper or Logo at this point
DO Logo											&& Line 292

*-----	Create a Menu and Define Its Pads.
DO MakeMenu										&& Line  43

*-----   Activate the Menu
ACTIVATE MENU Main

*-----	On Exit from Menu do Housekeeping and Exit
DO EXITPROC										&& Line 279
RETURN


**********************************************************************
*													PROCEDURES
**********************************************************************

PROCEDURE MakeMenu
*-----------------
	*-----	Create a menu called Main and define its Pads.
	DEFINE MENU Main
	DEFINE PAD Pad1 OF Main PROMPT "1_____" AT 01,01
	DEFINE PAD Pad2 OF Main PROMPT "2_____" AT 01,10
	DEFINE PAD Pad3 OF Main PROMPT "3_____" AT 01,19
	DEFINE PAD Pad4 OF Main PROMPT "4_____" AT 01,28
	DEFINE PAD Pad5 OF Main PROMPT "5_____" AT 01,37
	DEFINE PAD Pad6 OF Main PROMPT "6_____" AT 01,46
	DEFINE PAD Pad7 OF Main PROMPT "7_____" AT 01,55
	DEFINE PAD Pad8 OF Main PROMPT "8_____" AT 01,64
	DEFINE PAD Pad9 OF Main PROMPT "Files " AT 01,73
	
	*-----	Assign popups to the pads
	ON SELECTION PAD Pad1 OF Main ACTIVATE POPUP pop_1
	ON SELECTION PAD Pad2 OF Main ACTIVATE POPUP pop_2
	ON SELECTION PAD Pad3 OF Main ACTIVATE POPUP pop_3
	ON SELECTION PAD Pad4 OF Main ACTIVATE POPUP pop_4
	ON SELECTION PAD Pad5 OF Main ACTIVATE POPUP pop_5
	ON SELECTION PAD Pad6 OF Main ACTIVATE POPUP pop_6
	ON SELECTION PAD Pad7 OF Main ACTIVATE POPUP pop_7
	ON SELECTION PAD Pad8 OF Main ACTIVATE POPUP pop_8
	ON SELECTION PAD Pad9 OF Main ACTIVATE POPUP pop_9
	
	
	*-----   Define the Pop_1 popup
	DEFINE POPUP pop_1 FROM 02,00 MESSAGE "POPUP 1 - Not Yet Defined"
	DEFINE BAR 1 OF pop_1 PROMPT "1-1_________________"
	DEFINE BAR 2 OF pop_1 PROMPT "1-2_________________"
	DEFINE BAR 3 OF pop_1 PROMPT "1-3_________________"
	DEFINE BAR 4 OF pop_1 PROMPT "1-4_________________"
	DEFINE BAR 5 OF pop_1 PROMPT "1-5_________________"
	DEFINE BAR 6 OF pop_1 PROMPT "1-6_________________"
	DEFINE BAR 7 OF pop_1 PROMPT "1-7_________________"
	DEFINE BAR 8 OF pop_1 PROMPT "1-8________________2"
	DEFINE BAR 9 OF pop_1 PROMPT "1-9_5678901234567890"
	ON SELECTION BAR 1 OF pop_1 DO NOT_DONE
	ON SELECTION BAR 2 OF pop_1 DO NOT_DONE
	ON SELECTION BAR 3 OF pop_1 DO NOT_DONE
	ON SELECTION BAR 4 OF pop_1 DO NOT_DONE
	ON SELECTION BAR 5 OF pop_1 DO NOT_DONE
	ON SELECTION BAR 6 OF pop_1 DO NOT_DONE
	ON SELECTION BAR 7 OF pop_1 DO NOT_DONE
	ON SELECTION BAR 8 OF pop_1 DO NOT_DONE
	ON SELECTION BAR 9 OF pop_1 DO NOT_DONE		&& Line 260
	
	*-----   Define the POP_2 popup
	DEFINE POPUP pop_2 FROM 02,09 MESSAGE "POPUP 2 - Not Yet Defined"
	DEFINE BAR 1 OF pop_2 PROMPT "2-1_________________"
	DEFINE BAR 2 OF pop_2 PROMPT "2-2_________________"
	DEFINE BAR 3 OF pop_2 PROMPT "2-3_________________"
	DEFINE BAR 4 OF pop_2 PROMPT "2-4_________________"
	DEFINE BAR 5 OF pop_2 PROMPT "2-5_________________"
	DEFINE BAR 6 OF pop_2 PROMPT "2-6_________________"
	DEFINE BAR 7 OF pop_2 PROMPT "2-7_________________"
	DEFINE BAR 8 OF pop_2 PROMPT "2-8________________2"
	DEFINE BAR 9 OF pop_2 PROMPT "2-9_5678901234567890"
	ON SELECTION BAR 1 OF pop_2 DO NOT_DONE
	ON SELECTION BAR 2 OF pop_2 DO NOT_DONE
	ON SELECTION BAR 3 OF pop_2 DO NOT_DONE
	ON SELECTION BAR 4 OF pop_2 DO NOT_DONE
	ON SELECTION BAR 5 OF pop_2 DO NOT_DONE
	ON SELECTION BAR 6 OF pop_2 DO NOT_DONE
	ON SELECTION BAR 7 OF pop_2 DO NOT_DONE
	ON SELECTION BAR 8 OF pop_2 DO NOT_DONE
	ON SELECTION BAR 9 OF pop_2 DO NOT_DONE		&& Line 260
	
	*-----   Define the pop_3 popup
	DEFINE POPUP pop_3 FROM 02,18 MESSAGE "POPUP 3 - Not Yet Defined"
	DEFINE BAR 1 OF pop_3 PROMPT "3-1_________________"
	DEFINE BAR 2 OF pop_3 PROMPT "3-2_________________"
	DEFINE BAR 3 OF pop_3 PROMPT "3-3_________________"
	DEFINE BAR 4 OF pop_3 PROMPT "3-4_________________"
	DEFINE BAR 5 OF pop_3 PROMPT "3-5_________________"
	DEFINE BAR 6 OF pop_3 PROMPT "3-6_________________"
	DEFINE BAR 7 OF pop_3 PROMPT "3-7_________________"
	DEFINE BAR 8 OF pop_3 PROMPT "3-8________________2"
	DEFINE BAR 9 OF pop_3 PROMPT "3-9_5678901234567890"
	ON SELECTION BAR 1 OF pop_3 DO NOT_DONE
	ON SELECTION BAR 2 OF pop_3 DO NOT_DONE
	ON SELECTION BAR 3 OF pop_3 DO NOT_DONE
	ON SELECTION BAR 4 OF pop_3 DO NOT_DONE
	ON SELECTION BAR 5 OF pop_3 DO NOT_DONE
	ON SELECTION BAR 6 OF pop_3 DO NOT_DONE
	ON SELECTION BAR 7 OF pop_3 DO NOT_DONE
	ON SELECTION BAR 8 OF pop_3 DO NOT_DONE
	ON SELECTION BAR 9 OF pop_3 DO NOT_DONE		&& Line 260
	
	*-----   Define the pop_4 popup
	DEFINE POPUP pop_4 FROM 02,27 MESSAGE "POPUP 4 - Not Yet Defined"
	DEFINE BAR 1 OF pop_4 PROMPT "4-1_________________"
	DEFINE BAR 2 OF pop_4 PROMPT "4-2_________________"
	DEFINE BAR 3 OF pop_4 PROMPT "4-3_________________"
	DEFINE BAR 4 OF pop_4 PROMPT "4-4_________________"
	DEFINE BAR 5 OF pop_4 PROMPT "4-5_________________"
	DEFINE BAR 6 OF pop_4 PROMPT "4-6_________________"
	DEFINE BAR 7 OF pop_4 PROMPT "4-7_________________"
	DEFINE BAR 8 OF pop_4 PROMPT "4-8________________2"
	DEFINE BAR 9 OF pop_4 PROMPT "4-9_5678901234567890"
	ON SELECTION BAR 1 OF pop_4 DO NOT_DONE
	ON SELECTION BAR 2 OF pop_4 DO NOT_DONE
	ON SELECTION BAR 3 OF pop_4 DO NOT_DONE
	ON SELECTION BAR 4 OF pop_4 DO NOT_DONE
	ON SELECTION BAR 5 OF pop_4 DO NOT_DONE
	ON SELECTION BAR 6 OF pop_4 DO NOT_DONE
	ON SELECTION BAR 7 OF pop_4 DO NOT_DONE
	ON SELECTION BAR 8 OF pop_4 DO NOT_DONE
	ON SELECTION BAR 9 OF pop_4 DO NOT_DONE		&& Line 260
	
	*-----   Define the pop_5 popup
	DEFINE POPUP pop_5 FROM 02,36 MESSAGE "POPUP 5 - Not Yet Defined"
	DEFINE BAR 1 OF pop_5 PROMPT "5-1_________________"
	DEFINE BAR 2 OF pop_5 PROMPT "5-2_________________"
	DEFINE BAR 3 OF pop_5 PROMPT "5-3_________________"
	DEFINE BAR 4 OF pop_5 PROMPT "5-4_________________"
	DEFINE BAR 5 OF pop_5 PROMPT "5-5_________________"
	DEFINE BAR 6 OF pop_5 PROMPT "5-6_________________"
	DEFINE BAR 7 OF pop_5 PROMPT "5-7_________________"
	DEFINE BAR 8 OF pop_5 PROMPT "5-8________________2"
	DEFINE BAR 9 OF pop_5 PROMPT "5-9_5678901234567890"
	ON SELECTION BAR 1 OF pop_5 DO NOT_DONE
	ON SELECTION BAR 2 OF pop_5 DO NOT_DONE
	ON SELECTION BAR 3 OF pop_5 DO NOT_DONE
	ON SELECTION BAR 4 OF pop_5 DO NOT_DONE
	ON SELECTION BAR 5 OF pop_5 DO NOT_DONE
	ON SELECTION BAR 6 OF pop_5 DO NOT_DONE
	ON SELECTION BAR 7 OF pop_5 DO NOT_DONE
	ON SELECTION BAR 8 OF pop_5 DO NOT_DONE
	ON SELECTION BAR 9 OF pop_5 DO NOT_DONE		&& Line 260
	
	*-----   Define the pop_6 popup
	DEFINE POPUP pop_6 FROM 02,45 MESSAGE "POPUP 6 - Not Yet Defined"
	DEFINE BAR 1 OF pop_6 PROMPT "6-1_________________"
	DEFINE BAR 2 OF pop_6 PROMPT "6-2_________________"
	DEFINE BAR 3 OF pop_6 PROMPT "6-3_________________"
	DEFINE BAR 4 OF pop_6 PROMPT "6-4_________________"
	DEFINE BAR 5 OF pop_6 PROMPT "6-5_________________"
	DEFINE BAR 6 OF pop_6 PROMPT "6-6_________________"
	DEFINE BAR 7 OF pop_6 PROMPT "6-7_________________"
	DEFINE BAR 8 OF pop_6 PROMPT "6-8________________2"
	DEFINE BAR 9 OF pop_6 PROMPT "6-9_5678901234567890"
	ON SELECTION BAR 1 OF pop_6 DO NOT_DONE
	ON SELECTION BAR 2 OF pop_6 DO NOT_DONE
	ON SELECTION BAR 3 OF pop_6 DO NOT_DONE
	ON SELECTION BAR 4 OF pop_6 DO NOT_DONE
	ON SELECTION BAR 5 OF pop_6 DO NOT_DONE
	ON SELECTION BAR 6 OF pop_6 DO NOT_DONE
	ON SELECTION BAR 7 OF pop_6 DO NOT_DONE
	ON SELECTION BAR 8 OF pop_6 DO NOT_DONE
	ON SELECTION BAR 9 OF pop_6 DO NOT_DONE		&& Line 260
	
	*-----   Define the pop_7 popup
	DEFINE POPUP pop_7 FROM 02,54 MESSAGE "POPUP 7 - Not Yet Defined"
	DEFINE BAR 1 OF pop_7 PROMPT "7-1_________________"
	DEFINE BAR 2 OF pop_7 PROMPT "7-2_________________"
	DEFINE BAR 3 OF pop_7 PROMPT "7-3_________________"
	DEFINE BAR 4 OF pop_7 PROMPT "7-4_________________"
	DEFINE BAR 5 OF pop_7 PROMPT "7-5_________________"
	DEFINE BAR 6 OF pop_7 PROMPT "7-6_________________"
	DEFINE BAR 7 OF pop_7 PROMPT "7-7_________________"
	DEFINE BAR 8 OF pop_7 PROMPT "7-8________________2"
	DEFINE BAR 9 OF pop_7 PROMPT "7-9_5678901234567890"
	ON SELECTION BAR 1 OF pop_7 DO NOT_DONE
	ON SELECTION BAR 2 OF pop_7 DO NOT_DONE
	ON SELECTION BAR 3 OF pop_7 DO NOT_DONE
	ON SELECTION BAR 4 OF pop_7 DO NOT_DONE
	ON SELECTION BAR 5 OF pop_7 DO NOT_DONE
	ON SELECTION BAR 6 OF pop_7 DO NOT_DONE
	ON SELECTION BAR 7 OF pop_7 DO NOT_DONE
	ON SELECTION BAR 8 OF pop_7 DO NOT_DONE
	ON SELECTION BAR 9 OF pop_7 DO NOT_DONE		&& Line 260
	
	*-----   Define the pop_8 popup
	DEFINE POPUP pop_8 FROM 02,58 MESSAGE "POPUP 8 - Not Yet Defined"
	DEFINE BAR 1 OF pop_8 PROMPT "8-1_________________"
	DEFINE BAR 2 OF pop_8 PROMPT "8-2_________________"
	DEFINE BAR 3 OF pop_8 PROMPT "8-3_________________"
	DEFINE BAR 4 OF pop_8 PROMPT "8-4_________________"
	DEFINE BAR 5 OF pop_8 PROMPT "8-5_________________"
	DEFINE BAR 6 OF pop_8 PROMPT "8-6_________________"
	DEFINE BAR 7 OF pop_8 PROMPT "8-7_________________"
	DEFINE BAR 8 OF pop_8 PROMPT "8-8________________2"
	DEFINE BAR 9 OF pop_8 PROMPT "8-9_5678901234567890"
	ON SELECTION BAR 1 OF pop_8 DO NOT_DONE
	ON SELECTION BAR 2 OF pop_8 DO NOT_DONE
	ON SELECTION BAR 3 OF pop_8 DO NOT_DONE
	ON SELECTION BAR 4 OF pop_8 DO NOT_DONE
	ON SELECTION BAR 5 OF pop_8 DO NOT_DONE
	ON SELECTION BAR 6 OF pop_8 DO NOT_DONE
	ON SELECTION BAR 7 OF pop_8 DO NOT_DONE
	ON SELECTION BAR 8 OF pop_8 DO NOT_DONE
	ON SELECTION BAR 9 OF pop_8 DO NOT_DONE		&& Line 260
	
	*-----   Define the pop_9 popup
	DEFINE POPUP pop_9 FROM 02,58 MESSAGE "File Maintainance"
	DEFINE BAR 1 OF pop_9 PROMPT "File List"
	DEFINE BAR 2 OF pop_9 PROMPT "Backup Data Files"
	DEFINE BAR 3 OF pop_9 PROMPT "Restore Data Files"
	DEFINE BAR 4 OF pop_9 PROMPT "Rebuild Indexes"
	DEFINE BAR 5 OF pop_9 PROMPT "9-5_________________"
	DEFINE BAR 6 OF pop_9 PROMPT "9-6_________________"
	DEFINE BAR 7 OF pop_9 PROMPT "9-7_________________"
	DEFINE BAR 8 OF pop_9 PROMPT "9-8________________2"
	DEFINE BAR 9 OF pop_9 PROMPT "9-9_5678901234567890"
	ON SELECTION BAR 1 OF pop_9 DO FileList		&& Line 429
	ON SELECTION BAR 2 OF pop_9 DO Backup		&& Line 453
	ON SELECTION BAR 3 OF pop_9 DO Restore		&& Line 543
	ON SELECTION BAR 4 OF pop_9 DO Rebuild		&& Line 600
	ON SELECTION BAR 5 OF pop_9 DO NOT_DONE
	ON SELECTION BAR 6 OF pop_9 DO NOT_DONE
	ON SELECTION BAR 7 OF pop_9 DO NOT_DONE
	ON SELECTION BAR 8 OF pop_9 DO NOT_DONE
	ON SELECTION BAR 9 OF pop_9 DO NOT_DONE		&& Line 260
RETURN


PROCEDURE Not_Done
*-----------------
	*-----	Open a window and tell the user that this choice is not ready.
	*-----	This prevents system crashes.
	@ 23,00 CLEAR
	SAVE SCREEN TO MainMenu
		DEFINE WINDOW NotDone FROM 05,05 TO 15,74
		ACTIVATE WINDOW NotDone
			SET COLOR TO GR+/R
				CLEAR
				@ 05,10 SAY " THIS MENU SELECTION IS NOT YET COMPLETE! "
			SET COLOR TO W/B
			Command = INKEY(0)
		DEACTIVATE WINDOW NotDone
		RELEASE WINDOW NotDone
	RESTORE SCREEN FROM MainMenu
RETURN


PROCEDURE ExitProc
*-----------------
	*-----	This closes the open files and resets the system to the status
	*-----	it was in before this program was run.
	CLOSE DATABASES
	SET DIRECTORY TO 					&& Clears any Resetting of the Directory
	CLEAR ALL
	SET TALK ON
	CLEAR
	RETURN TO MASTER 					&&  LOGOUT - dBase IV's PROTECT
RETURN


PROCEDURE Logo
*-------------
	*-----	Draws the Logo and shows the Copyright Information
	CLEAR
	@ 03,05 TO 21,74
	@ 04,07 TO 20,72
	@ 05,09 TO 19,70
	@ 06,11 TO 18,68
	@ 07,13 TO 17,66
	@ 08,15 TO 16,64
	@ 09,17 TO 15,62
	@ 10,19 TO 14,60
	@ 11,21 TO 13,58
	
	Center = 0
	Center = (80 - LEN(M_App2))/2
	@ 12,Center SAY M_App2
	
	Center = 0
	Center = (80 - LEN(Your_Co))/2
	@ 22,11 SAY Your_Co
	
	@ 23,11 SAY " MainMenu for dBase IV - Copyright 1994, QT Enterprises "
	SET COLOR TO N/BG
		@ 00,00 SAY M_App1
	SET COLOR TO W/B
RETURN


PROCEDURE OpenFiles
*------------------
	*-----	Check for existance of the files used by the program.
	*-----	If the files are found they are opened.
	*-----	If a file is not found and it can be recreated, 
	*-----		as can NTX files, it will be recreated.  
	*-----	Otherwise a message is issued to the user,
	*-----		and the Program is NOT allowed to start.
	DEFINE WINDOW OpenFile FROM 01,00 TO 24,79
	ACTIVATE WINDOW OpenFile
		SET COLOR TO N/GB
		CLEAR
		
		*-----	Assumes that your directory structure is C:\dbase\new_app\data
		SET DIRECTORY TO \dBase\New_Apps\Data
		SET PATH TO \dBase\New_Apps
		
		*-----	The file, Dir_Text.DBF, is used to compare available diskspace 
		*-----		and the size of your data files for backup.
		IF .NOT. FILE("Dir_Text.DBF")
			? 	"Critical File Missing - Dir_Text.DBF"
			?	"Correct this problem before continuing."	
			WAIT
			CLOSE DATABASES
			QUIT
		ENDIF
		
		? "     The program will look for all required files at this time."
		? "     If all files are found they will be opened."
		?
		? "     IF they are NOT found, the program will be stopped!"
		?
		? "     This screen will display for 15 seconds, before continuing."
		
		*	IF FILE("First.DBF")
		*		IF FILE("First.MDX")
		*			IF FILE("First.NDX")
		*				SELECT 1
		*				USE First INDEX First
		*			ELSE
		*				SELECT 1
		*				USE First
		*				INDEX ON <Field1> TO <First.NDX>
		*			ENDIF
		*		ELSE
		*			? 	"Critical File Missing - First.MDX"
		*			?	"Correct this problem before continuing."	
		*			WAIT
		*			CLOSE DATABASES
		*			QUIT
		*		ENDIF
		*	ELSE
		*		? 	"Critical File Missing - First.DBF"
		*		?	"Correct this problem before continuing."
		*		WAIT
		*		CLOSE DATABASES
		*		QUIT
		*	ENDIF
		
		*-----	Repeat until ALL files used by your program have been accounted
		*-----	for, or created.  
		*-----	If any are missing do not allow the program to start!
		
		Pause = INKEY(15)				&& wait for 15 seconds
		SET COLOR TO W/B
	DEACTIVATE WINDOW OpenFile
	RELEASE WINDOW OpenFile
RETURN


PROCEDURE Login
*--------------
	Pass = Space(8)
	Center = (79 - LEN(M_Licensee))/2
	Tries = 1
	Passed = .F.
	DO WHILE .NOT. Passed
		CLEAR
		@ 05,Center SAY M_Licensee
		@ 08,15 SAY "Enter Your Initials: " GET Emp  PICTURE "@A!"
		@ 10,15 SAY "Enter Your Password: " 
		@ 10,45 SAY "( Use PASSWORD )"
		@ 23,11 SAY " MainMenu for dBase IV - Copyright 1994, QT Enterprises "
		READ
		
		*------	Make the Pass Word Unreadable
		SET COLOR TO ,N/N
		@ 10,36 GET Pass PICTURE "@A!"
		READ
		SET COLOR TO ,N/GB
		
		Tries = Tries +1
		*-----	This can be as simple as this, 
		*-----	or use a Lookup File and/or Login File to List Logins.
		IF Pass # "PASSWORD"
			@ 15,20 SAY "Wrong Password! - Press any key to correct"
			Pause = INKEY(0)			&& wait for a key to be pressed
			IF Tries > 3
				QUIT						&&  LOGOUT - dBase IV's PROTECT
			ENDIF
		ELSE 
			Passed = .T.
			WhoDidIt = RIGHT(DTOS(DATE()),6) + Emp
		ENDIF
	ENDDO
RETURN


PROCEDURE FileList
*-----------------
	@ 23,00 CLEAR
	SAVE SCREEN TO MainMenu
		DEFINE WINDOW FileList FROM 01,00 TO 24,79
		ACTIVATE WINDOW FileList
			SET COLOR TO N/GB
			CLEAR
			?? "Directory => "
			?? SET("DIRECTORY")
			? "Path      => "
			?? SET("PATH")
			?
			DIR *.*
			?
			? "Press any key to return"
			Pause = INKEY(0)
			SET COLOR TO W/B
		DEACTIVATE WINDOW FileList
		RELEASE WINDOW FileList
	RESTORE SCREEN FROM MainMenu
RETURN


PROCEDURE Backup
*---------------
	Drive = " "
	@ 23,00 CLEAR
	SAVE SCREEN TO MainMenu
		CLEAR
		@ 02,25 SAY "Backup Data Files TO Diskette"
		@ 05,05 SAY "Enter Drive to Copy TO (A/b/eXit): " ;
				  GET Drive PICTURE "@M A, B, X"
		READ
		IF Drive = "X"
			RESTORE SCREEN FROM MainMenu
			RETURN
		ENDIF
		
		Answer = " "
		DO WHILE Answer = " "
			@ 10,05 SAY "Load a Blank Diskette in Drive " + Drive + ": "
			@ 11,05 SAY "Continue (Y/n): " ;
					  GET Answer PICTURE "@M Y, N"
			READ
			IF Answer = "Y"
				SET DIRECTORY TO A:
					DiskSpace = DISKSPACE()
				SET DIRECTORY TO C:
				
				CLOSE DATABASES
				! DEL *.??K				&&  Delete backup copies of files
				! DIR > Dir.TXT		&&  Redirect the DIR Read to a file
				
				USE Dir_Text EXCL		&&  For multiuser installations
				APPEND FROM Dir.TXT TYPE SDF
				GOTO BOTTOM				&&  Goto the line which shows:
				SKIP -1					&&  Total File Space Used
				
				*	This is written for MS_DOS 6.2, which adds commas to make space
				*	available more readable.  If your version of DOS does not add
				*	commas - you will need to adjust this for your version.
				FileSize = VAL(SUBSTR(Dir_Line,22,3) + SUBSTR(Dir_Line,26,3) + ;
									SUBSTR(Dir_Line,30,3))
				
				! DEL Dir.TXT			&&  Delete this DIR Read
				SET SAFETY OFF
					ZAP					&&  Delete records from this DIR Read
				SET SAFETY ON
				CLOSE DATABASES
			ELSE
				RESTORE SCREEN FROM MainMenu
				RETURN
			ENDIF
		ENDDO
		
		IF Answer = "Y"
			CLEAR
			@ 02,32 SAY "Backup Data Files"
			@ 05,12 SAY "Drive " + Drive + ": = "
			@ 05,23 SAY DiskSpace
			@ 06,05 SAY "Files to Backup = "
			@ 06,23 SAY FileSize
			
			Answer = " "
			DO WHILE Answer = " "
				@ 10,05 SAY "Do you want to continue with this backup? (Y/n): " ;
						  GET Answer PICTURE "@M Y, N"
				READ
				IF Answer = "Y"
					IF DiskSpace > FileSize
						Files = "*.* " + Drive + ":"
						! COPY &Files
					ELSE
						?
						?	"     The use of MS-DOS's MSBACKUP or other backup "
						?	"     procedures are required because the files are "
						?	"     greater than the space on this diskette."
						?
						WAIT
					ENDIF
				ELSE
					RESTORE SCREEN FROM MainMenu
					RETURN
				ENDIF
			ENDDO
		ENDIF
		
		*	ReOpen Files
		DO OpenFiles							&& Line 321
		RESTORE SCREEN FROM MainMenu
RETURN


PROCEDURE Restore
*----------------
	Drive = " "
	@ 23,00 CLEAR
	SAVE SCREEN TO MainMenu
		CLEAR
		@ 02,32 SAY "Restore Data Files FROM Diskette"
		@ 05,05 SAY "Enter Drive to Copy FROM (A/b/eXit): " ;
				  GET Drive PICTURE "@M A, B, X"
		READ
		IF Drive = "X"
			RESTORE SCREEN FROM MainMenu
			RETURN
		ENDIF
		
		Answer = " "
		DO WHILE Answer = " "
			SET COLOR TO GR+/R
			@ 08,00 CLEAR TO 13,79
			@ 08,00 TO 13,79 DOUBLE
			@ 10,05 SAY "This WILL Destroy the Data on your Hard Drive!"
			@ 11,45 SAY "Continue (Y/n): " ;
					  GET Answer PICTURE "@M Y, N"
			READ
			SET COLOR TO W/B
			
			IF Answer = "Y"
				Answer = " "
				DO WHILE Answer = " "
					@ 15,05 SAY "Were the Files Copied or Backedup? (C/b): " ;
							  GET Answer PICTURE "@M C, B"
					READ
				ENDDO
				IF Answer = "C"
					CLOSE DATABASES
					Files = Drive + ":*.*"
					! COPY &Files
				ELSE
					?
					?	"     MS-DOS's MSBACKUP or an other backup procedure was used"
					?	"     because the files are on more than one diskette. "
					?	"     The same procedure must be used to restore them."
					?
					WAIT
				ENDIF
			ELSE
				RESTORE SCREEN FROM MainMenu
				RETURN
			ENDIF
		ENDDO
		
	*	ReOpen Files
	DO OpenFiles							&& Line 321
	RESTORE SCREEN FROM MainMenu
RETURN


PROCEDURE Rebuild
*----------------
	@ 23,00 CLEAR
	SAVE SCREEN TO MainMenu
		DEFINE WINDOW Rebuild FROM 01,00 TO 24,79
		ACTIVATE WINDOW Rebuild
			SET COLOR TO N/GB
			CLEAR
			? "               Build a list of all files and their indexes"
			?
			? "     CLOSE DATABASES"
			? "     USE First INDEX NDX1, NDX2, NDX3"
			? "     REINDEX"
			? "     This will reindex the three NDX Files and the Production MDX File"
			?
			? "     USE Second"
			? "     REINDEX"
			? "     ...   "
			?
			? "Press any key to return"
			Pause = INKEY(0)
			SET COLOR TO W/B
		DEACTIVATE WINDOW Rebuild
		RELEASE WINDOW Rebuild
	
	*	ReOpen Files
	DO OpenFiles							&& Line 321
	RESTORE SCREEN FROM MainMenu
RETURN

************************************************************ EOF