
* C:\MENUD\SAMPLE2.PRG Main program -- a pull-down/pop-out front end
* Generated from C:\MENUD\WW\SAMPLE2.WW using C:\MENUD\TEM\MENU_E.CTM.
* Generated 09:52:05, November 2, 1989.
* Language: Clipper Summer 87
*

PRIVATE main, pop_buf

SET CURSOR off
SET SCOREBOARD off
SET CONFIRM off

* inkey aliases     ( g_xxx = global variable xxx )
g_up = 5
g_down = 24
g_left = 19
g_right = 4

g_pgup = 18
g_pgdn = 3
g_home = 1
g_end = 6
g_Ins = 22                             && synonym for Ctl-V
g_Del = 7                              && synonym for Ctl-G

g_ctl_home = 29
g_ctl_end = 23


g_car_ret = 13
g_escape = 27
g_space = 32
g_bksp = 8


g_F1 = 28

* g_ctl_c = 3                           && g_pgdn
* g_ctl_d = 4                           && g_right
* g_ctl_e = 5                           && g_up

g_ctl_q = 17
* g_ctl_r = 18                          && g_pgup
g_ctl_w = 23
* g_ctl_x = 24                          && g_down


SAVE SCREEN TO main

SET COLOR TO +W/N
CLEAR

* Display the sign-on box

SET COLOR TO N/W
@ 2,13,17,64 BOX "Ŀ "
@ 3,28 SAY "This is a sign-on box"
@ 6,16 SAY "Please press:      "+CHR(17)+""
@ 7,34 SAY "       "
@ 8,34 SAY "    "
@ 9,34 SAY "       "
@ 10,34 SAY "      "


sam_helpd = .f.                         && help display status

DO WHILE .t.                            && loop until non-F1 key

  k = INKEY(0)                          && wait for key press

  IF k = g_F1                           && help requested?

    IF .NOT. sam_helpd                  && is help not displayed?
      sam_help = savescreen(0,0,24,79)

      * pop up the help box
      SET COLOR TO N/W
      @ 0,0,24,79 BOX "͸Գ "
      @ 1,2 SAY "Thanks!                                                  Sign-on help"
      @ 3,2 SAY "This is a help box.  From now on, I'll show the features, but you'll have"
      @ 4,2 SAY "to press F1 for an explanation."
      @ 6,2 SAY "A help box is any box you paint that is linked to one of the others and, via"
      @ 7,2 SAY "the naming convention, is ready to pop up when the user presses F1."
      @ 11,2 SAY "You were at the sign-on screen.  That's a box you paint that will pop up"
      @ 12,2 SAY "before beginning the application.  It pops down and the application starts"
      @ 13,2 SAY "on any keypress.  Sign-ons are optional -- see the manual for the subtle"
      @ 14,2 SAY "differences."
      @ 18,2 SAY "Press a key to pop this help down."
      @ 20,2 SAY "Press another key to start the application."
      sam_helpd = .t.
    ENDIF

   ELSE                                 && not an F1 key

    IF sam_helpd                        && if help is up, bring it down
      restscreen(0,0,24,79,sam_help)
      RELEASE sam_help
      sam_helpd = .f.
     ELSE                               && pass the key to the menu
      EXIT
    ENDIF

  ENDIF                                 && help requested
ENDDO                                   && F1 loop

SET COLOR TO +W/N
CLEAR
DO sam_main WITH k                      && begin the main menu

RESTORE SCREEN FROM main                && do a tidy exit
SET COLOR TO w/n

SET CURSOR ON
@ 23,78 say " "
RETURN                                                      && end of mainline



PROCEDURE sam_main
******************************************************************************
*** sam_main                                          main menu in SAMPLE2 ***
******************************************************************************
PARAMETER main_key
PRIVATE sam_main, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_main = savescreen(0,0,8,79)


* display the menu box

SET COLOR TO +W/N
@ 0,0,8,79 BOX "͸Գ "
SET COLOR TO W/N
@ 1,1 CLEAR TO 7, 78
* painted box
SET COLOR TO +W/N
@ 2,30 SAY "This is a MAIN menu"

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret) + CHR(g_down)
arrows_out = ""

mn__do = "main_do"
mn__hilo = "main_hilo"
mn__hlp = "main_hlp"

opt_keys = "NPESQ"
num_opts = 5

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

main_key = 0                            && the user's keypress

DO menu_ctl with main_key

restscreen(0,0,8,79,sam_main)
RELEASE sam_main, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                      && end of sam_main



PROCEDURE main_do
******************************************************************************
*** main_do                                   main option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO sam_n  WITH main_key

  CASE now_at = 2
    DO sam_p  WITH main_key

  CASE now_at = 3
    DO sam_e  WITH main_key

  CASE now_at = 4 .and. do_it = "Y"
    DO sam_s  WITH main_key

  CASE now_at = 5
    DO sam_q  WITH main_key

ENDCASE

RETURN                                                       && end of main_do



PROCEDURE main_hlp
******************************************************************************
*** main_hlp                                          pop up help for main ***
******************************************************************************
PARAMETER t,l,b,r,buffer

* display the help box

buffer = savescreen(10,2,22,76)
SET COLOR TO N/W
@ 10,2,22,76 BOX "ͻȺ "
@ 11,65 SAY "MAIN help"
@ 12,4 SAY "This is a MAIN menu."
@ 14,4 SAY "The menu options shown here are exagerated to show what you"
@ 15,4 SAY "can do."
@ 17,4 SAY "Arrow keys navigate, Enter (or first letter) selects, Esc exits."
@ 21,4 SAY "press any key to resume"

t = 10
l = 2
b = 22
r = 76

RETURN                                                      && end of main_hlp



PROCEDURE main_hilo
******************************************************************************
*** main_hilo                                     writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 4,2 CLEAR TO 7, 20
    @ 5,8 SAY "Nested"
    @ 6,6 SAY "pull-downs"

  CASE choice = 2
    @ 4,22 CLEAR TO 7, 40
    @ 5,26 SAY "Pull-downs"
    @ 6,25 SAY "with popouts"

  CASE choice = 3
    @ 4,42 CLEAR TO 7, 54
    @ 5,46 SAY "Empty"
    @ 6,46 SAY "boxes"

  CASE choice = 4
    @ 4,56 CLEAR TO 7, 67
    @ 5,60 SAY "Stop"
    @ 6,59 SAY "boxes"

  CASE choice = 5
    @ 4,69 CLEAR TO 7, 77
    @ 5,73 SAY "Q"
    @ 6,70 SAY "(paint)"

ENDCASE
RETURN                                                     && end of main_hilo



PROCEDURE sam_n
******************************************************************************
*** sam_n                                         a level 1 pull-down menu ***
******************************************************************************
PARAMETER n_key
PRIVATE sam_n, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_n = savescreen(8,0,19,25)


* display the menu box

SET COLOR TO +W/N
@ 8,0,19,25 BOX "ķӺ "
@ 10,5 SAY "A pull-down menu"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "n_do"
mn__hilo = "n_hilo"
mn__hlp = "n_hlp"

opt_keys = "FSA"
num_opts = 3

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

n_key = 0                               && the user's keypress

DO menu_ctl with n_key

restscreen(8,0,19,25,sam_n)
RELEASE sam_n, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                         && end of sam_n



PROCEDURE n_do
******************************************************************************
*** n_do                                         n option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO sam_nf  WITH n_key

  CASE now_at = 2
    DO sam_ns  WITH n_key

  CASE now_at = 3
    DO sam_na  WITH n_key

ENDCASE

RETURN                                                          && end of n_do



PROCEDURE n_hlp
******************************************************************************
*** n_hlp                                                pop up help for n ***
******************************************************************************
PARAMETER t,l,b,r,buffer

* display the help box

buffer = savescreen(8,23,22,79)
SET COLOR TO N/W
@ 8,23,22,79 BOX "ͻȺ "
@ 9,64 SAY "Pull-down help"
@ 11,25 SAY "A pull-down menu is a vertical menu (vertical refers"
@ 12,25 SAY "to the arrangement of the menu options) attached to"
@ 13,25 SAY "a horizontal menu."
@ 21,25 SAY "press any key to resume"

t = 8
l = 23
b = 22
r = 79

RETURN                                                         && end of n_hlp



PROCEDURE n_hilo
******************************************************************************
*** n_hilo                                        writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 13,3 CLEAR TO 13, 22
    @ 13,4 SAY "First from here"

  CASE choice = 2
    @ 15,3 CLEAR TO 15, 22
    @ 15,4 SAY "Second from here"

  CASE choice = 3
    @ 17,3 CLEAR TO 17, 22
    @ 17,4 SAY "And so on"

ENDCASE
RETURN                                                        && end of n_hilo



PROCEDURE sam_p
******************************************************************************
*** sam_p                                         a level 1 pull-down menu ***
******************************************************************************
PARAMETER p_key
PRIVATE sam_p, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_p = savescreen(8,18,19,43)


* display the menu box

SET COLOR TO +W/N
@ 8,18,19,43 BOX "ķӺ "
@ 9,27 SAY "Another"
@ 10,24 SAY "pull-down menu"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "p_do"
mn__hilo = "p_hilo"
mn__hlp = "p_hlp"

opt_keys = "PAL"
num_opts = 3

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

p_key = 0                               && the user's keypress

DO menu_ctl with p_key

restscreen(8,18,19,43,sam_p)
RELEASE sam_p, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                         && end of sam_p



PROCEDURE p_do
******************************************************************************
*** p_do                                         p option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO sam_pp  WITH p_key

  CASE now_at = 2
    DO sam_pa  WITH p_key

  CASE now_at = 3
    DO sam_pl  WITH p_key

ENDCASE

RETURN                                                          && end of p_do



PROCEDURE p_hlp
******************************************************************************
*** p_hlp                                                pop up help for p ***
******************************************************************************
PARAMETER t,l,b,r,buffer

* display the help box

buffer = savescreen(8,23,22,79)
SET COLOR TO N/W
@ 8,23,22,79 BOX "ͻȺ "
@ 9,64 SAY "Pull-down help"
@ 11,25 SAY "A pull-down menu is a vertical menu (vertical refers"
@ 12,25 SAY "to the arrangement of the menu options) attached to"
@ 13,25 SAY "a horizontal menu."
@ 21,25 SAY "press any key to resume"

t = 8
l = 23
b = 22
r = 79

RETURN                                                         && end of p_hlp



PROCEDURE p_hilo
******************************************************************************
*** p_hilo                                        writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 13,21 CLEAR TO 13, 40
    @ 13,22 SAY "Pop-out from here"

  CASE choice = 2
    @ 15,21 CLEAR TO 15, 40
    @ 15,22 SAY "Another from here"

  CASE choice = 3
    @ 17,21 CLEAR TO 17, 40
    @ 17,24 SAY "Last one here"

ENDCASE
RETURN                                                        && end of p_hilo



PROCEDURE sam_e
******************************************************************************
*** sam_e                                                   displays a box ***
******************************************************************************
PARAMETER e_key
PRIVATE buf_e


sam_e = savescreen(8,37,22,58)


* pop-up the box

SET COLOR TO +W/N
@ 8,37,22,58 BOX "ķӺ "
@ 11,42 SAY "This box is"
@ 13,45 SAY "empty"
@ 15,39 SAY "(nothing but text)"

sam_helpd = .f.                         && help display status

DO WHILE .t.                            && loop until non-F1 key

  e_key = INKEY(0)                      && wait for key press

  IF e_key = g_F1                       && help requested?

    IF .NOT. sam_helpd                  && is help not displayed?
      sam_help = savescreen(9,0,23,42)

      * pop up the help box
      SET COLOR TO N/W
      @ 9,0,23,42 BOX "ͻȺ "
      @ 10,31 SAY "empty help"
      @ 12,2 SAY "Empty boxes are used during development"
      @ 13,2 SAY "as placeholders for future menus or"
      @ 14,2 SAY "other box types."
      @ 16,2 SAY "They can also be used to display infor-"
      @ 17,2 SAY "mation."
      @ 22,2 SAY "press any key to resume"
      sam_helpd = .t.
    ENDIF

   ELSE                                 && not an F1 key

    IF sam_helpd                        && if help is up, bring it down
      restscreen(9,0,23,42,sam_help)
      RELEASE sam_help
      sam_helpd = .f.
     ELSE                               && pass the key to the menu
      EXIT
    ENDIF

  ENDIF                                 && help requested
ENDDO                                   && F1 loop

IF e_key = g_escape                     && do not return an escape
  e_key = g_car_ret
ENDIF

restscreen(8,37,22,58,sam_e)
RETURN                                                         && end of sam_e



PROCEDURE sam_s
******************************************************************************
*** sam_s                                                   displays a box ***
******************************************************************************
PARAMETER s_key
PRIVATE buf_s

* pop the "proceed? (stop)" box
pop_buf = savescreen(9,38,23,63)
SET COLOR TO +W/N
@ 9,38,23,63 BOX "ͻȺ "
* painted box
@ 10,63 SAY ""
@ 11,48 SAY "STOP!          "
@ 12,63 SAY ""
@ 13,40 SAY "Proceeding here is     "
@ 14,40 SAY "very dangerous!        "
@ 15,63 SAY ""
@ 16,40 SAY "Do you want to take    "
@ 17,40 SAY "the risk (Y/N)?        "
@ 18,63 SAY ""
@ 19,63 SAY ""
@ 20,63 SAY ""
@ 21,63 SAY ""
@ 22,63 SAY ""
SET COLOR TO W/N
@ 20,40 SAY "(This is just a demo."
@ 21,40 SAY "Go ahead.)"
SET CURSOR ON

DO WHILE .T.
  go_tmp_str = "N"
  @ 17,56 GET go_tmp_str PICTURE '!'
  READ
  IF go_tmp_str$"YNTF"
    go = go_tmp_str$"YT"
    EXIT
   ELSE
    DO beep
  ENDIF
ENDDO

SET CURSOR OFF
IF .not. go                             && user says 'no'
  restscreen(9,38,23,63,pop_buf)
  RELEASE pop_buf 
  s_key = lastkey()
  RETURN
ENDIF

restscreen(9,38,23,63,pop_buf)
RELEASE pop_buf

sam_s = savescreen(8,54,22,70)


* pop-up the box

SET COLOR TO +W/N
@ 8,54,22,70 BOX "ķӺ "
@ 10,57 SAY "Stopped box"
@ 12,56 SAY "(Presumably"
@ 13,56 SAY "this was for"
@ 14,56 SAY "some critical"
@ 15,56 SAY "operation.)"

sam_helpd = .f.                         && help display status

DO WHILE .t.                            && loop until non-F1 key

  s_key = INKEY(0)                      && wait for key press

  IF s_key = g_F1                       && help requested?

    IF .NOT. sam_helpd                  && is help not displayed?
      sam_help = savescreen(10,8,24,39)

      * pop up the help box
      SET COLOR TO N/W
      @ 10,8,24,39 BOX "ͻȺ "
      @ 11,29 SAY "stop help"
      @ 13,10 SAY "The stop box is used to give"
      @ 14,10 SAY "a warning about critical or"
      @ 15,10 SAY "irreversible operations."
      @ 17,10 SAY "The user must confirm by"
      @ 18,10 SAY 'pressing "Y".'
      @ 23,10 SAY "press any key to resume"
      sam_helpd = .t.
    ENDIF

   ELSE                                 && not an F1 key

    IF sam_helpd                        && if help is up, bring it down
      restscreen(10,8,24,39,sam_help)
      RELEASE sam_help
      sam_helpd = .f.
     ELSE                               && pass the key to the menu
      EXIT
    ENDIF

  ENDIF                                 && help requested
ENDDO                                   && F1 loop

IF s_key = g_escape                     && do not return an escape
  s_key = g_car_ret
ENDIF

restscreen(8,54,22,70,sam_s)
RETURN                                                         && end of sam_s



PROCEDURE sam_q
******************************************************************************
*** sam_q                                         a level 1 pull-down menu ***
******************************************************************************
PARAMETER q_key
PRIVATE sam_q, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

SAVE SCREEN TO sam_q

SET COLOR TO N/W
@ 0,0 CLEAR TO 24, 79


* display the menu box

SET COLOR TO +W/N
@ 3,0,17,20 BOX "͸Գ "

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "q_do"
mn__hilo = "q_hilo"
mn__hlp = "q_hlp"

opt_keys = "BND"
num_opts = 3

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

q_key = 0                               && the user's keypress

DO menu_ctl with q_key

RESTORE SCREEN FROM sam_q
RELEASE sam_q, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                         && end of sam_q



PROCEDURE q_do
******************************************************************************
*** q_do                                         q option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO sam_qb  WITH q_key

  CASE now_at = 2
    DO sam_qn  WITH q_key

  CASE now_at = 3
    DO sam_qd  WITH q_key

ENDCASE

RETURN                                                          && end of q_do



PROCEDURE q_hlp
******************************************************************************
*** q_hlp                                                pop up help for q ***
******************************************************************************
PARAMETER t,l,b,r,buffer

* display the help box

buffer = savescreen(0,27,18,75)
SET COLOR TO N/W
@ 0,27,18,75 BOX "ͻȺ "
@ 1,64 SAY "paint help"
@ 4,29 SAY "A paint box is any box used to paint the"
@ 5,29 SAY "screen, or a portion of the screen, prior to"
@ 6,29 SAY "displaying a menu or other box."
@ 17,29 SAY "press any key to resume"

t = 0
l = 27
b = 18
r = 75

RETURN                                                         && end of q_hlp



PROCEDURE q_hilo
******************************************************************************
*** q_hilo                                        writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 6,1 CLEAR TO 6, 19
    @ 6,2 SAY "Black paint"

  CASE choice = 2
    @ 8,1 CLEAR TO 8, 19
    @ 8,2 SAY "No paint"

  CASE choice = 3
    @ 10,1 CLEAR TO 10, 19
    @ 10,2 SAY "Design paint"

ENDCASE
RETURN                                                        && end of q_hilo



PROCEDURE sam_nf
******************************************************************************
*** sam_nf                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER nf_key
PRIVATE sam_nf, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_nf = savescreen(11,11,20,36)


* display the menu box

SET COLOR TO +W/N
@ 11,11,20,36 BOX "ķӺ "
@ 12,13 SAY "First nested pull-down"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "nf_do"
mn__hilo = "nf_hilo"
mn__hlp = ""

opt_keys = "UUU"
num_opts = 3

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

nf_key = 0                              && the user's keypress

DO menu_ctl with nf_key

restscreen(11,11,20,36,sam_nf)
RELEASE sam_nf, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_nf



PROCEDURE nf_do
******************************************************************************
*** nf_do                                       nf option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "nfu", 2, nf_key

  CASE now_at = 2
    DO DUMMY with "nfu", 2, nf_key

  CASE now_at = 3
    DO DUMMY with "nfu", 2, nf_key

ENDCASE

RETURN                                                         && end of nf_do



PROCEDURE nf_hilo
******************************************************************************
*** nf_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 14,14 CLEAR TO 14, 33
    @ 14,17 SAY "Unimplemented"

  CASE choice = 2
    @ 16,14 CLEAR TO 16, 33
    @ 16,17 SAY "Unimplemented"

  CASE choice = 3
    @ 18,14 CLEAR TO 18, 33
    @ 18,17 SAY "Unimplemented"

ENDCASE
RETURN                                                       && end of nf_hilo



PROCEDURE sam_ns
******************************************************************************
*** sam_ns                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER ns_key
PRIVATE sam_ns, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_ns = savescreen(13,11,22,36)


* display the menu box

SET COLOR TO +W/N
@ 13,11,22,36 BOX "ķӺ "
@ 14,14 SAY "2nd nested pull-down"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "ns_do"
mn__hilo = "ns_hilo"
mn__hlp = ""

opt_keys = "UUU"
num_opts = 3

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

ns_key = 0                              && the user's keypress

DO menu_ctl with ns_key

restscreen(13,11,22,36,sam_ns)
RELEASE sam_ns, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_ns



PROCEDURE ns_do
******************************************************************************
*** ns_do                                       ns option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "nsu", 2, ns_key

  CASE now_at = 2
    DO DUMMY with "nsu", 2, ns_key

  CASE now_at = 3
    DO DUMMY with "nsu", 2, ns_key

ENDCASE

RETURN                                                         && end of ns_do



PROCEDURE ns_hilo
******************************************************************************
*** ns_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 16,14 CLEAR TO 16, 33
    @ 16,17 SAY "Unimplemented"

  CASE choice = 2
    @ 18,14 CLEAR TO 18, 33
    @ 18,17 SAY "Unimplemented"

  CASE choice = 3
    @ 20,14 CLEAR TO 20, 33
    @ 20,17 SAY "Unimplemented"

ENDCASE
RETURN                                                       && end of ns_hilo



PROCEDURE sam_na
******************************************************************************
*** sam_na                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER na_key
PRIVATE sam_na, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_na = savescreen(15,11,24,36)


* display the menu box

SET COLOR TO +W/N
@ 15,11,24,36 BOX "ķӺ "
@ 16,14 SAY "3rd nested pull-down"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "na_do"
mn__hilo = "na_hilo"
mn__hlp = ""

opt_keys = "UUU"
num_opts = 3

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

na_key = 0                              && the user's keypress

DO menu_ctl with na_key

restscreen(15,11,24,36,sam_na)
RELEASE sam_na, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_na



PROCEDURE na_do
******************************************************************************
*** na_do                                       na option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "nau", 2, na_key

  CASE now_at = 2
    DO DUMMY with "nau", 2, na_key

  CASE now_at = 3
    DO DUMMY with "nau", 2, na_key

ENDCASE

RETURN                                                         && end of na_do



PROCEDURE na_hilo
******************************************************************************
*** na_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 18,14 CLEAR TO 18, 33
    @ 18,17 SAY "Unimplemented"

  CASE choice = 2
    @ 20,14 CLEAR TO 20, 33
    @ 20,17 SAY "Unimplemented"

  CASE choice = 3
    @ 22,14 CLEAR TO 22, 33
    @ 22,17 SAY "Unimplemented"

ENDCASE
RETURN                                                       && end of na_hilo



PROCEDURE sam_pp
******************************************************************************
*** sam_pp                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER pp_key
PRIVATE sam_pp, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_pp = savescreen(12,34,14,75)


* display the menu box

SET COLOR TO +W/N
@ 12,34,14,75 BOX "͸Գ "
SET COLOR TO W/N
@ 13,35 CLEAR TO 13, 74
@ 13,35 SAY "Pop-out"

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "pp_do"
mn__hilo = "pp_hilo"
mn__hlp = "pp_hlp"

opt_keys = "MS"
num_opts = 2

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

pp_key = 0                              && the user's keypress

DO menu_ctl with pp_key

restscreen(12,34,14,75,sam_pp)
RELEASE sam_pp, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_pp



PROCEDURE pp_do
******************************************************************************
*** pp_do                                       pp option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO sam_ppm  WITH pp_key

  CASE now_at = 2
    DO sam_pps  WITH pp_key

ENDCASE

RETURN                                                         && end of pp_do



PROCEDURE pp_hlp
******************************************************************************
*** pp_hlp                                              pop up help for pp ***
******************************************************************************
PARAMETER t,l,b,r,buffer

* display the help box

buffer = savescreen(9,2,22,30)
SET COLOR TO N/W
@ 9,2,22,30 BOX "ͻȺ "
@ 10,17 SAY "pop-out help"
@ 12,3 SAY "A pop-out menu is a"
@ 13,3 SAY 'horizontal menu, "popped'
@ 14,3 SAY 'out" of a vertical menu.'
@ 16,3 SAY "Try the up and down arrows."
@ 21,3 SAY "press any key to resume"

t = 9
l = 2
b = 22
r = 30

RETURN                                                        && end of pp_hlp



PROCEDURE pp_hilo
******************************************************************************
*** pp_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 13,43 CLEAR TO 13, 59
    @ 13,44 SAY "More pull-downs"

  CASE choice = 2
    @ 13,61 CLEAR TO 13, 72
    @ 13,62 SAY "Still more"

ENDCASE
RETURN                                                       && end of pp_hilo



PROCEDURE sam_pa
******************************************************************************
*** sam_pa                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER pa_key
PRIVATE sam_pa, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_pa = savescreen(14,34,16,75)


* display the menu box

SET COLOR TO +W/N
@ 14,34,16,75 BOX "͸Գ "
SET COLOR TO W/N
@ 15,35 CLEAR TO 15, 74
@ 15,35 SAY "Pop-out"

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "pa_do"
mn__hilo = "pa_hilo"
mn__hlp = "pa_hlp"

opt_keys = "UU"
num_opts = 2

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

pa_key = 0                              && the user's keypress

DO menu_ctl with pa_key

restscreen(14,34,16,75,sam_pa)
RELEASE sam_pa, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_pa



PROCEDURE pa_do
******************************************************************************
*** pa_do                                       pa option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "pau", 2, pa_key

  CASE now_at = 2
    DO DUMMY with "pau", 2, pa_key

ENDCASE

RETURN                                                         && end of pa_do



PROCEDURE pa_hlp
******************************************************************************
*** pa_hlp                                              pop up help for pa ***
******************************************************************************
PARAMETER t,l,b,r,buffer

* display the help box

buffer = savescreen(9,2,22,30)
SET COLOR TO N/W
@ 9,2,22,30 BOX "ͻȺ "
@ 10,17 SAY "pop-out help"
@ 12,3 SAY "A pop-out menu is a"
@ 13,3 SAY 'horizontal menu, "popped'
@ 14,3 SAY 'out" of a vertical menu.'
@ 16,3 SAY "Try the up and down arrows."
@ 21,3 SAY "press any key to resume"

t = 9
l = 2
b = 22
r = 30

RETURN                                                        && end of pa_hlp



PROCEDURE pa_hilo
******************************************************************************
*** pa_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 15,43 CLEAR TO 15, 57
    @ 15,44 SAY "Unimplemented"

  CASE choice = 2
    @ 15,59 CLEAR TO 15, 73
    @ 15,60 SAY "Unimplemented"

ENDCASE
RETURN                                                       && end of pa_hilo



PROCEDURE sam_pl
******************************************************************************
*** sam_pl                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER pl_key
PRIVATE sam_pl, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_pl = savescreen(16,34,18,75)


* display the menu box

SET COLOR TO +W/N
@ 16,34,18,75 BOX "͸Գ "
SET COLOR TO W/N
@ 17,35 CLEAR TO 17, 74
@ 17,35 SAY "Pop-out"

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "pl_do"
mn__hilo = "pl_hilo"
mn__hlp = "pl_hlp"

opt_keys = "UU"
num_opts = 2

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

pl_key = 0                              && the user's keypress

DO menu_ctl with pl_key

restscreen(16,34,18,75,sam_pl)
RELEASE sam_pl, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_pl



PROCEDURE pl_do
******************************************************************************
*** pl_do                                       pl option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "plu", 2, pl_key

  CASE now_at = 2
    DO DUMMY with "plu", 2, pl_key

ENDCASE

RETURN                                                         && end of pl_do



PROCEDURE pl_hlp
******************************************************************************
*** pl_hlp                                              pop up help for pl ***
******************************************************************************
PARAMETER t,l,b,r,buffer

* display the help box

buffer = savescreen(9,2,22,30)
SET COLOR TO N/W
@ 9,2,22,30 BOX "ͻȺ "
@ 10,17 SAY "pop-out help"
@ 12,3 SAY "A pop-out menu is a"
@ 13,3 SAY 'horizontal menu, "popped'
@ 14,3 SAY 'out" of a vertical menu.'
@ 16,3 SAY "Try the up and down arrows."
@ 21,3 SAY "press any key to resume"

t = 9
l = 2
b = 22
r = 30

RETURN                                                        && end of pl_hlp



PROCEDURE pl_hilo
******************************************************************************
*** pl_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 17,43 CLEAR TO 17, 57
    @ 17,44 SAY "Unimplemented"

  CASE choice = 2
    @ 17,59 CLEAR TO 17, 73
    @ 17,60 SAY "Unimplemented"

ENDCASE
RETURN                                                       && end of pl_hilo



PROCEDURE sam_qb
******************************************************************************
*** sam_qb                                                  displays a box ***
******************************************************************************
PARAMETER qb_key
PRIVATE buf_qb


SAVE SCREEN TO sam_qb

SET COLOR TO W/N
@ 2,7 CLEAR TO 20, 49
@ 2,19 SAY "Painted background"


* pop-up the box

SET COLOR TO N/W
@ 6,16,16,39 BOX "Ŀ "
SET COLOR TO W/N
@ 7,17 CLEAR TO 15, 38
@ 9,22 SAY "Box on paint"

sam_helpd = .f.                         && help display status

DO WHILE .t.                            && loop until non-F1 key

  qb_key = INKEY(0)                     && wait for key press

  IF qb_key = g_F1                      && help requested?

    IF .NOT. sam_helpd                  && is help not displayed?
      sam_help = savescreen(0,27,18,75)

      * pop up the help box
      SET COLOR TO N/W
      @ 0,27,18,75 BOX "ͻȺ "
      @ 1,64 SAY "paint help"
      @ 4,29 SAY "The black box painted a screen area prior to"
      @ 5,29 SAY "the display of the empty (non-menu) box."
      @ 17,29 SAY "press any key to resume"
      sam_helpd = .t.
    ENDIF

   ELSE                                 && not an F1 key

    IF sam_helpd                        && if help is up, bring it down
      restscreen(0,27,18,75,sam_help)
      RELEASE sam_help
      sam_helpd = .f.
     ELSE                               && pass the key to the menu
      EXIT
    ENDIF

  ENDIF                                 && help requested
ENDDO                                   && F1 loop

IF qb_key = g_escape                    && do not return an escape
  qb_key = g_car_ret
ENDIF

RESTORE SCREEN FROM sam_qb
RETURN                                                        && end of sam_qb



PROCEDURE sam_qn
******************************************************************************
*** sam_qn                                                  displays a box ***
******************************************************************************
PARAMETER qn_key
PRIVATE buf_qn


sam_qn = savescreen(6,16,16,39)


* pop-up the box

SET COLOR TO N/W
@ 6,16,16,39 BOX "Ŀ "
SET COLOR TO W/N
@ 7,17 CLEAR TO 15, 38
@ 9,20 SAY "Box not on paint"

sam_helpd = .f.                         && help display status

DO WHILE .t.                            && loop until non-F1 key

  qn_key = INKEY(0)                     && wait for key press

  IF qn_key = g_F1                      && help requested?

    IF .NOT. sam_helpd                  && is help not displayed?
      sam_help = savescreen(0,27,18,75)

      * pop up the help box
      SET COLOR TO N/W
      @ 0,27,18,75 BOX "ͻȺ "
      @ 1,64 SAY "paint help"
      @ 4,29 SAY "This is a regular empty (non-menu) box"
      @ 5,29 SAY "displayed without a paint background."
      @ 17,29 SAY "press any key to resume"
      sam_helpd = .t.
    ENDIF

   ELSE                                 && not an F1 key

    IF sam_helpd                        && if help is up, bring it down
      restscreen(0,27,18,75,sam_help)
      RELEASE sam_help
      sam_helpd = .f.
     ELSE                               && pass the key to the menu
      EXIT
    ENDIF

  ENDIF                                 && help requested
ENDDO                                   && F1 loop

IF qn_key = g_escape                    && do not return an escape
  qn_key = g_car_ret
ENDIF

restscreen(6,16,16,39,sam_qn)
RETURN                                                        && end of sam_qn



PROCEDURE sam_qd
******************************************************************************
*** sam_qd                                                  displays a box ***
******************************************************************************
PARAMETER qd_key
PRIVATE buf_qd


SAVE SCREEN TO sam_qd

SET COLOR TO W/N
@ 2,7 CLEAR TO 20, 49
@ 2,16 SAY "Painted design background"
@ 3,9 SAY "Ŀ"
@ 4,9 SAY "·         ͻ"
@ 5,13 SAY "ͼ ķ   "
@ 6,13 SAY "   ͻ      ͼ   "
@ 7,13 SAY "       ͼ             "
@ 8,9 SAY "ͻ            ͼ       "
@ 9,9 SAY "  Ŀ   "
@ 10,9 SAY "                               "
@ 11,9 SAY "      ͼ"
@ 12,9 SAY "  Ŀ        "
@ 13,9 SAY "                                "
@ 14,9 SAY "                                "
@ 15,9 SAY "      "
@ 16,9 SAY "    Ŀ     "
@ 17,9 SAY "                                "
@ 18,9 SAY "     "
@ 19,11 SAY "ͼ                  "
@ 20,15 SAY ""


* pop-up the box

SET COLOR TO N/W
@ 6,16,16,39 BOX "Ŀ "
SET COLOR TO W/N
@ 7,17 CLEAR TO 15, 38
@ 9,22 SAY "Box on paint"

sam_helpd = .f.                         && help display status

DO WHILE .t.                            && loop until non-F1 key

  qd_key = INKEY(0)                     && wait for key press

  IF qd_key = g_F1                      && help requested?

    IF .NOT. sam_helpd                  && is help not displayed?
      sam_help = savescreen(0,27,18,75)

      * pop up the help box
      SET COLOR TO N/W
      @ 0,27,18,75 BOX "ͻȺ "
      @ 1,64 SAY "paint help"
      @ 4,29 SAY "This paint sample uses the line drawing"
      @ 5,29 SAY 'capability to "paint" a design, prior to'
      @ 6,29 SAY "displaying the box."
      @ 8,29 SAY "Paint boxes can have borders, text and all"
      @ 9,29 SAY "other UI box features."
      @ 17,29 SAY "press any key to resume"
      sam_helpd = .t.
    ENDIF

   ELSE                                 && not an F1 key

    IF sam_helpd                        && if help is up, bring it down
      restscreen(0,27,18,75,sam_help)
      RELEASE sam_help
      sam_helpd = .f.
     ELSE                               && pass the key to the menu
      EXIT
    ENDIF

  ENDIF                                 && help requested
ENDDO                                   && F1 loop

IF qd_key = g_escape                    && do not return an escape
  qd_key = g_car_ret
ENDIF

RESTORE SCREEN FROM sam_qd
RETURN                                                        && end of sam_qd



PROCEDURE sam_ppm
******************************************************************************
*** sam_ppm                                       a level 3 pull-down menu ***
******************************************************************************
PARAMETER ppm_key
PRIVATE sam_ppm, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_ppm = savescreen(14,43,24,59)


* display the menu box

SET COLOR TO +W/N
@ 14,43,24,59 BOX "ķӺ "
@ 15,47 SAY "Pull-down"
@ 16,48 SAY "from a"
@ 17,48 SAY "pop-out"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "ppm_do"
mn__hilo = "ppm_hilo"
mn__hlp = ""

opt_keys = "UUU"
num_opts = 3

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

ppm_key = 0                             && the user's keypress

DO menu_ctl with ppm_key

restscreen(14,43,24,59,sam_ppm)
RELEASE sam_ppm, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                       && end of sam_ppm



PROCEDURE ppm_do
******************************************************************************
*** ppm_do                                     ppm option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "ppmu", 3, ppm_key

  CASE now_at = 2
    DO DUMMY with "ppmu", 3, ppm_key

  CASE now_at = 3
    DO DUMMY with "ppmu", 3, ppm_key

ENDCASE

RETURN                                                        && end of ppm_do



PROCEDURE ppm_hilo
******************************************************************************
*** ppm_hilo                                      writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 19,44 CLEAR TO 19, 58
    @ 19,45 SAY "Unimplemented"

  CASE choice = 2
    @ 21,44 CLEAR TO 21, 58
    @ 21,45 SAY "Unimplemented"

  CASE choice = 3
    @ 23,44 CLEAR TO 23, 58
    @ 23,45 SAY "Unimplemented"

ENDCASE
RETURN                                                      && end of ppm_hilo



PROCEDURE sam_pps
******************************************************************************
*** sam_pps                                       a level 3 pull-down menu ***
******************************************************************************
PARAMETER pps_key
PRIVATE sam_pps, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_pps = savescreen(14,59,24,75)


* display the menu box

SET COLOR TO +W/N
@ 14,59,24,75 BOX "ķӺ "
@ 15,63 SAY "Pull-down"
@ 16,64 SAY "from a"
@ 17,64 SAY "pop-out"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "pps_do"
mn__hilo = "pps_hilo"
mn__hlp = ""

opt_keys = "UUU"
num_opts = 3

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

pps_key = 0                             && the user's keypress

DO menu_ctl with pps_key

restscreen(14,59,24,75,sam_pps)
RELEASE sam_pps, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                       && end of sam_pps



PROCEDURE pps_do
******************************************************************************
*** pps_do                                     pps option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "ppsu", 3, pps_key

  CASE now_at = 2
    DO DUMMY with "ppsu", 3, pps_key

  CASE now_at = 3
    DO DUMMY with "ppsu", 3, pps_key

ENDCASE

RETURN                                                        && end of pps_do



PROCEDURE pps_hilo
******************************************************************************
*** pps_hilo                                      writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 19,60 CLEAR TO 19, 74
    @ 19,61 SAY "Unimplemented"

  CASE choice = 2
    @ 21,60 CLEAR TO 21, 74
    @ 21,61 SAY "Unimplemented"

  CASE choice = 3
    @ 23,60 CLEAR TO 23, 74
    @ 23,61 SAY "Unimplemented"

ENDCASE
RETURN                                                      && end of pps_hilo



PROCEDURE beep
******************************************************************************
*** beep                                             sounds a warning beep ***
******************************************************************************
* This can be changed for silence, or another tone.
?? CHR(7)
RETURN                                                          && end of beep



PROCEDURE menu_ctl
******************************************************************************
*** menu_ctl                                  general menu control routine ***
******************************************************************************
PARAMETER menu_key

* initialize the help parameters
STORE 0 TO h_top, h_left, h_bot, h_right, h_buf

DO &mn__hilo WITH 1, .T.                && hilite option 1

i = 2                                   && lolite the rest
DO WHILE i <= num_opts
  DO &mn__hilo WITH i, .F.
  i = i + 1
ENDDO

DO WHILE .t.                            && main loop

  IF .NOT. CHR(menu_key)$(arrows_prev+arrows_next)
                                        && arrow might come from a
                                        && called menu

    menu_key = INKEY(0)                 && get a keystroke

    IF menu_key = g_F1                  && loop until non-F1 key

      IF LEN(mn__hlp) > 0
        DO &mn__hlp WITH h_top, h_left, h_bot, h_right, h_buf

        menu_key = INKEY(0)             && and get a non-F1 keypress
        DO WHILE menu_key = g_F1
          menu_key = INKEY(0)
        ENDDO

        * and now restore the screen
        restscreen(h_top,h_left,h_bot,h_right,h_buf)
        * thanks to Tod, mask all keys other than arrows
        menu_key = IIF(CHR(menu_key)$(arrows_prev+arrows_next), ;
                         menu_key, g_space)
       ELSE
        DO beep
      ENDIF

    ENDIF                               && end of F1 test

  ENDIF                                 && get a new key


  DO CASE

    CASE CHR(menu_key)$arrows_prev
      do_it = iif(do_it = "N","N","M")
      move_it = .t.
      move_to = IIF( now_at = 1, num_opts, now_at - 1 )

    CASE CHR(menu_key)$arrows_next
      do_it = iif(do_it = "N","N","M")
      move_it = .t.
      move_to = IIF( now_at = num_opts, 1, now_at + 1 )

    CASE CHR(menu_key)$arrows_do
      move_it = .f.                     && carriage return
      do_it = "Y"

    CASE menu_key > g_space             && an option letter
      n = AT(UPPER(CHR(menu_key)),opt_keys)
                                        && n = option number if letter pressed
      IF n > 0
        move_it = n <> now_at
        move_to = n
        do_it = "Y"
       ELSE
        LOOP
      ENDIF

    CASE menu_key = g_escape .OR. menu_key = g_ctl_q
      EXIT

    CASE CHR(menu_key)$arrows_out
      EXIT

    OTHERWISE                           && ignore all others
      LOOP

  ENDCASE

  IF move_it                            && reset hi-lite bar
    DO &mn__hilo WITH now_at, .F.
    now_at = move_to
    DO &mn__hilo WITH now_at, .T.
  ENDIF

  menu_key = 0                          && key processed -- reset
  IF do_it <> "N"

    DO &mn__do WITH menu_key

    DO CASE

      CASE menu_key = -1                && explicit quit option in menu
        menu_key = g_escape
        EXIT

      CASE CHR(menu_key)$(arrows_prev+arrows_next)
        do_it = "M"                     && lower level exit via arrow key

      CASE menu_key <> 0
        do_it = "N"                     && some other return from action

      * OTHERWISE (menu_key = 0 -- did not call any routine)

    ENDCASE

  ENDIF                                 && not just scrolling the lite bar

ENDDO                                   && end of main loop

RETURN                                                      && end of menu_ctl


PROCEDURE dummy
******************************************************************************
*** dummy                       a routine for unimplemented option actions ***
******************************************************************************
PARAMETER s, l, dumm_key
PRIVATE c, dum_screen

SAVE SCREEN TO dum_screen
SET COLOR TO +W/N
@ 18,50 TO 24,79 DOUBLE
@ 19,51 CLEAR TO 23,78

c = UPPER(SUBSTR(s,LEN(s),1))
@ 20,52 SAY "Choice "+c+" not yet available."
@ 21,52 SAY "Called from: main "+s+"."
@ 22,52 SAY "Menu level: "+trim(str(l))+"."
c = " "
@ 24,55 SAY " Any key to continue "

dumm_key = INKEY(0)                     && wait for key press
DO WHILE dumm_key = g_F1                && no response to F1
  dumm_key = INKEY(0)                   && wait for key press
ENDDO

IF dumm_key = g_escape                  && do not return an escape
  dumm_key = g_car_ret
ENDIF

RESTORE SCREEN FROM dum_screen
RELEASE c, dum_screen
RETURN                                                         && end of dummy



*
* End of file C:\MENUD\SAMPLE2.PRG
* Generated from C:\MENUD\WW\SAMPLE2.WW using C:\MENUD\TEM\MENU_E.CTM.
* Generation completed at 09:52:05, November 2, 1989.

