
* C:\MENUD\NAMING.PRG Main program -- a pull-down/pop-out front end
* Generated from C:\MENUD\WW\NAMING.WW using C:\MENUD\TEM\MENU_E.CTM.
* Generated 09:54:03, November 2, 1989.
* Language: Clipper Summer 87
*

PRIVATE main, pop_buf

SET CURSOR off
SET SCOREBOARD off
SET CONFIRM off

* inkey aliases     ( g_xxx = global variable xxx )
g_up = 5
g_down = 24
g_left = 19
g_right = 4

g_pgup = 18
g_pgdn = 3
g_home = 1
g_end = 6
g_Ins = 22                             && synonym for Ctl-V
g_Del = 7                              && synonym for Ctl-G

g_ctl_home = 29
g_ctl_end = 23


g_car_ret = 13
g_escape = 27
g_space = 32
g_bksp = 8


g_F1 = 28

* g_ctl_c = 3                           && g_pgdn
* g_ctl_d = 4                           && g_right
* g_ctl_e = 5                           && g_up

g_ctl_q = 17
* g_ctl_r = 18                          && g_pgup
g_ctl_w = 23
* g_ctl_x = 24                          && g_down


SAVE SCREEN TO main

SET COLOR TO +W/N
CLEAR

* Display the sign-on box

SET COLOR TO N/W
@ 2,13,17,64 BOX "Ŀ "
@ 2,15 SAY " (sign-on) "
* painted box
@ 3,64 SAY ""
@ 4,21 SAY "Menu Templates -- Naming Conventions       "
@ 5,22 SAY "Copyright 1989, Martin L. Rinehart        "
@ 6,64 SAY ""
@ 7,15 SAY "READ THIS MESSAGE!                               "
@ 8,15 SAY 'This box is named "sign-on" as you see in the    '
@ 9,15 SAY "upper left portion of the border.  All boxes in  "
@ 10,15 SAY "this .WW will display their own names in this    "
@ 11,15 SAY "position."
@ 11,64 SAY ""
@ 12,37 SAY " "+CHR(17)+"                   "
@ 13,37 SAY "                         "
@ 14,37 SAY "                       "
@ 15,37 SAY "                         "
@ 16,37 SAY "                       "
SET COLOR TO *N/W
@ 11,44 SAY SPACE(1)
@ 12,24 SAY SPACE(1)
@ 13,24 SAY SPACE(1)
@ 14,22 SAY "Please press:"
@ 15,24 SAY SPACE(1)
@ 16,24 SAY SPACE(12)


nam_helpd = .f.                         && help display status

DO WHILE .t.                            && loop until non-F1 key

  k = INKEY(0)                          && wait for key press

  IF k = g_F1                           && help requested?

    IF .NOT. nam_helpd                  && is help not displayed?
      nam_help = savescreen(3,15,19,66)

      * pop up the help box
      SET COLOR TO N/W
      @ 3,15,19,66 BOX "ͻȺ "
      @ 3,17 SAY " (sign-on help) "
      @ 5,18 SAY "Box name:  sign-on"
      @ 6,18 SAY "Box type:  help"
      @ 8,18 SAY "This is a compound name, built from the root"
      @ 9,18 SAY "name plus a type."
      @ 11,18 SAY "Examples:"
      @ 13,22 SAY "MAIN"
      @ 14,22 SAY "MAIN HELP"
      @ 15,22 SAY "A"
      @ 16,22 SAY "A STOP"
      @ 18,21 SAY "press space twice to go to the main menu"
      nam_helpd = .t.
    ENDIF

   ELSE                                 && not an F1 key

    IF nam_helpd                        && if help is up, bring it down
      restscreen(3,15,19,66,nam_help)
      RELEASE nam_help
      nam_helpd = .f.
     ELSE                               && pass the key to the menu
      EXIT
    ENDIF

  ENDIF                                 && help requested
ENDDO                                   && F1 loop

SET COLOR TO +W/N
CLEAR
DO nam_main WITH k                      && begin the main menu

RESTORE SCREEN FROM main                && do a tidy exit
SET COLOR TO w/n

SET CURSOR ON
@ 23,78 say " "
RETURN                                                      && end of mainline



PROCEDURE nam_main
******************************************************************************
*** nam_main                                           main menu in NAMING ***
******************************************************************************
PARAMETER main_key
PRIVATE nam_main, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

nam_main = savescreen(0,0,22,51)


* display the menu box

SET COLOR TO +W/N
@ 0,0,22,51 BOX "͸Գ "
@ 0,2 SAY " (main) "
SET COLOR TO W/N
@ 1,1 CLEAR TO 21, 50
@ 3,22 SAY 'This is the "main" menu.'
@ 4,22 SAY "The starting menu must be"
@ 5,22 SAY 'named "main".'
@ 7,22 SAY "Please start at the top."

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret) + CHR(g_right)
arrows_out = ""

mn__do = "main_do"
mn__hilo = "main_hilo"
mn__hlp = "main_hlp"

opt_keys = "CRTE"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

main_key = 0                            && the user's keypress

DO menu_ctl with main_key

restscreen(0,0,22,51,nam_main)
RELEASE nam_main, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                      && end of nam_main



PROCEDURE main_do
******************************************************************************
*** main_do                                   main option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO nam_c  WITH main_key

  CASE now_at = 2
    DO nam_r  WITH main_key

  CASE now_at = 3
    DO nam_t  WITH main_key

  CASE now_at = 4
    DO nam_e  WITH main_key

ENDCASE

RETURN                                                       && end of main_do



PROCEDURE main_hlp
******************************************************************************
*** main_hlp                                          pop up help for main ***
******************************************************************************
PARAMETER t,l,b,r,buffer

* display the help box

buffer = savescreen(0,0,9,55)
SET COLOR TO N/W
@ 0,0,9,55 BOX "Ŀ "
@ 0,2 SAY " (main help) "
* painted box
@ 1,45 SAY "main help "
@ 2,55 SAY ""
@ 3,2 SAY 'The starting menu is be named "main" to tell the     '
@ 4,2 SAY "menu templates where to start.                       "
@ 5,55 SAY ""
@ 6,55 SAY ""
@ 7,55 SAY ""
@ 8,55 SAY ""
SET COLOR TO *N/W
@ 8,1 SAY " press any key to resume"

t = 0
l = 0
b = 9
r = 55

RETURN                                                      && end of main_hlp



PROCEDURE main_hilo
******************************************************************************
*** main_hilo                                     writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 2,2,5,14 BOX "Ŀ "
    @ 3,4 SAY "Compound"
    @ 4,6 SAY "names"

  CASE choice = 2
    @ 7,2,10,14 BOX "Ŀ "
    @ 8,6 SAY "Root"
    @ 9,6 SAY "names"

  CASE choice = 3
    @ 12,2,15,14 BOX "Ŀ "
    @ 13,6 SAY "Types"

  CASE choice = 4
    @ 17,2,20,14 BOX "Ŀ "
    @ 18,4 SAY "Examples"

ENDCASE
RETURN                                                     && end of main_hilo



PROCEDURE nam_c
******************************************************************************
*** nam_c                                                   displays a box ***
******************************************************************************
PARAMETER c_key
PRIVATE buf_c


nam_c = savescreen(2,16,20,79)


* pop-up the box

SET COLOR TO N/W
@ 2,16,20,79 BOX "ͻȺ "
@ 2,18 SAY " (c) "
@ 4,18 SAY "<name> := <root> [<type>]"
@ 6,18 SAY "Each name is built from a root and, optionally, a type."
@ 8,18 SAY 'This box is "c".  It'+"'s associated help box is "+'"c help".'
@ 10,18 SAY "Examples:"
@ 11,18 SAY ""
@ 12,18 SAY "main                         ac"
@ 13,18 SAY "main help                    ac help"
@ 14,18 SAY "a                            ac paint"
@ 15,18 SAY "a stop                       acx"
@ 16,18 SAY "b                            acx stop"
@ 17,18 SAY "b help                       acx paint"
@ 18,18 SAY "b paint                     "
@ 19,46 SAY ""

nam_helpd = .f.                         && help display status

DO WHILE .t.                            && loop until non-F1 key

  c_key = INKEY(0)                      && wait for key press

  IF c_key = g_F1                       && help requested?

    IF .NOT. nam_helpd                  && is help not displayed?
      nam_help = savescreen(2,16,20,79)

      * pop up the help box
      SET COLOR TO N/W
      @ 2,16,20,79 BOX "ͻȺ "
      @ 2,18 SAY " (c help) "
      @ 4,18 SAY "Names are not case sensitive.  Use upper or lower as you"
      @ 5,18 SAY "prefer.  These are equivalent examples:"
      @ 7,18 SAY 'This box is "c help" but it might also be "C HELP" or'
      @ 8,18 SAY '"c HELP" or "C help" or "C HeLp".  These are all the same.'
      @ 10,18 SAY "Examples:"
      @ 11,18 SAY ""
      @ 12,18 SAY "MAIN                         AC"
      @ 13,18 SAY "MAIN HELP                    AC HELP"
      @ 14,18 SAY "A                            AC PAINT"
      @ 15,18 SAY "A STOP                       ACX"
      @ 16,18 SAY "B                            ACX STOP"
      @ 17,18 SAY "B HELP                       ACX PAINT"
      @ 18,18 SAY "B PAINT                     "
      @ 19,46 SAY ""
      nam_helpd = .t.
    ENDIF

   ELSE                                 && not an F1 key

    IF nam_helpd                        && if help is up, bring it down
      restscreen(2,16,20,79,nam_help)
      RELEASE nam_help
      nam_helpd = .f.
     ELSE                               && pass the key to the menu
      EXIT
    ENDIF

  ENDIF                                 && help requested
ENDDO                                   && F1 loop

IF c_key = g_escape                     && do not return an escape
  c_key = g_car_ret
ENDIF

restscreen(2,16,20,79,nam_c)
RETURN                                                         && end of nam_c



PROCEDURE nam_r
******************************************************************************
*** nam_r                                         a level 1 pull-down menu ***
******************************************************************************
PARAMETER r_key
PRIVATE nam_r, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

nam_r = savescreen(2,15,20,79)


* display the menu box

SET COLOR TO N/W
@ 2,15,20,79 BOX "ͻȺ "
@ 2,17 SAY " (r) "
@ 4,17 SAY 'The root name of this box is "r" since it is option "r" from'
@ 5,17 SAY "the main menu.  As you choose the options below, you'll see"
@ 6,17 SAY "this pattern continue."
@ 8,17 SAY "There are two earlier root names:"
@ 9,33 SAY "sign-on (the sign-on screen)"
@ 10,33 SAY "main    (the main menu)"
@ 12,17 SAY "Pick A from the menu below to start further discussion."

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "r_do"
mn__hilo = "r_hilo"
mn__hlp = ""

opt_keys = "ABCDE"
num_opts = 5

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

r_key = 0                               && the user's keypress

DO menu_ctl with r_key

restscreen(2,15,20,79,nam_r)
RELEASE nam_r, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                         && end of nam_r



PROCEDURE r_do
******************************************************************************
*** r_do                                         r option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO nam_ra  WITH r_key

  CASE now_at = 2
    DO nam_rb  WITH r_key

  CASE now_at = 3
    DO nam_rc  WITH r_key

  CASE now_at = 4
    DO nam_rd  WITH r_key

  CASE now_at = 5 .and. do_it = "Y"
    DO nam_re  WITH r_key

ENDCASE

RETURN                                                          && end of r_do



PROCEDURE r_hilo
******************************************************************************
*** r_hilo                                        writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    IF high
      SET COLOR TO W/N
      @ 15,18,18,28 BOX "Ŀ "
      SET COLOR TO N/W
      @ 16,19 CLEAR TO 17, 27
      @ 16,23 SAY "A"
     ELSE
      @ 15,18,18,28 BOX "Ŀ "
      @ 16,23 SAY "A"
    ENDIF

  CASE choice = 2
    IF high
      SET COLOR TO W/N
      @ 15,30,18,40 BOX "Ŀ "
      SET COLOR TO N/W
      @ 16,31 CLEAR TO 17, 39
      @ 16,35 SAY "B"
     ELSE
      @ 15,30,18,40 BOX "Ŀ "
      @ 16,35 SAY "B"
    ENDIF

  CASE choice = 3
    IF high
      SET COLOR TO W/N
      @ 15,42,18,52 BOX "Ŀ "
      SET COLOR TO N/W
      @ 16,43 CLEAR TO 17, 51
      @ 16,47 SAY "C"
     ELSE
      @ 15,42,18,52 BOX "Ŀ "
      @ 16,47 SAY "C"
    ENDIF

  CASE choice = 4
    IF high
      SET COLOR TO W/N
      @ 15,54,18,64 BOX "Ŀ "
      SET COLOR TO N/W
      @ 16,55 CLEAR TO 17, 63
      @ 16,59 SAY "D"
     ELSE
      @ 15,54,18,64 BOX "Ŀ "
      @ 16,59 SAY "D"
    ENDIF

  CASE choice = 5
    IF high
      SET COLOR TO W/N
      @ 15,66,18,76 BOX "Ŀ "
      SET COLOR TO N/W
      @ 16,67 CLEAR TO 17, 75
      @ 16,71 SAY "E"
     ELSE
      @ 15,66,18,76 BOX "Ŀ "
      @ 16,71 SAY "E"
    ENDIF

ENDCASE
RETURN                                                        && end of r_hilo



PROCEDURE nam_t
******************************************************************************
*** nam_t                                                   displays a box ***
******************************************************************************
PARAMETER t_key
PRIVATE buf_t


nam_t = savescreen(2,16,20,79)


* pop-up the box

SET COLOR TO N/W
@ 2,16,20,79 BOX "ͻȺ "
@ 2,18 SAY " (t) "
@ 4,18 SAY "Types are an extensible set, designed for the whole template"
@ 5,18 SAY "family.  In the Menu Templates, three types are supported:"
@ 7,21 SAY "help  --  boxes that pop up when F1 is pressed"
@ 9,21 SAY 'stop  --  boxes that "stop" and wait for a "Y" keypress'
@ 10,31 SAY '(or return if the "N" default is chosen)'
@ 12,21 SAY "paint --  boxes that provide a screen background"
@ 14,18 SAY "Any root box can have any collection of associated types."
@ 15,18 SAY 'For instance, "A" can have:'
@ 17,29 SAY "a help          a stop         a paint"

t_key = INKEY(0)                        && wait for key press
DO WHILE t_key = g_F1                   && an F1 is a NOP
  t_key = INKEY(0)                      && wait for key press
ENDDO

IF t_key = g_escape                     && do not return an escape
  t_key = g_car_ret
ENDIF

restscreen(2,16,20,79,nam_t)
RETURN                                                         && end of nam_t



PROCEDURE nam_e
******************************************************************************
*** nam_e                                         a level 1 pull-down menu ***
******************************************************************************
PARAMETER e_key
PRIVATE nam_e, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

nam_e = savescreen(2,16,20,79)


* display the menu box

SET COLOR TO N/W
@ 2,16,20,79 BOX "ͻȺ "
@ 2,18 SAY " (e) "
@ 3,19 SAY 'This is box "e", a menu.  Note how it'+"'s pop-outs are named."
@ 6,32 SAY "Plain pop-out"
@ 10,32 SAY 'Pop-out with "stop"  (press Enter to select)'
@ 14,32 SAY "Pop-out and pull-downs"
@ 18,32 SAY 'Pop-out and pull-downs with "paint" boxes'

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "e_do"
mn__hilo = "e_hilo"
mn__hlp = ""

opt_keys = "ABCD"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

e_key = 0                               && the user's keypress

DO menu_ctl with e_key

restscreen(2,16,20,79,nam_e)
RELEASE nam_e, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                         && end of nam_e



PROCEDURE e_do
******************************************************************************
*** e_do                                         e option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO nam_ea  WITH e_key

  CASE now_at = 2 .and. do_it = "Y"
    DO nam_eb  WITH e_key

  CASE now_at = 3
    DO nam_ec  WITH e_key

  CASE now_at = 4
    DO nam_ed  WITH e_key

ENDCASE

RETURN                                                          && end of e_do



PROCEDURE e_hilo
******************************************************************************
*** e_hilo                                        writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    IF high
      SET COLOR TO +W/N
      @ 5,18,7,29 BOX "Ŀ "
      SET COLOR TO N/W
      @ 6,19 CLEAR TO 6, 28
      @ 6,23 SAY "A"
     ELSE
      @ 5,18,7,29 BOX "Ŀ "
      @ 6,23 SAY "A"
    ENDIF

  CASE choice = 2
    IF high
      SET COLOR TO +W/N
      @ 9,18,11,29 BOX "Ŀ "
      SET COLOR TO N/W
      @ 10,19 CLEAR TO 10, 28
      @ 10,23 SAY "B"
     ELSE
      @ 9,18,11,29 BOX "Ŀ "
      @ 10,23 SAY "B"
    ENDIF

  CASE choice = 3
    IF high
      SET COLOR TO +W/N
      @ 13,18,15,29 BOX "Ŀ "
      SET COLOR TO N/W
      @ 14,19 CLEAR TO 14, 28
      @ 14,23 SAY "C"
     ELSE
      @ 13,18,15,29 BOX "Ŀ "
      @ 14,23 SAY "C"
    ENDIF

  CASE choice = 4
    IF high
      SET COLOR TO +W/N
      @ 17,18,19,29 BOX "Ŀ "
      SET COLOR TO N/W
      @ 18,19 CLEAR TO 18, 28
      @ 18,23 SAY "D"
     ELSE
      @ 17,18,19,29 BOX "Ŀ "
      @ 18,23 SAY "D"
    ENDIF

ENDCASE
RETURN                                                        && end of e_hilo



PROCEDURE nam_ra
******************************************************************************
*** nam_ra                                                  displays a box ***
******************************************************************************
PARAMETER ra_key
PRIVATE buf_ra


nam_ra = savescreen(0,0,14,50)


* pop-up the box

SET COLOR TO N/W
@ 0,0,14,50 BOX "ͻȺ "
@ 0,2 SAY " (ra) "
@ 2,1 SAY "Here are the root names:"
@ 3,19 SAY "Ŀ"
@ 4,19 SAY "  sign-on      Optional"
@ 5,19 SAY ""
@ 6,25 SAY CHR(31)
@ 7,19 SAY "Ŀ"
@ 8,19 SAY "    main    "
@ 9,19 SAY ""
@ 10,5 SAY ""
@ 11,2 SAY "Ŀ  Ŀ  Ŀ           continued"
@ 12,2 SAY " <t>    <t>    <t>  (etc.)    on (rb). . ."
@ 13,2 SAY "    "

ra_key = INKEY(0)                       && wait for key press
DO WHILE ra_key = g_F1                  && an F1 is a NOP
  ra_key = INKEY(0)                     && wait for key press
ENDDO

IF ra_key = g_escape                    && do not return an escape
  ra_key = g_car_ret
ENDIF

restscreen(0,0,14,50,nam_ra)
RETURN                                                        && end of nam_ra



PROCEDURE nam_rb
******************************************************************************
*** nam_rb                                                  displays a box ***
******************************************************************************
PARAMETER rb_key
PRIVATE buf_rb


nam_rb = savescreen(0,9,14,59)


* pop-up the box

SET COLOR TO N/W
@ 0,9,14,59 BOX "ͻȺ "
@ 0,11 SAY " (rb) "
@ 2,11 SAY "Ŀ  Ŀ  Ŀ"
@ 3,11 SAY " <t>    <t>    <t>  (etc.)"
@ 4,11 SAY "    "
@ 6,11 SAY "<t> := option trigger letter"
@ 8,11 SAY "For instance, if the options on"
@ 9,11 SAY "main were `A', `B' and `C' these"
@ 10,11 SAY "boxes would be `A', `B' and `C'."
@ 11,47 SAY "continued"
@ 12,47 SAY "on (rc). . ."

rb_key = INKEY(0)                       && wait for key press
DO WHILE rb_key = g_F1                  && an F1 is a NOP
  rb_key = INKEY(0)                     && wait for key press
ENDDO

IF rb_key = g_escape                    && do not return an escape
  rb_key = g_car_ret
ENDIF

restscreen(0,9,14,59,nam_rb)
RETURN                                                        && end of nam_rb



PROCEDURE nam_rc
******************************************************************************
*** nam_rc                                                  displays a box ***
******************************************************************************
PARAMETER rc_key
PRIVATE buf_rc


nam_rc = savescreen(0,19,14,69)


* pop-up the box

SET COLOR TO N/W
@ 0,19,14,69 BOX "ͻȺ "
@ 0,21 SAY " (rc) "
@ 2,21 SAY "Ŀ  Ŀ  Ŀ"
@ 3,21 SAY " <t>     B     <t>  (etc.)"
@ 4,21 SAY "    "
@ 5,24 SAY "Ŀ"
@ 6,21 SAY "Ŀ  Ŀ  Ŀ"
@ 7,21 SAY " BX     BY     BZ  "
@ 8,21 SAY "    "
@ 10,25 SAY "Assume that menu"
@ 11,25 SAY "B has options X, Y              continued"
@ 12,25 SAY "and Z.                          on (rd). . ."

rc_key = INKEY(0)                       && wait for key press
DO WHILE rc_key = g_F1                  && an F1 is a NOP
  rc_key = INKEY(0)                     && wait for key press
ENDDO

IF rc_key = g_escape                    && do not return an escape
  rc_key = g_car_ret
ENDIF

restscreen(0,19,14,69,nam_rc)
RETURN                                                        && end of nam_rc



PROCEDURE nam_rd
******************************************************************************
*** nam_rd                                                  displays a box ***
******************************************************************************
PARAMETER rd_key
PRIVATE buf_rd


nam_rd = savescreen(0,29,14,79)


* pop-up the box

SET COLOR TO N/W
@ 0,29,14,79 BOX "ͻȺ "
@ 0,31 SAY " (rd) "
@ 2,31 SAY "Ŀ  Ŀ  Ŀ"
@ 3,31 SAY "         B             Names for menus"
@ 4,31 SAY "        under options A,"
@ 5,34 SAY "Ŀ       B and C from menu"
@ 6,31 SAY "Ŀ  Ŀ  Ŀ    BZ."
@ 7,31 SAY " BX     BY     BZ  "
@ 8,31 SAY "    "
@ 9,43 SAY "Ŀ"
@ 10,40 SAY "Ŀ  Ŀ  Ŀ"
@ 11,40 SAY " BZA    BZB    BZC "
@ 12,40 SAY "    "

rd_key = INKEY(0)                       && wait for key press
DO WHILE rd_key = g_F1                  && an F1 is a NOP
  rd_key = INKEY(0)                     && wait for key press
ENDDO

IF rd_key = g_escape                    && do not return an escape
  rd_key = g_car_ret
ENDIF

restscreen(0,29,14,79,nam_rd)
RETURN                                                        && end of nam_rd



PROCEDURE nam_re
******************************************************************************
*** nam_re                                                  displays a box ***
******************************************************************************
PARAMETER re_key
PRIVATE buf_re

* pop the "proceed? (stop)" box
pop_buf = savescreen(0,0,24,79)
SET COLOR TO N/W
@ 0,0,24,79 BOX "Ŀ "
@ 0,2 SAY " (re stop) "
* painted box
@ 1,79 SAY ""
@ 2,2 SAY "The next screen assumes that each menu has options A, B and C.  The .WW      "
@ 3,2 SAY "might look like this:                                                        "
@ 4,79 SAY ""
@ 5,79 SAY ""
@ 6,79 SAY ""
@ 7,79 SAY ""
@ 8,79 SAY ""
@ 9,79 SAY ""
@ 10,79 SAY ""
@ 11,79 SAY ""
@ 12,79 SAY ""
@ 13,79 SAY ""
@ 14,79 SAY ""
@ 15,79 SAY ""
@ 16,79 SAY ""
@ 17,79 SAY ""
@ 18,39 SAY "Would you like to see the sample        "
@ 19,39 SAY "names (Y/N) ?                           "
@ 20,79 SAY ""
@ 21,79 SAY ""
@ 22,79 SAY ""
@ 23,79 SAY ""
SET COLOR TO +W/N
@ 5,2 SAY "ͻ"
@ 6,2 SAY " A  B  C   (MAIN)                "
@ 7,2 SAY "ͻ ͼ"
@ 8,2 SAY "     (A)     "
@ 9,2 SAY "           ͻ"
@ 10,2 SAY "  A A  B  C     (AA)     "
@ 11,2 SAY "           ͻͼ"
@ 12,2 SAY "  B    (AAA)    "
@ 13,2 SAY "                      ͻ"
@ 14,2 SAY "  C  A A  B  C     (AAAA)   "
@ 15,2 SAY "                      ͼ"
@ 16,2 SAY "             B  "
@ 17,2 SAY "ͺ             "
@ 18,14 SAY "  C  "
@ 19,14 SAY "             "
@ 20,14 SAY "             "
@ 21,14 SAY "ͼ"
SET CURSOR ON

DO WHILE .T.
  go_tmp_str = "N"
  @ 19,53 GET go_tmp_str PICTURE '!'
  READ
  IF go_tmp_str$"YNTF"
    go = go_tmp_str$"YT"
    EXIT
   ELSE
    DO beep
  ENDIF
ENDDO

SET CURSOR OFF
IF .not. go                             && user says 'no'
  restscreen(0,0,24,79,pop_buf)
  RELEASE pop_buf 
  re_key = lastkey()
  RETURN
ENDIF

restscreen(0,0,24,79,pop_buf)
RELEASE pop_buf

nam_re = savescreen(1,6,24,73)


* pop-up the box

SET COLOR TO N/W
@ 1,6,24,73 BOX "ͻȺ "
@ 1,8 SAY " (re) "
@ 3,8 SAY "SIGN-ON              (screen display before start)"
@ 4,8 SAY "MAIN                 (first menu)"
@ 5,8 SAY ""
@ 6,8 SAY "Ŀ"
@ 7,8 SAY "           "
@ 8,8 SAY "A     B      C       (pull-downs under MAIN)"
@ 9,8 SAY ""
@ 10,8 SAY " AA                (pop-outs from A)"
@ 11,8 SAY "  "
@ 12,8 SAY "  Ŀ"
@ 13,8 SAY "            "
@ 14,8 SAY "    AAA  AAB  AAC   (pull-downs under AA)"
@ 15,8 SAY "     "
@ 16,8 SAY "      AAAA        (pop-outs from AAA)"
@ 17,8 SAY "      AAAB"
@ 18,8 SAY "      AAAC"
@ 19,8 SAY ""
@ 20,8 SAY " AB"
@ 21,8 SAY " AC"

re_key = INKEY(0)                       && wait for key press
DO WHILE re_key = g_F1                  && an F1 is a NOP
  re_key = INKEY(0)                     && wait for key press
ENDDO

IF re_key = g_escape                    && do not return an escape
  re_key = g_car_ret
ENDIF

restscreen(1,6,24,73,nam_re)
RETURN                                                        && end of nam_re



PROCEDURE nam_ea
******************************************************************************
*** nam_ea                                                  displays a box ***
******************************************************************************
PARAMETER ea_key
PRIVATE buf_ea


nam_ea = savescreen(5,32,7,77)


* pop-up the box

SET COLOR TO +W/N
@ 5,32,7,77 BOX "Ŀ "
@ 5,34 SAY " (ea) "
@ 6,34 SAY '"main" option "e", "e" option "a"'

ea_key = INKEY(0)                       && wait for key press
DO WHILE ea_key = g_F1                  && an F1 is a NOP
  ea_key = INKEY(0)                     && wait for key press
ENDDO

IF ea_key = g_escape                    && do not return an escape
  ea_key = g_car_ret
ENDIF

restscreen(5,32,7,77,nam_ea)
RETURN                                                        && end of nam_ea



PROCEDURE nam_eb
******************************************************************************
*** nam_eb                                                  displays a box ***
******************************************************************************
PARAMETER eb_key
PRIVATE buf_eb

* pop the "proceed? (stop)" box
pop_buf = savescreen(6,0,14,30)
SET COLOR TO N/W
@ 6,0,14,30 BOX "͸Գ "
@ 6,2 SAY " (eb stop) "
@ 8,2 SAY '"eb stop" stops you from'
@ 9,2 SAY 'getting to "eb" without a'
@ 10,2 SAY 'confirming "Y" keypress.'
@ 12,2 SAY "OK (y/n)?"
SET CURSOR ON

DO WHILE .T.
  go_tmp_str = "N"
  @ 12,12 GET go_tmp_str PICTURE '!'
  READ
  IF go_tmp_str$"YNTF"
    go = go_tmp_str$"YT"
    EXIT
   ELSE
    DO beep
  ENDIF
ENDDO

SET CURSOR OFF
IF .not. go                             && user says 'no'
  restscreen(6,0,14,30,pop_buf)
  RELEASE pop_buf 
  eb_key = lastkey()
  RETURN
ENDIF

restscreen(6,0,14,30,pop_buf)
RELEASE pop_buf

nam_eb = savescreen(9,32,11,77)


* pop-up the box

SET COLOR TO +W/N
@ 9,32,11,77 BOX "Ŀ "
@ 9,34 SAY " (eb) "
@ 10,34 SAY '"main" option "e", "e" option "b"'

eb_key = INKEY(0)                       && wait for key press
DO WHILE eb_key = g_F1                  && an F1 is a NOP
  eb_key = INKEY(0)                     && wait for key press
ENDDO

IF eb_key = g_escape                    && do not return an escape
  eb_key = g_car_ret
ENDIF

restscreen(9,32,11,77,nam_eb)
RETURN                                                        && end of nam_eb



PROCEDURE nam_ec
******************************************************************************
*** nam_ec                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER ec_key
PRIVATE nam_ec, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

nam_ec = savescreen(13,32,15,77)


* display the menu box

SET COLOR TO +W/N
@ 13,32,15,77 BOX "͸Գ "
@ 13,34 SAY " (ec) "
SET COLOR TO W/N
@ 14,33 CLEAR TO 14, 76

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "ec_do"
mn__hilo = "ec_hilo"
mn__hlp = ""

opt_keys = "ABCD"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

ec_key = 0                              && the user's keypress

DO menu_ctl with ec_key

restscreen(13,32,15,77,nam_ec)
RELEASE nam_ec, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of nam_ec



PROCEDURE ec_do
******************************************************************************
*** ec_do                                       ec option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO nam_eca  WITH ec_key

  CASE now_at = 2
    DO nam_ecb  WITH ec_key

  CASE now_at = 3
    DO nam_ecc  WITH ec_key

  CASE now_at = 4
    DO nam_ecd  WITH ec_key

ENDCASE

RETURN                                                         && end of ec_do



PROCEDURE ec_hilo
******************************************************************************
*** ec_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 14,34 CLEAR TO 14, 42
    @ 14,38 SAY "A"

  CASE choice = 2
    @ 14,45 CLEAR TO 14, 53
    @ 14,49 SAY "B"

  CASE choice = 3
    @ 14,56 CLEAR TO 14, 64
    @ 14,60 SAY "C"

  CASE choice = 4
    @ 14,67 CLEAR TO 14, 75
    @ 14,71 SAY "D"

ENDCASE
RETURN                                                       && end of ec_hilo



PROCEDURE nam_ed
******************************************************************************
*** nam_ed                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER ed_key
PRIVATE nam_ed, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

SAVE SCREEN TO nam_ed

SET COLOR TO N/W
@ 0,0,24,79 BOX "Ŀ "
@ 0,2 SAY " (ed paint) "
@ 12,29 SAY 'This is a "paint" box'
@ 14,22 SAY 'It is painted "under" its root box.'


* display the menu box

SET COLOR TO +W/N
@ 2,6,4,51 BOX "͸Գ "
@ 2,8 SAY " (ed) "
SET COLOR TO W/N
@ 3,7 CLEAR TO 3, 50

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "ed_do"
mn__hilo = "ed_hilo"
mn__hlp = ""

opt_keys = "ABCD"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

ed_key = 0                              && the user's keypress

DO menu_ctl with ed_key

RESTORE SCREEN FROM nam_ed
RELEASE nam_ed, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of nam_ed



PROCEDURE ed_do
******************************************************************************
*** ed_do                                       ed option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO nam_eda  WITH ed_key

  CASE now_at = 2
    DO nam_edb  WITH ed_key

  CASE now_at = 3
    DO nam_edc  WITH ed_key

  CASE now_at = 4
    DO nam_edd  WITH ed_key

ENDCASE

RETURN                                                         && end of ed_do



PROCEDURE ed_hilo
******************************************************************************
*** ed_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 3,8 CLEAR TO 3, 16
    @ 3,12 SAY "A"

  CASE choice = 2
    @ 3,19 CLEAR TO 3, 27
    @ 3,23 SAY "B"

  CASE choice = 3
    @ 3,30 CLEAR TO 3, 38
    @ 3,34 SAY "C"

  CASE choice = 4
    @ 3,41 CLEAR TO 3, 49
    @ 3,45 SAY "D"

ENDCASE
RETURN                                                       && end of ed_hilo



PROCEDURE nam_eca
******************************************************************************
*** nam_eca                                                 displays a box ***
******************************************************************************
PARAMETER eca_key
PRIVATE buf_eca


nam_eca = savescreen(15,31,24,45)


* pop-up the box

SET COLOR TO +W/N
@ 15,31,24,45 BOX "ķӺ "
@ 15,33 SAY " (eca) "
@ 17,33 SAY "Pull-down A"
@ 18,36 SAY "from"
@ 19,34 SAY "Pop-out C"
@ 20,36 SAY "from"
@ 21,35 SAY "Main A"

eca_key = INKEY(0)                      && wait for key press
DO WHILE eca_key = g_F1                 && an F1 is a NOP
  eca_key = INKEY(0)                    && wait for key press
ENDDO

IF eca_key = g_escape                   && do not return an escape
  eca_key = g_car_ret
ENDIF

restscreen(15,31,24,45,nam_eca)
RETURN                                                       && end of nam_eca



PROCEDURE nam_ecb
******************************************************************************
*** nam_ecb                                                 displays a box ***
******************************************************************************
PARAMETER ecb_key
PRIVATE buf_ecb


nam_ecb = savescreen(15,42,24,56)


* pop-up the box

SET COLOR TO +W/N
@ 15,42,24,56 BOX "ķӺ "
@ 15,44 SAY " (ecb) "
@ 17,44 SAY "Pull-down B"
@ 18,47 SAY "from"
@ 19,45 SAY "Pop-out C"
@ 20,47 SAY "from"
@ 21,46 SAY "Main A"

ecb_key = INKEY(0)                      && wait for key press
DO WHILE ecb_key = g_F1                 && an F1 is a NOP
  ecb_key = INKEY(0)                    && wait for key press
ENDDO

IF ecb_key = g_escape                   && do not return an escape
  ecb_key = g_car_ret
ENDIF

restscreen(15,42,24,56,nam_ecb)
RETURN                                                       && end of nam_ecb



PROCEDURE nam_ecc
******************************************************************************
*** nam_ecc                                                 displays a box ***
******************************************************************************
PARAMETER ecc_key
PRIVATE buf_ecc


nam_ecc = savescreen(15,53,24,67)


* pop-up the box

SET COLOR TO +W/N
@ 15,53,24,67 BOX "ķӺ "
@ 15,55 SAY " (ecc) "
@ 17,55 SAY "Pull-down C"
@ 18,58 SAY "from"
@ 19,56 SAY "Pop-out C"
@ 20,58 SAY "from"
@ 21,57 SAY "Main A"

ecc_key = INKEY(0)                      && wait for key press
DO WHILE ecc_key = g_F1                 && an F1 is a NOP
  ecc_key = INKEY(0)                    && wait for key press
ENDDO

IF ecc_key = g_escape                   && do not return an escape
  ecc_key = g_car_ret
ENDIF

restscreen(15,53,24,67,nam_ecc)
RETURN                                                       && end of nam_ecc



PROCEDURE nam_ecd
******************************************************************************
*** nam_ecd                                                 displays a box ***
******************************************************************************
PARAMETER ecd_key
PRIVATE buf_ecd


nam_ecd = savescreen(15,64,24,78)


* pop-up the box

SET COLOR TO +W/N
@ 15,64,24,78 BOX "ķӺ "
@ 15,66 SAY " (ecd) "
@ 17,66 SAY "Pull-down D"
@ 18,69 SAY "from"
@ 19,67 SAY "Pop-out C"
@ 20,69 SAY "from"
@ 21,68 SAY "Main A"

ecd_key = INKEY(0)                      && wait for key press
DO WHILE ecd_key = g_F1                 && an F1 is a NOP
  ecd_key = INKEY(0)                    && wait for key press
ENDDO

IF ecd_key = g_escape                   && do not return an escape
  ecd_key = g_car_ret
ENDIF

restscreen(15,64,24,78,nam_ecd)
RETURN                                                       && end of nam_ecd



PROCEDURE nam_eda
******************************************************************************
*** nam_eda                                                 displays a box ***
******************************************************************************
PARAMETER eda_key
PRIVATE buf_eda


SAVE SCREEN TO nam_eda

SET COLOR TO +W/N
@ 1,30,10,72 BOX "Ŀ "
@ 1,32 SAY " (eda paint) "
* painted box
@ 2,72 SAY ""
@ 3,72 SAY ""
@ 4,72 SAY ""
@ 5,72 SAY ""
@ 6,72 SAY ""
@ 7,72 SAY ""
@ 8,72 SAY ""
@ 9,72 SAY ""
SET COLOR TO W/N
@ 3,41 SAY " Floating paint box  "


* pop-up the box

SET COLOR TO +W/N
@ 4,6,15,21 BOX "Ŀ "
@ 4,8 SAY " (eda) "
@ 6,8 SAY "Pull-down A"
@ 7,12 SAY "from"
@ 8,10 SAY "menu ED."

eda_key = INKEY(0)                      && wait for key press
DO WHILE eda_key = g_F1                 && an F1 is a NOP
  eda_key = INKEY(0)                    && wait for key press
ENDDO

IF eda_key = g_escape                   && do not return an escape
  eda_key = g_car_ret
ENDIF

RESTORE SCREEN FROM nam_eda
RETURN                                                       && end of nam_eda



PROCEDURE nam_edb
******************************************************************************
*** nam_edb                                                 displays a box ***
******************************************************************************
PARAMETER edb_key
PRIVATE buf_edb


SAVE SCREEN TO nam_edb

SET COLOR TO N/W
@ 0,0,24,79 BOX "Ŀ "
@ 0,2 SAY " (edb paint) "
@ 4,40 SAY "Full-screen paint box"


* pop-up the box

SET COLOR TO +W/N
@ 4,15,15,30 BOX "Ŀ "
@ 4,17 SAY " (edb) "
@ 6,17 SAY "Pull-down B"
@ 7,21 SAY "from"
@ 8,19 SAY "menu ED."

edb_key = INKEY(0)                      && wait for key press
DO WHILE edb_key = g_F1                 && an F1 is a NOP
  edb_key = INKEY(0)                    && wait for key press
ENDDO

IF edb_key = g_escape                   && do not return an escape
  edb_key = g_car_ret
ENDIF

RESTORE SCREEN FROM nam_edb
RETURN                                                       && end of nam_edb



PROCEDURE nam_edc
******************************************************************************
*** nam_edc                                                 displays a box ***
******************************************************************************
PARAMETER edc_key
PRIVATE buf_edc


SAVE SCREEN TO nam_edc

SET COLOR TO W/N
@ 0,0 CLEAR TO 24, 79
@ 5,6 SAY 'Underneath "edc" is "edc paint" -- a no border low white on black'
@ 6,6 SAY "box covering the whole screen.  Press the left or right arrows to"
@ 7,6 SAY "see for yourself."


* pop-up the box

SET COLOR TO +W/N
@ 0,0,2,79 BOX "͸Գ "
@ 0,2 SAY " (edc) "
* painted box
@ 1,6 SAY "New pseudo-main menu, perhaps ("
@ 1,71 SAY ").      "
SET COLOR TO W/N
@ 1,37 SAY "but still just a pull-down from ED"

edc_key = INKEY(0)                      && wait for key press
DO WHILE edc_key = g_F1                 && an F1 is a NOP
  edc_key = INKEY(0)                    && wait for key press
ENDDO

IF edc_key = g_escape                   && do not return an escape
  edc_key = g_car_ret
ENDIF

RESTORE SCREEN FROM nam_edc
RETURN                                                       && end of nam_edc



PROCEDURE nam_edd
******************************************************************************
*** nam_edd                                                 displays a box ***
******************************************************************************
PARAMETER edd_key
PRIVATE buf_edd


SAVE SCREEN TO nam_edd

SET COLOR TO *+W/W
@ 3,41 CLEAR TO 3, 49
@ 3,45 SAY "D"


* pop-up the box

SET COLOR TO +W/N
@ 4,37,15,52 BOX "Ŀ "
@ 4,39 SAY " (edd) "
* painted box
@ 5,52 SAY ""
@ 6,39 SAY "Pull-down D  "
@ 7,43 SAY "from     "
@ 8,41 SAY "menu ED.   "
@ 9,52 SAY ""
@ 10,52 SAY ""
@ 11,52 SAY ""
@ 12,52 SAY ""
@ 13,52 SAY ""
@ 14,52 SAY ""
SET COLOR TO *+W/N
@ 11,41 SAY "Press F1"

nam_helpd = .f.                         && help display status

DO WHILE .t.                            && loop until non-F1 key

  edd_key = INKEY(0)                    && wait for key press

  IF edd_key = g_F1                     && help requested?

    IF .NOT. nam_helpd                  && is help not displayed?
      nam_help = savescreen(9,28,19,62)

      * pop up the help box
      SET COLOR TO N/W
      @ 9,28,19,62 BOX "Ŀ "
      @ 9,30 SAY " (edd help) "
      @ 11,31 SAY 'Note the blinking "D".'
      @ 13,31 SAY "What made the option blink?"
      @ 15,31 SAY "You are really seeing box"
      @ 16,31 SAY '"edd paint", and not the menu'
      @ 17,31 SAY "option."
      nam_helpd = .t.
    ENDIF

   ELSE                                 && not an F1 key

    IF nam_helpd                        && if help is up, bring it down
      restscreen(9,28,19,62,nam_help)
      RELEASE nam_help
      nam_helpd = .f.
     ELSE                               && pass the key to the menu
      EXIT
    ENDIF

  ENDIF                                 && help requested
ENDDO                                   && F1 loop

IF edd_key = g_escape                   && do not return an escape
  edd_key = g_car_ret
ENDIF

RESTORE SCREEN FROM nam_edd
RETURN                                                       && end of nam_edd



PROCEDURE beep
******************************************************************************
*** beep                                             sounds a warning beep ***
******************************************************************************
* This can be changed for silence, or another tone.
?? CHR(7)
RETURN                                                          && end of beep



PROCEDURE menu_ctl
******************************************************************************
*** menu_ctl                                  general menu control routine ***
******************************************************************************
PARAMETER menu_key

* initialize the help parameters
STORE 0 TO h_top, h_left, h_bot, h_right, h_buf

DO &mn__hilo WITH 1, .T.                && hilite option 1

i = 2                                   && lolite the rest
DO WHILE i <= num_opts
  DO &mn__hilo WITH i, .F.
  i = i + 1
ENDDO

DO WHILE .t.                            && main loop

  IF .NOT. CHR(menu_key)$(arrows_prev+arrows_next)
                                        && arrow might come from a
                                        && called menu

    menu_key = INKEY(0)                 && get a keystroke

    IF menu_key = g_F1                  && loop until non-F1 key

      IF LEN(mn__hlp) > 0
        DO &mn__hlp WITH h_top, h_left, h_bot, h_right, h_buf

        menu_key = INKEY(0)             && and get a non-F1 keypress
        DO WHILE menu_key = g_F1
          menu_key = INKEY(0)
        ENDDO

        * and now restore the screen
        restscreen(h_top,h_left,h_bot,h_right,h_buf)
        * thanks to Tod, mask all keys other than arrows
        menu_key = IIF(CHR(menu_key)$(arrows_prev+arrows_next), ;
                         menu_key, g_space)
       ELSE
        DO beep
      ENDIF

    ENDIF                               && end of F1 test

  ENDIF                                 && get a new key


  DO CASE

    CASE CHR(menu_key)$arrows_prev
      do_it = iif(do_it = "N","N","M")
      move_it = .t.
      move_to = IIF( now_at = 1, num_opts, now_at - 1 )

    CASE CHR(menu_key)$arrows_next
      do_it = iif(do_it = "N","N","M")
      move_it = .t.
      move_to = IIF( now_at = num_opts, 1, now_at + 1 )

    CASE CHR(menu_key)$arrows_do
      move_it = .f.                     && carriage return
      do_it = "Y"

    CASE menu_key > g_space             && an option letter
      n = AT(UPPER(CHR(menu_key)),opt_keys)
                                        && n = option number if letter pressed
      IF n > 0
        move_it = n <> now_at
        move_to = n
        do_it = "Y"
       ELSE
        LOOP
      ENDIF

    CASE menu_key = g_escape .OR. menu_key = g_ctl_q
      EXIT

    CASE CHR(menu_key)$arrows_out
      EXIT

    OTHERWISE                           && ignore all others
      LOOP

  ENDCASE

  IF move_it                            && reset hi-lite bar
    DO &mn__hilo WITH now_at, .F.
    now_at = move_to
    DO &mn__hilo WITH now_at, .T.
  ENDIF

  menu_key = 0                          && key processed -- reset
  IF do_it <> "N"

    DO &mn__do WITH menu_key

    DO CASE

      CASE menu_key = -1                && explicit quit option in menu
        menu_key = g_escape
        EXIT

      CASE CHR(menu_key)$(arrows_prev+arrows_next)
        do_it = "M"                     && lower level exit via arrow key

      CASE menu_key <> 0
        do_it = "N"                     && some other return from action

      * OTHERWISE (menu_key = 0 -- did not call any routine)

    ENDCASE

  ENDIF                                 && not just scrolling the lite bar

ENDDO                                   && end of main loop

RETURN                                                      && end of menu_ctl


*
* End of file C:\MENUD\NAMING.PRG
* Generated from C:\MENUD\WW\NAMING.WW using C:\MENUD\TEM\MENU_E.CTM.
* Generation completed at 09:54:03, November 2, 1989.

