
* C:\MENUD\SAMPLE1.PRG Main program -- a pull-down/pop-out front end
* Generated from C:\MENUD\WW\SAMPLE1.WW using C:\MENUD\TEM\MENU_E.CTM.
* Generated 09:50:53, November 2, 1989.
* Language: Clipper Summer 87
*

PRIVATE main, pop_buf

SET CURSOR off
SET SCOREBOARD off
SET CONFIRM off

* inkey aliases     ( g_xxx = global variable xxx )
g_up = 5
g_down = 24
g_left = 19
g_right = 4

g_pgup = 18
g_pgdn = 3
g_home = 1
g_end = 6
g_Ins = 22                             && synonym for Ctl-V
g_Del = 7                              && synonym for Ctl-G

g_ctl_home = 29
g_ctl_end = 23


g_car_ret = 13
g_escape = 27
g_space = 32
g_bksp = 8


g_F1 = 28

* g_ctl_c = 3                           && g_pgdn
* g_ctl_d = 4                           && g_right
* g_ctl_e = 5                           && g_up

g_ctl_q = 17
* g_ctl_r = 18                          && g_pgup
g_ctl_w = 23
* g_ctl_x = 24                          && g_down


SAVE SCREEN TO main

SET COLOR TO +W/N
CLEAR

* Display the sign-on box

SET COLOR TO N/W
@ 2,13,17,64 BOX "Ŀ "
* painted box
@ 3,15 SAY "Sample 1                                         "
@ 4,64 SAY ""
@ 5,30 SAY "Nested pull-downs                 "
@ 6,38 SAY "v.                        "
@ 7,35 SAY "Pop-outs                     "
@ 8,64 SAY ""
@ 9,64 SAY ""
@ 10,64 SAY ""
@ 11,64 SAY ""
@ 12,17 SAY "Menu Templates  (c) 1989, Martin L. Rinehart   "
@ 13,64 SAY ""
@ 14,64 SAY ""
@ 15,64 SAY ""
@ 16,64 SAY ""
SET COLOR TO *N/W
@ 15,28 SAY "press any key to begin"


k = INKEY(0)                            && wait for key press
DO WHILE k = g_F1                       && an F1 is a NOP
  k = INKEY(0)                          && wait for key press
ENDDO

SET COLOR TO +W/N
CLEAR
DO sam_main WITH k                      && begin the main menu

RESTORE SCREEN FROM main                && do a tidy exit
SET COLOR TO w/n

SET CURSOR ON
@ 23,78 say " "
RETURN                                                      && end of mainline



PROCEDURE sam_main
******************************************************************************
*** sam_main                                          main menu in SAMPLE1 ***
******************************************************************************
PARAMETER main_key
PRIVATE sam_main, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_main = savescreen(0,0,2,79)


* display the menu box

SET COLOR TO +W/N
@ 0,0,2,79 BOX "͸Գ "
SET COLOR TO W/N
@ 1,1 CLEAR TO 1, 78

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret) + CHR(g_down)
arrows_out = ""

mn__do = "main_do"
mn__hilo = "main_hilo"
mn__hlp = ""

opt_keys = "NPCDE"
num_opts = 5

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

main_key = 0                            && the user's keypress

DO menu_ctl with main_key

restscreen(0,0,2,79,sam_main)
RELEASE sam_main, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                      && end of sam_main



PROCEDURE main_do
******************************************************************************
*** main_do                                   main option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO sam_n  WITH main_key

  CASE now_at = 2
    DO sam_p  WITH main_key

  CASE now_at = 3
    DO sam_c  WITH main_key

  CASE now_at = 4
    DO sam_d  WITH main_key

  CASE now_at = 5
    DO sam_e  WITH main_key

ENDCASE

RETURN                                                       && end of main_do



PROCEDURE main_hilo
******************************************************************************
*** main_hilo                                     writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 1,2 CLEAR TO 1, 20
    @ 1,3 SAY "Nested pull-downs"

  CASE choice = 2
    @ 1,22 CLEAR TO 1, 31
    @ 1,23 SAY "Pop-outs"

  CASE choice = 3
    @ 1,33 CLEAR TO 1, 42
    @ 1,34 SAY "C choice"

  CASE choice = 4
    @ 1,44 CLEAR TO 1, 53
    @ 1,45 SAY "D choice"

  CASE choice = 5
    @ 1,55 CLEAR TO 1, 64
    @ 1,56 SAY "E choice"

ENDCASE
RETURN                                                     && end of main_hilo



PROCEDURE sam_n
******************************************************************************
*** sam_n                                         a level 1 pull-down menu ***
******************************************************************************
PARAMETER n_key
PRIVATE sam_n, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_n = savescreen(2,0,15,20)


* display the menu box

SET COLOR TO +W/N
@ 2,0,15,20 BOX "ķӺ "
@ 3,2 SAY "Nested pull-downs"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "n_do"
mn__hilo = "n_hilo"
mn__hlp = ""

opt_keys = "ABCDE"
num_opts = 5

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

n_key = 0                               && the user's keypress

DO menu_ctl with n_key

restscreen(2,0,15,20,sam_n)
RELEASE sam_n, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                         && end of sam_n



PROCEDURE n_do
******************************************************************************
*** n_do                                         n option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO sam_na  WITH n_key

  CASE now_at = 2
    DO sam_nb  WITH n_key

  CASE now_at = 3
    DO sam_nc  WITH n_key

  CASE now_at = 4
    DO sam_nd  WITH n_key

  CASE now_at = 5
    DO sam_ne  WITH n_key

ENDCASE

RETURN                                                          && end of n_do



PROCEDURE n_hilo
******************************************************************************
*** n_hilo                                        writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 5,1 CLEAR TO 5, 19
    @ 5,2 SAY "Another pull-down"

  CASE choice = 2
    @ 7,1 CLEAR TO 7, 19
    @ 7,2 SAY "Brother pull-down"

  CASE choice = 3
    @ 9,1 CLEAR TO 9, 19
    @ 9,2 SAY "Charlie pull-down"

  CASE choice = 4
    @ 11,1 CLEAR TO 11, 19
    @ 11,2 SAY "Dreaded pull-down"

  CASE choice = 5
    @ 13,1 CLEAR TO 13, 19
    @ 13,2 SAY "Envious pull-down"

ENDCASE
RETURN                                                        && end of n_hilo



PROCEDURE sam_p
******************************************************************************
*** sam_p                                         a level 1 pull-down menu ***
******************************************************************************
PARAMETER p_key
PRIVATE sam_p, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_p = savescreen(2,16,15,37)


* display the menu box

SET COLOR TO +W/N
@ 2,16,15,37 BOX "ķӺ "
@ 3,23 SAY "Pop-outs"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "p_do"
mn__hilo = "p_hilo"
mn__hlp = ""

opt_keys = "CWROB"
num_opts = 5

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

p_key = 0                               && the user's keypress

DO menu_ctl with p_key

restscreen(2,16,15,37,sam_p)
RELEASE sam_p, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                         && end of sam_p



PROCEDURE p_do
******************************************************************************
*** p_do                                         p option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO sam_pc  WITH p_key

  CASE now_at = 2
    DO sam_pw  WITH p_key

  CASE now_at = 3
    DO sam_pr  WITH p_key

  CASE now_at = 4
    DO sam_po  WITH p_key

  CASE now_at = 5
    DO sam_pb  WITH p_key

ENDCASE

RETURN                                                          && end of p_do



PROCEDURE p_hilo
******************************************************************************
*** p_hilo                                        writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 5,18 CLEAR TO 5, 35
    @ 5,19 SAY "Choose me first!"

  CASE choice = 2
    @ 7,18 CLEAR TO 7, 35
    @ 7,24 SAY "We will"

  CASE choice = 3
    @ 9,18 CLEAR TO 9, 35
    @ 9,25 SAY "Roll"

  CASE choice = 4
    @ 11,18 CLEAR TO 11, 35
    @ 11,26 SAY "On"

  CASE choice = 5
    @ 13,18 CLEAR TO 13, 35
    @ 13,26 SAY "By"

ENDCASE
RETURN                                                        && end of p_hilo



PROCEDURE sam_c
******************************************************************************
*** sam_c                                                   displays a box ***
******************************************************************************
PARAMETER c_key
PRIVATE buf_c


sam_c = savescreen(2,31,15,44)


* pop-up the box

SET COLOR TO +W/N
@ 2,31,15,44 BOX "ķӺ "
@ 3,37 SAY "C"
@ 5,34 SAY "This box"
@ 6,36 SAY "is an"
@ 7,35 SAY "`empty'"

c_key = INKEY(0)                        && wait for key press
DO WHILE c_key = g_F1                   && an F1 is a NOP
  c_key = INKEY(0)                      && wait for key press
ENDDO

IF c_key = g_escape                     && do not return an escape
  c_key = g_car_ret
ENDIF

restscreen(2,31,15,44,sam_c)
RETURN                                                         && end of sam_c



PROCEDURE sam_d
******************************************************************************
*** sam_d                                                   displays a box ***
******************************************************************************
PARAMETER d_key
PRIVATE buf_d


sam_d = savescreen(2,42,15,55)


* pop-up the box

SET COLOR TO +W/N
@ 2,42,15,55 BOX "ķӺ "
@ 3,48 SAY "D"
@ 5,45 SAY "This box"
@ 6,47 SAY "is an"
@ 7,46 SAY "`empty'"

d_key = INKEY(0)                        && wait for key press
DO WHILE d_key = g_F1                   && an F1 is a NOP
  d_key = INKEY(0)                      && wait for key press
ENDDO

IF d_key = g_escape                     && do not return an escape
  d_key = g_car_ret
ENDIF

restscreen(2,42,15,55,sam_d)
RETURN                                                         && end of sam_d



PROCEDURE sam_e
******************************************************************************
*** sam_e                                                   displays a box ***
******************************************************************************
PARAMETER e_key
PRIVATE buf_e


sam_e = savescreen(2,53,15,66)


* pop-up the box

SET COLOR TO +W/N
@ 2,53,15,66 BOX "ķӺ "
@ 3,59 SAY "E"
@ 5,56 SAY "This box"
@ 6,58 SAY "is an"
@ 7,57 SAY "`empty'"

e_key = INKEY(0)                        && wait for key press
DO WHILE e_key = g_F1                   && an F1 is a NOP
  e_key = INKEY(0)                      && wait for key press
ENDDO

IF e_key = g_escape                     && do not return an escape
  e_key = g_car_ret
ENDIF

restscreen(2,53,15,66,sam_e)
RETURN                                                         && end of sam_e



PROCEDURE sam_na
******************************************************************************
*** sam_na                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER na_key
PRIVATE sam_na, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_na = savescreen(6,6,19,25)


* display the menu box

SET COLOR TO +W/N
@ 6,6,19,25 BOX "ķӺ "
@ 7,12 SAY "Another"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "na_do"
mn__hilo = "na_hilo"
mn__hlp = ""

opt_keys = "ABCDE"
num_opts = 5

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

na_key = 0                              && the user's keypress

DO menu_ctl with na_key

restscreen(6,6,19,25,sam_na)
RELEASE sam_na, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_na



PROCEDURE na_do
******************************************************************************
*** na_do                                       na option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "naa", 2, na_key

  CASE now_at = 2
    DO DUMMY with "nab", 2, na_key

  CASE now_at = 3
    DO DUMMY with "nac", 2, na_key

  CASE now_at = 4
    DO DUMMY with "nad", 2, na_key

  CASE now_at = 5
    DO DUMMY with "nae", 2, na_key

ENDCASE

RETURN                                                         && end of na_do



PROCEDURE na_hilo
******************************************************************************
*** na_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 9,8 CLEAR TO 9, 23
    @ 9,12 SAY "A choice"

  CASE choice = 2
    @ 11,8 CLEAR TO 11, 23
    @ 11,12 SAY "B choice"

  CASE choice = 3
    @ 13,8 CLEAR TO 13, 23
    @ 13,12 SAY "C choice"

  CASE choice = 4
    @ 15,8 CLEAR TO 15, 23
    @ 15,12 SAY "D choice"

  CASE choice = 5
    @ 17,8 CLEAR TO 17, 23
    @ 17,12 SAY "E choice"

ENDCASE
RETURN                                                       && end of na_hilo



PROCEDURE sam_nb
******************************************************************************
*** sam_nb                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER nb_key
PRIVATE sam_nb, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_nb = savescreen(8,6,21,25)


* display the menu box

SET COLOR TO +W/N
@ 8,6,21,25 BOX "ķӺ "
@ 9,12 SAY "Brother"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "nb_do"
mn__hilo = "nb_hilo"
mn__hlp = ""

opt_keys = "ABCDE"
num_opts = 5

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

nb_key = 0                              && the user's keypress

DO menu_ctl with nb_key

restscreen(8,6,21,25,sam_nb)
RELEASE sam_nb, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_nb



PROCEDURE nb_do
******************************************************************************
*** nb_do                                       nb option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "nba", 2, nb_key

  CASE now_at = 2
    DO DUMMY with "nbb", 2, nb_key

  CASE now_at = 3
    DO DUMMY with "nbc", 2, nb_key

  CASE now_at = 4
    DO DUMMY with "nbd", 2, nb_key

  CASE now_at = 5
    DO DUMMY with "nbe", 2, nb_key

ENDCASE

RETURN                                                         && end of nb_do



PROCEDURE nb_hilo
******************************************************************************
*** nb_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 11,8 CLEAR TO 11, 23
    @ 11,12 SAY "A choice"

  CASE choice = 2
    @ 13,8 CLEAR TO 13, 23
    @ 13,12 SAY "B choice"

  CASE choice = 3
    @ 15,8 CLEAR TO 15, 23
    @ 15,12 SAY "C choice"

  CASE choice = 4
    @ 17,8 CLEAR TO 17, 23
    @ 17,12 SAY "D choice"

  CASE choice = 5
    @ 19,8 CLEAR TO 19, 23
    @ 19,12 SAY "E choice"

ENDCASE
RETURN                                                       && end of nb_hilo



PROCEDURE sam_nc
******************************************************************************
*** sam_nc                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER nc_key
PRIVATE sam_nc, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_nc = savescreen(10,6,23,25)


* display the menu box

SET COLOR TO +W/N
@ 10,6,23,25 BOX "ķӺ "
@ 11,12 SAY "Charlie"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "nc_do"
mn__hilo = "nc_hilo"
mn__hlp = ""

opt_keys = "ABCDE"
num_opts = 5

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

nc_key = 0                              && the user's keypress

DO menu_ctl with nc_key

restscreen(10,6,23,25,sam_nc)
RELEASE sam_nc, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_nc



PROCEDURE nc_do
******************************************************************************
*** nc_do                                       nc option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "nca", 2, nc_key

  CASE now_at = 2
    DO DUMMY with "ncb", 2, nc_key

  CASE now_at = 3
    DO DUMMY with "ncc", 2, nc_key

  CASE now_at = 4
    DO DUMMY with "ncd", 2, nc_key

  CASE now_at = 5
    DO DUMMY with "nce", 2, nc_key

ENDCASE

RETURN                                                         && end of nc_do



PROCEDURE nc_hilo
******************************************************************************
*** nc_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 13,8 CLEAR TO 13, 23
    @ 13,12 SAY "A choice"

  CASE choice = 2
    @ 15,8 CLEAR TO 15, 23
    @ 15,12 SAY "B choice"

  CASE choice = 3
    @ 17,8 CLEAR TO 17, 23
    @ 17,12 SAY "C choice"

  CASE choice = 4
    @ 19,8 CLEAR TO 19, 23
    @ 19,12 SAY "D choice"

  CASE choice = 5
    @ 21,8 CLEAR TO 21, 23
    @ 21,12 SAY "E choice"

ENDCASE
RETURN                                                       && end of nc_hilo



PROCEDURE sam_nd
******************************************************************************
*** sam_nd                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER nd_key
PRIVATE sam_nd, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_nd = savescreen(12,6,22,25)


* display the menu box

SET COLOR TO +W/N
@ 12,6,22,25 BOX "ķӺ "
@ 13,12 SAY "Dreaded"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "nd_do"
mn__hilo = "nd_hilo"
mn__hlp = ""

opt_keys = "ABCD"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

nd_key = 0                              && the user's keypress

DO menu_ctl with nd_key

restscreen(12,6,22,25,sam_nd)
RELEASE sam_nd, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_nd



PROCEDURE nd_do
******************************************************************************
*** nd_do                                       nd option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "nda", 2, nd_key

  CASE now_at = 2
    DO DUMMY with "ndb", 2, nd_key

  CASE now_at = 3
    DO DUMMY with "ndc", 2, nd_key

  CASE now_at = 4
    DO DUMMY with "ndd", 2, nd_key

ENDCASE

RETURN                                                         && end of nd_do



PROCEDURE nd_hilo
******************************************************************************
*** nd_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 15,8 CLEAR TO 15, 23
    @ 15,12 SAY "A choice"

  CASE choice = 2
    @ 17,8 CLEAR TO 17, 23
    @ 17,12 SAY "B choice"

  CASE choice = 3
    @ 19,8 CLEAR TO 19, 23
    @ 19,12 SAY "C choice"

  CASE choice = 4
    @ 21,8 CLEAR TO 21, 23
    @ 21,12 SAY "D choice"

ENDCASE
RETURN                                                       && end of nd_hilo



PROCEDURE sam_ne
******************************************************************************
*** sam_ne                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER ne_key
PRIVATE sam_ne, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_ne = savescreen(14,6,24,25)


* display the menu box

SET COLOR TO +W/N
@ 14,6,24,25 BOX "ķӺ "
@ 15,12 SAY "Envious"

arrows_prev  = CHR(g_up)
arrows_next  = CHR(g_down)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_left) + CHR(g_right)

mn__do = "ne_do"
mn__hilo = "ne_hilo"
mn__hlp = ""

opt_keys = "ABCD"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

ne_key = 0                              && the user's keypress

DO menu_ctl with ne_key

restscreen(14,6,24,25,sam_ne)
RELEASE sam_ne, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_ne



PROCEDURE ne_do
******************************************************************************
*** ne_do                                       ne option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "nea", 2, ne_key

  CASE now_at = 2
    DO DUMMY with "neb", 2, ne_key

  CASE now_at = 3
    DO DUMMY with "nec", 2, ne_key

  CASE now_at = 4
    DO DUMMY with "ned", 2, ne_key

ENDCASE

RETURN                                                         && end of ne_do



PROCEDURE ne_hilo
******************************************************************************
*** ne_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 17,8 CLEAR TO 17, 23
    @ 17,12 SAY "A choice"

  CASE choice = 2
    @ 19,8 CLEAR TO 19, 23
    @ 19,12 SAY "B choice"

  CASE choice = 3
    @ 21,8 CLEAR TO 21, 23
    @ 21,12 SAY "C choice"

  CASE choice = 4
    @ 23,8 CLEAR TO 23, 23
    @ 23,12 SAY "D choice"

ENDCASE
RETURN                                                       && end of ne_hilo



PROCEDURE sam_pc
******************************************************************************
*** sam_pc                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER pc_key
PRIVATE sam_pc, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_pc = savescreen(6,22,8,68)


* display the menu box

SET COLOR TO +W/N
@ 6,22,8,68 BOX "͸Գ "
SET COLOR TO W/N
@ 7,23 CLEAR TO 7, 67

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "pc_do"
mn__hilo = "pc_hilo"
mn__hlp = ""

opt_keys = "PTDA"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

pc_key = 0                              && the user's keypress

DO menu_ctl with pc_key

restscreen(6,22,8,68,sam_pc)
RELEASE sam_pc, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_pc



PROCEDURE pc_do
******************************************************************************
*** pc_do                                       pc option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "pcp", 2, pc_key

  CASE now_at = 2
    DO DUMMY with "pct", 2, pc_key

  CASE now_at = 3
    DO DUMMY with "pcd", 2, pc_key

  CASE now_at = 4
    DO DUMMY with "pca", 2, pc_key

ENDCASE

RETURN                                                         && end of pc_do



PROCEDURE pc_hilo
******************************************************************************
*** pc_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 7,24 CLEAR TO 7, 33
    @ 7,25 SAY "Press"

  CASE choice = 2
    @ 7,35 CLEAR TO 7, 44
    @ 7,36 SAY "The"

  CASE choice = 3
    @ 7,46 CLEAR TO 7, 55
    @ 7,47 SAY "Down"

  CASE choice = 4
    @ 7,57 CLEAR TO 7, 66
    @ 7,58 SAY "Arrow"

ENDCASE
RETURN                                                       && end of pc_hilo



PROCEDURE sam_pw
******************************************************************************
*** sam_pw                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER pw_key
PRIVATE sam_pw, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_pw = savescreen(8,22,10,68)


* display the menu box

SET COLOR TO +W/N
@ 8,22,10,68 BOX "͸Գ "
SET COLOR TO W/N
@ 9,23 CLEAR TO 9, 67

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "pw_do"
mn__hilo = "pw_hilo"
mn__hlp = ""

opt_keys = "RSAN"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

pw_key = 0                              && the user's keypress

DO menu_ctl with pw_key

restscreen(8,22,10,68,sam_pw)
RELEASE sam_pw, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_pw



PROCEDURE pw_do
******************************************************************************
*** pw_do                                       pw option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "pwr", 2, pw_key

  CASE now_at = 2
    DO DUMMY with "pws", 2, pw_key

  CASE now_at = 3
    DO DUMMY with "pwa", 2, pw_key

  CASE now_at = 4
    DO DUMMY with "pwn", 2, pw_key

ENDCASE

RETURN                                                         && end of pw_do



PROCEDURE pw_hilo
******************************************************************************
*** pw_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 9,24 CLEAR TO 9, 33
    @ 9,25 SAY "Rolling"

  CASE choice = 2
    @ 9,35 CLEAR TO 9, 44
    @ 9,36 SAY "Straight"

  CASE choice = 3
    @ 9,46 CLEAR TO 9, 55
    @ 9,47 SAY "And"

  CASE choice = 4
    @ 9,57 CLEAR TO 9, 66
    @ 9,58 SAY "Narrow"

ENDCASE
RETURN                                                       && end of pw_hilo



PROCEDURE sam_pr
******************************************************************************
*** sam_pr                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER pr_key
PRIVATE sam_pr, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_pr = savescreen(10,22,12,68)


* display the menu box

SET COLOR TO +W/N
@ 10,22,12,68 BOX "͸Գ "
SET COLOR TO W/N
@ 11,23 CLEAR TO 11, 67

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "pr_do"
mn__hilo = "pr_hilo"
mn__hlp = ""

opt_keys = "ITNA"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

pr_key = 0                              && the user's keypress

DO menu_ctl with pr_key

restscreen(10,22,12,68,sam_pr)
RELEASE sam_pr, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_pr



PROCEDURE pr_do
******************************************************************************
*** pr_do                                       pr option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "pri", 2, pr_key

  CASE now_at = 2
    DO DUMMY with "prt", 2, pr_key

  CASE now_at = 3
    DO DUMMY with "prn", 2, pr_key

  CASE now_at = 4
    DO DUMMY with "pra", 2, pr_key

ENDCASE

RETURN                                                         && end of pr_do



PROCEDURE pr_hilo
******************************************************************************
*** pr_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 11,24 CLEAR TO 11, 33
    @ 11,25 SAY "In"

  CASE choice = 2
    @ 11,35 CLEAR TO 11, 44
    @ 11,36 SAY "The"

  CASE choice = 3
    @ 11,46 CLEAR TO 11, 55
    @ 11,47 SAY "Nineties"

  CASE choice = 4
    @ 11,57 CLEAR TO 11, 66
    @ 11,58 SAY "Age"

ENDCASE
RETURN                                                       && end of pr_hilo



PROCEDURE sam_po
******************************************************************************
*** sam_po                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER po_key
PRIVATE sam_po, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_po = savescreen(12,22,14,68)


* display the menu box

SET COLOR TO +W/N
@ 12,22,14,68 BOX "͸Գ "
SET COLOR TO W/N
@ 13,23 CLEAR TO 13, 67

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "po_do"
mn__hilo = "po_hilo"
mn__hlp = ""

opt_keys = "PATR"
num_opts = 4

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

po_key = 0                              && the user's keypress

DO menu_ctl with po_key

restscreen(12,22,14,68,sam_po)
RELEASE sam_po, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_po



PROCEDURE po_do
******************************************************************************
*** po_do                                       po option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "pop", 2, po_key

  CASE now_at = 2
    DO DUMMY with "poa", 2, po_key

  CASE now_at = 3
    DO DUMMY with "pot", 2, po_key

  CASE now_at = 4
    DO DUMMY with "por", 2, po_key

ENDCASE

RETURN                                                         && end of po_do



PROCEDURE po_hilo
******************************************************************************
*** po_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 13,24 CLEAR TO 13, 33
    @ 13,25 SAY "Popouts"

  CASE choice = 2
    @ 13,35 CLEAR TO 13, 44
    @ 13,36 SAY "Are"

  CASE choice = 3
    @ 13,46 CLEAR TO 13, 55
    @ 13,47 SAY "The"

  CASE choice = 4
    @ 13,57 CLEAR TO 13, 66
    @ 13,58 SAY "Rage"

ENDCASE
RETURN                                                       && end of po_hilo



PROCEDURE sam_pb
******************************************************************************
*** sam_pb                                        a level 2 pull-down menu ***
******************************************************************************
PARAMETER pb_key
PRIVATE sam_pb, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at

sam_pb = savescreen(14,22,16,68)


* display the menu box

SET COLOR TO +W/N
@ 14,22,16,68 BOX "͸Գ "
SET COLOR TO W/N
@ 15,23 CLEAR TO 15, 67

arrows_prev  = CHR(g_left)
arrows_next  = CHR(g_right)
arrows_do  = CHR(g_car_ret)
arrows_out = CHR(g_up) + CHR(g_down)

mn__do = "pb_do"
mn__hilo = "pb_hilo"
mn__hlp = ""

opt_keys = "PS"
num_opts = 2

do_it = "N"                             && do_it: Y = Yes, M = Maybe, N = No
now_at = 1                              && the currently hilited option

pb_key = 0                              && the user's keypress

DO menu_ctl with pb_key

restscreen(14,22,16,68,sam_pb)
RELEASE sam_pb, arrows_prev, arrows_next, arrows_do, arrows_out, ;
        mn__do, mn__hilo, mn__hlp, ;
        opt_keys, num_opts, do_it, now_at
RETURN                                                        && end of sam_pb



PROCEDURE pb_do
******************************************************************************
*** pb_do                                       pb option action selection ***
******************************************************************************

DO CASE
  CASE now_at = 1
    DO DUMMY with "pbp", 2, pb_key

  CASE now_at = 2
    DO DUMMY with "pbs", 2, pb_key

ENDCASE

RETURN                                                         && end of pb_do



PROCEDURE pb_hilo
******************************************************************************
*** pb_hilo                                       writes hi/lolited option ***
******************************************************************************
PARAMETER choice, high

IF high
  last_color = "N/W"
  SET COLOR TO N/W
 ELSE
  last_color = "W/N"
  SET COLOR TO W/N
ENDIF

DO CASE
  CASE choice = 1
    @ 15,35 CLEAR TO 15, 44
    @ 15,36 SAY "Popouts"

  CASE choice = 2
    @ 15,46 CLEAR TO 15, 55
    @ 15,48 SAY "Save!"

ENDCASE
RETURN                                                       && end of pb_hilo



PROCEDURE beep
******************************************************************************
*** beep                                             sounds a warning beep ***
******************************************************************************
* This can be changed for silence, or another tone.
?? CHR(7)
RETURN                                                          && end of beep



PROCEDURE menu_ctl
******************************************************************************
*** menu_ctl                                  general menu control routine ***
******************************************************************************
PARAMETER menu_key

* initialize the help parameters
STORE 0 TO h_top, h_left, h_bot, h_right, h_buf

DO &mn__hilo WITH 1, .T.                && hilite option 1

i = 2                                   && lolite the rest
DO WHILE i <= num_opts
  DO &mn__hilo WITH i, .F.
  i = i + 1
ENDDO

DO WHILE .t.                            && main loop

  IF .NOT. CHR(menu_key)$(arrows_prev+arrows_next)
                                        && arrow might come from a
                                        && called menu

    menu_key = INKEY(0)                 && get a keystroke

    IF menu_key = g_F1                  && loop until non-F1 key

      IF LEN(mn__hlp) > 0
        DO &mn__hlp WITH h_top, h_left, h_bot, h_right, h_buf

        menu_key = INKEY(0)             && and get a non-F1 keypress
        DO WHILE menu_key = g_F1
          menu_key = INKEY(0)
        ENDDO

        * and now restore the screen
        restscreen(h_top,h_left,h_bot,h_right,h_buf)
        * thanks to Tod, mask all keys other than arrows
        menu_key = IIF(CHR(menu_key)$(arrows_prev+arrows_next), ;
                         menu_key, g_space)
       ELSE
        DO beep
      ENDIF

    ENDIF                               && end of F1 test

  ENDIF                                 && get a new key


  DO CASE

    CASE CHR(menu_key)$arrows_prev
      do_it = iif(do_it = "N","N","M")
      move_it = .t.
      move_to = IIF( now_at = 1, num_opts, now_at - 1 )

    CASE CHR(menu_key)$arrows_next
      do_it = iif(do_it = "N","N","M")
      move_it = .t.
      move_to = IIF( now_at = num_opts, 1, now_at + 1 )

    CASE CHR(menu_key)$arrows_do
      move_it = .f.                     && carriage return
      do_it = "Y"

    CASE menu_key > g_space             && an option letter
      n = AT(UPPER(CHR(menu_key)),opt_keys)
                                        && n = option number if letter pressed
      IF n > 0
        move_it = n <> now_at
        move_to = n
        do_it = "Y"
       ELSE
        LOOP
      ENDIF

    CASE menu_key = g_escape .OR. menu_key = g_ctl_q
      EXIT

    CASE CHR(menu_key)$arrows_out
      EXIT

    OTHERWISE                           && ignore all others
      LOOP

  ENDCASE

  IF move_it                            && reset hi-lite bar
    DO &mn__hilo WITH now_at, .F.
    now_at = move_to
    DO &mn__hilo WITH now_at, .T.
  ENDIF

  menu_key = 0                          && key processed -- reset
  IF do_it <> "N"

    DO &mn__do WITH menu_key

    DO CASE

      CASE menu_key = -1                && explicit quit option in menu
        menu_key = g_escape
        EXIT

      CASE CHR(menu_key)$(arrows_prev+arrows_next)
        do_it = "M"                     && lower level exit via arrow key

      CASE menu_key <> 0
        do_it = "N"                     && some other return from action

      * OTHERWISE (menu_key = 0 -- did not call any routine)

    ENDCASE

  ENDIF                                 && not just scrolling the lite bar

ENDDO                                   && end of main loop

RETURN                                                      && end of menu_ctl


PROCEDURE dummy
******************************************************************************
*** dummy                       a routine for unimplemented option actions ***
******************************************************************************
PARAMETER s, l, dumm_key
PRIVATE c, dum_screen

SAVE SCREEN TO dum_screen
SET COLOR TO +W/N
@ 18,50 TO 24,79 DOUBLE
@ 19,51 CLEAR TO 23,78

c = UPPER(SUBSTR(s,LEN(s),1))
@ 20,52 SAY "Choice "+c+" not yet available."
@ 21,52 SAY "Called from: main "+s+"."
@ 22,52 SAY "Menu level: "+trim(str(l))+"."
c = " "
@ 24,55 SAY " Any key to continue "

dumm_key = INKEY(0)                     && wait for key press
DO WHILE dumm_key = g_F1                && no response to F1
  dumm_key = INKEY(0)                   && wait for key press
ENDDO

IF dumm_key = g_escape                  && do not return an escape
  dumm_key = g_car_ret
ENDIF

RESTORE SCREEN FROM dum_screen
RELEASE c, dum_screen
RETURN                                                         && end of dummy



*
* End of file C:\MENUD\SAMPLE1.PRG
* Generated from C:\MENUD\WW\SAMPLE1.WW using C:\MENUD\TEM\MENU_E.CTM.
* Generation completed at 09:50:53, November 2, 1989.

