         page       64, 132 

TITLE	MEMTABLE    Program to return a character string from an indexed table
         
    ;   The purpose of this program is to have a two, three or four position
    ;   character field used as an index to return a character string in the 
    ;   calling memory variable in a dBIII+ program

    ;   This program must be modified in two areas

    ;   First, place the proper values for the number of records, length of
    ;           the index, and the length of returned value.

    ;   Second, enter your data in the table area after removing the test data
    ;           It must be in the form as shown.  Please see the accompanying
    ;           documentation for further instructions

    ;   To use this program see the documentation.  The only unusual aspect is
    ;           that you must pad the calling memvar with blank spaces so that
    ;           MEMTABLE does not write over other variables.

    ;           memvar = "1454" + Space(Name_Length - Index_Length)
    ;           Call MEMTABLE with memvar
    ;           ? memvar


    ;   (c) 1986 by John J. Dean, Esq.
    ;               Suite 500
    ;               Mutual Building
    ;               816 Fifth Ave.
    ;               Pittsburgh, PA  15219
    ;               (412) 391- 1350
    ;               CIS 73055.1752

    ;   Program may be freely used but not sold alone or as part of a package


CODESEG       SEGMENT     BYTE PUBLIC 'CODE'
              assume cs:codeseg, ds:codeseg, es:codeseg



; *********   Start of the area to enter the values of your table ***********

No_Of_Records      =    0008                 ;The total number of records in
                                             ; the table(index & name = 1)

Index_Length       =    0004                 ;Number of characters in the Index
                                             ;  Should be either 2, 3, or 4

Name_Length        =    0012                 ;The size of your character field
                                             ;  can be any value up to 255

; *********   End of the area to enter the values of your table *************


Total_Increment    =    Index_Length + Name_Length
Index_Increment    =    Index_Length - 2

MEMTAB   PROC       FAR

BEGIN:
         pushF                               ;save all the registers
         push       ax                       ;  this probably isn't 
         push       bx                       ;  necessary; but at machine
         push       cx                       ;  speeds, better safe than 
         push       dx                       ;  sorry

         push       ds
         push       es
         push       si
         push       di
                                             ;Set up area for memvar

         mov        di, bx                   ;receiving area = ES:DI	
         push       ds                       ; bx points to DS but we
         pop        es                       ; need it in ES

         mov        ax, [es:bx]              ;enter first part of memvar

                                             ;Set up the table area

         push       cs                       ;set DS = CS
         pop        ds                       ; we need cs in ds
         lea        si, MainTable            ;sending string = DS:SI

         mov        cx, No_Of_Records        ;enter the table length
 

no_find: cmp        ax, [si]                 ;this part does the index compare
      IF Index_length -2
         je         part2                    ; it was a match, check next part
      ELSE
         je         transfer                 ; it was a match, go transfer it
      ENDIF
         add        si, Total_Increment      ; it wasn't, so increment
         loop       no_find                  ;    and try again

                                             ;If no match has been found
                                             ; the program will drop through
                                             ; the loop with the pointer set
                                             ; at the default area 

transfer:  mov      cx, Name_Length          ;This part transfers the name
           add      si, Index_Length         ; adjusted for offset of index
           rep      movsb                    ; using repetative move 

         pop        di                       ;restore all the registers
         pop        si
         pop        es
         pop        ds
         pop        dx
         pop        cx
         pop        bx
         pop        ax
         popF        

         ret

part2:   mov        ax, es:[bx+Index_increment] ;get the next two in memvar
         cmp        ax, [si+Index_increment]    ;compare with next two in table
         je         transfer                 ; we have a match, so move it
         mov        ax, es:[bx]              ; no match, restore original text
         add        si, Total_Increment      ;    and original increment 
         jmp        no_find                  ;    go back and try again

         
MainTable           Label     WORD           ; here is the data table


; *********   Start of the area of your table ***************************

; Naturally, remove the examples listed here & these comments in your program
; Make sure that the width of each of your name fields is equal to name_length 
;                         '--constant -'   

         DB         '1234','Penkower    '
         DB         '1134','McDaniels   '
         DB         '1135','Strauss     '
         DB         '2250','Ross        '
         DB         '2288','Cercone     '
         DB         '2292','Novak       '
         DB         '2345','Bigley      '
         DB         '9567','Dauer       '

; *********   End of the area of your table ********************************


Default  DB         Name_Length DUP ('*')    ; this is default result if there
                                             ;    is no match
  

MEMTAB	 ENDP

codeseg  ends
         end        begin

  