* MEMORY.PRG -- uses INTER.BIN and PEEK.BIN
* Andrew Schulman 9/13/87
* 12 Humboldt Street, Cambridge MA 02140
* measures conventional, extended, expanded memory

*---- necessary formalities
if .not. file("inter.bin") .or. .not. file("peek.bin")
    ? "This program requires INTER.BIN and PEEK.BIN"
    return
endif
if type('didinter') = 'U'
    public didinter
    load inter
    didinter = .t.
endif
if type('didpeek') = 'U'
    public didpeek
    load peek
    didpeek = .t.
endif

*---- conventional memory installed
*---- note: FoxBase+ 2.0 has sys(12) which tells amount of available memory
cmd="x12 0 0 0 0"+space(20)
call inter with cmd
convmem=substr(cmd,1,5)         && AX
? convmem + " Kbytes conventional memory"

*---- see if this is an AT or 386 machine:  F000:FFFE must be 0xFC
cmd="xf000 xfffe x"
call peek with cmd
ator386=iif("FC" $ cmd, .t., .f.)

*---- if an AT or 386, check extended memory (not present on other machines)
if (ator386)
    cmd="x15 x8800 0 0 0"+space(20)     && interrupt 15h, func 88h
    call inter with cmd
    extmem=substr(cmd,1,5)      && AX
    ? extmem + " Kbytes extended memory"
endif

*---- see if expanded memory installed:  requires CHKDRV.PRG
if file("chkdrv.prg")
    do chkdrv with 103,"LIM Expanded Memory driver"
    if inst103
        cmd="x67 x4200 0 0 0"+space(20)
        call inter with cmd
        bx=int(val(substr(cmd,7,5)))
        dx=int(val(substr(cmd,19,5)))
        pagesfree=bx
        pagestotal=dx
        expmem=ltrim(str(dx*16))
        expfree=ltrim(str(bx*16))
        ? expmem + " Kbytes LIM expanded memory installed"
        ? expfree + " Kbytes LIM expanded memory available"
    endif
endif






