
* procedure library for menus


* ---InitBar:  defines the public variables needed for menus

PROCEDURE InitBar

   PUBLIC MChoiceLen, MHelpLen, MChoices, MBar, MFirstLet    ;
          MRow, MCol, MNormal, MHighlight
   PUBLIC MChoice1, MChoice2, MChoice3, MChoice4, MChoice5,  ;
          MChoice6, MChoice7, MChoice8, MChoice9, MChoice10
   PUBLIC MHelp1,   MHelp2,   MHelp3,   MHelp4,   MHelp5,    ;
          MHelp6,   MHelp7,   MHelp8,   MHelp9,   MHelp10

RETURN   && Procedure InitBar





* ---NewBar:  allocates variables for a brand new menu bar


PROCEDURE NewBar
   PARAMETERS NumChoices, ChoiceLen, HelpLen, Row, Col, Normal, Highlight
   PRIVATE i

   MChoices   = NumChoices                         && save these away
   MChoiceLen = ChoiceLen                          && in public variables
   MHelpLen   = HelpLen
   MRow       = Row
   MCol       = Col
   MNormal    = Normal
   MHighlight = Highlight
   i = 1
   DO WHILE i <= MChoices
      MChoiceVar = "MCHOICE" + LTRIM(STR(i))
      STORE REPLICATE(" ", MChoiceLen) TO &MChoiceVar
      MHelpVar = "MHELP" + LTRIM(STR(i))
      STORE REPLICATE(" ", 76)         TO &MHelpVar
      i = i + 1
   ENDDO

RETURN  && Procedure NewBar


* ---CenterStr: centers a string.  Used by BarItem.

PROCEDURE CenterStr
   PARAMETERS InString, Length, OutString
   PRIVATE PadAmt

   OutString = LTRIM(TRIM(InString))
   PadAmt = INT((Length - LEN(OutString)) / 2) 
   OutString = SPACE(PadAmt) + OutString 
   OutString = OutString + SPACE(Length - LEN(OutString))

RETURN  && CenterStr


* ---BarItem: Adds a new menu choice to the menu

PROCEDURE BarItem
   PARAMETERS Position, Choice, Help
   PRIVATE i
   PUBLIC CenterVar

   MChoiceVar = "MCHOICE" + LTRIM(STR(Position))
   STORE SUBSTR(Choice+&MChoiceVar., 1, MChoiceLen) TO &MChoiceVar

   MHelpVar = "MHELP" + LTRIM(STR(Position))
   STORE SUBSTR(Help+&MHelpVar., 1, MHelpLen)       TO &MHelpVar

   i = 1                                            && build the choice bar
   MBar = ""
   MFirstLet = ""
   DO WHILE i <= MChoices
      MChoiceVar = "MCHOICE" + LTRIM(STR(i))
      DO CenterStr WITH &MChoiceVar., MChoiceLen, CenterVar
      MBar = MBar + CenterVar + "  "
      MFirstLet = MFirstLet + LTRIM(SUBSTR(&MChoiceVar., 1, 1))
      i = i + 1
   ENDDO

   RELEASE CenterVar
RETURN  && Procedure BarItem




* --- SaveBar:   saves the set of menu variables to a memory disk file.

PROCEDURE SaveBar
   PARAMETERS FileName

   SAVE ALL LIKE M* to &FileName

RETURN  && Procedure SaveBar




* --- LoadBar:   restores the set of menu variables from a
*                    memory disk file.

PROCEDURE LoadBar
   PARAMETERS FileName

   RESTORE FROM &FileName  ADDITIVE

RETURN  && Procedure LoadBar




* --- BarChoice:  gets a menu choice.  The parameter holds the choice to be
*                 highlighted on entry, and holds the number of the choice
*                 that the user selected on exit.   Returns 0 if the user
*                 pressed [Esc]

PROCEDURE BarChoice
   PARAMETERS Choice
   PRIVATE position, looping, key, OldChoice, MHelp

   SET COLOR TO &MNormal
   @ MRow, MCol  SAY MBar                          && draw the initial bar

   OldChoice = Choice
   looping = .T.

   DO WHILE looping
      position = (MChoiceLen+2)*(OldChoice-1) + 1  && unhighlight the last
      SET COLOR TO &MNormal
      @ MRow, MCol+position-1 SAY SUBSTR(MBar,position,MChoiceLen)
      OldChoice = Choice

      MHelp = "MHELP" + LTRIM(STR(Choice))         && display the help
      @ MRow+1, MCol SAY &MHelp

      position = (MChoiceLen+2)*(Choice-1) + 1     && highlight this one
      SET COLOR TO &MHighlight
      @ MRow, MCol+position-1 SAY SUBSTR(MBar,position,MChoiceLen)

      SET ESCAPE OFF
      key = 0                                      && wait for a key
      DO WHILE key = 0
         key = INKEY()
      ENDDO
      SET ESCAPE ON

      DO CASE                                      && handle the keys
         CASE key = 4                              && right arrow
            IF Choice = MChoices
                  Choice = 1
               ELSE
                  Choice = Choice + 1
            ENDIF
            LOOP

         CASE key = 19                              && left arrow    
            IF Choice = 1
                  Choice = MChoices
               ELSE
                  Choice = Choice - 1
            ENDIF
            LOOP

         CASE KEY = 13                             && enter
            looping = .F.
            LOOP

         CASE key = 1                              && home
            Choice = 1
            LOOP

         CASE key = 6                              && end
            Choice = MChoices
            LOOP

         CASE KEY = 27                             && escape
            looping = .F.
            Choice = 0
            LOOP

         OTHERWISE                                 && look for first letters
            i = Choice                               && from here to end
            DO WHILE (i <= MChoices) .AND. looping   && of the list
               IF SUBSTR(MFirstLet,i,1) = UPPER(CHR(key))
                  Choice = i
                  looping = .F.
               ENDIF
               i = i + 1
            ENDDO
            i = 1                                    && and, if no luck yet,
            DO WHILE (i <= Choice) .AND. looping     && from start to here
               IF SUBSTR(MFirstLet,i,1) = UPPER(CHR(key))
                  Choice = i
                  looping = .F.
               ENDIF
               i = i + 1
            ENDDO

      ENDCASE && key processing

   ENDDO  && looping

   SET COLOR TO &MNormal                             && restore the color

RETURN  && Procedure BarChoice

