*~  Program...........: MATXTAB.PRG
*~  Author............: Valdis Matison
*~  Version...........: 2.5
*~} Project...........: 
*~  Created...........: 11/01/93
*~  Copyright.........: (c) Matison Consulting Group Inc., 1993
*~                          187 Dunblaine Avenue
*~                          Toronto, Ontario
*~                          M5M 2S6
*~
*~                          416-256-4495
*~
*~) Description.......: Replacement for GENXTAB.prg that ships with FoxPro
*~] Dependencies......: 
*~  Calling Samples...: do MATXTAB with "XTAB", 1, .t., .f., 1, 4, 5, .t., 2, 3, 0, 0, .t., .t., .t., .t.
*~                      do MATXTAB with "XTAB", 1, .t., .f., 1, 2, 6, .t., 3, 4, 5, 0, .t., .t., .t., .t., la_fldlist, 2, 0, 1
*~  Returns...........: If you initialize a variable named LN_RETURN in the calling program
*~                      this program will return a value in that variable
*~                      This functionality is incomplete
*~
*~                      0 = Success!
*~                      - 1 = Unique column count greater than 256
*~                      - 2 = Escape pressed, procedure cancelled
*~                      - 3 = No dbf in current area
*~                      - 4 = Less than three fields in input dbf
*~                      - 5 = Too many fields in results table
*~                      - 6 = Row field must be character
*~                      - 7 = Column field must be character
*~                      > 0 returns Foxpro's error code generated by error()
*~
*~  Major change list.: 
*~  Future............: Create a front end, DOS/Windows/MAC
*~  Notes:............: The error handling is incomplete, the user should decide what errors to trap.
*~                      Naming convention: First letter "l" denotes local variable
*~                                         Second letter denotes type
*~
*~  Parameter List....: lc_outfile : Name of the output file
*~                      lu_struct  : 1 means cursor, 2 means table, 3 means array, 
*~                                  .t. means cursor, .f. means table
*~                                   if blank, same format as input
*~                      ll_closein : .t. means close input file, else keep open
*~                      ll_therm   : Included for compatibility with GENXTAB, not used by MATXTAB
*~                      ln_rowfld  : Number of field used for rows - field number
*~                      ln_cellfld : Column used for individual totals in results table  field number
*~                      ln_colhead : Field used for column headings in XTAB report field number
*~                      ll_xtotal  :.t. means create cross totals, else don't bother
*~
*~                      Differences from Genxtab begin here
*~
*~                      ln_extfld1 : First extra field to go into output
*~                      ln_extfld2 : Second extra field to go into output
*~                      ln_extfld3 : Third extra field to go into output
*~                      ln_extfld4 : Fourth extra field to go into output
*~                      ll_cnt     : Display count for each unique row
*~                      ll_avg     : Display average
*~                      ll_min     : Display minimum
*~                      ll_max     : Display maximum
*~                      la_uniqcol : name of array passed that has the uniqe column names already in list
*~                      ln_rowcol  : Number of dimensions in the array that's sent down
*~                      ln_colsort : 0 means smallest to largest
*~                                   1 means largest to smallest
*~                      ln_rowsort : 0 means ascending
*~                                   1 means descending
*~

parameters lc_outfile, lu_struct, ll_closein, ll_therm, ln_rowfld, ;
           ln_colhead, ln_cellfld, ll_xtotal, ln_extfld1, ln_extfld2, ;
           ln_extfld3, ln_extfld4, ll_cnt, ll_avg, ll_min, ll_max, ;
           la_uniqcol, ln_rowcol, ln_colsort, ln_rowsort

external array la_uniqcol

private lc_colsort, lc_dbfname, lc_colhead, lc_cellfld, ;
        ln_dimens, lc_error, lc_escasta, lc_escape, lc_group, ;
        ln_params, lc_program, lc_rowfld, lc_rowsort, lc_safesta, ;
        lc_talksta, lc_type, lc_where, ln_uniqcnt

lc_dbfname = alias()			&& Source file taken from alias name
lc_error   = ON( "ERROR" )
lc_escasta = SET( "ESCAPE" )
lc_escape  = ON( "ESCAPE" )
ln_params  = parameters()
lc_safesta = SET( "SAFETY" )
lc_talksta = SET( "TALK" )

on error do lo_exit with error()
set escape on
on escape do lo_exit with -2
set safety off
set talk off

if empty( alias() )		&& A file must be open in the selected area
 do lo_exit with -3
endif

if fcount() < 3			&& At least three fields required
 do lo_exit with -4
endif

if ln_params < 1	&& Nothing sent down - Determine filename for output
   lc_outfile = 'XTABX.DBF'
endif

if ln_params < 2	&& No format given for output

 if isdigit( left( justfname( dbf() ) ,1 ) )
  lu_struct = 1		&& Cursor
 else
  lu_struct = 2		&& Table
 endif

else

 if type("lu_struct") = "L"	&& Logical value
  if lu_struct				&& True means create a cursor
   lu_struct = 1
  else						&& False means table
   lu_struct = 2
  endif						&& 
 endif						&& Logical or numeric value

endif				&& No format given for output


if ln_params < 3	&& Close input defaults to yes
 ll_closein = .t.
endif

if ln_params < 5	&& Number of field for cross tab rows
 ln_rowfld = 1
endif

if type( field( ln_rowfld ) ) <> "C"
 on escape do lo_exit with -6
endif


if ln_params < 6	&& Number of field for columns
 ln_colhead = 2
endif

if type( field( ln_colhead ) ) <> "C"
 on escape do lo_exit with -7
endif

if ln_params < 7	&& Number of field for cross tab cells
 ln_cellfld = 3
endif

if ln_params < 8
 ll_xtotal = .f.
endif

if ln_params < 17
 private la_uniqcol
 dime la_uniqcol(1)
endif

if ln_params > 17
 ln_dimens  = ln_rowcol
else
 ln_dimens  = 1 
endif

if ln_params > 18 
 do case
  case ln_colsort = 1
  lc_colsort = "DESC" 

  otherwise 
  lc_colsort = "ASC" 
 endcase

else
  lc_colsort = "ASC"  
endif

if ln_params = 20
 do case
  case ln_rowsort = 1
  lc_rowsort = "DESC" 

  otherwise 
  lc_rowsort = "ASC" 
 endcase

else
  lc_rowsort = "ASC"  
endif

lc_colhead = field( ln_colhead )
lc_cellfld = lc_dbfname + "." + field( ln_cellfld )
lc_group   = lc_dbfname + "." + field( ln_rowfld )
lc_program = program( 1 )
ln_return  = 0
lc_rowfld  = lc_group
lc_where   = "ZZ" + "." + ;
             lc_colhead + "=" + ;
             lc_dbfname + "." + ;
             lc_colhead


do matshow

if ln_params < 17

 lc_type = type( (lc_colhead) )
 do case
  case lc_type = "C"

   select &lc_colhead ;
     from ( lc_dbfname ) ;
    order by 1 &lc_colsort ;
    group by 1 ;
     into array la_uniqcol

  case lc_type = "D"

   select "D"+dtoc( &lc_colhead, 1 ) ;
     from (lc_dbfname) ;
    order by 1 &lc_colsort ;
    group by 1 ;
     into array la_uniqcol

   lc_where = "ZZ" + "." + ;
              lc_colhead + "=" + ;
              "'D' +dtoc(" + ;
              lc_dbfname + "." + ;
              "&lc_colhead, 1 )"

 endcase

 ln_uniqcnt = alen( la_uniqcol )

else

 ln_uniqcnt = alen( la_uniqcol, ln_dimens )

endif

if ln_uniqcnt >256
 do lo_exit with -1
endif

dime la_colname[ ln_uniqcnt + 1, 4 ]
la_colname[1,1] = lc_colhead
la_colname[1,2] = "C"

if ln_params < 17 		&& no array sent down
 la_colname[ 1,3 ] = len( &lc_colhead )
else
 la_colname[ 1,3 ] = len( la_uniqcol[ 1,1 ] )	&& What about width ?
endif

la_colname[1,4] = 0

for ln_k = 2 to ln_uniqcnt + 1
 la_colname[ ln_k, 1 ] = la_uniqcol[ 1, ln_k-1 ]
 la_colname[ ln_k, 2 ] = "N"
 la_colname[ ln_k, 3 ] = 1
 la_colname[ ln_k, 4 ] = 0
endfor

create cursor ZZ from array la_colname

*--Now populate the table with 1's
for ln_k = 2 to ln_uniqcnt + 1
 INSERT INTO ZZ ( (lc_colhead), (field(ln_k)) ) ;
        VALUES (la_colname[ ln_k, 1 ], 1 )
endfor

*--
*-- Now create the cross tab
*--

lc_sqlxtab  = "SELECT " + lc_rowfld


if ln_params > 8
 if ln_extfld1 > 0
  lc_sqlxtab = lc_sqlxtab + ", " + ;
              lc_dbfname + "." + ;
              field( ln_extfld1, lc_dbfname ) 
 endif
endif

if ln_params > 9
 if ln_extfld2 > 0
  lc_sqlxtab = lc_sqlxtab + ", " + ;
              lc_dbfname + "." + ;
              field( ln_extfld2, lc_dbfname ) 
 endif
endif

if ln_params > 10
 if ln_extfld3 > 0
  lc_sqlxtab = lc_sqlxtab + ", " + ;
              lc_dbfname + "." + ;
              field( ln_extfld3, lc_dbfname ) 
 endif
endif

if ln_params > 11
 if ln_extfld4 > 0
  lc_sqlxtab = lc_sqlxtab + ", " + ;
              lc_dbfname + "." + ;
              field( ln_extfld4, lc_dbfname ) 
 endif
endif

for ln_k = 1 to ln_uniqcnt
 lc_sqlxtab = lc_sqlxtab + ", " + ;
              "SUM( " + lc_cellfld + ;
              "*ZZ." + ;
              la_uniqcol[ 1, ln_k ] + ") as '" + ;
              la_uniqcol[ ln_dimens, ln_k ] + "' "
endfor

*--
*-- Add totals column if required.
*-- Add count, average, min, max functions as well
*--

if ll_cnt
 lc_sqlxtab = lc_sqlxtab + ;
              ", COUNT( " + lc_rowfld + " ) as 'XCNT' "
endif

if ll_avg
 lc_sqlxtab = lc_sqlxtab + ;
             ", AVG( " + lc_cellfld + " ) as 'XAVG' "
endif

if ll_min
 lc_sqlxtab = lc_sqlxtab + ;
             ", MIN( " + lc_cellfld + " ) as 'XMIN' "
endif

if ll_max
 lc_sqlxtab = lc_sqlxtab + ;
             ", MAX( " + lc_cellfld + " ) as 'XMAX' "
endif

if ll_xtotal
 lc_sqlxtab = lc_sqlxtab + ;
             ", SUM( " + lc_cellfld + " ) as 'XTOT' "
endif

lc_sqlxtab = lc_sqlxtab + ;
     "FROM (lc_dbfname), ZZ " + ;
     "WHERE &lc_where " + ;
     "GROUP BY &lc_group " + ;
     "Order by &lc_group &lc_rowsort " + ;
     "INTO "

do case
 case lu_struct = 2			&& output to table
 lc_sqlxtab = lc_sqlxtab + ;
              "TABLE " + ;
              lc_outfile

 case lu_struct = 3			&& output to array
 lc_sqlxtab = lc_sqlxtab + ;
              "ARRAY _XTABX "

 public _xtabx
 dime _xtabx[ 1,1 ]

otherwise					&& output to cursor DEFAULT
 lc_sqlxtab = lc_sqlxtab + ;
              "CURSOR " + ;
              lc_outfile
endcase

*-- Run the query

&lc_sqlxtab

do lo_exit with ln_return
*-- eop MATXTAB


*~!*********************************************
*~!
*~!       Procedure: lo_exit        
*~!
*~!*********************************************
PROCEDURE lo_exit        
*~  Author............: Valdis Matison
*~  Modified by.......: 
*~} Project...........: 
*~  Created...........: 11/01/93
*~  Copyright.........: (c) Matison Consulting Group Inc., 1993
*~) Description.......: Shutdown procedure for MATXTAB
*~)                   
*~] Dependencies......: 
*~  Calling Samples...: 
*~  Parameter List....: ln_ret : Error code
*~  Returns...........: 
*~  Future ideas......: 
*~  Major change list.: 

parameters ln_ret
ln_return = ln_ret

if lc_talksta = "ON"
 set talk on
endif

if lc_safesta = "ON"
 set safety on
endif

if lc_escasta = "OFF"
 set escape off
endif

release windows lw_mat
clear typeahead

*-- Close input files only if successful
if ln_ret = 0
 select ZZ
 use

 if ll_closein			&& close the input file
  select ( lc_dbfname )
  use
 endif

 select ( lc_outfile )
endif

ON ERROR &lc_error
ON ESCAPE &lc_escape

return to lc_program

*--
*-- eop lo_exit


*!*********************************************************************
*!
*!      Function: JUSTFNAME()
*!
*!      Called by: GENXTAB.PRG                   
*!               : DEFAULTEXT()   (function  in GENXTAB.PRG)
*!               : FORCEEXT       (procedure in GENXTAB.PRG)
*!      This routine copied directly from Genxtab
*!*********************************************************************
FUNCTION justfname
* Return just the filename (i.e., no path) from "filname"

PARAMETERS filname

PRIVATE ALL
IF RAT('\',m.filname) > 0
   m.filname = SUBSTR(m.filname,RAT('\',m.filname)+1,255)
ENDIF
IF AT(':',m.filname) > 0
   m.filname = SUBSTR(m.filname,AT(':',m.filname)+1,255)
ENDIF

RETURN ALLTRIM(UPPER(m.filname))
*--
*-- eop justfname


*~!*********************************************
*~!
*~!       Procedure: matshow        
*~!
*~!*********************************************
PROCEDURE matshow        
*~  Author............: Valdis Matison
*~  Modified by.......: 
*~} Project...........: 
*~  Created...........: 11/01/93
*~  Copyright.........: (c) Matison Consulting Group Inc., 1993
*~) Description.......: Displays logo and wait message. For DOS only
*~)                     Not required to run module.
*~] Dependencies......: 
*~  Calling Samples...: 
*~  Parameter List....: 
*~  Returns...........: 
*~  Future ideas......: Create windows version.
*~  Major change list.: 
 
private lc_color
lc_color   = scheme(1,1) + "*"

DEFINE WINDOW lw_mat ;
		FROM INT((SROW()-17)/2),INT((SCOL()-55)/2) ;
		TO INT((SROW()-17)/2)+16,INT((SCOL()-55)/2)+54 ;
		FLOAT ;
		NOCLOSE ;
		SHADOW ;
		DOUBLE ;
		COLOR SCHEME 1

activate WINDOW lw_mat noshow

@ 8,15,11,20 BOX REPLICATE("",8)+""
@ 8,15 FILL TO 11,20 ;
	COLOR SCHEME 13
@ 7,3,7,20 BOX REPLICATE("",8)+""
@ 7,3 FILL TO 7,20 ;
	COLOR SCHEME 13
@ 9,8,11,11 BOX REPLICATE("",8)+""
@ 9,8 FILL TO 11,11 ;
	COLOR SCHEME 13
@ 8,8,8,11 BOX REPLICATE("",8)+""
@ 8,8 FILL TO 8,11 ;
	COLOR SCHEME 13
@ 12,8,12,11 BOX REPLICATE("",8)+""
@ 12,8 FILL TO 12,11 ;
	COLOR SCHEME 13
@ 12,15,12,20 BOX REPLICATE("",8)+""
@ 12,15 FILL TO 12,20 ;
	COLOR SCHEME 13
@ 9,3,11,6 BOX REPLICATE("",8)+""
@ 9,3 FILL TO 11, 6 ;
	COLOR SCHEME 13
@ 8,3,8,6 BOX REPLICATE("",8)+""
@ 8,3 FILL TO 8, 6 ;
	COLOR SCHEME 13
@ 12,3,12,6 BOX REPLICATE("",8)+""
@ 12,3 FILL TO 12, 6 ;
	COLOR SCHEME 13
@ 7,26 SAY "Matison Consulting Group" ;
	COLOR SCHEME 13
@ 8,26 SAY "187 Dunblaine Avenue" ;
	COLOR SCHEME 13
@ 9,26 SAY "Toronto, Ontario" ;
	COLOR SCHEME 13
@ 10,26 SAY "M5M 2S6" ;
	COLOR SCHEME 13
@ 12,26 SAY "(416)-256-4495" ;
	COLOR SCHEME 13
@ 13,3 SAY "(c) 1992" ;
	COLOR SCHEME 13
@ 14,3 SAY "Version 1.0" ;
	COLOR SCHEME 13

@ 1,3 SAY "This cross tab report is being generated by"
@ 2,3 SAY "the Cross Tab Generator written by:"
@ 4,3 SAY "Valdis Matison"
@ 11,26 SAY "Canada"
@ 5,3 SAY "President"

@ 13,21 say "Working..." color ( lc_color )

ACTIVATE WINDOW lw_mat
*--
*-- eop matshow