
/******************************
*
* FUNCTION MAKEMRG(lAllfields?, aFieldnames, nNumberoffields)
*
* Function to create a WordPerfect Secondary Merge File from 
*  selected fields in a DBF. The database and indices must be open
*  and any filters applied before calling the function.
*
* lAllfields? is a logical field telling whether or not to use all
*             fields in the DBF.
*
* aFieldnames is an array of the fieldnames to use.  Only use if
*             lAllfields = .F.
*
* nNumberoffields is the number of fields in aFieldnames.  Only use if 
*                 lAllfields = .F.
*
* Tested with WordPerfect 5.0.  If this function is not compatable with 5.1,
* it could easily be modified by changing FIELDEND and RECORDEND to the 
* appropriate ASCII codes. By changing the FIELDEND and RECORDEND you can
* write several different kinds of files.  I hope you find this useful!
*
* Author: David B. Coss   70474,3272   
*
*
*/

FUNCTION MAKEMRG

PARAMETERS FIELDALL, FARRAY, NOFLDS

CLEAR 

@ 16, 10 SAY "CREATING WORDPERFECT MERGE FILE...."

FIELDEND := CHR(18)+CHR(13)+CHR(10)

RECORDEND := CHR(5)+CHR(13)+CHR(10)


IF FIELDALL

  DECLARE FIELDS[FCOUNT()]

  FCNT := FCOUNT()

  FOR X=1 TO FCNT
   FIELDS[X] = FIELD(X)
  NEXT

ELSE

  DECLARE FIELDS[NOFLDS]

  FCNT := NOFLDS

  ACOPY(FARRAY,FIELDS)

ENDIF


HANDLE := FCREATE("DBMERGE.MRG")

GO TOP


DO WHILE .NOT. EOF()

  FOR J = 1 TO FCNT

     MFNAME := FIELDS[J]  
     MDATA := &(FIELDS[J])

     IF TYPE(MFNAME) = "N"
       FSTRING := ALLTRIM(STR(MDATA))
     ELSEIF TYPE(MFNAME) = "C"
       FSTRING := ALLTRIM(MDATA)
     ELSEIF TYPE(MFNAME) = "D"
       FSTRING := DTOS(MDATA)
     ENDIF

     IF J < FCNT
       FWRITE(HANDLE,FSTRING+FIELDEND)
     ELSE
       FWRITE(HANDLE,FSTRING+RECORDEND)
     ENDIF

  NEXT

  SKIP

ENDDO

FCLOSE(HANDLE)

