***************************************************************************
*
* MAKEDBF.PRG
*
* Author: Craig S. Steinberg, O.D.
* CIS ID: 70166,337
* Note..: Public Domain, use as you wish, no express or implied warranty,
* user(s) assume any and all risks inherent in using this routine.
*
* Purpose: This function, MAKEDBF() was created by me to simplify the
* distribution of my applications.  By including only one data file,
* DBFSTRU.DBF, and calling MAKEDBF() at the beginning of the application,
* I can be assured that all the DBF's used are present and correct.
*
* This program reads a DBF file called DBFSTRU.DBF, then uses the info
* in it to create data your files.  The structure of dbfstru.dbf is:
*
*  1  DBFNAME    C 8
*  2  FNAME      C 10
*  3  TYPE       C 1
*  4  LENGTH     C 3
*  5  DECIMALS   C 2
*
* Include one record for each field in each data file you wish to make.
* Note that you will repeat the contents of the DBFNAME field for each
* field to be in a single data file.  If you are going to create three
* data files there will be three UNIQUE values in DBFNAME.  Within each
* group of common DBFNAME's, each FNAME must be unique.
*
* PARAMETER: name of dbf to create.  If none, create all possible.
* RETURN...: .T. if successful, .F. if failed for any reason.
*
* Optional Return: to find out the exact error, declare a public memvar
* called MAKEERR.  Makedbf() will store a numeric value indicating the
* error which occured, as follows:
*
*    0 = no error
*    1 = no dbfstru.dbf file found
*    2 = unable to open dbfstru in exclusive mode
*
* OVERWRITE FLAG
* If you want this function to overwrite an existing dbf with the new
* structure, create the public memvar OVERWRITE in your calling program
* and define it as .T.  (i.e. PUBLIC OVERWRITE, OVERWRITE = .T.).  Otherwise
* the MAKEDBF() function will not overwrite any existing data file with the
* same name as one in dbfstru.dbf.
*
* UPDATE: This fixes an error in the OVERWRITE function.  I left the ! out
* causing it to work the opposite!  This works correctly.  Damn Bugs!
*
***************************************************************************

***************************************************************************
* MAKEDB.EXE
*
* This is a small routine to call MAKEDBF to create all data files in
* the DBFSTRU.DBF file.  To use the function directly in your programs,
* remove this item and include the MAKEDB.PRG/OBJ in your file list
* (or incorporate it into one of your PRG's).
*
PARAMETERS thisone
if PCOUNT() = 1
  makedbf(thisone)
else
  MAKEDBF()
endif
RETURN
***************************************************************************


***************************************************************************
*
* MAKEDBF()
*
* This is the actual working function.
*
***************************************************************************
FUNCTION MAKEDBF
  PRIVATE thedbf,X,Y,N,count,sel
  PARAMETERS thedbf

  * --- save the currently selected work area for later restoration
  sel = SELECT()

  * --- initialize the error number
  makeerr = 0

  * --- make sure there is a data file available (can't make this one!)
  IF ! file("DBFSTRU.DBF")
    makeerr = 1
    retur .F.
  ENDIF

  * --- open the structure data file
  SELECT 0
  use DBFSTRU exclusive
  IF neterr()
    makeerr = 2
    retur .F.
  ENDIF

  * --- make the index files
  SET UNIQUE ON
  * this index is used for finding how many dbf's are to be made
  index on upper(DBFNAME) to DBFSTRU1
  SET UNIQUE OFF
  * this index is used for finding the fields within each dbf to be made
  index on upper(DBFNAME) to DBFSTRU2
  set index to

  * --- now, if no parameter passed, get the names of each data file to make
  IF PCOUNT() = 0

    * --- find out how many dbf's are there to be made
    set index to DBFSTRU1                        && unique for each DBFNAME defined
    N = 0                                        && start with 0
    DO WHILE ! eof()                             && search for all unique dbfnames
      n = n + 1                                  && increment the number of dbf's to make
      skip
    ENDDO
    GO TOP                                       && return to the top
    PRIVATE dbfs[n]                              && make an array of the right size
    X = 1                                        && start with 1 unique file to make
    DO WHILE ! eof()                             && get the names of the dbf's to make
      dbfs[x] = upper(dbfname)                   && make each upper case and save in array
      x = x + 1
      skip
    ENDDO
    set index to                                 && close the index

    * --- if there is one passed, put only this name into the list of files to make
  ELSE
    N = 1                                        && only one dbf to make
    PRIVATE   dbfs[1]                            && put the name in the array
    dbfs[1] = upper(thedbf)
  ENDIF

  *
  * At this point, the array DBFS[] contains a list of 1 or more data files
  * that will be created.  Except, we won't recreate existing data files
  * unless the OVERWRITE memvar exists and is .T.
  *

  * --- figure out if overwrite is on or not
  IF TYPE("overwrite") != "L"
    overwrite = .F.
  ENDIF

  * --- open the second index which groups all fields within a dbf together
  SET INDEX TO dbfstru2
  GO TOP

  * --- now process DBFSTRU n times
  FOR Y = 1 to n
    dbf2make = upper(dbfs[y])                    && what dbf is being made

    * --- check overwrite status and skip if it exists already
    IF ! overwrite
      IF file(trim(dbf2make)+".DBF")
        LOOP
      ENDIF
    ENDIF

    seek dbf2make                                && find the first field definition
    if ! eof()                                   && if there is at least one field defined...

      * --- find out how many elements (fields) there are in this dbf
      count = 0
      DO WHILE upper(dbfname) = dbf2make .and. ! eof()
        count = count + 1
        skip
      ENDDO

      * --- now build strings for building the dbf in MAKEITDBF
      PRIVATE    data[count]                     && holds the field structure
      DB         = dbf2make                      && the name of the dbf
      FIELDCOUNT = count                         && the number of fields in dbf

      * --- now get the stucture of each field in the array
      count = 1
      seek dbf2make                              && start at the top
      DO WHILE upper(dbfname) = dbf2make .and. ! eof()
        data[count] = fname + type + length + decimals
        count = count + 1
        skip
      ENDDO

      * ---  now the array holds the structure of each field, so make it
      DO MAKEITDBF
    endif
  NEXT

  * --- close the DBFSTRU.DBF file
  USE

  * --- get rid of the temp files...
  erase dbfstru1.ntx
  erase dbfstru2.ntx

  * --- restore the selected area
  SELECT (sel)
RETURN .T.
* end of makedbf() function


***************************************************************************
*
* This procedure actually creates the DBF(s) according to data created in
* the makedbf() function.  Specifically, it uses the following items:
*
*    DB          = name of data file to create
*    FIELDCOUNT  = number of fields in the data file to be created
*    DATA[]      = array, each element defines one field in the data file
*       fieldname  first 10 characters
*       fieldtype  next 1 character
*       length     next 3 characters
*       decimals   next 2 characters
*
***************************************************************************
PROCEDURE MAKEITDBF
  PRIVATE selected
  selected = select()
  SELECT 0
  create EXPTEMP
  c = 1
  do while c <= FIELDCOUNT
    append blank
    replace field_name  with substr(data[c],1,10)
    replace field_type  with substr(data[c],11,1)
    replace field_len   with val(substr(data[c],12,3))
    replace field_dec   with val(substr(data[c],15,2))
    c=c+1
  enddo
  create &DB from EXPTEMP
  use
  delete file EXPTEMP.DBF
  select (selected)
RETURN
* end of procedure makeitdbf












