;	peek.asm - peek into memory

;       Expects a character variable parameter of the
;       form "XXXX" or "XXXX:XXXX" giving the memory
;       location to peek into, in ASCII hex. If the
;       first form is used, the peek is into the
;       current data segment.

;       Optionally expects a parameter n giving
;       bytes to peek, in ASCII decimal. If omitted,
;       reads 1 byte.

;       Expects arguments in dBASE IV format and
;       locations, i.e.:
;               ES:DI points to table of far pointers
;                      to arguments.
;		CX holds number of arguments.	

;       This program must be assembled and linked, then
;       converted to a binary image file by EXE2BIN.
;       It cannot be converted to a .COM file.

        .model tiny
        code segment
        assume cs:code

peek    proc far
        jcxz done               ; must be a parm
        mov bp,ds               ; save our segment
        lds si,es:[di]          ; point to address
        call htob               ; get address
        cmp byte ptr [si]-1,':' ; is there more?
        jnz getnum              ; jump if not

        mov bp,bx               ; else this segment
        call htob               ; and get the offset
getnum: push bx                 ; save offset address
        cmp cx,1                ; only one parm
        jz read                 ; then 1 byte
        lds si,es:[di]+4        ; point to second parm
        call atob               ; get number of bytes
        mov cx,bx               ; into cx
read:   mov ds,bp               ; source segment
        pop si                  ; offset address
        les di,es:[di]          ; first parm
        rep movsb               ; copy bytes into it
done:   ret
peek    endp

;       Htob - ASCII hex to binary conversion routine.
;       Converts a number expressed in ASCII hex at
;       DS:SI to binary value in BX.
;       Does not check for overflow but returns value
;       mod 65,536.  Ignores spaces, treats any other
;       non-digit as terminator.
;       Cannot handle mnegative numbers.
;       Destroys AX,BX.  On return, SI points past
;       terminator.

Htob    proc near
        push cx
        mov cl,4                ; shift count
        xor bx,bx               ; initialize the number

h_next: lodsb                   ; get a character
        cmp al,' '              ; space?
        jz h_next               ; ignore spaces
        sub al,'0'              ; else make it hex
        jb h_done            ; done if less than 0
        cmp al,9                ; a digit?
        jbe h_num               ; jump for that
        and al,1Fh              ; capitalize letters
        sub al,7                ; make 'A'=0ah, etc.
        cmp al,0ah              ; was it A-F?
        jb h_done               ; done if not
        cmp al,0fh
        ja h_done
		
h_num:  sal bx,cl               ; shift number left 4
        add bl,al               ; add the new
        jmp short h_next
	
h_done: pop cx
        ret
Htob    endp

;	Atob - ASCII to binary conversion routine.
;       Converts ASCII digits at DS:SI to binary in BX.
;       Does not check for overflow but returns value
;       mod 65,536.
;       Ignores spaces, treats any other non-digit as
;       terminator.
;	Cannot handle negative numbers.
;       Destroys AX,BX.  On return, SI points past
;       terminator.

Atob    proc near
        xor bx,bx               ; initialize the number

a_dig:  lodsb                   ; get a character
        cmp al,' '              ; space?
        jz a_dig                ; ignore spaces
        sub al,'0'              ; else convert
        jb a_done               ; done if less than 0
        cmp al,9
        ja a_done               ; or more than 9

        cbw                     ; clear ah
        sal bx,1                ; old number times 2
        add ax,bx               ; new digit plus 2*old
        sal bx,1                ; old number times 4
        sal bx,1                ; old number times 8
        add bx,ax               ; 10*old plus new
        jmp short a_dig
	
a_done: ret
Atob    endp

code    ends
        end
