**   Two udfs for hexadecimal conversions

*    Convert an integer to hexadecimal.

FUNCTION dec2hex
PARAMETERS Decimal
PRIVATE D, H
D = int( Decimal )
H = ""
DO WHILE D > 0
  H = substr( "0123456789ABCDEF", mod( D, 16 ) + 1, 1 ) + H
  D = int( D / 16 )
ENDDO
RETURN iif( "" # H, H,"0" )

*    Convert hexadecimal string to number    

FUNCTION hex2dec
PARAMETERS Hex
PRIVATE D, H
H = Hex
D = 0
DO WHILE len( H ) > 0
  D = D * 16 + at( upper( left( H, 1 ) ), "123456789ABCDEF" )
  H = iif( len( H ) > 1, substr( H, 2 ), "" )
ENDDO
RETURN D

**   udfs illustrating calls to lowlevel.bin.
**   all of these are written to return a negative number in case of
**   a DOS error on the interrupt call.  The abs() of that number is
**   the value returned in AX by DOS, usually the error number.

*    returns dos version number.  Takes no argument.

FUNCTION dosver
PRIVATE Arg
Arg="21,AX=3000"
CALL Lowlevel WITH Arg
IF left( Arg, 2 )="CY"
  RETURN -hex2dec( right( Arg, 2 ) )
ELSE
  RETURN hex2dec( right( Arg, 2 ) ) ;
    + hex2dec( substr( Arg, 7, 2 ) ) / 100
ENDIF

*   create a file.  Takes file specification, returns handle.

FUNCTION fcreate
PARAMETERS Filespec
PRIVATE Arg1
Arg1="21,AX=3C00,CX=0000,DS:DX=2"
CALL Lowlevel WITH Arg1,Filespec
RETURN hex2dec( substr( Arg1, 7, 4 ) ) ;
  * iif( left( Arg1, 2 ) = "CY", -1, 1 )

*   open a file.  Takes file specification and mode, returns handle.
*   "Mode" must be 0 for read-only, 1 for write-only, or 2 for both.

*   This function will have to be rewritten to accept a two-character
*   string for Mode, and to store both characters after "3D" in Arg1,
*   if it is desired to set the inheritance flag and sharing mode for
*   DOS 3.0 and higher.

FUNCTION fopen
PARAMETERS Filespec, Mode
PRIVATE Arg1
Arg1 = "21,AX=3D0" + str( Mode, 1 ) + ",DS:DX=2"
CALL Lowlevel WITH Arg1, Filespec
RETURN hextodec( substr( Arg1, 7, 4 ) ) ;
  * iif( left( Arg1, 2 ) = "CY", -1, 1 )

*   Move file pointer.  Takes handle, method, bytes to move.
*   Returns absolute bytes of new pointer from start of file.
*   "Method" must be 0 if move is from start of file, 1 if it
*   is from the current pointer position, 2 if it is from end
*   of file.  To determine file length, call with Method 2 and
*   bytes 0; be sure to reset the pointer if necessary.

FUNCTION fileptr
PARAMETERS Handle, Method, Bytes
PRIVATE Arg1, C, D, V
Arg1 = "21,AX=3D0" + str( Method, 1 ) + "," ;
  + "BX=" + dec2hex( Handle ) + ","
V = abs( Bytes )
IF Method = 0
  C = dec2hex( int( V / 2^16 ) )
  D = dec2hex( mod( V, 2^16 ) )
ELSE
  IF Bytes < 0
    V = 2^32 - V
  ENDIF
    C = dec2hex( int( V / 2^8 ) )
    D = dec2hex( mod( V / 2^8 ) )
ENDIF
Arg1 = Arg1 + "CX=" + C + ",DX=" + D
CALL Lowlevel WITH Arg1, Filespec
IF left( Arg1, 2 ) = "CY"
  RETURN -hex2dec( substr( Arg1, 7, 4 ) )
ELSE
  RETURN hex2dec( substr( Arg1, 31, 4 ) + ;
    substr( Arg1, 7, 4 ) )   && value in DX:AX
ENDIF

*   Close a file.  Takes handle.  Return not significant unless
*   negative for error.

FUNCTION fclose
PARAMETERS Handle
PRIVATE Arg1
Arg1 = "21,AX=3E00,BX=" + dectohex( Handle )
CALL Lowlevel WITH Arg1
RETURN hex2dec( substr( Arg1, 7, 4 ) ) ;
  * iif( left( Arg1, 2 )= "CY", -1, 1 )
