* Program LASTNAME.PRG - Generic last name extraction program
* Assumes dbf file is NAMES and field name is FNAME.
* Tony Lima, January 13, 1989
* Placed into the public domain by the author.

* Housekeeping
DO Pstart
* Set up windows
DO Wndowdef

* Open dbf
USE NAMES
* Note:  40 is length of field.  In generic application,
*  use COPY STRUCTURE EXTENDED to get field length from
*  field name entered by user.
ln_fldlen=40
SCAN
  ll_lstfrst=.F.
  ln_chrpos=40
  DO CASE
    CASE "JR"$UPPER(FNAME) .AND. ","$FNAME
      * If there's a , and a jr then it's a Jr.
      ln_chrpos=AT(",",FNAME)-1
    CASE ","$UPPER(FNAME)
      * If there's a , and no jr, it's probably last name first
      ll_lstfrst=.T.
      ln_chrpos=AT(",",FNAME)-1
    CASE "II"$FNAME
      * If II, then it's II or III (we don't worry about IV, etc.)
      * Note that if it's <last name>, II, previos case will handle it
      ln_chrpos=AT("II",FNAME)-2
  ENDCASE
  DO WHILE SUBSTR(FNAME,ln_chrpos,1)=" "
    ln_chrpos = ln_chrpos - 1
  ENDDO && WHILE SUBSTR(FNAME,ln_chrpos,1)=" "
  * ln_chrpos will contain position of first non-blank character
  *  from the right end of the field
  lc_lname=""
  DO WHILE SUBSTR(FNAME,ln_chrpos,1)<>" " .AND. ln_chrpos>0
    lc_lname = SUBSTR(FNAME,ln_chrpos,1) + lc_lname
    ln_chrpos = ln_chrpos - 1
  ENDDO && WHILE SUBSTR(FNAME,ln_chrpos,1)<>" "
  * Just in case a leading or trailing blank crept in
  lc_lname = ALLTRIM(lc_lname)
  REPLACE FLNAME WITH lc_lname
ENDSCAN
* Show the result
LIST
WAIT "Press the space bar to continue..."
* Reset the dbf
REPLACE ALL FLNAME WITH SPACE(40)
RETURN
* End of Main: LASTNAME.PRG

* Function
FUNCTION ALLTRIM
PARAMETERS lc_name
lc_name = RTRIM(LTRIM(lc_name))
RETURN(lc_name)

* Procedures in alpha order

* Pstart - Initial housekeeping
PROCEDURE Pstart
SET COLOR TO
@ 0 , 0 CLEAR
SET CONSOLE ON
SET BELL OFF
SET CARRY OFF
SET CLOCK TO 01,00
SET CLOCK ON
SET CENTURY OFF
SET CONFIRM OFF
SET DELIMITERS OFF
SET DELIMITERS TO ""
SET ESCAPE ON
SET INSTRUCT OFF
SET SAFETY ON
* I leave STATUS and TALK on so user can see what's going on
SET STATUS ON
SET TALK ON
RETURN

* Pstop - Exit housekeeping
PROCEDURE Pstop
SET COLOR TO
@ 0 , 0 CLEAR
SET CONSOLE ON
SET BELL ON
SET CARRY OFF
SET CLOCK TO 01,00
SET CLOCK ON
SET CENTURY OFF
SET CONFIRM OFF
SET DELIMITERS OFF
SET DELIMITERS TO ""
SET ESCAPE ON
SET INSTRUCT OFF
SET SAFETY ON
SET STATUS ON
SET TALK ON
RETURN

* Wndowdef - Set up windows
PROCEDURE Wndowdef
* NONE parameter refers to window border.  Other legal arguments
*  are DOUBLE and PANEL.  The default is a single line window.
*  full and full2 are the names of the windows.
*-- Windows to cover work surface during edit, append, etc.
DEFINE WINDOW full  FROM 0,0 TO 19,79 NONE
DEFINE WINDOW full2  FROM 0,0 TO 19,79 NONE

*-- Window to cover work surface during edit, append, etc.
DEFINE WINDOW dot FROM 1,0 TO 19,79 

*-- Window for area below menu heading & for running reports/labels in
DEFINE WINDOW desktop FROM 4,0 TO 19,79 

*-- Window for area for browsing 
DEFINE WINDOW Browse FROM 10,05 TO 19,79

*-- Window for error messages
DEFINE WINDOW Errwin FROM 18,00 TO 23,79 DOUBLE
RETURN

* EOF: LASTNAME.PRG

