*-------------------------------------------------------------------------------
*-- Program.....: LITEBAR.PRG 
*-- Programmer..: Ken Mayer
*-- Date........: 7/19/91 
*-- Notes.......: The dBASE Menus are fine to a point, but there are times when
*--               you may need a LOT of menu pads. This program is designed to
*--               allow up to 60 menu items, although you can, if you desire,
*--               setup some options as headers (this will not be chooseable
*--               by the user), and you can set up conditions where an option
*--               may be skipped. This was originally created to handle things
*--               for my fantasy gaming programs, and the idea came from FELIXR
*--               on the AT-BBS. Originally if you chose an item you weren't
*--               allowed to choose it again (this was again based on my gaming
*--               programs), but this was taken out for this version of the
*--               program. The procedures you should need to modify are:
*--                 REFRESH
*--                 LOADARRAY
*--                 DOCHOICE
*--                 VALID
*--               Anything else you may need to modify is noted.
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 07/17/91 -- Original version, not very flexible, based on
*--                           suggestion from FELXIR (AT-BBS).
*--               07/18/91 -- Version 2 (LITE2.PRG) -- started playing with
*--                           defining the arrays for it.
*--               07/18/91 -- Version 3 (LITE3.PRG) -- got closer, but serious
*--                           problems in MOVECOL and MOVEROW routines. This
*--                           Was uploaded to several programmers on ATBBS.
*--               07/19/91 -- Version 4 (LITE4.PRG) -- after serious thought,
*--                           and some better coding, it works. Added <Home>
*--                           and <End> keys, and remembered to release all
*--                           the public memvars.
*--               07/19/91 -- Version 5 (LITEBAR.PRG) -- modified to be a bit
*--                           more generic than my original program (which was
*--                           designed to be VERY specific to my fantasy gaming
*--                           character generation programs ...) 
*-- Calls.......: Center               (Procedure in PROC.PRG)
*--               ScrnHead             (Procedure in PROC.PRG)
*--               Load_Array           (Procedure in LITEBAR.PRG)
*--               ScrnPnt              (Procedure in LITEBAR.PRG)
*--               MoveCol              (Procedure in LITEBAR.PRG)
*--               MoveRow              (Procedure in LITEBAR.PRG)
*--               HomeEnd              (Procedure in LITEBAR.PRG)
*--               DoChoice             (Procedure in LITEBAR.PRG)
*-- Called by...: Any (after programmer modification)
*-- Usage.......: DO LITEBAR
*-- Example.....: See above
*-- Returns.....: None
*-- Parameters..: None (All internal)
*-------------------------------------------------------------------------------

*-- Setup
cTalk   = set("TALK")
set talk off 
cStatus = set("STATUS")
set stat off    && just making sure
cEscape = set("ESCAPE")
set escape off  && for use with INKEY()
cCursor = set("CURSOR")
set cursor off

set procedure to proc   && contains a few routines like YESNO ...
clear                   && clear screen completely for this ...
?scrnhead("rg+/gb","Test Light Bar")

public n_LiteRow,n_LiteCol,n_Choice,n_LastCol,n_LastRow  && global memvars
  *-- n_LiteRow = row position
  *-- n_LiteCol = column -- used together to hold real positions
  *-- n_Choice  = user entry (up, down, right, left, <Enter>, <Esc>
  *-- n_LastCol = last column -- entered in REFRESH routine
  *-- n_LastRow = last row    -- ditto

nMax = 60                  && max entries
n_Choice = 0               && init user choice

public a_LiteBar,a_Pos1,a_Pos2,a_Skip,a_Heading,a_Skill && arrays
declare a_Skill[nMax],a_Pos1[15],a_Pos2[4],a_LiteBar[15,4]
declare a_Skip[15,4],a_Heading[15,4]
  *-- a_Skill[x]      = value we're obtaining from user ... for demo purposes
  *-- a_Pos1[x]       = position of choices on screen ... rows
  *-- a_Pos2[y]       = same ... columns
  *-- a_LiteBar[x,y]  = choices displayed on screen ...
  *-- a_Skip[x,y]     = flag to determine if we should a_Skip an option ...
  *-- a_Heading[x,y]  = if it's a a_Heading, we need to display in specific clrs

*--------------------------------------------------------------------------
* START processing here
*--------------------------------------------------------------------------

do Load_Array   && procedure below to load values into arrays

*-- PROGRAMMER - This must be set for the first LiteBar to be displayed in 
*-- hi-lite colors for scrnpnt routine ...
n_LiteRow = 2     && starting coordinates
n_LiteCol = 1     && ditto
do ScrnPnt        && paint the screen the first time .. the rest is handled
                  && when the cursor is moved ...

do while n_Choice # 27    && loop until user presses <Esc>
	
	n_Choice = 0         && default it to 0, just to be safe ....
	n_Choice = inkey(0)
	*-- inkey() returns: 4 = right arrow
	*--                 19 = left arrow
	*--                  5 = up arrow
	*--                 24 = down arrow
	*--                 13 = <Enter>/Carriage Return
	*--                 27 = <Esc>
	*--                  2 = <End>
	*--                 26 = <Home>
	
	do case
		case n_Choice = 4 .or. n_Choice = 19
			do MoveCol
		case n_Choice = 5 .or. n_Choice = 24
			do MoveRow
		case n_Choice = 2 .or. n_Choice = 26
			do HomeEnd
		case n_Choice = 13
			do DoChoice
		case n_Choice = 27    && user pressed ESC
			exit
	endcase
enddo  && loop and main procedure ...

*--------------------------------------------------------------------------
*-- CLEANUP
*--------------------------------------------------------------------------
release n_LiteRow,n_LiteCol,n_Choice,n_LastCol,n_LastRow
release a_Pos1,a_Pos2,a_LiteBar,a_Skip,a_Heading
release a_Skill              && for your program you may not need this array
set escape &cEscape          && reset (if needed)
set talk &cTalk
set stat &cStatus
set cursor &cCursor

RETURN                       && to calling program
*-- End of Program: LITEBAR.PRG

*--------------------------------------------------------------------------
* procedures here
*--------------------------------------------------------------------------

PROCEDURE Load_Array
*--------------------------------------------------------------------------
*-- Programmer..: Ken Mayer (Kenmayer)
*-- Date........: 7/17/1991
*-- Notes.......: Used to load the arrays needed for LITEBAR.PRG
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 7/18/1991 thru 7/19/1991 - minor tweaks here and there
*--               for efficiency's sake.
*-- Calls.......: None
*-- Called by...: LITEBAR.PRG
*-- Usage.......: do Load_Array
*-- Example.....: do Load_Array
*-- Returns.....: None (arrays are PUBLIC memvars)
*-- Parameters..: None
*--------------------------------------------------------------------------

	*-- MAY BE REMOVED FROM HERE --*
	nCount = 0                 && initialize "a_Skill" array -- eventually
	                           && for my purposes, this info would be gotten
	                           && from a database ... this routine can be
	                           && removed if you so desire ... (Just this
	                           && loop)
	ln_num = int(rand(-1) * 20) + 1
	do while nCount < nMax
		nCount = nCount + 1
		a_Skill[nCount] = int(rand() * 20) + 1   && random number from 1 to 20
	enddo
	*-- TO HERE --*

	nCnt1 = 0                && initialize the lightbar array ...
	do while nCnt1 < 15
		nCnt1 = nCnt1 + 1
		nCnt2 = 0
		do while nCnt2 < 4
			nCnt2 = nCnt2 + 1
			a_LiteBar[nCnt1,nCnt2] = space(1)     && init to a single space
			                                      && character in it...
			store .f. to a_Skip[nCnt1,nCnt2]      && init to NO Skip, but change
			                                      && in REFRESH as needed ...
		enddo
	enddo
	
	DO REFRESH   && this is used to setup the litebars ... and can be called
	             && as a separate procedure from anywhere ...
	
	*-- this shouldn't need to be changed ...
	*-- start at row six, allowing room at top of window/screen for a_Headings
	nRow1  =  6
	nRow2  =  7
	nRow3  =  8
	nRow4  =  9
	nRow5  = 10
	nRow6  = 11
	nRow7  = 12
	nRow8  = 13
	nRow9  = 14
	nRow10 = 15
	nRow11 = 16
	nRow12 = 17
	nRow13 = 18
	nRow14 = 19
	nRow15 = 20
	
	*-- set for four columns, up to 20 characters each -- column four should
	*-- be kept down to 15 ... actually all of them should.
	nCol1 = 5
	nCol2 = 25
	nCol3 = 45
	nCol4 = 65
	
	*-- positions -- A_POS1 array is the row
	a_Pos1[1]  = nRow1
	a_Pos1[2]  = nRow2
	a_Pos1[3]  = nRow3
	a_Pos1[4]  = nRow4
	a_Pos1[5]  = nRow5
	a_Pos1[6]  = nRow6
	a_Pos1[7]  = nRow7
	a_Pos1[8]  = nRow8
	a_Pos1[9]  = nRow9
	a_Pos1[10] = nRow10
	a_Pos1[11] = nRow11
	a_Pos1[12] = nRow12
	a_Pos1[13] = nRow13
	a_Pos1[14] = nRow14
	a_Pos1[15] = nRow15
	*-- positions -- A_POS2 array is the column
	a_Pos2[1]  = nCol1
	a_Pos2[2]  = nCol2
	a_Pos2[3]  = nCol3
	a_Pos2[4]  = nCol4
	
RETURN
*-- EoP: Load_Array

*--------------------------------------------------------------------------

PROCEDURE Refresh 
*--------------------------------------------------------------------------
*-- Programmer..: Ken Mayer (Kenmayer)
*-- Date........: 7/17/1991
*-- Notes.......: Used to define and/or refresh the a_LiteBar array. Very
*--               important if A_SKIP array is being used ...
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 7/17/1991 -- First version, minor tweaks since ...
*-- Calls.......: None
*-- Called by...: LITEBAR.PRG
*--               DoChoice             (Procedure in LITEBAR.PRG)
*-- Usage.......: do Refresh
*-- Example.....: do Refresh
*-- Returns.....: None (all arrays are public)
*-- Parameters..: None
*--------------------------------------------------------------------------

	*-- PROGRAMMER CHANGES --*

	*-- Headings should define both A_SKIP and A_HEADING arrays as true for
	*-- those entries, otherwise the program will allow them as "valid"
	*-- choices. If you want to set up conditionals, this is the place to
	*-- do it (such things as:
	*--    IF <condition>
	*--       STORE .T. TO A_SKIP[x,y]
	*--    ELSE
	*--       STORE .F. TO A_SKIP[x,y]
	*--    ENDIF
	*-- this would replace the WHEN in popup BAR definitions ...)
	
	a_LiteBar[1,1] = "HEADING 1"
	store .t. to a_Skip[1,1]     && don't allow as valid choice
	store .t. to a_Heading[1,1]  && for color display
	a_LiteBar[2,1] = "Choice 1: "+ltrim(str(a_Skill[1]))
	a_LiteBar[3,1] = "Choice 2: "+ltrim(str(a_Skill[2]))
	*-- 4,1 = nothing -- blank
	a_LiteBar[5,1] = "HEADING 2"
	store .t. to a_Skip[5,1]
	store .t. to a_Heading[5,1]
	a_LiteBar[6,1] = "Choice 3: "+ltrim(str(a_Skill[3]))
	a_LiteBar[7,1] = "Choice 4: "+ltrim(str(a_Skill[4]))
	*-- column 2
	a_LiteBar[1,2] = "HEADING 3"
	store .t. to a_Skip[1,2]
	store .t. to a_Heading[1,2]
	a_LiteBar[2,2] = "Choice 5: "+ltrim(str(a_Skill[5]))
	a_LiteBar[3,2] = "Choice 6: "+ltrim(str(a_Skill[6]))
	a_LiteBar[4,2] = "Choice 7: "+ltrim(str(a_Skill[7]))
	*-- 5,2 = nothing
	a_LiteBar[6,2] = "HEADING 4"
	store .t. to a_Skip[6,2]
	store .t. to a_Heading[6,2]
	a_LiteBar[7,2] = "Choice 8: "+ltrim(str(a_Skill[8]))
	*-- column 3
	a_LiteBar[1,3] = "HEADING 5"
	store .t. to a_Skip[1,3]
	store .t. to a_Heading[1,3]
	a_LiteBar[2,3] = "Choice  9: "+ltrim(str(a_Skill[9]))
	a_LiteBar[3,3] = "Choice 10: "+ltrim(str(a_Skill[10]))
	a_LiteBar[4,3] = "Choice 11: "+ltrim(str(a_Skill[11]))
	a_LiteBar[5,3] = "Choice 12: "+ltrim(str(a_Skill[12]))
	
	*-- It is VITAL that the last column and last row items be set properly,
	*-- for validation routines when moving the cursor ...
	n_LastCol = 3
	n_LastRow = 7
	
	
RETURN
*-- EoP: Refresh

*--------------------------------------------------------------------------

PROCEDURE ScrnPnt
*--------------------------------------------------------------------------
*-- Programmer..: Ken Mayer (Kenmayer)
*-- Date........: 07/17/1991
*-- Notes.......: Used to do the initial painting of the screen for the 
*--               lightbar routine.
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 07/17/1991 -- Original version - called each time the
*--                 lightbar was moved. Bad idea ...
*--               07/19/1991 -- Final version, much more efficiently programmed,
*--                 using arrays to display the screen.
*-- Calls.......: None
*-- Called by...: LITEBAR.PRG
*-- Usage.......: Do ScrnPnt
*-- Example.....: Do ScrnPnt
*-- Returns.....: None
*-- Parameters..: None
*--------------------------------------------------------------------------
	*-- this procedure will probably only be called once - at the beginning
	*-- of the program. There shouldn't be a need to change this ...
	
	nCnt = 0
	do while nCnt < 15
		nCnt = nCnt + 1
		nCnt2 = 0
		do while nCnt2 < 4
			nCnt2 = nCnt2 + 1
			if len(trim(a_LiteBar[nCnt,nCnt2])) > 0
				if a_Heading[nCnt,nCnt2]
					@a_Pos1[nCnt],a_Pos2[nCnt2] say a_LiteBar[nCnt,nCnt2];
						color rg+/gb   && it's a a_Heading
				else
					@a_Pos1[nCnt],a_Pos2[nCnt2] say a_LiteBar[nCnt,nCnt2]
				endif
			endif
		enddo
	enddo
	
	@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] say a_LiteBar[2,1] color n/g   
		&& display first bar higlighted
	
	do center with 23,80,"rg+/r","Press: "+chr(24)+chr(25)+chr(26)+chr(27)+;
		", <Home>, <End> to move, <Enter> to choose, <Esc> to quit"
	
RETURN
*-- EoP: ScrnPnt

*--------------------------------------------------------------------------

PROCEDURE MoveRow
*--------------------------------------------------------------------------
*-- Programmer..: Ken Mayer (Kenmayer)
*-- Date........: 07/19/1991
*-- Notes.......: Used when user presses up or down arrow keys. 
*--               This procedure handles up and down movement. It is 
*--               designed to first, redisplay the current litebar area in
*--               "normal" color (default is whatever your screen/window 
*--               NORMAL color is set to). Next, it looks at the keystroke, 
*--               and moves the pointer to the next item. We check
*--               to see if that's valid (using VALID() below), and if it is, 
*--               we are done. If it's not valid, we move in the direction 
*--               (up/down) again, and check for valid, looping until we either 
*--               find a valid option, or, if none of the options in that 
*--               column are valid, we move to the next column. (Tricky, eh?) 
*--               Once we have a valid position, we display it highlighted, 
*--               and return ...
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 07/17/1991 -- First version, very complex. Had to reprogram
*--                 if a new column was added, and so on.
*--               07/19/1991 -- After much frustration, did a total reprogram
*--                 to what is below. This is quite efficient and doesn't need
*--                 to be modified if rows or columns are added. 
*-- Calls.......: VALID()              (Function in LITEBAR.PRG)
*-- Called by...: LITEBAR.PRG
*--               MoveCol              (Procedure in LITEBAR.PRG)
*-- Usage.......: do MoveRow
*-- Example.....: do MoveRow
*-- Returns.....: None
*-- Parameters..: None
*--------------------------------------------------------------------------

	*-- PROGRAMMER -- NO CHANGES NEEDED (in next three procedures) ... --*
	
	*-- redisplay old position ...
	if valid()
		@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] say a_LiteBar[n_LiteRow,n_LiteCol] 
	endif  && valid()
	
	do case
		*-- uparrow first
		case n_Choice = 5 
			
			if n_LiteRow = 1               && if first row
				n_LiteRow = n_LastRow       && wrap it around ...
			else
				n_LiteRow = n_LiteRow - 1   && decrement (move up to next row)
			endif
			nCount = 1                     && set counter to 1
			do while .not. Valid()         && function below to determine if 
			                               &&   a_LiteBar is valid
				nCount = nCount + 1         && if we're here, we're moving again
				if nCount = n_LastRow       && we've wrapped around
					n_Choice = 4             && stick a right arrow in here ...
					do MoveCol               && procedure to move cursor by col!
					exit                     && we're done here ...
				endif                       && nCount = n_LastRow
				if n_LiteRow = 1            && check for first row
					n_LiteRow = n_LastRow    && wrap around
				else
					n_LiteRow = n_LiteRow - 1  && decrement (move to next)
				endif
			enddo
			
		*-- down arrow next
		case n_Choice = 24
	
			if n_LiteRow = n_LastRow       && if last row
				n_LiteRow = 1               && wrap it around ...
			else
				n_LiteRow = n_LiteRow + 1   && increment (move to next row)
			endif
			nCount = 1                     && set counter to 1
			do while .not. Valid()         && function below to determine if 
			                               && a_LiteBar is valid
				nCount = nCount + 1         && if we're here, we're moving again
				if nCount = n_LastRow       && we've wrapped around
					n_Choice = 19            && stick a left arrow in here ...
					do MoveCol               && procedure to move cursor by col!
					exit                     && we're done here ...
				endif                       && nCount = n_LastRow
				if n_LiteRow = n_LastRow    && check for last row
					n_LiteRow = 1            && wrap around
				else
					n_LiteRow = n_LiteRow + 1  && increment (move to next)
				endif
			enddo
			
	endcase
	
	*-- clean out current row, just to be safe ...
	@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] clear to ;
	                   a_Pos1[n_LiteRow],a_Pos2[n_LiteCol]+19
	*-- redisplay but highlighted this time ...
	@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] say ;
	                   a_LiteBar[n_LiteRow,n_LiteCol] color n/g
		
RETURN
*-- EoP: MoveRow

*--------------------------------------------------------------------------

PROCEDURE MoveCol
*--------------------------------------------------------------------------
*-- Programmer..: Ken Mayer (Kenmayer)
*-- Date........: 07/19/1991
*-- Notes.......: See MoveRow for details -- it works the same, except
*--               left/right, instead of up/down.
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: See MoveRow for details
*-- Calls.......: VALID()              (Function in LITEBAR.PRG)
*-- Called by...: LITEBAR.PRG
*--               MoveRow              (Procedure in LITEBAR.PRG)
*--               HomeEnd              (Procedure in LITEBAR.PRG)
*-- Usage.......: Do MoveCol
*-- Example.....: Do MoveCol
*-- Returns.....: None
*-- Parameters..: None
*--------------------------------------------------------------------------

	if valid()
		@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] say a_LiteBar[n_LiteRow,n_LiteCol] 
	endif && valid()
	
	do case
	
		case n_Choice = 4
		** right arrow
			if n_LiteCol = n_LastCol       && if last column
				n_LiteCol = 1               && wrap it around ...
			else
				n_LiteCol = n_LiteCol + 1   && increment (move to next column)
			endif
			nCount = 1                     && set counter to 1
			do while .not. Valid()         && function below to determine if 
			                               &&   a_LiteBar is valid
				nCount = nCount + 1         && if we're here, we're moving again
				if nCount = n_LastCol       && we've wrapped around
					n_Choice = 24            && stick a down arrow in here ...
					do MoveRow               && procedure to move cursor by rows!
					exit                     && we're done here ...
				endif                       && nCount = n_LastCol
				if n_LiteCol = n_LastCol    && check for last column
					n_LiteCol = 1            && wrap around
				else
					n_LiteCol = n_LiteCol + 1  && increment (move to next)
				endif
			enddo
			
		*-- left arrow next
		case n_Choice = 19 
	
			if n_LiteCol = 1               && if FIRST column
				n_LiteCol = n_LastCol       && wrap it around ...
			else
				n_LiteCol = n_LiteCol - 1   && decrement (move to next column)
			endif
			nCount = 1                     && set counter to 1
			do while .not. Valid()         && function below to determine if 
			                               &&   a_LiteBar is valid ...
				nCount = nCount + 1         && if we're here, we're moving again
				if nCount = n_LastCol       && we've wrapped around
					n_Choice = 5             && stick an up arrow in here ...
					do MoveRow               && procedure to move cursor by rows!
					exit                     && we're done here ...
				endif                       && nCount = n_LastCol
				if n_LiteCol = 1            && check for last column
					n_LiteCol = n_LastCol    && wrap around
				else
					n_LiteCol = n_LiteCol - 1  && decrement (move to next)
				endif
			enddo
	endcase
	
	*-- clean out current row, just to be safe ...
	@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] clear to ;
				a_Pos1[n_LiteRow],a_Pos2[n_LiteCol]+19
	@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] say ;
				a_LiteBar[n_LiteRow,n_LiteCol] color n/g
	
RETURN
*-- EoP: MoveCol

*--------------------------------------------------------------------------

PROCEDURE HomeEnd
*--------------------------------------------------------------------------
*-- Programmer..: Ken Mayer (Kenmayer)
*-- Date........: 07/19/1991
*-- Notes.......: Very much the same type of logic as MoveRow and MoveCol, 
*--               but cursor is moved to first position (<Home>) or last 
*--               (<End>) and validation is checked in those columns ...
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: none
*-- Calls.......: MoveCol              (Procedure in LITEBAR.PRG)
*-- Called by...: LITEBAR.PRG
*-- Usage.......: do HomeEnd
*-- Example.....: do HomeEnd
*-- Returns.....: None
*-- Parameters..: None
*--------------------------------------------------------------------------
	
	if valid()
		@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] say a_LiteBar[n_LiteRow,n_LiteCol] 
	endif  && valid()
	
	do case
		*-- For HOME, we need to go to first position, and move down the column,
		*-- as if we were doing the routine in MOVEROW ... for END we do the
		*-- same, but go to last position, and work UP the column, looking for 
		*-- valid ...
		
		case n_Choice = 26
		*-- <Home> key
			n_LiteCol = 1                  && move pointer to "Home" position
			n_LiteRow = 1
			
			nCount = 1                     && set counter to 1
			do while .not. Valid()         && function below to determine if 
			                               &&   a_LiteBar is valid
				nCount = nCount + 1         && if we're here, we're moving again
				if nCount = n_LastRow       && we've wrapped around
					n_Choice = 4             && stick a right arrow in here ...
					do MoveCol               && procedure to move cursor by rows!
					exit                     && we're done here ...
				endif                       && nCount = n_LastRow
				if n_LiteRow = n_LastRow    && check for last column
					n_LiteRow = 1            && wrap around
				else
					n_LiteRow = n_LiteRow + 1  && increment (move to next)
				endif
			enddo
		
		case n_Choice = 2
			*-- <End> key
			n_LiteRow = n_LastRow          && move cursor to last item
			n_LiteCol = n_LastCol
			
			nCount = 1                     && set counter to 1
			do while .not. Valid()         && function below to determine if 
			                               &&   a_LiteBar is valid
				nCount = nCount + 1         && if we're here, we're moving again
				if nCount = n_LastRow       && we've wrapped around
					n_Choice = 19            && stick a left arrow in here ...
					do MoveCol               && procedure to move cursor by col
					exit                     && we're done here ...
				endif                       && nCount = n_LastRow
				if n_LiteRow = 1            && check for first row
					n_LiteRow = n_LastRow    && wrap around
				else
					n_LiteRow = n_LiteRow - 1  && increment (move to next)
				endif
			enddo
			
	endcase
	
	*-- clean out current row, just to be safe ...
	@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] clear to ;
				a_Pos1[n_LiteRow],a_Pos2[n_LiteCol]+19
	@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] say ;
				a_LiteBar[n_LiteRow,n_LiteCol] color n/g
		&& display in hilight colors ...

RETURN 
*-- EoP: HomeEnd

*--------------------------------------------------------------------------

PROCEDURE DoChoice
*--------------------------------------------------------------------------
*-- Programmer..: Ken Mayer (Kenmayer)
*-- Date........: 07/19/1991
*-- Notes.......: This is where we go when the user has pressed <Enter>. 
*--               It means they want to choose the highlighted option. 
*--               The current structure below looks at the column, and then 
*--               the row we are pointing to to decide what to do. Such 
*--               options as  "DO <program>"  can be placed in the approprate
*--               cases ... if a header is in row1 column1, leave the case 
*--               blank, if you want to execute a program, or do something
*--               else (assign a value ... whatever), put that command in 
*--               the appropriate case. You may need to look at your REFRESH 
*--               procedure definitions to set this part properly ...
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: None
*-- Calls.......: Center               (Procedure in PROC.PRG)
*--               Refresh              (Procedure in LITEBAR.PRG)
*-- Called by...: LITEBAR.PRG
*-- Usage.......: Do DoChoice
*-- Example.....: Do DoChoice
*-- Returns.....: None
*-- Parameters..: None
*--------------------------------------------------------------------------
	
	*-- PROGRAMMER CHANGES --*
	
	*-- can this be done more efficiently? I can't think of a better
	*-- way ... >sigh<.
	
	do case
		case n_LiteCol = 1
			do case
				case n_LiteRow = 1
				
				case n_LiteRow = 2
					
				case n_LiteRow = 3
					
				case n_LiteRow = 4
				
				case n_LiteRow = 5
				
				case n_LiteRow = 6
					
				case n_LiteRow = 7
					
				case n_LiteRow = 8
				
				case n_LiteRow = 9
				
				case n_LiteRow = 10
				
				case n_LiteRow = 11
				
				case n_LiteRow = 12
				
				case n_LiteRow = 13
				
				case n_LiteRow = 14
				
				case n_LiteRow = 15
				
			endcase
		case n_LiteCol = 2
			do case
				case n_LiteRow = 1
				
				case n_LiteRow = 2
					
				case n_LiteRow = 3
					
				case n_LiteRow = 4
					
				case n_LiteRow = 5
				
				case n_LiteRow = 6
				
				case n_LiteRow = 7
					
				case n_LiteRow = 8
				
				case n_LiteRow = 9
				
				case n_LiteRow = 10
				
				case n_LiteRow = 11
				
				case n_LiteRow = 12
				
				case n_LiteRow = 13
				
				case n_LiteRow = 14
				
				case n_LiteRow = 15
				
			endcase
		case n_LiteCol = 3
			do case
				case n_LiteRow = 1
				
				case n_LiteRow = 2
					
				case n_LiteRow = 3
					
				case n_LiteRow = 4
					
				case n_LiteRow = 5
					
				case n_LiteRow = 6
				
				case n_LiteRow = 7
				
				case n_LiteRow = 8
				
				case n_LiteRow = 9
				
				case n_LiteRow = 10
				
				case n_LiteRow = 11
				
				case n_LiteRow = 12
				
				case n_LiteRow = 13
				
				case n_LiteRow = 14
				
				case n_LiteRow = 15
				
			endcase
		
		case n_LiteCol = 4
			do case
				case n_LiteRow = 1
			
				case n_LiteRow = 2
				
				case n_LiteRow = 3
				
				case n_LiteRow = 4
				
				case n_LiteRow = 5
				
				case n_LiteRow = 6
				
				case n_LiteRow = 7
				
				case n_LiteRow = 8
				
				case n_LiteRow = 9
				
				case n_LiteRow = 10
				
				case n_LiteRow = 11
				
				case n_LiteRow = 12
				
				case n_LiteRow = 13
				
				case n_LiteRow = 14
				
				case n_LiteRow = 15
				
			endcase
	endcase
	
	*-- PROGRAMMER CHANGE --* these two lines are here for demo only ...
	@22,0 clear to 22,79  && clear out old one
	do center with 22,80,"","You chose to do item "+a_LiteBar[n_LiteRow,n_LiteCol]
	
	*-- Next two commands are necessary if you are changing some values.
	*-- with this demo, they could be removed ... If you change the
	*-- a_LiteBar option after choosing it, then these are vital. They
	*-- don't slow the program down appreciably, and can be left alone.
	do refresh   && if you have set some A_SKIP options this is vital
	
	*-- clean out current row, just to be safe ...
	@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] clear to ;
				a_Pos1[n_LiteRow],a_Pos2[n_LiteCol]+19
	
	*-- redisplay highlighted (it is the current choice ...) -- important
	*-- if the a_LiteBar definition has changed ...
	@a_Pos1[n_LiteRow],a_Pos2[n_LiteCol] say ;
				a_LiteBar[n_LiteRow,n_LiteCol] color n/g

RETURN
*-- EoP: DoChoice

*--------------------------------------------------------------------------

FUNCTION Valid
*--------------------------------------------------------------------------
*-- Programmer..: Ken Mayer (Kenmayer)
*-- Date........: 07/18/1991
*-- Notes.......: Used to determine if 'current' a_LiteBar option is a valid
*--               one.
*-- Written for.: dBASE IV, 1.1.
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: MoveRow              (Procedure in LITEBAR.PRG)
*--               MoveCol              (Procedure in LITEBAR.PRG)
*--               HomeEnd              (Procedure in LITEBAR.PRG)
*-- Usage.......: valid()
*-- Example.....: Do while .not. valid()
*--                  && statements to move cursor and such...
*--               Enddo
*-- Returns.....: .t./.f.  -- logical
*-- Parameters..: None
*--------------------------------------------------------------------------

	if len(trim(a_LiteBar[n_LiteRow,n_LiteCol])) > 0 .and. .not. ;
		   a_Skip[n_LiteRow,n_LiteCol]
		store .t. to lValid
	else
		store .f. to lValid
	endif

RETURN lValid
*-- EoF: Valid

*--------------------------------------------------------------------------
* End of Program: LITEBAR.PRG
*--------------------------------------------------------------------------
