*** Erik McBeth
*** Borland International dBASE Technical Support
*** 1992.03.20

PROCEDURE LBL_entry
PARAMETER pc_panel,pc_file

**  gc_lzrlbl:  the name of the lazer label we are using   
** gl_isquick:  can the do a quick layout with this DBF?
** gc_org_dbf:  the dbf we assume is current
  PUBLIC gc_lzrlbl,gl_isquick,gc_org_dbf
  
  DO setupenv
  gc_org_dbf = get_dbf(pc_file)
  IF ISBLANK(gc_org_dbf)
     DO resetenv
     RETURN TO MASTER
  ENDIF      
  gl_isquick = isqcklbl()
  gc_lzrlbl  = lzrlblnm(pc_file)

RETURN


PROCEDURE LBL_exit
PARAMETER pc_panel,pc_file,pc_save
  
  PRIVATE ln_x,lc_lzrfile,ln_lzrflfd
  
  ln_lzrflfd = 0
  
  IF pc_save # "ABANDON"  && we're saving the label
     lc_lzrfile = lzrfilenm(pc_file)
     
     IF "" # gc_lzrlbl    && doing a laser label
        ln_lzrflfd = createll(lc_lzrfile)
        ln_x=FPUTS(ln_lzrflfd,gc_lzrlbl) && write out the label name
        ln_lzrflfd = closell(ln_lzrflfd)
     ENDIF
** here we generate the .lbg dBASE code instead of having the
** label designer do it     
     ln_x = DGEN("label.gen",killext(pc_file)+'.lnl')
  ENDIF  
   
  IF pc_save # "RESUME"  && leaving label screen
     RELEASE gc_lzrlbl,ga_qckflds,gn_qckfldc,gl_isquick,gc_org_dbf
     DO resetenv
  ENDIF
RETURN 


PROCEDURE LBL_layout
PARAMETER pc_panel,pc_file

  PRIVATE ln_aindex,lc_string,lc_alias

** create a popup which allows users to choose a lazer label
** and have the dimensions of the label automatcially changed
** or do a "quick layout" label  
  IF cur_dbf() # gc_org_dbf  && used a different database
     gc_org_dbf = cur_dbf()
     gl_isquick = isqcklbl()
  ENDIF   
  
  gn_bar=0
  DEFINE POPUP pop_layout  FROM 6,10 TO 9,25
  DEFINE BAR 1 OF pop_layout PROMPT "Laser labels" 
  DEFINE BAR 2 OF pop_layout PROMPT "Quick layout" ;
                         SKIP FOR .NOT. gl_isquick
  ON SELECTION POPUP pop_layout DO killmenu WITH "POPUP"
  ACTIVATE POPUP pop_layout
  RELEASE POPUP pop_layout
    
  IF gn_bar=0
     RETURN
  ENDIF

  DO CASE
     CASE gn_bar = 1
** present of popup of lazer labels, when one is chosen use
** KEYBOARD to set the dimensions of the label          
          lc_alias  = ALIAS()
          DO opendbf WITH "labels","ORDER name"
          
          gc_prompt=""
          DEFINE POPUP pop_labels ;
            FROM 10,30 TO 20,30+LEN(name) PROMPT FIELD name
          ON SELECTION POPUP pop_labels DO killmenu WITH "POPUP"
          ACTIVATE POPUP pop_labels
          RELEASE POPUP pop_labels
          
          IF "" # gc_prompt
             gc_lzrlbl = gc_prompt
             SEEK gc_lzrlbl
             IF FOUND()
                DO setsize
             ENDIF   
          ENDIF
          USE
          SELECT (lc_alias)
     
     CASE gn_bar = 2
** here we actually KEYBOARD in what the quick label should
** look like          
          ln_aindex = 1
          DO WHILE ln_aindex <= gn_qckfldc
             lc_string = ga_qckflds[ln_aindex,1] 
             IF ga_qckflds[ln_aindex,2]  && is it a field?  
                KEYBOARD "{F5}"+lc_string+"{CTRL-M}{CTRL-END}"
             ELSE
                KEYBOARD lc_string
             ENDIF 
             ln_aindex = ln_aindex + 1
          ENDDO 
     
  ENDCASE   

RETURN


PROCEDURE LBL_exec
PARAMETER pc_panel,pc_file
** called when getting ready to print labels from the 
** Control Center, sets _pscode to the needed Escape codes
  PRIVATE lc_lzrlbl,lc_alias

  DO setupenv
  IF ISBLANK(get_dbf(pc_file))
     DO resetenv
     RETURN TO MASTER
  ENDIF      
  
  lc_lzrlbl = lzrlblnm(pc_file)
  
  IF "" # lc_lzrlbl
     lc_alias = ALIAS()
     DO opendbf WITH "labels","ORDER name"
     
     SEEK lc_lzrlbl
     IF FOUND()
        _pscode  = TRIM(esccodes) 
        _plength = plength
     ENDIF  
     USE
     SELECT (lc_alias)
  ENDIF
  
  DO resetenv

RETURN 


****
****  LBL_lbl sub-procedures and functions
****

FUNCTION get_dbf  && grab the dbf/view we'll be using 
PARAMETER pc_file

  PRIVATE lc_cur_dbf,lc_cat_dbf,ll_isqbe,ln_use_cur,lc_nopath
  
  lc_cur_dbf = cur_dbf()
  ll_isqbe   = .F. 
  lc_cat_dbf = cat_dbf(pc_file,ll_isqbe)
  lc_nopath  = killpath(lc_cat_dbf)
  ln_use_cur = 2
  
  IF ISBLANK(lc_cur_dbf) .AND. ISBLANK(lc_cat_dbf)
     DO nodbfbox
     CLOSE DATABASES
     RETURN ""
  ENDIF   

  IF ISBLANK(lc_cat_dbf) .OR. lc_cat_dbf = lc_cur_dbf
     ln_use_cur = 1 && use the current dbf
  ENDIF   
  
  IF ("" # lc_cur_dbf .AND. "" # lc_cat_dbf) .AND.;
           (killpath(lc_cur_dbf) # lc_nopath)
     ln_use_cur = if_use_cur(lc_nopath)
     IF ln_use_cur = 0  && hit escape
        RETURN ""
     ENDIF
  ENDIF      
  
  IF ln_use_cur = 2  && use dbf per catalog 
     SELECT 1
     IF ll_isqbe
        DEFINE WINDOW win_setvue FROM 10,10 TO 16,69 DOUBLE
        ACTIVATE WINDOW win_setvue
        ?? "SET VIEW TO "+lc_cat_dbf AT 1 FUNCTION "V54"
        ON ESCAPE DO pressakey WITH "get_dbf"
        SET ESCAPE ON
        SET VIEW TO (lc_cat_dbf)
        SET ESCAPE OFF
        ON ESCAPE 
        DEACTIVATE WINDOW win_setvue
        RELEASE WINDOW win_setvue
     ELSE
        CLOSE DATABASES
        USE (lc_cat_dbf)
     ENDIF      
     lc_cur_dbf = cur_dbf()
  ENDIF   

RETURN lc_cur_dbf


PROCEDURE nodbfbox  && tell the user we need a dbf/view

  DEFINE WINDOW win_nodbf FROM 8,15 TO 15,64 DOUBLE
  ACTIVATE WINDOW win_nodbf
  ? "Please put a database file or view into use first" ;
      AT 1 FUNCTION "V47"
  ?
  ?  "Press any key to continue..." ;
      AT 1 PICTURE REPLICATE("X",47) FUNCTION "I"
  READ
  DEACTIVATE WINDOW win_nodbf
  RELEASE WINDOW win_nodbf
  
RETURN  


PROCEDURE pressakey  && grab a key and return
PARAMETER pc_program

  DEFINE WINDOW win_pak FROM 8,15 TO 13,64 DOUBLE
  ACTIVATE WINDOW win_pak
  ?
  ?  "Press any key to continue..." ;
      AT 1 PICTURE REPLICATE("X",47) FUNCTION "I"
  READ
  DEACTIVATE WINDOW win_pak
  RELEASE WINDOW win_pak
  
RETURN TO &pc_program 


FUNCTION if_use_cur  && use current dbf/view or the catalog's?
PARAMETER pc_norm_file

** a return value of 0 means the user hit Escape and we should
** abandon, 1 == use the current dbf/view, 2 == use the catalog's 
  
  gc_pad = ""
  DEFINE WINDOW win_usecur FROM 8,10 TO 16,69 DOUBLE
  DEFINE MENU mnu_usecur MESSAGE ;
  "Select option and press ENTER, or press first letter of desired option"
  DEFINE PAD pad_view OF mnu_usecur PROMPT "Current view" AT 1,12 
  DEFINE PAD pad_dbf  OF mnu_usecur PROMPT TRIM(pc_norm_file) AT 1,35
  ON SELECTION PAD pad_view OF mnu_usecur DO killmenu WITH "MENU"
  ON SELECTION PAD pad_dbf  OF mnu_usecur DO killmenu WITH "MENU"
  
  ACTIVATE WINDOW win_usecur
  ?
  ?
  ? "You may choose to use either the current database file or view, "+ ;
    "or the database file or view usually associated with the file "+; 
    "you just selected." AT 2 FUNCTION "V54"
  ACTIVATE MENU mnu_usecur
  DEACTIVATE WINDOW win_usecur
  RELEASE WINDOW win_usecur
  RELEASE MENU mnu_usecur
  
RETURN IIF(ISBLANK(gc_pad),0,IIF(UPPER(gc_pad)="PAD_VIEW",1,2))


FUNCTION cat_dbf  && dbf associated with this label
PARAMETER pc_file,pl_isqbe

  PRIVATE lc_dbf,lc_catalog,lc_file,lc_code,lc_delete,;
          lc_alias
  
  pl_isqbe   = .F.
  lc_dbf     = ""
  IF ISBLANK(pc_file) && creating a new label 
     RETURN lc_dbf
  ENDIF   
  lc_delete  = SET("DELETE")
  SET DELETE ON
  lc_catalog = CATALOG()
  lc_file    = UPPER(killpath(pc_file))  && label highlighted
  lc_alias   = ALIAS()
  
  DO opendbf WITH lc_catalog,"AGAIN"
  
  GO TOP
  LOCATE FOR lc_file=UPPER(file_name)  && find the label in the catalog
  
  IF FOUND()  && now find the associated dbf/qbe
     lc_code = code
     GO TOP
     LOCATE FOR LOWER(type) $ "dbf qbe" .AND. code=lc_code
     IF FOUND()
        lc_dbf = path
        IF LOWER(type)="qbe"
           pl_isqbe = .T.
        ENDIF   
     ENDIF
  ENDIF      
  
  SET DELETE &lc_delete
  USE
  IF "" # lc_alias
     SELECT (lc_alias)
  ENDIF   
  
RETURN UPPER(lc_dbf)  
  

FUNCTION cur_dbf  && what is the current dbf/view?
  
  PRIVATE lc_dbf
  
  lc_dbf = SET("VIEW")
  IF ISBLANK(lc_dbf)
     lc_dbf = DBF()
  ENDIF   

RETURN UPPER(lc_dbf)


PROCEDURE opendbf  && open a dbf in another WA if not already open
PARAMETER pc_file,pc_mode
  
  PRIVATE lc_catstat,lc_usealias
  
  lc_catstat  = SET("CATALOG")
  lc_usealias = killpath(killext(pc_file))
  SET CATALOG OFF  

  SELECT SELECT()
  USE (pc_file) &pc_mode 
  
  SET CATALOG &lc_catstat
  
RETURN  


PROCEDURE setsize && set label dimensions based on LABELS.DBF 
  
  PRIVATE ln_aindex,la_sizing,lc_field

  DECLARE la_sizing[6]
  la_sizing[1] = "WIDTH"
  la_sizing[2] = "HEIGHT"
  la_sizing[3] = "INDENT"
  la_sizing[4] = "LINESBETWN"
  la_sizing[5] = "SPACEBETWN"
  la_sizing[6] = "COLUMNS"

  KEYBOARD "{ALT-D}"    && Dimension menu
  
  ln_aindex = 1
  DO WHILE ln_aindex<=6
     lc_field = la_sizing[ln_aindex]
     KEYBOARD LEFT(lc_field,1)+LTRIM(STR(&lc_field))+"{CTRL-M}"
     ln_aindex = ln_aindex + 1
  ENDDO
  
** save the settings and make the Layout menu the default menu
** when we hit F10 the next time 
  KEYBOARD "{CTRL-END}{ALT-L}{27}" 

RETURN

  
FUNCTION isqcklbl
** function to determine if the dbf in use can be used as a
** quick layout type label, the data file must have the same
** fields as defined in the DLDD (Default Label Description Database)
  
  PRIVATE ln_aindex,ln_recno,lc_field,lc_alias
** gn_qckfldc:  size of ga_qckflds  
  PUBLIC gn_qckfldc

  lc_alias = ALIAS()
  DO opendbf WITH "dldd","ORDER pos"
  gn_qckfldc = RECCOUNT()
  ln_aindex  = 1

** ga_qckflds:  array which describes our quick layout label,
**              two columns, one for the name of the field or
**              string to place on the label surface and the
**              other to tell if we are using a DBF field          
  PUBLIC ARRAY ga_qckflds[gn_qckfldc,2]
  
  GO TOP
  DO WHILE .NOT. EOF()
     ln_recno = RECNO()
     ga_qckflds[ln_recno,1]=TRIM(string)  && field name or string
     ga_qckflds[ln_recno,2]=isfield       && field name??
     SKIP
  ENDDO
  
  USE
  SELECT (lc_alias)
  DO WHILE ln_aindex <= gn_qckfldc
     IF ga_qckflds[ln_aindex,2]  && is it a field?
        lc_field = ga_qckflds[ln_aindex,1]
        IF TYPE(lc_field) = 'U'  && field doesn't exist
           EXIT
        ENDIF   
     ENDIF
     ln_aindex = ln_aindex + 1
  ENDDO

RETURN ln_aindex > gn_qckfldc  && did the DBF qualify?


FUNCTION lzrfilenm  && text file containing Avery label name
PARAMETER pc_file
RETURN killext(pc_file)+".lzr"


FUNCTION lzrlblnm  && return the name of the Avery label
PARAMETER pc_file

  PRIVATE ln_lzrflfd,lc_lzrlbl
  
  IF ISBLANK(pc_file)  && creating new label
     RETURN ""
  ENDIF   
  ln_lzrflfd = openll(lzrfilenm(pc_file))
  lc_lzrlbl  = IIF(ln_lzrflfd = 0,"",FGETS(ln_lzrflfd))
  ln_lzrflfd = closell(ln_lzrflfd)

RETURN lc_lzrlbl
  

****
****  General purpose sub-procedures and functions
****

PROCEDURE setupenv  && setup our working environment
  
**  gc_talk, etc.:  holds current setting of these SETs  
  PUBLIC gc_talk,gc_dbtrap,gc_escape,gc_typea,gc_exact,;
         gc_full,gc_bell
  
  gc_talk   = settalk("OFF")
  gc_dbtrap = SET("DBTRAP") 
  gc_escape = SET("ESCAPE")
  gc_typea  = SET("TYPEAHEAD")
  gc_bell   = SET("BELL")
  gc_exact  = SET("EXACT")  
  gc_full   = SET("FULLPATH")
  SET DBTRAP OFF
  SET ESCAPE OFF
  SET TYPEAHEAD TO 255
  SET BELL OFF
  SET EXACT ON
  SET FULLPATH ON

RETURN  


PROCEDURE resetenv  && set the dBASE environment back to status quo 
  
  SET DBTRAP &gc_dbtrap
  SET ESCAPE &gc_escape
  SET TYPEAHEAD TO gc_typea
  SET BELL &gc_bell
  SET EXACT &gc_exact
  SET FULLPATH &gc_full
  SET TALK &gc_talk
  RELEASE gc_talk,gc_dbtrap,gc_escape,gc_typea,;
          gc_exact,gc_bell,gc_full
  
RETURN  


PROCEDURE killmenu  && general procedure to kill a popup/menu
PARAMETER pc_menutype

  gc_prompt = PROMPT()
  gn_bar    = BAR()
  gc_pad    = PAD() 
  DEACTIVATE &pc_menutype

RETURN


FUNCTION settalk  && SET TALK and return the current setting
PARAMETER pc_talk

  IF SET("TALK")="ON"
     SET TALK &pc_talk
     RETURN "ON"
  ENDIF   
  SET TALK &pc_talk
  
RETURN "OFF"        


FUNCTION openll  && open a low-level file and return the handle
PARAMETER pc_file,pc_mode
  
  IF FILE(pc_file)
     RETURN FOPEN(pc_file,IIF(PCOUNT()=1,"r",pc_mode))
  ENDIF 

RETURN 0
   

FUNCTION createll  && create a low-level file and return the handle 
PARAMETER pc_file,pc_mode
RETURN FCREATE(pc_file,IIF(PCOUNT()=1,"rw",pc_mode))


FUNCTION closell  && close a low-level file and return 0
PARAMETER pc_fd
  
  IF pc_fd # 0
     pc_fd = IIF(FCLOSE(pc_fd),0,pc_fd)
  ENDIF   

RETURN pc_fd


FUNCTION killext  && return the file name without an extension
PARAMETER pc_file
RETURN LEFT(pc_file,LEN(pc_file)-FRAT(".",pc_file))


FUNCTION killpath  && return the file name without a path
PARAMETER pc_file
RETURN SUBSTR(pc_file,RAT("\",pc_file)+1)


FUNCTION strrev  && reverse the letters in a string
PARAMETER pc_string

  PRIVATE lc_char,ln_len,ln_x,lc_string
  
  lc_string = pc_string
  ln_len    = LEN(lc_string)
  ln_x      = 1
  
  DO WHILE ln_x < ln_len  && move toward the middle
     lc_char   = SUBSTR(lc_string,ln_x,1)
     lc_string = STUFF(lc_string,ln_x,1,SUBSTR(lc_string,ln_len,1))
     lc_string = STUFF(lc_string,ln_len,1,lc_char)
     ln_x      = ln_x + 1
     ln_len    = ln_len - 1
  ENDDO
  
RETURN lc_string      


FUNCTION rat  && last AT() in string
PARAMETER pc_search,pc_string

   PRIVATE ln_at
   
   ln_at = AT(strrev(pc_search),strrev(pc_string))

RETURN IIF(ln_at = 0,0,LEN(pc_string)-(ln_at+LEN(pc_search)-2))


FUNCTION frat  && position of rat() counting from the right
PARAMETER pc_search,pc_string

   PRIVATE ln_rat
   
   ln_rat = rat(pc_search,pc_string)

RETURN IIF(ln_rat = 0,0,LEN(pc_string)+1-ln_rat)

