*  LBARMENU.PRG -- Light Bar Menu for dBase III+
*              10/13/86 Bob DuCharme
*   when control leaves MenuLoop, memory variable called Choice will contain
*      the number of the choice chosen by the user
*   set color to w/n is for normal;
*   set color to n/w is for reverse
*
set talk off
*   Replace these strings with whatever titles you like
title1 = 'A This is title1               '
title2 = 'B This is title2               '
title3 = 'C This is title3               '
title4 = 'D This is title4               '
title5 = 'E Exit                         '
*   ChoiceNum = total number of choices
ChoiceNum = 5
clear
*   while in loop, Choice means Current Row of menu;
*   PChoice means Previous Current Row
Choice=1
set color to w/n
@ 6,23 say 'ͻ'
r=7
do while r<6+2*ChoiceNum
  @ r,23 say '                                 '
  r=r+1
enddo
@ 16,23 say 'ͼ'
set color to n/w
@ 7,25 say title1
set color to w/n
@ 9,25 say title2
@ 11,25 say title3
@ 13,25 say title4
@ 15,25 say title5
MenuLoop = .t.
*   MenuLoop value becomes false if either enter or an appropriate letter is
*     entered, meaning the user has made a choice.  If up or down cursor keys
*     are hit, light bar just moves to appropriate place.
*
*   Assign inkey ASCII values -- up key, 5; down key, 24 return, 13
UpKey = 5
DownKey = 24
ReturnKey = 13
do while MenuLoop
  PChoice = Choice
  key=0
  * inkey loop - won't leave until appropriate value is pressed
  *   corresponding characters: up key, chr(5) =  ; down key, chr(24) = 
  *   If ChoiceNum is > 5, add appropriate characters (f,F,g,G,etc.) to
  *     string in condition governing inkey loop
  do while .not. ( (chr(key) $ ('abcdeABCDE')) .or. key = ReturnKey )
    key=inkey()
  enddo
  do case
  case key = ReturnKey
    MenuLoop = .f.
  case key = UpKey .and. Choice>1
    Choice = Choice-1
  case key=DownKey .and. Choice<ChoiceNum
    Choice = Choice+1
  *  next two cases are for if letter key was hit (A - E if ChoiceNum = 5)
  case key>96 .and. key<ChoiceNum+97
    Choice = key - 96
    MenuLoop = .f.
  *  or lower case letter
  case key>64 .and. key<ChoiceNum+65
    Choice = key - 64
    MenuLoop = .f.
  endcase
  * Un-highlight Previous Choice by writing it in regular video
  do case
  case PChoice=1
    @ 7,25 say title1
  case pChoice=2
    @ 9,25 say title2
  case PChoice=3
    @ 11,25 say title3
  case pChoice=4
    @ 13,25 say title4
  case PChoice=5
    @ 15,25 say title5
  endcase
  * Highlight new choice by writing it in reverse video
  set color to n/w
  do case
  case Choice=1
    @ 7,25 say title1
  case Choice=2
    @ 9,25 say title2
  case Choice=3
    @ 11,25 say title3
  case Choice=4
    @ 13,25 say title4
  case Choice=5
    @ 15,25 say title5
  endcase
  set color to w/n
enddo
* after falling out of the loop here, variable Choice has number of
* choice that was picked, which could then be passed to a case statement
* that would pass control to the appropriate program or procedure based
* on what the user picked.
@ 23,0 say 'Choice number '+str(choice,2,0)+' was picked.'
