* LASENV.PRG - Hugh Hemington, 72447-3475 
* 04/14/91
* Prints envelope with Postnet bar codes when supplied with zip+4 code
* Compile with the default no-procedure directive

* This program may be a little crude, but it works.  
* Any improvments or suggestions would be appreciated
* for clarity, I have hard-coded all raster bytes and control codes
* non-compressed, with repeated ESC.  These could be combined.
* Possible improvements include, an algorythm (instead of rote replacement)
* for generating 5-bar sets, combining the digit and array build functions
* possibly using code blocks, etc.

* Again, this is my first running version, employing some 
* "Sweat-Hog" methods.  I downloaded EMJR.ZIP which is a demo of a program
* which prints the postnet bar codes, and I became curious (dangerous!).
* Although I intend to use this function in my applications (as I invite you
* to do), it was more of a programming exercise than anything else.

* NOTE: Since LaserJet II lacks the "print direction" command found
* in the LaserJet IID & III, the codes are built and printed
* upside-down and backwards.
* In the later (PCL5) models, this code could be changed by positive-stepping
* the for-next loops, changing the bar-bytes and the absolute cursor
* positioning commands appropriately

* the postnet bar codes seem to follow a five-bit (74210) pattern
* except for zero, which adds up to eleven (?), anyway, the postnet code
* has a tall bar on each end; each digit is represented by 5 bars, and 
* the last five bars (before the ending tall bar) are a digit holding an 
* error correction code which is the sum of all of the zipcode digits,
* subtracted from the next highest 10.  The barcode should "baseline" 1/4 inch
* from the bottom of the envelope (which it does here on a standard
* 4 1/8 X 9 1/2 envelope because of the 1590 dot vertical cursor positioning.

* each bar is made up of 3 raster lines @ 150dpi, and each blank space is
* 4 raster lines.

* much of the technical raster graphics information used here was obtained 
* from an HP PCL5 manual (free to HP LJIII owners) Part No. 33459-90903
* chapter 14

* techinical information about the postnet code was obtained from
* a regional post office - "Auto-readability" department
* such as the one in Van Nuys, CA  (818) 908-6604

CLEAR
tm := 21  && top margin for envelope - 21 lines
lm := 46  && left margin - 46 spaces
DO WHILE .T.
  l1 := SPACE(34)
  l2 := SPACE(34)
  l3 := SPACE(34)
  lcity := SPACE(20)
  lstate := SPACE(2)
  zcode := SPACE(10)
  @  5, 2 SAY 'Line 1: ' GET l1
  @  6, 2 SAY 'Line 2: ' GET l2
  @  7, 2 SAY 'Line 3: ' GET l3
  @  8, 2 SAY 'City:   ' GET Lcity
  @  8,32 SAY 'State: ' GET lstate PICTURE '!!'
  @  8,44 SAY 'Zipcode: ' GET zcode PICTURE '99999-9999' 
  READ
  IF EMPTY(l1)
    QUIT
  END
  IF LEN(TRIM(Zcode)) = 10
    ZCD := XB_BLD(Zcode)
  END
  SET PRINT ON
  SET CONSOLE OFF
  ?? CHR(27)+'&l1O'+CHR(27)+'&l3H'  && setup for envelope
*     landscape     man. envelope
  FOR x = 1 TO tm
    ?
  NEXT
  ? SPACE(lm)+l1
  ? SPACE(lm)+l2
  IF !EMPTY(l3)
    ? SPACE(lm)+l3
  END
  ? SPACE(lm)+TRIM(lcity)+', '+lstate+'  '+zcode
  * position 
  IF LEN(TRIM(Zcode)) = 10
    ?? CHR(27)+'*p1590Y'+CHR(27)+'*p2800X'
*   abs. cursor pos Y axis    and   X axis
    ?? CHR(27)+'*r0F'+CHR(27)+'*t150R'+CHR(27)+'*r210T'+CHR(27)+'*r16S'+ CHR(27)+'*r1A'+CHR(27)+'*b0M'
* presentation mode   raster resolut.  raster height    raster width     start raster   raster compression (0)
    ?? CHR(27)+'*b3W'+CHR(015)+CHR(255)+CHR(255)  && three raster lines
    ?? CHR(27)+'*b3W'+CHR(015)+CHR(255)+CHR(255)  && of long lines to start
    ?? CHR(27)+'*b3W'+CHR(015)+CHR(255)+CHR(255)  && postnet bar set
    ?? CHR(27)+'*b3W'+CHR(0)+CHR(0)+CHR(0)  && four blank raster lines
    ?? CHR(27)+'*b3W'+CHR(0)+CHR(0)+CHR(0)  && between each bar
    ?? CHR(27)+'*b3W'+CHR(0)+CHR(0)+CHR(0)
    ?? CHR(27)+'*b3W'+CHR(0)+CHR(0)+CHR(0)
    FOR x = 10 TO 1 STEP -1  && printing reversed - last-to-first
      FOR y = 5 TO 1 STEP -1  && last bar to first bar - each digit
        ?? CHR(27)+'*b3W'+zcd[x][y]
        ?? CHR(27)+'*b3W'+zcd[x][y]
        ?? CHR(27)+'*b3W'+zcd[x][y]
        ?? CHR(27)+'*b3W'+CHR(0)+CHR(0)+CHR(0)  && hard coding a blank bar
        ?? CHR(27)+'*b3W'+CHR(0)+CHR(0)+CHR(0)  && between each code bar
        ?? CHR(27)+'*b3W'+CHR(0)+CHR(0)+CHR(0)  && makes ZCD smaller
        ?? CHR(27)+'*b3W'+CHR(0)+CHR(0)+CHR(0)  
        * with a LaserJet III, you have a Y-Offset command which seems to be absent
        * in the LaserJet II.  Such a command might make these four blank lines
        * unnecessary. If I am wrong, please advise!
      NEXT
    NEXT
    ?? CHR(27)+'*b3W'+CHR(015)+CHR(255)+CHR(255)  && tall bar to finish
    ?? CHR(27)+'*b3W'+CHR(015)+CHR(255)+CHR(255)  && or actually start since
    ?? CHR(27)+'*b3W'+CHR(015)+CHR(255)+CHR(255)  && it prints "backwards"
    ?? CHR(27)+'*rB'  && end raster
  END  && zipcode print
  EJECT
  ?? CHR(27)+'E'  && reset printer to stop manual-landscape printing
  SET PRINT OFF
  SET CONSOLE ON
END

FUNCTION XB_BLD(zpn)  && build zipcode byte array from zipcode
LOCAL z := zt := zx := zy := 0
LOCAL az := ARRAY(10,5)
zpn := TRIM(STRTRAN(zpn,'-'))   && take out a dash if one exists
zt := 0  && total of all digits
FOR z = 1 TO 9
  zt := zt + VAL(SUBSTR(zpn,z,1))
NEXT
* generate error correction code - subtract sum of digits from next higher 10
zpn := zpn + IF(RIGHT(STR(zt,2),1)='0','0',STR((VAL(LEFT(STR(zt,2),1))+1)*10-zt,1) )
FOR zx = 10 TO 1 STEP -1  && generate bars backwards
  Zcd := XB_ZPD(SUBSTR(zpn,zx,1))  && get bar code for digit
  FOR zy = 5 TO 1 STEP -1
    IF SUBSTR(zcd,zy,1) = '0'
      az[zx][zy] := CHR(0)+CHR(0)+CHR(255)  && short bar
    ELSE
      az[zx][zy] :=  CHR(015)+CHR(255)+CHR(255)  && long bar
    END
  NEXT zy
NEXT zx
RETURN az  && returns the array filled with appropriate bytes

FUNCTION XB_ZPD(zpd)  && turn zip digit into byte string
*  each digit has a corresponding postnet bar code
*  0 represents a short bar; 1 represents a tall bar
IF zpd = '1'
  RETURN '00011'
ELSEIF zpd = '2'
  RETURN '00101'
ELSEIF zpd = '3'
  RETURN '00110'
ELSEIF zpd = '4'
  RETURN '01001'
ELSEIF zpd = '5'
  RETURN '01010'
ELSEIF zpd = '6'
  RETURN '01100'
ELSEIF zpd = '7'
  RETURN '10001'
ELSEIF zpd = '8'
  RETURN '10010'
ELSEIF zpd = '9'
  RETURN '10100'
ELSE
  RETURN '11000'  
END
