******************************************************************************
*LAN_PROC.PRG - A procedure file for use with Multi-user FoxBase+ 2.0 or
*               above providing more bearable shared access to data with
*               enhanced error handling, and job server facilities.
*
*  Author:  Edward Mark Rauh            FidoNet: 1:141/491.100
*           20 Upper Commons
*           Woodbury, CT  06798
*
*  Version 1.0   14 April, 1989
*
*  These procedures are released to the public domain.  They have been
*  tested on Novell Advanced NetWare v2.x with MS/PC DOS 3.xx.  The
*  author takes no responsibility for your results - if you break it,
*  it's all yours...
******************************************************************************
*  Use of DOS environment variables on Novell networks:
*
*       I use the DOS environment strings to inform my applications about
*  workstation configuration and resources.  Some specific items are:
*
*       INTHENET - I set this immediately as part of the system login
*                  script, and remove it at logout to indicate whether
*                  the station is logged on the net.  It's useful to
*                  know when selecting printers or deciding if you need
*                  to SET EXCLUSIVE OFF...
*
*                  In the login script:
*
*                       DOS SET INTHENET="%PATH%" (Store PATH on entry)
*                       <script file continues>
*
*                  As part of the logoff batch file:
*
*                       <main body of LOGOFF.BAT>
*                       MAP G:=SYS:PUBLIC
*                       PATH %INTHENET%         (Restores original path)
*                       SET INTHENET=
*                       G:LOGOUT
*
*                  To test if the station is on the network in your
*                  program:
*
*                       IF Len(Getenv("INTHENET")) > 0
*                          <logged on the network>
*                       ELSE
*                          <not logged on>
*                       ENDIF
*
*       WORKDISK - I set this string from the AUTOEXEC.BAT to let the
*                  program know what disk drive should be used when a
*                  temporary workfile is needed - usually the drive
*                  letter of a local hard drive if one is present.  If
*                  no local disk is available, do not set the environment
*                  variable in the AUTOEXEC.BAT file.  You will find that
*                  most database commands run faster when temporary and
*                  private work files are on a local drive.
*
*                  In AUTOEXEC.BAT:
*
*                       <batch file begins>
*                       SET WORKDISK=D:        (Use drive D for work files)
*                       <batch file continues>
*
*                  Prepare your program to use the drive as specified by:
*
*                       PUBLIC work_disk
*                       work_disk = Getenv("WORKDISK")
*                       work_disk = Iif(Len(work_disk)>0, work_disk, Sys(5))
*
*                  When you perform an operation that uses temporary files,
*                  the following fragment will make FoxBase+ use your work
*                  drive:
*
*                       defa_disk = Sys(5)
*                       SET DEFAULT TO &work_disk
*                       <commands that need temp files>
*                       SET DEFAULT TO &defa_disk
*
*                  Be sure to use '&defa_disk.' to prefix any file name
*                  specified between the two SET DEFAULT lines that should
*                  be on the default drive.  For example:
*
*                       defa_disk = Sys(5)
*                       USE original.dbf
*                       SET DEFAULT TO &work_disk
*                       SORT ON somefield TO &defa_disk.sorted.dbf
*                        && work files will be made on your work drive,
*                        && but the final SORT file on the default drive
*                       SET DEFAULT TO &defa_disk
*
*                  You may create work files explicitly on the work drive
*                  and access them without switching SET DEFA using the
*                  work_disk variable as a macro:
*
*                  Example:
*
*                       USE anydbf
*                       COPY to &work_disk.tempfile
*                       USE &work_disk.tempfile
*
*       USERID -   Another one created as part of the system login script
*                  and cleared at logoff.  I pass the login name of the
*                  current user this way.
*
*                  In the login script:
*
*                       DOS SET USERID="%1"
*
*                  In the LOGOFF.BAT file:
*
*                       <batch file begins>
*                       SET USERID=
*                       <batch file continues>
*
*                  Your program can retrieve this value with Getenv("USERID")
*
*  Using the environment strings allows you to test functions off the net
*  using SET to create the environment variables under DOS.
*
******************************************************************************

procedure fillock
*
*  fillock() is a UDF that returns .t. if a file lock can be obtained
*            on the file opened in the CWA.  The user may abort the wait
*            by pressing an <Esc>, in which case fillock() returns .f.
*
private counter
@ 0,0
clear typeahead
do while .not. (flock() .or. inkey() = 27)
    set color to N/W
    @ 0,0 say 'Waiting for file '+trim(alias())+' - <Esc> to abort'
    set color to
    counter = 0
    do while counter < 100 .and. .not. flock()
        counter = counter + 1
        @ 0,65 say counter picture '999'
        @ 0,70 say time()
    enddo
enddo
@ 0,0
return flock()


procedure reclock
*
*  reclock() is a UDF that returns .t. if a record lock can be obtained
*            on the current record of the CWA.  The user may abort the wait
*            by pressing an <Esc>, in which case reclock() returns .f.
*
private counter
@ 0,0
clear typeahead
do while .not. (rlock() .or. inkey() = 27)
    set color to N/W
    @ 0,0 say 'Waiting for record '+ltrim(str(recno(),9))+' in '+trim(alias())+' - <Esc> to abort'
    set color to
    counter = 0
    do while counter < 100 .and. .not. rlock()
        counter = counter + 1
        @ 0,65 say counter picture '999'
        @ 0,70 say time()
    enddo
enddo
@ 0,0
return rlock()

PROCEDURE LOCKUP
*
*  Lockup - a basic error handling routine for most common net errors
*
*  Enable it with the following command line:
*
* on error do lockup with error(),message(),sys(16),message(1), .t.
*
parameters errnum,mess,curr_prg,bad_line,may_suspnd
*
* errnum        - the FoxBase+ error code
* mess          - FoxBase+ error text
* curr_prg      - Current procedure name
* bad_line      - Detokenized version of tokenized line causing the fault
* may_suspnd    - if .t., user may suspend execution
*
@ 0,0
@ 0,70 say errnum
do case
case errnum = 108
   clear typeahead
   do while .not. flock()
      if inkey() = 27
         close databases
         flush
         return to master
      endif
      @ 0,0 say mess
   enddo
   @ 0,0
   retry
case errnum = 109 .or. errnum = 130
   clear typeahead
   do while .not. rlock()
      if inkey() = 27
         close databases
         flush
         return to master
      endif
      @ 0,0 say mess
   enddo
   @ 0,0
   retry
case errnum = 125
   set color to N/W
   private devassign
   devassign = sys(101)
   set device to screen
   set printer to
   set printer to &oldprtdev
   @ 0,0
   do while sys(13) = 'OFFLINE' .and. inkey() # 27
      @ 0,0 say 'Print device '+oldprtdev+' offline - fix it or press <Esc> to quit'
   enddo
   set color to
   @ 0,0
   if sys(13) = 'OFFLINE'
      close databases
      quit
   endif
   set device to &devassign
   retry
otherwise
    on error
    set color to
    set device to screen
    @ 15,0 clear to 20,79
    set color to W+/N
    @ 15,0 to 20,79 double
    @ 16,8 say 'A fatal system error has occurred.  The program cannot continue'
    @ 17,8 say 'An error log will be printed.  Please store it in the Error Log'
    @ 18,8 say 'folder next to the file server, and notify the system manager or'
    @ 19,8 say 'technical support staff about this error as soon as possible!'
    set color to
    set device to print
    set printer to 
    if len(getenv('INTHENET'))>0
       set printer to \\SPOOLER\P=0\C=1\F=0\B=ERROR-LOG
    endif
    do while sys(13)='OFFLINE'
       set device to screen
       set color to *N/W
       @ 20,8 say 'Printer is not ready.  Please fix it!'
       ? chr(7)
       set color to
       set device to print
    enddo
    @ 1,10 say 'System error number '+ltrim(str(errnum,4))
    @ 2,10 say mess
    @ 4,10 say 'Called from '+curr_prg
    @ 6,10 say time()
    @ 6,20 say date()
    @ 6,30 say 'User Name '+getenv('USERID')
    @ 7,0 say '...'
    @ 8,0 say bad_line
    set device to screen
    set console off
    do instruct with 'Listing RunTime Status'
    list status to print
    do instruct with 'Listing Program Private Storage'
    list memory to print
    eject
    if may_suspnd
      if yorn('Suspend program execution but stay in FoxBase+?')
         suspend
      endif
    endif
    quit
endcase
return

procedure appblank
*
*   appblank() is a UDF which will attempt to add a blank record to the 
*              currently selected database.  It will either add the record
*              and return .t., positioned at the new record with the new
*              record locked, or it will return .f. with no lock held in
*              the CWA.  The user may abort the wait by pressing <Esc>
*
private append_ok
append_ok = .t.
on error do app_fail with error(),message(),sys(16),message(1),append_ok
append blank
unlock
on error do lockup with error(),message(),sys(16),message(1), .t.
@ 0,0
if append_ok
   append_ok = reclock()
endif
return append_ok

procedure app_fail
*
*   Error handler for appblank()
*
parameter errcode,errmsg,errproc,errline,do_retry
if errcode = 108
   set color to N/W
   @ 0,0 say 'Waiting for append in file '+trim(alias())+' - <Esc> to abort'
   set color to
   do_retry = inkey() # 27
   if do_retry
      retry
   else
      resume
   endif
else
   do lockup with errcode,errmsg,errproc,errline,.t.
endif
return

procedure net_open
*
*   net_open() is a UDF that will either open the requested file for
*              use in the requested mode in the CWA and return .t.,
*              or return .f. with no file in use in the CWA.  The user
*              may abort a wait for access by pressing <Esc>
*
parameter dbf_2_use, index_list, as_alias, excl_open
*
*   dbf_2_use   - name of database we want to use
*   index_list  - index file list (null string for no indexes)
*   as_alias    - alias to assign (null string = default alias)
*   excl_open   - .t. if exclusive use is desired
*
private opened_ok, use_cmd_ln
opened_ok = type([dbf_2_use+index_list+as_alias]) = 'C' .and. type([excl_open]) = 'L'
opened_ok = iif(opened_ok, len(ltrim(trim(dbf_2_use))) > 0, .f.)
if opened_ok
   use_cmd_ln = 'use '+ltrim(trim(dbf_2_use))
   if len(ltrim(trim(index_list))) > 0
      use_cmd_ln = use_cmd_ln + ' index '+ltrim(trim(index_list))
   endif
   if excl_open
      use_cmd_ln = use_cmd_ln + ' exclusive'
   endif
   if len(ltrim(trim(as_alias))) > 0
      use_cmd_ln = use_cmd_ln + ' alias ' + ltrim(trim(as_alias))
   endif
   on error do use_fail with error(),message(),sys(16),message(1),opened_ok
   &use_cmd_ln
endif
on error do lockup with error(),message(),sys(16),message(1), .t.
@ 0,0
return opened_ok

proc use_fail
*
*   Error handler for net_open()
*
parameter errcode,errmsg,errproc,errline,do_retry
do case
case str(errcode,4)$[1600|  19| 114|   3|  24|1101|1220|1149|  15|   6|  28]
   set color to N/W
   @ 0,0 say errmsg+' <Space> to retry'
   set color to
   do_retry = (inkey(20) = 32)
   if do_retry
      use
      flush
      retry
   else
      resume
   endif
case errcode = 108
   set color to N/W
   @ 0,0 say 'Waiting for use of file '+trim(alias())+' - <Esc> to abort'
   set color to
   do_retry = inkey() # 27
   if do_retry
      retry
   else
      resume
   endif
otherwise
   do lockup with errcode,errmsg,errproc,errline,.t.
endcase
return

******************************************************************************
*
*  Job servers and batch processing
*
*  Many networks have stations that may sit idle for much of the day which
*  could be used to process non-interactive tasks for users, such as 
*  running long reports, that would tie up an active user for long periods
*  of time.  In fact, most such tasks can run in an unattended state.  I
*  use a database to submit jobs for batch processing.  The database is
*  named JOB_2_DO, in \JOB directory, with the following structure:
*
*       REQUESTOR  Char(20)     && User requesting job
*       REQ_TIME   Char(8)
*       REQ_DATE   Date
*       NEED_RESRC Char(100)    && Resources needed to run this job
*       PROC_2_RUN Char(8)      && Procedure file to execute
*       PARM_4_JOB Char(8)      && .MEM file with parms
*       TIME_2_RUN Num(8,0)     && Requeue job if not finished in (secs)
*       WAIT_4_SVC Logical      && Server began job
*       INIT_TIME  Num(8,0)     && Time server accepted job (sec since midnite)
*       INIT_DATE  Date         && Date server accepted job
*       JOB_ENDED  Logical      && Has job run to completion
*       JOB_REPLY  Char(8)      && .MEM file with results from server
*
*  This system works like a 'Help Wanted' board!
*
*  I treat each job server as a serially reusable resource (Hoare's monitor
*  paradigm) for controlling job execution.  The job queue is a single queue
*  with multiple servers.  Jobs are serviced in FIFO fashion on the basis of
*  oldest job servicable by the server in the queue is selected - this can be
*  non-optimal as in the example of one server having a unique resource that
*  is needed for some job grabbing an older job servicable by any server
*  while other servers sit idle due to inadequate resources to process pending
*  jobs needing that resource.
*
*  Adding a priority field and indexing on it could be used to alter the age
*  based FIFO queueing.
*
*  The requeue procedure causes the job to be executed AT LEAST ONCE.  If
*  a job can be run AT MOST ONCE, the server must hold record lock on the
*  job record in the queue until the job is completed to prevent requeue
*  from occuring.  This could block other jobs from being run or submitted
*  due to lock granularity.
*
*  The routines below were inspired by the chapters on servers and distributed
*  operating environments in Paul J. Fortier's "Handbook of LAN Technology"
*  (1989, Intertext Publications (McGraw Hill)) and Andrew Tannenbaum's
*  "Computer Networks" (2nd edition, 1987, Prentice-Hall), a case of Jolt,
*  and lots of Szechuan food...
*
******************************************************************************

procedure job_4_q
*
*  UDF to submit a job for batch service.  Returns .t. if success, .f.
*  otherwise.  Takes 4 arguments:
*
*       job_proc   - Char(),name of .FOX procedure to run
*       job_parms  - Char(),name of .MEM file containing runtime arguments
*       req_delay  - Num(),secs to wait on server to complete before requeue
*                    if 0, server must hold rlock() to prevent timeout
*       job_needs  - Char(),parses to <expL> describing resources that a
*                    server must have to be able to service the job
*
*       CWA is destroyed by the UDF
*
parameter job_proc, job_parms, req_delay, job_needs
private job_queued
job_queued = .f.
if type('job_proc+job_parms+job_needs') # 'C' .or. type('req_delay') # 'N'
   return .f.
endif
if type(job_needs) # 'L' .or. req_delay < 0
   return .f.
endif
if .not. file('\JOB\'+trim(ltrim(job_proc))+'.fox')
   return .f.
endif
if len(trim(job_parms)) > 0
   if .not. file('\JOB\'+trim(ltrim(job_parms))+'.mem')
      return .f.
   endif
endif
job_queued = net_open('\JOB\JOB_2_DO','','QUEUE',.f.)
if job_queued
   job_queued = appblank()
   if job_queued
      replace queue->requestor with userid, queue->req_time with time()
      replace queue->req_date with date(), queue->need_resrc with job_needs
      replace queue->proc_2_run with job_proc, queue->job_parms with job_parms
      replace queue->time_2_run with req_delay, queue->wait_4_svc with .t.
      replace queue->job_ended with .f.
      unlock
   endif
*
*       Instead of exiting, we could watch queue->job_ended for job completion
*       after we unlock the job request record to block further processing.
*       This would act in a similar fashion to Unix's blocking RPC() feature.
*
*       If instead we pass back the record number and later check the record
*       for completion to synchronize processing, we would emulate XDR().
*
   use
   flush
endif
return job_queued

procedure initsrvr
*
*       UDF to initialize a job server.  Returns .t. if job queue is
*       present and readable, .f. otherwise
*
close databases
set deleted on
select 9
if file('\JOB\JOB_2_DO.DBF')
   return net_open('\JOB\JOB_2_DO','','QUEUE',.f.)
endif
return .f.

procedure svc_jobq
*
*       UDF to scan job queue for work.  Returns .t. if a job is found
*       with QUEUE positioned at the job request record with the record
*       locked, .f. otherwise.  Active jobs exceeding their service times
*       are requeued if necessary.
*
*       Once a job is taken on, the job record can be unlocked by the 
*       server, although holding the lock will prevent timeout requeue
*       by another server.  The server must hold record position in QUEUE
*       until it finishes working on the job.
*
private svc_4_sec, meet_needs, have_work
select queue
set filter to .not. queue->job_ended
have_work = .f.
go top
do while .not. eof() 
   if rlock()
      if .not. queue->wait_4_svc
         svc_4_sec = (24 * 60 * 60 * (date()-queue->init_date)) - queue->init_time + sys(2)
         if svc_4_sec > queue->time_2_run
            replace queue->wait_4_svc with .t.
         endif
      endif
      meet_needs = trim(queue->need_resrc)
      if queue->wait_4_svc .and. &meet_needs
         replace queue->wait_4_svc with .f., queue->init_time with sys(2)
         replace queue->init_date with date()
         have_work = .t.
         flush
         exit
      endif
      unlock
   endif
   skip
enddo
return have_work

procedure job_srvr
*
*  Main server process
*
private job_proc, job_parms, defa_s_drv, refuse_job
close databases
set escape off
do initsrvr
clear
@ 0,0 say 'FoxBase+ Job Server process active'
defa_s_drv = sys(5)
do while .not. inkey() = 27
   @ 23,0
   @ 23,0 say 'No job in progress - <Esc> to cancel server'
   if svc_jobq()
      @ 23,0
      @ 23,0 say 'Processing batch job - please wait'
      job_proc = '\JOB\'+ltrim(trim(queue->proc_2_run))+'.FOX'
      job_parms = '\JOB\'+ltrim(trim(queue->job_parms))+'.MEM'
      refuse_job = .f.
      if queue->time_2_run > 0
         unlock
      endif
      do &job_proc with job_parms, refuse_job
      set defa to &defa_s_drv
      select queue
      if .not. (queue->job_ended .or. deleted())
         refuse_job = qjob_ran(job_parms,refuse_job)
      endif
      unlock
   endif
enddo
close databases
set escape on
return

      
procedure qjob_ran
*
*  UDF to mark job as finished
*
parameter reply_file,job_notrun
*
* reply_file - Char(), name of the .MEM file returned by job (if any)
* job_notrun - Logical, .t. if server refused to run job or aborted it
* 
select queue
do while .not. rlock()
enddo
if job_notrun
   replace queue->wait_4_svc with .t.
else
   replace queue->job_ended with .t., queue->job_reply with reply_file
endif
unlock
flush
set filter to
go top
return .t.

procedure my_qstat
parameter myuserid,kill_wait,kill_done
*
*  UDF to scan job queue entries I created.  Returns a 32 character
*  string as str(all your jobs,8)+str(jobs waiting service,8)+
*  str(jobs executing,8)+str(jobs finished)
*
*  The CWA is destroyed by a successful execution of the UDF
*
*  if kill_wait is .t., jobs waiting to run are deleted from the queue
*  if kill_done is .t., completed jobs are deleted from the queue 
*
private countlist,jcnt,wcnt,ecnt,dcnt
if type('myuserid')+type('kill_wait .and. kill_done') # 'CL'
   return ''
endif
countlist = space(32)
if net_open('\JOB\JOB_2_DO','','QUEUE',.f.)
   set filter to queue->requestor = myuserid
   go top
   jcnt = 0
   wcnt = 0
   ecnt = 0
   dcnt = 0
   do while .not. eof()
      jcnt = jcnt + 1
      do case
      case queue->job_ended
         dcnt = dcnt + 1
         if kill_done
            if reclock()
               delete
               unlock
               flush
            endif
         endif
      case queue->wait_4_svc
         wcnt = wcnt + 1
         if kill_wait
            if reclock()
               delete
               unlock
               flush
            endif
         endif
      otherwise
         ecnt = ecnt + 1
      endcase
      skip
   enddo
   countlist = str(dcnt,8)+str(wcnt,8)+str(ecnt,8)+str(dcnt,8)
   use
endif
return countlist

******************************************************************************
*
*  Notice that this facility could be used in a single-user environment to
*  make batches of jobs to run when the machine is inactive (e.g. overnight,
*  at lunchtime, etc.)
*
*  It is the responsibility of the REQUESTOR to clear old reply files and
*  delete records for completed job streams.
*
******************************************************************************
