;     KEYBLINK.ASM
;     Keven Miller    19 Mar 1993   70732,1340
;     For FOXPRO 2.x
;
;     ** FREEWARE **   use as you see fit
;
;     Blink keyboard LEDs
;     Only works on 84 keyboards and 8086
;     The 101 keyboard and 80x86 can control the keyboard leds
;        NUMLOCK, CAPSLOCK, SCROLLLOCK
;     (see keyled.BIN,ASM,PRG)
;     However, before the 101 keyboard, the 84 keyboard would blink
;     its led at system boot time (see IBM Tech. Ref. manual).
;     This routine does the same by Disable/Enabling the keyboard.
;     This method does not seem to work on the 101 keyboards.
;
;     Pass in the number of times to blink as binary, CHR ( times )
;     between 1 and 255.
;
;     LOAD keyblink
;     CALL keyblink WITH CHR (3)
;     RELEASE keyblink
;
;     TO BUILD keyblink.BIN
;        MASM %1,,;
;        LINK %1/map
;        EXE2BIN %1 %1.BIN
;
         ORG     0
PROGRAM SEGMENT
         ASSUME  CS:PROGRAM
MYPROC   PROC    FAR
START:
         OR      BX,BX           ; Test for parameter passed
         JZ      EXIT

         PUSH  AX
         PUSH  CX
         MOV   AH,BYTE PTR [BX]  ; Get number of times to blink
         OR    AH,AH             ;    keyboard leds
         JZ    RETURN
AGAIN:
         CLI
         IN    AL,61H            ; Get current status bits
         AND   AL,0BFH           ; Disable keyboard, bit 6
         OUT   61H,AL
         STI
         MOV   CX,5000H          ; Wait for keyboard to read
WAIT:
         LOOP  WAIT
         CLI
         IN    AL,61H            ; Get current status bits
         OR    AL,40H            ; Enable keyboard
         OUT   61H,AL
         STI
         MOV   CX,5000H          ; Wait for keyboard to read
WAIT2:
         LOOP  WAIT2
         DEC   AH                ; Repeat specified times
         JNZ   AGAIN
RETURN:
         POP   CX
         POP   AX
EXIT:
         RET
MYPROC   ENDP
PROGRAM  ENDS
         END

