;       keybd - program to supply "keystrokes" to dBASE III and IV.
;       Copyright (C) 1990 Jay Parsons, CIS 70160,340.  ATBBS "Jparsons".

;       License is granted to all to use this program.  License is also
;       granted to developers to include the assembled code in packages
;       furnished to their clients, provided the developer assumes FULL
;       responsibility for any errors or upgrades needed.

;       While the author welcomes mention of this program in other programs
;       and explanation to the users of such programs how to download it,
;       dissemination of the assembled code without identification of the
;       author is prohibited.  It makes support too difficult.

;               Version 1.3       August 21, 1990

;	Version 1.1 corrected a failure to reinitialize the buffer pointer on
;		each call that prevented repeated calls without reloading.
;       Version 1.2 corrected the handling of special characters when more
;		than one is passed in the argument.
;       Version 1.3 expands the standard buffer to 255 characters, adds to
;               the documentation and provides code to prevent system
;               hangup if it is used improperly.

;	Expects a character variable argument containing the chr() values of
;	the characters to be supplied.

;	Special characters in the string:
;               Chr(255) indicates next character in string is the second byte
;       of the scan code of an "extended", or non-ASCII, key code, unless
;       the next character is also chr(255), in which case a single chr(255)
;       is placed in buffer.

;	Syntax:
;		LOAD keybd
;		CALL keybd with "Hello"+chr(13)	     && Hello & "Enter" key
;                          or
;               CALL keybd with chr(255)+chr(80)     && down arrow

;                              *  How it works  *

;       This program redirects the keyboard-service interrupt, 16h, to its
;       own handler routine.  Then, when dBASE, which uses the ROM BIOS
;       service routines, asks for input, this program intercepts the
;       request and supplies the next character(s) from its own buffer.
;       When the final character has been supplied, this program restores the
;       interrupt vector to its previous address.

;                       ***  IMPORTANT PRECAUTIONS ***

;       It is ESSENTIAL that the interrupt 16h vector be restored by this
;       program to its original state.  This program cannot restore it if
;       it is not allowed to complete its delivery of characters.
;       Do not QUIT from dBASE, RELEASE MODULE Keybd, or otherwise release
;       the memory occupied by this program while characters remain in its
;       buffer, or a system crash is almost certain.

;       This program may not work, and may cause problems, if used together
;	with TSR's such as SideKick that continually reset the int16h vector 
;	to take priority.

;       This program may be called repeatedly without reloading, but should
;       not be called a second time before the characters given at the first
;       call have been supplied to dBASE, since the second group of characters
;       will overwrite the first group and remaining characters of the first
;       group will be lost.

;                 *  Differences from the KEYBOARD command  *

;       The dBASE IV 1.1 KEYBOARD command places characters directly into the
;       typeahead buffer.  This program does not (it doesn't know where the
;       dBASE typeahead buffer is), but supplies characters in response to
;       BIOS calls.  These are usually made by dBASE only when input is
;       expected but the typeahead buffer is empty.

;       dBASE traps such as ON KEY monitor keystrokes as they are placed into
;       the typeahead buffer.  With KEYBOARD, that occurs as soon as the
;       KEYBOARD command is executed.  With this program, it occurs only when
;       the characters from this program's buffer are supplied to the typeahead
;       buffer in response to dBASE calling the BIOS for input.

;       If a trap or other situation leaves keys in this program's buffer that
;       will not be needed by the calling program, they must be removed in
;       order to restore the vector and exit safely.  CLEAR TYPEAHEAD is of
;       no help since the keys have not yet been delivered to the typeahead
;       buffer.  Use a loop like the following, which removes any keys from
;       the typeahead buffer then from this program's buffer:
;               X=1
;		DO WHILE X # 0
;		  X=inkey()
;		ENDDO 

;                               *  Scan codes  *

;       Scan codes for non-ASCII characters may be found in the reference
;       guide to MASM 5.0, in Peter Norton's Programmer's Guide, and the like.
;       To find the code for a key on an unusual keyboard, or without a
;       reference, use DEBUG.COM.  To its "-" prompt, type in a known key like
;       the letter "A" three times, then the key in question two or three
;       times, then "A" again a few times, and press the <Enter> key.

;       Next, type "d 40:10 <Enter>."  You should see the BIOS keyboard buffer
;       at 0040:1Eh on the screen, and between the sets of "A" codes will
;       appear the scan codes for the unknown key.  ASCII keys like "A"
;       have a code of character then 00 (here 41 00) while non-ASCII keys
;       have 00 first then something else, as 00 47 for "Home".  The "new"
;       keys on the PS/2 actually generate codes with "E0" rather than "00"
;       as the first byte ("Grey Home" is E0 47), as you'll see in DEBUG,
;       but the Keybd program ignores this distinction as does dBASE.

;                             *  Program size  *

;       As written, the character buffer in this program will hold 255
;       characters, allowing two bytes (one word) for each.  It can be called
;       repeatedly with chunks of a larger string, provided as discussed above
;       that each bunch of characters is removed from the buffer by dBASE before
;       the next call.  To save memory usage by allowing fewer characters,
;       change the value of "buflen."  Characters passed to the program
;	that cannot be stored in the buffer specified will be discarded.

;	In the somewhat unlikely event you want to change the buffer but do not
;	have access to an assembler, load the .BIN file into the DOS DEBUG
;	program by "DEBUG Keybd.bin".  Then, look at the CX register by typing
;       "rcx <enter>".  Note the value.  Adjust it downward by two
;       for each character less desired in the buffer. Type "rcx=xxxx <enter>"
;       where xxxx is the adjusted value of CX.  Then type "w <enter>"
;       to write the changed file to disk.

;	This program must be assembled and linked, then converted to a
;	binary image file by EXE2BIN.  It cannot be converted to a .COM file.

buflen          equ 255

		.model tiny
		code segment
		assume cs:code

;	initialization and storage of parameter string

keybd   	proc far		; dBASE requires FAR return
		jmp short begin
firstchar:	dw ?			; pointer to next char in buffer
lastchar:	dw ?			; pointer to end of buffer in use
oldvect:	dd 0			; storage for old int16h vector
begin:		mov si,bx		; change pointer to parameters	
		mov ax,cs
		mov es,ax		; point es:di to our buffer
		mov di,offset buffer
		mov word ptr es:firstchar,di  ; initialize character pointer
		cld			; forward
nextkey:	lodsb			; get a key	
		xor ah,ah		; a zero as scan code (doesn't matter)
		cmp al,0		; at end of string?
		jz setvect		; then jump
		cmp di,offset bufend	; or end of buffer
		jae setvect
		cmp al,255		; special code?
		jnz normchar		; if not, go on
		lodsb			; get the auxiliary byte
		cmp al,255		; second code 255?
		jz normchar		; if so, just save it followed by null
		xchg ah,al		; else save null first
normchar:	stosw			; save two bytes in buffer	
		jmp short nextkey	; and on

;	setvect - save end-of-characters address and change int16h vector

setvect:	mov cx,cs
		mov ds,cx
		mov word ptr lastchar,di	
		mov di,offset oldvect
		mov ax,3516h		; get int16h vector
		int 21h
		mov ax,bx		; load vector offset
		mov dx,es		; save its segment for now	
                cmp cx,dx               ; has vector already been set?
                jz setend               ; then don't overwrite saved address

                mov es,cx               ; point es to ours
		stosw			; save offset
		mov ax,dx		; and segment
		stosw
		mov dx,offset handler	; address of our handler 
		mov ax,2516h		; set vector (ds points to our segment)
		int 21h
setend:         ret                     ; and all done
keybd		endp

;	handler - intercept keyboard requests and deliver our keys 

handler		proc near
		sti			; allow interrupts
		push ds			; save registers
		push si
		mov cx,cs		; cx isn't used by int 16h calls
		mov ds,cx		; point to our code		
		mov si,word ptr firstchar
		cmp ah,1		; check service requested
		jb readchar		; if 0, read a character
		je getstat		; if 1, get status
		pop si
		pop ds
		jmp dword ptr cs:[oldvect] ; else use original handler

;	read character service
; 	Return scan code in ah, key in al, and remove key from buffer.
;	Reset vector if this is last key.

readchar:	lodsw				; load both bytes of char
		mov word ptr firstchar,si
		cmp si,word ptr lastchar	; all done?
		jb readret			; not yet
		push dx
		push ax				; save for return
		mov ax,2516h			; update interrupt 16h
		lds dx,dword ptr oldvect	; with original address
		int 21h
		pop ax				; restore registers	
		pop dx
readret:	pop si
		pop ds
		iret				; all done	
		
;	keyboard status service
;  	Clear zero flag, return with ah=scan code, al=char, but
;	leave the key in the buffer for next read.
	                                   
getstat:	lodsw				; get next char
		or ax,ax			; clear zero
		pop si
		pop ds
		retf 2				; don't change zero flag
handler		endp

buffer		dw buflen dup (0)
bufend		equ $

code	 	ends	
       		end

