* jdblclk.prg
*
* example of how to use DBL-Clicks to exit browse.
*
close data
set talk off
clear
if !file("jkeysamp.dbf")
	use (sys(2004)+"foxhelp") again && open the FOXHELP file
	copy to jkeysamp fields topic, class
	use jkeysamp
	index on upper(topic) tag topic
endif

**** Load jKey into memory
if "2.0"$version()
	set library to jKey20 additive
else
	set library to jKey additive
endif

**** Define the window that will be used for the browse.
define window jbrowser from 10, 5 to 20, 75 ;
	color scheme 10 ;
	close float grow zoom ;
	font wfont(1, "screen"), 12, "B" && wfont(2, "screen") style wfont(3, "screen")

**** Open the JKEYSAMP file (created above)
use jkeysamp order topic

**** Set the SYSMENU OFF before using jKey.
if !"WINDOWS"$upper(version()) && don't use _DOS/_WIN for 2.0 compatibility
	set sysmenu off
else
	set clock status
endif

_JEXITKEY = 13 && char 13 (enter) ends jKey.
_JDBLCLICK = .75 && Timeout for resetting search

store -1 to m.g_lastrow, m.g_lastcol, m.g_lastcllk

=jKeyInit("U", "", "")
on key label leftmouse do i_dblclk
BROWSE WINDOW JBROWSER
on key label leftmouse
=jKeyCanc()

****************************************************************
procedure i_dblclk
*
private all like l_*

#DEFINE C_FONTNAME wfont(1, wontop())
#DEFINE C_FONTSZ wfont(2, wontop())
#DEFINE C_STYLE wfont(3, wontop())

#DEFINE C_CHARH fontm(1, C_FONTNAME, C_FONTSZ, C_STYLE)
#DEFINE C_CHARW fontm(6, C_FONTNAME, C_FONTSZ, C_STYLE)

****
**** DECIDE WHICH OF THESE TO USE BASED ON YOUR SITUATION
****
* standard user window
#DEFINE FRIGHTBAR (sysm(3) + sysm(5))
#DEFINE FBOTTOMBAR (sysm(3) + sysm(8))

* NOGROW WINDOWS
*#DEFINE FRIGHTBAR (sysm(10) + sysm(5))
*#DEFINE FBOTTOMBAR (sysm(10) + sysm(8))

* DOUBLE/PANEL WINDOWS
*#DEFINE FRIGHTBAR (sysm(12) + sysm(5))
*#DEFINE FBOTTOMBAR (sysm(12) + sysm(8))
****
**** END OF DESCISION TIME!
****

#DEFINE C_MPIXELROW (mrow(wontop()) * C_CHARH)
#DEFINE C_MPIXELCOL (mcol(wontop()) * C_CHARW)

#DEFINE C_PIXELSH ((wrows(wontop()) * C_CHARH) - FBOTTOMBAR)
#DEFINE C_PIXELSW ((wcols(wontop()) * C_CHARW) - FRIGHTBAR)

if _WINDOWS
	if !between(C_MPIXELROW, C_CHARH, C_PIXELSH) or ;
	   !between(C_MPIXELCOL, 0, C_PIXELSW)
		****
		**** Mouse not in the BROWSE WINDOW
		****
		return
	endif
else
	if !between(mrow(wontop()), 3, wrows(wontop()) - 2) or ;
	   !between(mcol(wontop()), 0, wcols(wontop()) - 2)
		****
		**** Mouse not in the BROWSE WINDOW
		****
		return
	endif
endif

if mrow() # m.g_lastrow or ;
   mcol() # m.g_lastcol or ;
   (seconds() - g_lastcllk) > _DBLCLICK
	m.g_lastrow = mrow()
	m.g_lastcol = mcol()
	m.g_lastcllk = seco()
else
	**** same row and col within _DBLCLICK seconds!
	keyboard chr(23)
endif
