PARAMETERS mserver, mworksn, oktopass
* ' A file to look at the .APP files on a LAN server and
* ' if the server has later information - to download the file to
* ' the work station.  Uses FOXPRO V2.0 functions.
* '
SET SAFETY OFF
SET TALK OFF
SET ESCAPE OFF

if parameters() < 2
	= ALERT('ERROR - An error was encountered in the PRIME startup program.  ' + ;
		'Please report this error to PC Support.')
	oktopass = .f.
	return (oktopass)
endif parameters() < 2


STORE '.APP'    TO mxtn                      && **** Application Extension
STORE .F.       TO mupdate

DIMENSION mfiles(5),server(5),worksn(5)
=ADIR(mfiles,mserver+'*'+mxtn)  && **** Collect .APPs off SERVER

FOR i = 1 TO ALEN(mfiles,1)
  = datetime(substr(mfiles(i,1),1,at('.',mfiles(i,1))-1), @oktopass)
ENDFOR
RETURN (oktopass)

*************************************************************************
* ' Procedure Name:       DATETIME
* ' Purpose or Function:  Retrieve information about filea on SERVER and
* '                       on WORKSTATION and compare dates and time.
* '                       If a newer file exists on the SERVER then the
* '                       WORKSTATION file is updated.
* ' Parameters Passed:    File Name minus the extension
* ' Variables Passed:     None
* ' Environment Passed:   None
* ' Variables Returned:   None
* ' Example:              DO datetime WITH substr(mfiles(i),1,;
*                             at('.',mfiles(i,1))-1)
*
PROCEDURE datetime
PARAMETER prgm, oktopass

=ADIR(server,mserver+prgm+mxtn) && **** Get info about SERVER file
=ADIR(worksn,mworksn+prgm+mxtn) && **** Get info about WORKSTATION file
STORE .f. TO mupdate

IF FILE(mworksn+prgm+mxtn)      && **** Update?
   DO CASE
   CASE SERVER[3] < WORKSN[3] or ;
            (SERVER[3] = WORKSN[3] and SERVER[4] < WORKSN[4])
       ACTIVATE SCREEN
       @ 24, 0            
	   = ALERT('ERROR - The startup program has determined that the ' +;
			'server version of ' +  UPPER(prgm)  + ' is older that the ' +;
			'workstation version.  This implies a potentially ' +;
			'serious problem.  Please contact PC Support immediately ' +;
			'and report this problem.')
       oktopass = .f.
       
    CASE (server(3) <> worksn(3)) .OR.( server(4) <> worksn(4))
       STORE .T. TO mupdate
    ENDCASE
ELSE
  STORE .T. TO mupdate
ENDIF
IF mupdate                      && **** Update across the LAN
  COPY FILE (mserver+prgm+mxtn) TO (mworksn+prgm+mxtn)
ENDIF
RETURN (oktopass)
