*!*****************************************************************************
*!
*!       Function: POPSONG()
*!
*!      Called by: TICKLER.PRG                       
*!               : REPORTS.PRG                       
*!               : ISFOUND()          (function  in PROJECT.PRG)
*!               : ISCOMPLETED()      (function  in PROJECT.PRG)
*!               : REPTDEST.SPR                      
*!               : ASGBROW.PRG                       
*!               : ZAP_ONE            (procedure in ASGBROW.PRG)
*!               : GETASGN.PRG                       
*!               : DATACHK()          (function  in M_READ.PRG)
*!               : PRNFACT.PRG                       
*!
*!          Calls: BEEP()             (function  in PROCLIB.PRG)
*!               : POPTALK()          (function  in PROCLIB.PRG)
*!               : UNTALK()           (function  in PROCLIB.PRG)
*!
*!*****************************************************************************
FUNCTION alert
PARAMETERS s_row, s_col, t_mess
PRIVATE t_mess, cur_win, s_row, s_col, lr_row, lr_col
PRIVATE num_lines, cur_width, pcount, i
SET BELL ON
savecursor = SET('cursor') = 'ON'
SET CURSOR OFF
pcount = parameters()

= beep(5)

DO CASE 

  CASE pcount = 1 .and. type('s_row') = 'C'
    t_mess = s_row
    s_row = 10
    s_col = 15

  CASE pcount = 2 .and. type('s_col') = 'C'
    t_mess = s_col
    s_col = 15

  CASE pcount = 3 .and. type('t_mess') = 'C'

  OTHERWISE
    = poperror('Incorrect parameters passed to the '+;
               'function POPTALK.  No message '+;
               'will be displayed.')

ENDCASE 

IF wexist('pop_talk')         &&  there already is a message
  RELEASE WINDOW pop_talk     &&  on the screen.
ENDIF

cur_win = woutput()

IF len(t_mess) <= 40
  s_col = s_col + 18 - int(len(t_mess)/2)
  s_col = iif(s_col+len(t_mess) > 69,69-len(t_mess),;
              s_col)
  s_row = iif(s_row>20,20,s_row)
  lr_row = s_row + 4
  lr_col = s_col + 10 + len(t_mess)
ELSE
  cur_width = set('memowidth')
  SET MEMOWIDTH TO 40

  num_lines = memlines(t_mess)

  s_col = iif(s_col > 30,30,s_col)
  s_row = iif(s_row+num_lines > 21,21-num_lines,s_row)
  lr_row = s_row + 3  + num_lines
  lr_col = s_col + 49

ENDIF

DEFINE WINDOW pop_talk FROM s_row,s_col TO lr_row,lr_col ;
              DOUBLE SHADOW COLOR SCHEME 7
ACTIVATE WINDOW pop_talk

IF len(t_mess) <= 40
  @ 1,4 SAY t_mess
ELSE

  FOR i = 1 to num_lines
    @ i,4 SAY  mline(t_mess,i)
  ENDFOR

  SET MEMOWIDTH TO cur_width

ENDIF

IF savecursor
   SET CURSOR ON
ENDIF
WAIT ""
RELEASE WINDOW pop_talk
RETURN ""
