*******************************************************************************
* COPYFILE
* Utility to determine the amount of free disk space on a given drive/
* directory and to copy a file to that disk if there is sufficient space.
*
* PARAMETER LIST
*
* d_drive 	-	destination drive
* o_drive	-	origination drive
* mfsize	-	file bytes being copied to the destination drive
* mfile1	-	name.extension of file to be copied
* mfile2	-	destination file name.extension
*
*******************************************************************************
PARAMETERS	d_drive,o_drive,mfsize,mfile1,mfile2
PRIVATE drivesp,mcount,totused
STORE 0 TO drivesp,mcount,totused
STORE .F. TO Success

SET SAFETY OFF							&& optional - shuts off warning of copying over
										&&	 a dest. file of same name
SET DEFAULT TO (d_drive)
drivesp = SYS(2020)						&& total bytes available on dest. drive

** Array must be predefined, otherwise, if the destination disk is blank
** no array will be created by the ADIR() function.

DIMENSION defaspace(1,5)		
=ADIR(defaspace,"*.*")

** If the destination disk is blank, the array created by DIMENSION will
** return a logical .F. for element 1,2 (file size element).

IF TYPE('defaspace(1,2)') = 'N'
	STORE ALEN(defaspace) TO mcount			&& total elements in array
	
** Adds all the x,2 elements to get total disk space used

	FOR x =1 TO (mcount/5)						&& each array record contains 5 elements
		totused = defaspace(x,2) + totused
	ENDFOR	
ENDIF defaspace = .F., mcount,totused are initialized at 0  	

** (Total bytes of dest. disk - 50 [just in case]) - total dest. disk
** bytes used compared to the size of the file to be copied down.

IF (VAL(drivesp)-50) - totused < mfsize
	WAIT WINDOW 'Insufficient space on destination drive ' ;
		+ LEFT(UPPER(d_drive),2) TIMEOUT 5
ELSE
	SET DEFAULT TO (o_drive)
	COPY FILE (mfile1) TO (d_drive + mfile2) 
    STORE .T. TO Success
ENDIF
SET DEFAULT TO (o_drive)
RETURN (Success)