set talk off
set score off
set echo off
set debug off
set deleted on
set cursor off
set bell on

close all
clear all
clear

define window w_title from 01,15 to 03,65 color w+/g shadow
activate window w_title noshow
@ 00,00 say padc('PRIME Installation',wcols())
show window w_title

drive    = 'C'  && Destination Drive for Install
verified = .f.  && When .t., destination drive verified
oktopass = .f.  && Stop Installation Flag
MinMem   = 480  && Minimum Amount of Memory to run application

*-/ Opening Installation Screen
do openscrn.spr
if lastkey() = 27
   = cleanup()
   return
endif

*-/ Check Environment for Diskspace and Total Memory
= chkenv(@oktopass,MinMem)
if ! oktopass
   = cleanup()
   return
endif   

do while ! verified
   *-/ Check available disk space
   do getdrive.spr with m.oktopass, m.drive
   = clrline(24)
   if ! oktopass
      = cleanup()
      return
   endif   
   m.verified = .f.
   do verify.spr with m.verified,m.drive  && cancel and esc handled in .SPR
   = clrline(24)
   if ! verified 
      loop
   endif
enddo
   
do chkspace.spr with m.oktopass, m.drive
if ! oktopass
   = cleanup()
   return
endif   

instcancl = .f.
*-/ Install Files on Install Drive
= doinstal(@m.drive,@instcancl)
if instcancl
   = alert('ERROR - Prime was not completely installed and will not run as is.  '+;
    'Please notify PC support.  Press any key to continue.')
else
   *-/ Copy Appropriate CONFIG.FP and PRIME.BAT file based on letter selected
   = driveltr(m.drive,'CONFIG','FP')
   = driveltr(m.drive,'PRIME','BAT')
   = alert('Installation Complete.  Press any key to continue.')
endif   
= cleanup()
return

function chkenv
parameter OkToPass,MinMem 
*-/Minimum amount of memory to run application
OkToPass = iif(memory() < MinMem ,.f.,.t.)
if not m.oktopass
   = alert('ERROR - You do not have enough conventional memory remaining to '+;
      'run PRIME.  Please contact PC Support to report this problem.  '+;
     'Press any key to exit installation program.')
endif      
return (OkToPass)

function cleanup
close all
clear all
clear
set talk on
set debug on
set score on
return && quit

function clrline
parameter line
activate screen
@ line,0
return ""
