*!*****************************************************************************
*!
*!       Function: BEEP()
*!
*!      Called by: POPSONG()          (function  in PROCLIB.PRG)
*!               : POPMESS()          (function  in PROCLIB.PRG)
*!               : QRYMENU.PRG                       
*!               : POPERROR()         (function  in POPERROR.PRG)
*!               : SAVE_IT            (procedure in PRO2EROR.PRG)
*!               : GROUP_CHK()        (function  in GETPERS.PRG)
*!               : ISASG()            (function  in PROJECT.PRG)
*!               : ISFOUND()          (function  in PROJECT.PRG)
*!               : UTILMENU           (procedure in UTILMENU.PRG)
*!               : SEKPERS            (procedure in SEKPERS.PRG)
*!               : PICKRECS()         (function  in QRYMENU.PRG)
*!               : REFCHECK()         (function  in REFCHECK.PRG)
*!               : CK_AND_OR          (procedure in QUERY.PRG)
*!               : CODECHEK()         (function  in ADD_GRP.PRG)
*!               : REFCHEC2()         (function  in REFCHEC2.PRG)
*!
*!*****************************************************************************
FUNCTION beep
PARAMETERS song
PRIVATE song, i

************************************************************
*  beep(<expN>)                                            *
*  Note: Plays the songs from the Xbase Hit Parade.        *
*                                                          *
*  song      1 = error                                     *
*            2 = danger                                    *
*            3 = hello                                     *
*            4 = death                                     *
*            5 = slide up                                  *
*            6 = slide down                                *
************************************************************

IF TYPE('song') # 'N'                            &&  if bizzare thing passed
   song = 0
ENDIF (TYPE('song') # 'N'                        &&  if bizzare thing passed)

DO CASE
   
CASE song = 1
   SET BELL TO 800,1
   ?? CHR(7)
   = INKEY(.1)
   ?? CHR(7)
   
CASE song = 2
   SET BELL TO 523.3,1
   ?? CHR(7)
   = INKEY(.1)
   ?? CHR(7)
   = INKEY(.1)
   ?? CHR(7)
   = INKEY(.1)
   ?? CHR(7)
   = INKEY(.1)
   
CASE song = 3
   SET BELL TO 261,3
   ?? CHR(7)
   SET BELL TO 349,4
   ?? CHR(7)
   SET BELL TO 440,1
   ?? CHR(7)
   SET BELL TO 349,1
   ?? CHR(7)
   SET BELL TO 261,3
   ?? CHR(7)
   SET BELL TO 349,4
   ?? CHR(7)
   SET BELL TO 440,8
   ?? CHR(7)
   SET BELL TO 349,6
   ?? CHR(7)
   
CASE song = 4
   SET BELL TO 261,8
   ?? CHR(7)
   SET BELL TO 261,7
   ?? CHR(7)
   SET BELL TO 261,2
   ?? CHR(7)
   SET BELL TO 261,8
   ?? CHR(7)
   SET BELL TO 311,7
   ?? CHR(7)
   SET BELL TO 293,2
   ?? CHR(7)
   SET BELL TO 293,7
   ?? CHR(7)
   SET BELL TO 261,2
   ?? CHR(7)
   SET BELL TO 261,7
   ?? CHR(7)
   SET BELL TO 247,2
   ?? CHR(7)
   SET BELL TO 261,8
   ?? CHR(7)
   
CASE song = 5
   FOR i = 400 TO 1800 STEP 100
      SET BELL TO i,1
      ?? CHR(7)
   ENDFOR
   
CASE song = 6
   FOR i = 1800 TO 400 STEP -100
      SET BELL TO i,1
      ?? CHR(7)
   ENDFOR
   
OTHERWISE
   SET BELL TO 440,6
   ?? CHR(7)
   
ENDCASE

RETURN(.T.)

