***************************************************************************
*
* Procedure file: INCLUDE.PRG
*         System: GenScrnX
*        Version: 1.1
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* INCLUDE - Setup snippet #INCLUDE driver.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* Acts as a #INCLUDE directive for all screens.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* Function calls made from this program may be contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PRIVATE codedata

* Ignore for header record or driver disable mode.
IF OBJTYPE=1.OR..NOT.drvenable(PROGRAM())
  GOTO BOTTOM
  RETURN .F.
ENDIF

* Create line of code be #INCLUDEd.
m.codedata=""

* Add directives and/or code to beginning of Setup snippet.
REPLACE SETUPCODE WITH m.codedata+''+m.cr_lf+SETUPCODE

* Go to bottom of .SCX database to have GENSCRNX skip calling this driver
* for every non-header record.
GOTO BOTTOM

RETURN .T.
