***************************************************************************
*
* Procedure file: GETTXT.PRG
*         System: GenScrnX
*        Version: 1.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* GETTXT - Get Text.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* Prompts for text string.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* All function calls made from this program are contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PARAMETERS say_str
PRIVATE code,setcursor

* Check for driver disable mode.
IF OBJTYPE=1.AND..NOT.drvenable(PROGRAM())
  GOTO BOTTOM
  RETURN .F.
ENDIF

m.setcursor=SET('CURSOR')
IF EMPTY(m.say_str)
  m.say_str=''
ENDIF
m.code=SPACE(255)
@ 1,0 CLEAR TO 1,WCOLS()
@ 1,2 SAY m.say_str;
      GET m.code PICTURE '@S'+ALLTRIM(STR(50-LEN(m.say_str),3))
SET CURSOR ON
READ TIMEOUT 15
IF m.setcursor=='ON'
  SET CURSOR ON
ELSE
  SET CURSOR OFF
ENDIF
@ 1,0 CLEAR TO 1,WCOLS()
RETURN ALLTRIM(m.code)
