*  The purpose of this procedure is to get a NetWare queue from the
*  user and set the capture parameters to that queue.
*
*	This procedure sets a timeout of 0, to flush the job and release it
*  to the network I would recommend using the N_FlushLPT() function.
*
*  Useage:	Do SetQueue
*

parameters Y1, X1
private Answer, File_name, Wkarea, Q_brow, Ok, ServName, ;
   P_Array, Q_Array, OuterLoop, InnerLoop, TalkStat, QCount, Queue_Pop, queues
*  Set Talk off and save the status
if set("Talk") = 'ON'
	set talk off
	TalkStat = 'ON'
else
	TalkStat = 'OFF'
endif
if .not. "GPLIB" $ set('LIBRARY')       && Open GPLIB For API Routines
	set library to GPLIB additive
endif
Q_Brow = sys(2015)						&& Get unique temp names for windows & pop - ups
Queue_Pop = sys(2015)
Queues = sys(2015)
Ok = .f.
if type('X1') <> 'N'					&& No window location specified, set default
	Y1 = 5
	X1 = 12
endif
WkArea = select()						&& Save Current Work Area
select 0
creat cursor (Queues) (Name C(48), S_Name C(48))
for OuterLoop = 1 to 8
	ServName = N_ServFrID(OuterLoop)	&& Get the name of Server on Conn#
	if .not. empty(ServName)
		QCount = N_getQList('QArray', '*', ServName)    && Get a list of Queues on that server
		for InnerLoop = 1 to QCount
			append blank		&& Put the queue and server name in the cursor
			replace Name with QArray[InnerLoop, 1], S_Name with ServName
		endfor
	endif
endfor
*  Give the USER LPT1 and COM1 as choices also
append blank
replace name with 'COM1:'
append blank
replace name with 'LPT1:'
= N_GetPStat(1, 'P_Array')		&& Get current capture settings
locate for NAME = P_ARRAY[2]
* Define window and pop-up
define window (Q_brow) from Y1, X1 to Y1 + 17, X1 + 33 double title ' Select Print Queue ' color scheme 5 shadow
define popup (Queue_pop) from 0, 0 prompt field padr(rtrim(s_name) + ;
   iif(empty(s_name), '', '\') + rtrim(Name), 30) shadow in (q_brow) color scheme 6 scroll
on selection popup (Queue_pop) deactivate popup
do while .not. Ok
	*  Set Mouse limits
	= setmlimit(Y1 + 2, X1 + 2, Y1 + 15, X1 + 32)
	activate window (q_brow)
	activate popup (Queue_pop) rest     && Activate the Pop - Up
	deactivate window (q_brow)
	= inkey(.5)
	if empty(S_Name)					&& Verify user wants selected port or queue
		ok = yes('Set printer to port ' + rtrim(name) + '?')
	else
		Ok = Yes('Set printer to :~~  Server Name : ' + rtrim(S_name) + '~  Queue Name  : ' + rtrim(name))
	endif
	= inkey(.5)
enddo
*  Reset mouse limits
= setmlimit(0, 0, 55, 79)
if empty(S_Name)						&& User selected COM1 or LPT1
	Answer = rtrim(Name)
	= n_Capture(1, 'OFF')
	set printer to &answer
else									&& Setup capture defaults
	P_Array[1] = rtrim(S_Name)			&& Server Name
	P_Array[2] = rtrim(name)			&& Queue Name
	* Set Flags : Tab Expansion, FormFeed, Banner Page, Notify
	store 'OFF' to P_Array[4], P_Array[5], P_Array[7], P_Array[12]
	* Number of copies
	store 1 to p_Array[8]
	* Timeout in seconds
	store 0 to p_array[11]
	*  Initialization and Reset Codes
	P_Array[13] = _pscode
	P_Array[14] = _pecode
	= N_SetPStat(1, 'P_Array')
endif
*  Clean up and go home
release window (Q_brow)
release popup (QUEUE_POP)
use
select (WkArea)
set talk &TalkStat
