*:*********************************************************************
*:
*: Procedure file: F:\SOURCE\ECOTRACK\..\COMMON\PRGS\YES.PRG
*:
*:         System: ECO Tracking Program
*:         Author: George Sexton & Lorraine St. Myers
*:      Copyright (c) 1992, COBE CArdiovascular Inc.
*:  Last modified: 02/06/92     12:09
*:
*:         Set by: ECODATA.PRG
*:               : VALPART.PRG
*:               : VALIDDIR.PRG
*:               : CHANGECO           (procedure in ECODATA.PRG)
*:               : DELETECO           (procedure in ECODATA.PRG)
*:
*:          Calls: SETMPOS()          (function  in ?)
*:               : SETMLIMIT()        (function  in ?)
*:               : CTLALTSHFT()       (function  in ?)
*:
*:      Documented 02/11/92 at 15:23               FoxDoc  version 2.10b
*:*********************************************************************
*   The purpose of this function is to get a yes or no answer from the
*   user.  If the parameters row, col are passed then the program will
*   display a YES/NO bar menu for selection.  If a character string is
*   passed then it will be displayed in a pop-up window with Ok/Cancel
*   Note:  Any ~ (tilde) charachters are translated to a {cr}{lf}
*
*   Usage:    ?'Are you sure you want to do this (Y/N)?'
*  			  if yes()
*					do Dangerous_thing
*			  endif
*
*
*   Usage:    ?'Are you sure you want to do this (Y/N)?'
*             && Now we will have a menu bar choice at 5,50
*  			  if yes(5,50)
*					do Dangerous_thing
*			  endif
*
*   Usage:    && Activate pop up window with 'ok/cancel push buttons, and msg displayed
*
*			  if yes('Are you sure you want to do this?')  && Window is Dialog Color
*					do Dangerous_thing
*			  endif
*			  if yes('Are you sure you want to do this?',.t.)  && Window is Alert Color
*					do Dangerous_thing
*			  endif
*

parameter param1, param2
private talkstat, choice, tempvar, old_rmarg, old_lmarg, last_width, ;
   width, height, win_title, c_var, current_choice, y_pos, n_pos, on_pair, yesmsg, ;
   off_pair, s_pos, answer, xctr, yctr
if set('TALK') = 'ON'
	set talk off
	talkstat = 'ON'
else
	talkstat = 'OFF'
endif
answer = .f.
if .not. 'GPLIB' $ set("LIBRARY")
	set library to gplib additive
endif
clear typeahead
do case
case type('Param1') = 'C'
	* Param1 really holds the message we wish to display
	param1 = strtran(param1, '~', chr(13) + chr(10))
	old_rmarg = _rmargin
	old_lmarg = _lmargin
	old_wrap = _wrap
	xctr = scols() / 2
	yctr = srows() / 2
	last_width = set('MEMOWIDTH')
	width = 40
	set memowidth to width - 4
	do while ((width - 4) / (memlines(param1) + 5)) < 3.2
		width = width + 4
		set memowidth to width - 4
	enddo
	height = memlines(param1) + 5
	_lmargin = 2
	_rmargin = _lmargin + width - 4
	_wrap = .t.
	if param2					&&  called in alert mode
		win_title = ' Warning! '
		c_var = 7
		current_choice = 0
	else
		win_title = ' Verify '
		c_var = 5
		current_choice = 1
	endif

	yesmsg = sys(2015)
	define window (yesmsg) from int(YCTR - height / 2), int(xctr - width / 2) to int(YCTR + .5 + height / 2), int(xctr + width / 2) double color scheme (c_var) shadow title (win_title) footer " Press SHIFT to Hide Window "
	activate window (yesmsg)
	y_pos = int((_rmargin - _LMARGIN) / 2) - 6
	n_pos = y_pos + 8
	on_pair = scheme(c_var, 6)
	off_pair = scheme(c_var, 9)

	? param1
	s_pos = row() + 2
	= setmpos(s_pos + int(YCTR - height / 2) + 1, y_pos + 3 + int(xctr - width / 2) + iif(current_choice = 1, 0, 9))
	= setmlimit(int(YCTR - height / 2) + 1, int(xctr - width / 2) + 1, int(YCTR + height / 2) - 1, int(xctr + width / 2) - 1)
	keyboard chr(32) plain
	do while .t.
		choice = inkey(.5, 'HM')
		do case
		case choice < 0
			if between(choice, - 10, - 1)
				choice = abs(choice) + 1
				TempVar = 'F' + alltrim(str(choice))
				TempVar = on('KEY', Tempvar)
				if trimlen(tempvar) > 0
					tempvar = right(tempvar, len(tempvar) - 3)
					do &tempvar
					clear typeahead
				endif
			endif
			loop
		case ctlaltshft() .and. choice = 0
			hide window (yesmsg)
			do while ctlaltshft()
			enddo
			show window (yesmsg)
			loop
		case choice = 0
			loop
		case choice = 27 .or. choice = asc('C') .or. choice = asc('c')
			answer = .f.
		case choice = 151
			*  mouse button was pressed
			do case
			case mrow() <> s_pos
				loop
			case between(mcol(), y_pos, y_pos + 5)
				answer = .t.
			case between(mcol(), n_pos, n_pos + 7)
				answer = .f.
			otherwise
				loop
			endcase
		case choice = 13
			*  User Pressed Enter, Return Present Value
			answer = (current_choice = 0)
		case choice = asc('O') .or. choice = asc('o')
			answer = .t.
		otherwise
			current_choice = ((current_choice + 1) % 2 )
			@ s_pos, y_pos say '< Ok >' color (iif(current_choice = 0, on_pair, off_pair))
			@ s_pos, n_pos say '<Cancel>' color (iif(current_choice = 1, on_pair, off_pair))
			= setmpos(mrow() + 1 + int(YCTR - height / 2), mcol() + int(xctr - width / 2))
			= setmpos(mrow() + 1 + int(YCTR - height / 2), mcol() + 2 + int(xctr - width / 2))
			loop
		endcase
		exit
	enddo
	= setmlimit(0, 0, srows() - 1, scols() - 1)
	set memowidth to last_width
	deactivate window (yesmsg)
	release window (yesmsg)
	_rmargin = old_rmarg
	_lmargin = old_lmarg
	_wrap = old_wrap
case type('Param2') = 'N'
	choice = 0
	do while .t.
		@param1, param2 prompt "  YES  "
		@param1, param2 + 15 prompt "   NO   "
		menu to choice
		if (choice > 0)
			answer = (choice = 1)
			exit
		endif
	enddo
otherwise
	answer = (upper(chr(inkey(0, "H"))) = 'Y' .or. lastkey() = 13)
endcase
if talkstat = 'ON'
	set talk on
endif
return answer
*: EOF: YES.PRG
