*	Purpose:
*
*	The purpose of this function is similar to that of FKillAll, except
*	that this function will recursively go through sub-directories to
*	erase all occurrences of SKELETON.
*
*
*	Syntax
*
*	Sweep(<C_DirectoryName>, <C_FileSpec> [, <L_RemoveSubs>])
*
*		C_DirectoryName is the directory name to Sweep
*
*		C_FileSpec is the File Spec to erase
*
*		L_RemoveSubs is an optional logical flag if .T., empty
*		sub-directories are removed, upto and including the C_DirectoryName
*		specified.
*
*	Returns
*
*		The number of files erased.
*
*	Usage:
*
*		? 'Erased '+ltrim(str(Sweep('\users','*.bk!')))+' .bk! files from directory \users'
*		=Sweep('\users','*.bk!')
*
*		=Sweep('\DRAWING','*.BAK',.T.) && Remove any empty sub-directories
*
*	Notes:
*
*			This function is interesting because it recursively calls itself
*			to go down through the directory structure.  In order for this function
*			to work, you must have previously issued the command
*			SET LIBRARY TO GPLIB
*
function Sweep

	parameters direct, Skeleton, RemoveSubs

	*  Note that all variables are declared private.  If this is not done
	*  the recursive process would not work.

	private Dir_Array, LOOP, Counter
	*  Kill the top level directory files
	Counter = Fkillall(direct + '\' + Skeleton)
	*  Find any subs in that directory
	*  Note that because the ADIR() skeleton is *, rather than *.*, directories with
	*  extensions will be missed.  You can change this, but be aware that
	*  by changing it to *.*, every file in the directory will be included, and
	*  you may run into memory problems.
	if adir(Dir_array, direct + '\*', 'D') > 0
		for loop = 1 to alen(Dir_array, 1)
			*  Check to see if the file is actually a directory and not a file.
			if 'D' $ Dir_array[loop, 5] .and. Dir_Array[loop, 1] <> '.'
				*  Add the number erased to the counter
				Counter = Counter + Sweep(direct + '\' + Dir_Array[loop, 1], Skeleton, RemoveSubs)
			endif
		endfor
	endif
	if RemoveSubs
		= rem_dir(direct)
	endif
return Counter


