*  The purpose of this program is to read the PRINTCON.DAT file,
*  and set the current capture settings to that specified by the
*  job.  If no job is specified, then the defaultJobName will be
*  used.  The intent is to allow the developer to Use Novell's
*  JOB system to control printer output.  For information on how
*  Novell uses the JOB system, please refer to your Novell documentation.
*  One feature this program permits is the use of a "GLOBAL"
*  PRINTCON.DAT.  This means that one user may develop a PRINTCON.DAT
*  and place it in a location accessible to users running the PROGRAM.
*  This eliminates the requirement that each user have his own PRINTCON.DAT
*  stored in his MAIL directory.
*
*	To create a GLOBAL printcon, create a PRINTCON.DAT file using Novells
*   PRINTCON utility.  Then copy the PRINTCON.DAT from your MAIL directory
*   into a common area.  To find your mail directory look up your
*   object ID in SYSCON/USER INFO/OTHER.  The mail directory is located
*   on the SYS volume.
*
*   For information on the API calls, please refer to the documentation
*   for the API library.
*
*
*  Parameters
*
*	JobName		This is the name of the print job to set to.  If it
*				is not specified, the program set the print parameters
*				to the DEFAULT job.
*
*	DatName		This is the name of the file to use containing the
*				PRINTCON information.  If no  name is specified for
*				the PRINTCON.DAT file in the Mail directory for the
*				logged in USER on the SYS volume of the default
*				server.  If you specify a file name you must
*				specify the drive letter in the path name.  The program
*				will look for the NET$PRN.DAT in the PUBLIC directory
*				on the same drive.  The file name must be in the format
*				<DRIVE>:\DIRECTORY\FILENAME.
*
*
*   Examples
*
*			PJobSet=SetPJob()
*			if .not. PJobSet
*				Wait Window "Unable to get default print job"
*			Endif
*
*			PJobSet=SetPJob("LTRHEAD")  && set to job name letterhead
*
*			PJobSet=SetPJob(.f.,"F:\PUBLIC\PRINTCON.DAT")  && Set default form from global PRINTCON.DAT
*
* 			PJobSet=SetPJob('LTRHEAD',"F:\PUBLIC\PRINTCON.DAT")
*			&& Set job ltrhead from global PRINTCON.DAT
*
*	Notes		This program was developed using information I obtained from
*				the NOVLIB forum on CompuServe about the PRINTCON.DAT
*				and NET$PRN.DAT files.  If you are interested, the file
*				names are PRNTCN.ZIP and NETPRN.ZIP.  This function could
*				be optimized by eliminating the parts that read in
*				the complete device name tables and mode name tables.
*				In the interest of clarity, and ease of maintenance
*				I have left them in.
*
*				This function requires that either the GPLIB API library
*				or FPNET API library have been previously loaded by
*				issuing the command SET LIBRARY TO <Library Name>
*
parameter JobName, DatName
private file_handle, TempDrive, TempArray, counter, InString, OffSet, ;
   TempString, P_Array, DeviceName, ModeName, PortNumber
* Initialize variables
set talk off
store 0 to Offset, counter
if type('DatName') <> 'C'
	*  We need to look for the printcon.dat in the users mail directory on volume SYS
	TempDrive = GetSYSLtr()
	= N_AcctList('TempArray', N_LoginID())
	DatName = TempDrive + ':\MAIL\' + tempArray[1, 2] + '\PRINTCON.DAT'
else
	DatName = alltrim(upper(DATNAME))
	TempDrive = left(datname, 1)
endif
file_handle = fopen(DatName)
if file_handle < 0
	return .f.
endif
if type('JobName') <> 'C'
	*  Get the default job name
	= fseek(file_handle, 118)
	JobName = NullTrim(fread(file_handle, 32))
endif
JobName = upper(JobName)
* locate the end of the header, and try to find our job name
= fseek(file_handle, 150)
for Counter = 1 to 37
	*  Search throught the Job Name table to find our Job Offset
	InString = fread(file_handle, 36)
	if upper(NullTrim(InString)) = JobName
		offset = Bin2L(right(instring, 4))
		exit
	endif
endfor
if offset > 0
	* ok, we have found the offset into the job
	* Goto the offset, and initialize P_Array to contain the
	* Job parameters, then call N_SetPStat()
	*
	= N_GetPStat(1, 'P_Array')	&& really just calling this to create array
	= fseek(file_handle, int(OffSet))
	P_Array[1] = nulltrim(fread(file_handle, 48))       && Server Name
	P_Array[2] = nulltrim(fread(file_handle, 48))		&& Queue Name
	P_Array[3] = asc(fread(file_handle, 1))				&& Tab size
	P_Array[8] = Bin2L(fread(file_handle, 2))			&& Number of Copies
	P_Array[10] = NullTrim(fread(File_Handle, 13))		&& Form Name
	= fread(File_Handle, 27)	&& Reserved record
	P_Array[12] = iif(asc(fread(file_handle, 1)) = 0, 'OFF', 'ON')      && Notify
	= fread(File_Handle, 4)		&& Print Server
	= fread(File_Handle, 13)	&& UserName
	P_Array[6] = nulltrim(fread(file_handle, 13))       && Banner Text
	DeviceName = NullTrim(fread(file_handle, 33))		&& Device Name
	ModeName = NullTrim(fread(file_handle, 33))			&& Mode Name
	P_Array[7] = iif(asc(fread(file_handle, 1)) = 0, 'OFF', 'ON')       && Banner Flag
	P_Array[4] = iif(asc(fread(file_handle, 1)) = 1, 'OFF', 'ON')		&& Tab Expansion Flag
	P_Array[5] = iif(asc(fread(file_handle, 1)) = 1, 'OFF', 'ON')		&& Form Feed Flag
	P_Array[11] = Bin2L(fread(file_handle, 2))  && Timeout in Seconds
	PortNumber = asc(fread(file_handle, 1))
	*  Make the call to GetDevInfo() to read the Device, MODE, and Form Information
	= GetDevInfo(TempDrive + ':\PUBLIC\NET$PRN.DAT', 'P_ARRAY', DeviceName, ModeName, p_array[10])
	*  If your initialization string is longer than 64 bytes you will need
	*  to modify your SHELL.CFG statement to permit this.  Refer to
	*  documentation on N_SetPStat() and your Novell documentation.
	= N_SetPstat(PortNumber, 'P_Array')
endif
*  Perform clean up
= fclose(file_handle)
return (Offset > 0)

function GetDevInfo
	parameter Fname, ArrayName, DeviceName, ModeName, FormName
	private Dat_Handle, DevTableOffset, FormTableOffset, Counter, DeviceCount, DevArray ;
	   , DeviceNumber, DevNameArray, FuncArray, InitString, ModeNumber, Length, FormArray
	InitString = ''
	*  Open NET$PRN.DAT
	Dat_Handle = fopen(fname)
	if Dat_Handle < 0
		return .f.
	endif
	= fgets(Dat_Handle)			&& Read line 1, Description
	= fgets(Dat_Handle)			&& Read Line 2, Copyright Notice
	= fread(Dat_Handle, 1)		&& read 0x1A
	= fread(Dat_Handle, 12)		&& skip past the date stamp
	DevTableOffset = Bin2L(fread(Dat_Handle, 4))        && Get offset to Device Table
	FormTableOffset = Bin2L(fread(Dat_Handle, 4))		&& Get Offset to Form Table
	= fseek(Dat_Handle, DevTableOffset)
	DeviceCount = Bin2L(fread(Dat_Handle, 2))			&& Get number of devices in table
	declare DevArray[DeviceCount, 5]
	*  Column 1 is offset to device definition
	*  Column 2 is Length of Device Name
	*  Column 3 is Device Name
	*  Column 4 is Offset to Device Modes
	*  Column 5 is offset to device Functions
	for Counter = 1 to DeviceCount      && Get the offsets to the table
		DevArray[Counter, 1] = Bin2L(fread(Dat_Handle, 4))
	endfor
	for Counter = 1 to DeviceCount
		*  Now, fill in the array with the Device Information
		= fseek(Dat_Handle, DevArray[counter, 1])
		DevArray[Counter, 2] = Bin2L(fread(Dat_Handle, 1))
		DevArray[Counter, 3] = fread(Dat_Handle, DevArray[Counter, 2])
		DevArray[Counter, 4] = Bin2L(fread(Dat_Handle, 4))
		DevArray[Counter, 5] = Bin2L(fread(Dat_Handle, 4))
	endfor
	DeviceNumber = ascan(DevArray, DeviceName)
	if (deviceNumber > 0)
		* Ok, We have found our device
		DeviceNumber = 1 + int(DeviceNumber / alen(DevArray, 2))        && Convert the element number to a row number
		= fseek(Dat_Handle, DevArray[DeviceNumber, 4])
		declare DevNameArray[Bin2L(fread(Dat_Handle, 2)), 4]
		*  Column 1 Offset to Device Mode Definition
		*  Column 2 Length of Device Mode Name
		*  Column 3 Mode Name
		*  Column 4 Offset to Mode function list table
		for Counter = 1 to alen(DevNameArray, 1)        && build list to ModeNames
			DevNameArray[Counter, 1] = Bin2L(fread(Dat_Handle, 4))
		endfor
		for Counter = 1 to alen(DevNameArray, 1)		&& Fill In Table with offsets to mode names
			= fseek(Dat_Handle, devNameArray[counter, 1])
			DevNameArray[Counter, 2] = asc(fread(Dat_Handle, 1))        && mode name length
			DevNameArray[Counter, 3] = fread(Dat_Handle, DevNameArray[Counter, 2])      && mode name
			DevNameArray[Counter, 4] = Bin2L(fread(Dat_Handle, 4))
		endfor
		ModeNumber = ascan(DevNameArray, ModeName)
		if (ModeNumber > 0)
			*  Ok, we now have the mode we want to use
			ModeNumber = 1 + int(ModeNumber / alen(DevNameArray, 2))
			* Seek to Mode function list table
			= fseek(Dat_Handle, DevNameArray[ModeNumber, 4])
			* Declare array to hold offsets to Functions for the MODE
			declare FuncArray[ Bin2L(fread(Dat_Handle, 2)) ]
			for Counter = 1 to alen(FuncArray, 1)       && Read the Offsets to the functions
				FuncArray[counter] = Bin2L(fread(Dat_Handle, 4))
			endfor
			for Counter = 1 to alen(FuncArray, 1)
				*  Ok, now we read each function in and build our
				*  initialization string.
				= fseek(Dat_Handle, FuncArray[counter])
				Length = asc(fread(Dat_Handle, 1))		&& Function Name Length
				= fread(Dat_Handle, Length)				&& Function Name
				Length = asc(fread(Dat_Handle, 1))		&& Escape Code Length
				InitString = InitString + fread(Dat_Handle, length)
			endfor
			&ArrayName[13] = InitString
			*  From examining the results of capture J= the Reset string
			*  is the same as the initialization string.  I am setting it
			*  to 16 because that is the default length of the buffer reserved
			*  by the NetWare shell.  You may wish to change how this works.
			&ArrayName[14] = left(InitString, 16)
			*  Yea, Yea (Picture Kermit the Frog going Yea.)
			*  We now have the initialization string.
		endif
		if .not. empty(formname)
			*  Now, we need to get the form number if possible
			= fseek(dat_handle, FormTableOffset)
			Length = Bin2L(fread(dat_handle, 2))		&& Number of Forms
			if Length > 0
				declare FormArray[length]
				for counter = 1 to alen(FormArray, 1)
					FormArray[counter] = Bin2L(fread(dat_handle, 4))
				endfor
				for counter = 1 to alen(FormArray, 1)
					= fseek(dat_handle, FormArray[counter])
					length = asc(fread(dat_handle, 1))
					if fread(dat_handle, length) = FormName
						&ArrayName[9] = Bin2L(fread(dat_handle, 2))
						exit
					endif
				endfor
			endif
		endif
	endif
	= fclose(Dat_Handle)

function GetSYSLtr

	*  The purpose of this function is to find a drive mapped to
	*  the SYS volume of the current DEFAULT server.

	private Start
	Start = chr(65 + N_LocDrv())        && Get the lowest Novell drive
	do while Start < '['
		if n_servname(start) = n_servFrId() .and. n_getpath(start) = 'SYS:'
			exit
		else
			Start = chr(asc(Start) + 1)
		endif
	enddo
	if start = 'Z'
		wait window 'Unable to find drive mapped to SYS:'
		cancel
	else
		return Start
	endif


function NullTrim

	*  The purpose of this function is to trim off any characters in a string
	*  after the null character (CHR(0)).

	parameter String
	String = left(String, at(chr(0), String) - 1)
return String

function Bin2L

	*  The purpose of this function is to convert a string to an integer
	*  number.  The Offsets stored in the file are read in as a string
	*  and converted to an integer.  I.E. a string consisting of
	*  CHR(1)+CHR(2) would return 513.

	parameter InString
	private Counter, RetVal
	RetVal = 0
	for Counter = 0 to len(Instring) - 1
		RetVal = RetVal + 256^Counter * asc(substr(Instring, counter + 1, 1))
	endfor
return int(RetVal)
