*
*	Purpose:	Send message to users who are logged in, and are part of a
*   specified group.  If no group is specified, group EVERYONE is assumed.
*



parameters Message, GroupName
private NumStations, Counter, StationCount, UserArray, UserID, LastMode

message = alltrim(Message)
if len(message) > 55 .or. len(message) = 0
	return - 1
endif
if type('GroupName') <> 'C'
	GroupName = "EVERYONE"
else
	GroupName = alltrim(GroupName)
endif
LastMode = N_GetBMode()
= N_Cast(1)						&& set it so we don't get our own message
StationCount = 0
NumStations = N_MaxConns()
*  The purpose of this array is to hold user names so that if a user is
*  logged in on more than one station, he only gets one message.
declare UserArray[NumStations]
for Counter = 1 to NumStations	&& Cycle through the stations
	UserID = N_LoginID(Counter)
	if len(UserID) = 0
		loop
	else
		if ascan(UserArray, UserID, 1, Counter) = 0 .and. ;
			   N_ismember(GroupName, UserID)
			StationCount = StationCount + N_SendMsg(Message, UserID)
			store UserID to UserArray[Counter]
		endif
	endif
endfor
= N_Cast(LastMode)
return StationCount
