*  The purpose of this procedure is to provide a simple queue
*  management program for FoxPro programs.

private LastRec, Outer, Inner, Counter, LastDel, LastTalk, QCount, ;
   WkArea, LastLib, QList, QJobs, LastEscape
*  Save Current Machine State
if set('TALK') = 'ON'
	set talk off
	LastTalk = 'ON'
else
	LastTalk = 'OFF'
endif
LastEscape = set("ESCAPE")
LastDel = set('DELETED')
LastLib = set("LIBRARY")
push key clear
WkArea = select()
*  Set up new environment
set library to gplib
set deleted on
set escape off
*  The next two lines keep the project manager from barfing on the array names.
declare qlist[1]
declare qjobs[1]
define window BrowWin from 1, 0 to srows() - 10, 79 color scheme 10 title 'JobList' shadow system
define window Instr from srows() - 8, 0 to srows() - 2, 79 double title ' Queue Mgr Instructions ' ;
   shadow footer ' ESC to Exit ' color w +/ RB, w +/ BG, w +/ RB, w +/ RB, w +/ RB, w +/ B, gr +/ RB, N +/ N, w +/ RB, w / RB, +

activate window instr noshow
text
 Press SPACE to move a job, DEL to delete a job.

 Wait 10 Seconds, or Click right mouse button to refresh display.
endtext
show window instr
activate screen
create cursor QUEUES (NAME C(48), s_name C(48))
LastRec = 1
*  Get a list of queues for all servers we're on
for Outer = 1 to 8
	if .not. empty(N_ServFRID(Outer))
		qcount = N_getqlist('qlist', '*', N_ServFrID(Outer))
		for inner = 1 to qcount
			append blank
			replace name with qlist[inner, 1], s_name with n_ServFrid(Outer)
		endfor
	endif
endfor
create cursor joblist ( UserName C(48), Queue C(48), desc C(50), status C(12), JobNumber N(5, 0), size N(10), ServerName C(48))
*  Get a list of all jobs in all queues
set sysmenu off
= setmlimit( 1, 0, 15, 79)
do while lastkey() <> 27
	select queues
	scan
		JobCount = N_PJobList('qjobs', queues.name, S_Name)
		select joblist
		for Counter = 1 to JobCount
			append blank
			replace UserName with qjobs[counter, 1], desc with qjobs[counter, 2], ;
			   status with qjobs[counter, 3], JobNumber with qjobs[counter, 4], ;
			   Queue with queues.name, size with qjobs[counter, 5], ServerName with queues.s_name
		endfor
	endscan
	select joblist
	if LastRec <= reccount()
		goto LastRec
	else
		go top
	endif
	*  Set up for browse of jobs
	on key label SPACEBAR do MoveJob with joblist.queue, joblist.JobNumber, joblist.ServerName
	on key label DEL do DelJob with joblist.queue, joblist.JobNumber, joblist.ServerName
	on key label leftmouse do qmouse
	on key label rightmouse keyboard chr(23)
	browse fields UserName :H = 'User Name' :15, ;
	   Queue :H = 'Queue' :16, ;
	   desc :H = 'Description' :12, ;
	   status :H = 'Status' :12, ;
	   JobNumber :H = 'Job' :5, ;
	   size :H = 'Size' :10 ;
	   window browwin save noclear nomenu nomodify color scheme 10 timeout 10
	on key label del
	on key label rightmouse
	on key label leftmouse
	on key label spacebar
	LastRec = recno()
	zap
enddo
= setmlimit(0, 0, 24, 79)
set sysmenu automatic
*  Restore Machine State
select Queues
use
select JobList
use
deactivate window instr
release window BrowWin
release window instr
select (WkArea)
set library to &LastLib
set talk &LastTalk
set deleted &LastDel
set escape &LastEscape
pop key
clear
keyboard chr(32) plain

procedure DelJob

	parameter Queue, Number, SName
	private result
	if Yes('Delete Job Number ' + ltrim(str(number)) + '?')
		result = n_pjobrem(rtrim(queue), number, rtrim(SName))
		if result = 0
			delete
			goto recno()
		else
			do case
			case result = 208
				wait window 'No queue rights.'
			case result = 214
				wait window 'No Job Rights...'
			endcase
		endif
	endif
	retry

procedure MoveJob

	*  The purpose of this procedure is to perform a job move.
	*  unfortunately there is no way to force a screen update,
	*  so the job will not appear to update until the browse has timed out.

	parameter Queue, Number, SName
	private result, NewPos, FireUpStr, LastWin
	FireUpStr = on('KEY', 'SPACEBAR')
	LastWin = wlast()
	on key label SPACEBAR
	define window MoveJob from 5, 5 to 15, 60 double title ' Move Job ' color scheme 5 shadow
	activate window MoveJob
	clear
	newpos = 1
	@2, 2 say 'Enter new service position :' get NewPos picture '999' range 1, 250
	read
	deactivate window MoveJob
	release window MoveJob
	if lastkey() = 27
		on key label SPACEBAR &FireUpStr
		return
	else
		if Yes('Change service sequence for job ' + ltrim(str(number)) + ' to ' + ltrim(str(newpos)) + '?')
			result = n_pjobmove(rtrim(queue), number, newpos, rtrim(SName))
			if result <> 0
				do case
				case result = 208
					wait window 'No queue rights.'
				case result = 214
					wait window 'No Job Rights...'
				case result = 211
					wait window 'No queue rights.'
				endcase
			endif
		endif
		on key label SPACEBAR &FireUpStr
	endif
	retry

procedure QMouse
	if mwindow() = 'INSTR'
	endif
