*  The purpose of this procedure is to provide a simple queue
*  management program for FoxPro programs.

private LastRec, Outer, Inner, Counter, LastDel, LastTalk, QCount, ;
   WkArea, lHadLib, QList, QJobs, LastEscape, cSafety

external array qlist
external array qjobs
EXTERNAL ARRAY aServers   
*  Save Current Machine State
if set('TALK') = 'ON'
	set talk off
	LastTalk = 'ON'
else
	LastTalk = 'OFF'
endif
cSafety = set('SAFETY')
LastEscape = set("ESCAPE")
LastDel = set('DELETED')
if not 'GPLIB' $ set('LIBRARY')
	lHadLib=.f.
	set library to gplib additive
else
	lHadLib=.t.
endif
push key clear
WkArea = select()
*  Set up new environment
set deleted on
set safety off
set escape off

define window BrowWin from 1, 0 to srows() - 10, scols() - 2 ;
	color scheme 10 title 'JobList' shadow system

define window Instr from srows() - 8, 0 to srows() - 2, scols() - 2 ;
	double title ' Queue Mgr Instructions ' ;
	shadow footer ' ESC to Exit ' ;
	color w +/ rb, w +/ bg, w +/ rb, w +/ rb, w +/ rb, w +/ B, gr +/ rb, N +/ N, w +/ rb, w / rb, +

activate window instr noshow
?
?padc('Press SPACE to move a job, DEL to delete a job.', wcols() - 1)
?
?padc('Wait 10 Seconds, or Click right mouse button to refresh display.', wcols() - 1)
?
show window instr
activate screen
create cursor QUEUES (NAME C(47), s_name C(47))
LastRec = 1
*  Get a list of queues for all servers we're on
nServers=N_Servers('aServers')
for Outer = 1 to alen(aServers,1)
		qcount = N_getqlist('qlist', '*', aServers[Outer])
		for inner = 1 to qcount
			append blank
			replace name with qlist[inner, 1], s_name with aServers[outer]
		endfor
endfor
create cursor joblist ( UserName C(47), Queue C(47), desc C(50), status C(12), JobNumber N(5, 0), size N(10), ServerName C(47))
*  Get a list of all jobs in all queues
set sysmenu off
keyboard ' ' plain
=inkey(0)
do while lastkey() <> 27
	select queues
	scan
		JobCount = N_LstQJobs(Queues.Name,'qjobs', S_Name)
		select joblist
		for Counter = 1 to JobCount
			append blank
			replace UserName with qjobs[counter, 4], desc with qjobs[counter, 3], ;
			   status with qjobs[counter, 5], JobNumber with qjobs[counter, 1], ;
			   Queue with queues.name, size with qjobs[counter, 2], ServerName with queues.s_name
		endfor
	endscan
	select joblist
	if LastRec <= reccount()
		goto LastRec
	else
		go top
	endif
	*  Set up for browse of jobs
	on key label SPACEBAR do MoveJob with joblist.queue, joblist.JobNumber, joblist.ServerName
	on key label DEL do DelJob with joblist.queue, joblist.JobNumber, joblist.ServerName
	on key label rightmouse keyboard chr(23)
	browse fields UserName :H = 'User Name' :15, ;
	   Queue :H = 'Queue' :16, ;
	   desc :H = 'Description' :12, ;
	   status :H = 'Status' :12, ;
	   JobNumber :H = 'Job' :5, ;
	   size :H = 'Size' :10 ;
	   window browwin save noclear nomenu ;
	   nomodify color scheme 10 timeout 10
	on key label del
	on key label rightmouse
	on key label spacebar
	LastRec = recno()
	zap
enddo
set sysmenu automatic
*  Restore Machine State
select Queues
use
select JobList
use
deactivate window instr
release window BrowWin
release window instr
select (WkArea)

if not lHadLib
	release library gplib
endif

set talk &LastTalk
set deleted &LastDel
set escape &LastEscape
set safety &cSafety
pop key
clear && Necessary to counteract Browse NOCLEAR
return


procedure DelJob

	parameter Queue, number, SName
	private result
	push key clear
	if Yes('Delete Job Number ' + ltrim(str(number)) + '?')
		result = n_DelQJob(Number, rtrim(queue), rtrim(SName))
		if result = 0
			delete
			goto recno()
		else
			do case
			case result = 208
				wait window 'No queue rights.'
			case result = 214
				wait window 'No Job Rights...'
			endcase
		endif
	endif
	pop key
	retry
return

procedure MoveJob

	*  The purpose of this procedure is to perform a job move.
	*  unfortunately there is no way to force a screen update,
	*  so the job will not appear to update until the browse has timed out.

	parameter Queue, number, SName
	private result, NewPos, LastWin
	push key clear
	LastWin = wlast()
	on key label SPACEBAR
	define window MoveJob from 5, 5 to 15, 60 double title ' Move Job ' color scheme 5 shadow
	activate window MoveJob
	clear
	newpos = 1
	@2, 2 say 'Enter new service position :' get NewPos picture '999' range 1, 250
	read
	deactivate window MoveJob
	release window MoveJob
	if lastkey() != 27
		if Yes('Change service sequence for job ' + ltrim(str(number)) + ' to ' + ltrim(str(newpos)) + '?')
			result = n_moveqJob(NewPos, Number, rtrim(queue), rtrim(SName))
			if result <> 0
				do case
				case result = 208
					wait window 'No queue rights.'
				case result = 214
					wait window 'No Job Rights...'
				case result = 211
					wait window 'No queue rights.'
				endcase
			endif
		endif

	endif
	pop key
	retry
return
